/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge;

import eu.hansolo.enzo.common.Section;
import eu.hansolo.enzo.gauge.RadialGauge;
import eu.hansolo.enzo.gauge.RadialGaugeBuilder;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class DemoRadialGauge
extends Application {
    private static final Random RND = new Random();
    private static int noOfNodes = 0;
    private RadialGauge leftControl;
    private RadialGauge rightControl;
    private long lastTimerCall;
    private AnimationTimer timer;

    public void init() {
        this.leftControl = ((RadialGaugeBuilder)((RadialGaugeBuilder)((RadialGaugeBuilder)((RadialGaugeBuilder)((RadialGaugeBuilder)((RadialGaugeBuilder)RadialGaugeBuilder.create().title("Bright")).unit("Bright")).sections(new Section(35.0, 50.0, Color.LIME))).areas(new Section(80.0, 100.0, Color.rgb((int)255, (int)0, (int)0, (double)0.5)))).ledVisible(true)).ledColor(Color.CYAN)).build();
        this.rightControl = ((RadialGaugeBuilder)((RadialGaugeBuilder)((RadialGaugeBuilder)RadialGaugeBuilder.create().title("Dark")).unit("Dark")).style("-body: black; -tick-mark-fill: white; -tick-label-fill: white;")).build();
        this.lastTimerCall = System.nanoTime() + 50000000L;
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > DemoRadialGauge.this.lastTimerCall + 2000000000L) {
                    DemoRadialGauge.this.leftControl.setValue(RND.nextDouble() * 100.0);
                    DemoRadialGauge.this.rightControl.setValue(RND.nextDouble() * 100.0);
                    DemoRadialGauge.this.leftControl.setBlinking(DemoRadialGauge.this.leftControl.getValue() > 50.0);
                    DemoRadialGauge.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) throws Exception {
        HBox controlBox = new HBox(new Node[]{this.leftControl, this.rightControl});
        controlBox.setSpacing(20.0);
        StackPane pane = new StackPane();
        pane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        pane.getChildren().add((Object)controlBox);
        Scene scene = new Scene((Parent)pane, (Paint)Color.BLACK);
        stage.setTitle("RadialGauge");
        stage.setScene(scene);
        stage.show();
        this.timer.start();
        DemoRadialGauge.calcNoOfNodes((Node)scene.getRoot());
        System.out.println(noOfNodes + " Nodes in SceneGraph");
    }

    public void stop() {
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                DemoRadialGauge.calcNoOfNodes(n);
            }
        }
    }
}

