/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.ledbargraph;

import eu.hansolo.enzo.led.Led;
import eu.hansolo.enzo.ledbargraph.LedBargraph;
import eu.hansolo.enzo.ledbargraph.LedBargraphBuilder;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class Demo
extends Application {
    private static int noOfNodes = 0;
    private static final Random RND = new Random();
    private LedBargraph control;
    private long lastTimerCall;
    private AnimationTimer timer;

    public void init() {
        Color[] ledColors = new Color[]{Color.LIME, Color.LIME, Color.LIME, Color.LIME, Color.LIME, Color.LIME, Color.YELLOW, Color.YELLOW, Color.YELLOW, Color.RED};
        this.control = ((LedBargraphBuilder)((LedBargraphBuilder)((LedBargraphBuilder)((LedBargraphBuilder)((LedBargraphBuilder)((LedBargraphBuilder)LedBargraphBuilder.create().ledType(Led.LedType.ROUND)).orientation(Orientation.HORIZONTAL)).noOfLeds(16)).ledColors(ledColors)).peakValueVisible(true)).ledSize(32.0)).build();
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > Demo.this.lastTimerCall + 100000000L) {
                    Demo.this.control.setValue(RND.nextDouble());
                    Demo.this.lastTimerCall = NOW;
                }
            }
        };
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane(new Node[]{this.control});
        pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        Scene scene = new Scene((Parent)pane, 400.0, 400.0, (Paint)Color.rgb((int)0, (int)0, (int)0, (double)0.8));
        stage.setTitle("Led Bargraph demo");
        stage.setScene(scene);
        stage.show();
        this.timer.start();
        Demo.calcNoOfNodes((Node)scene.getRoot());
        System.out.println(noOfNodes + " Nodes in SceneGraph");
    }

    public void stop() {
    }

    public static void main(String[] args) {
        Demo.launch((String[])args);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                Demo.calcNoOfNodes(n);
            }
        }
    }
}

