/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.sevensegment.skin;

import eu.hansolo.enzo.sevensegment.SevenSegment;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public class SevenSegmentSkin
extends SkinBase<SevenSegment>
implements Skin<SevenSegment> {
    private static final double PREFERRED_WIDTH = 268.0;
    private static final double PREFERRED_HEIGHT = 357.0;
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static double aspectRatio;
    private double size;
    private double width;
    private double height;
    private Pane pane;
    private Region segmentA;
    private Region segmentB;
    private Region segmentC;
    private Region segmentD;
    private Region segmentE;
    private Region segmentF;
    private Region segmentG;
    private Region segmentDot;
    private Map<SevenSegment.Segment, Region> segmentMap;

    public SevenSegmentSkin(SevenSegment CONTROL) {
        super((Control)CONTROL);
        aspectRatio = 1.3320895522388059;
        this.pane = new Pane();
        this.segmentMap = new HashMap<SevenSegment.Segment, Region>(8);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((SevenSegment)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((SevenSegment)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((SevenSegment)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((SevenSegment)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((SevenSegment)this.getSkinnable()).getPrefWidth() > 0.0 && ((SevenSegment)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((SevenSegment)this.getSkinnable()).setPrefSize(((SevenSegment)this.getSkinnable()).getPrefWidth(), ((SevenSegment)this.getSkinnable()).getPrefHeight());
            } else {
                ((SevenSegment)this.getSkinnable()).setPrefSize(268.0, 357.0);
            }
        }
        if (Double.compare(((SevenSegment)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((SevenSegment)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((SevenSegment)this.getSkinnable()).setMinSize(5.0, 5.0);
        }
        if (Double.compare(((SevenSegment)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((SevenSegment)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((SevenSegment)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
        if (((SevenSegment)this.getSkinnable()).getPrefWidth() != 268.0 || ((SevenSegment)this.getSkinnable()).getPrefHeight() != 357.0) {
            aspectRatio = ((SevenSegment)this.getSkinnable()).getPrefHeight() / ((SevenSegment)this.getSkinnable()).getPrefWidth();
        }
    }

    private void initGraphics() {
        this.segmentA = new Region();
        this.segmentA.getStyleClass().setAll((Object[])new String[]{"a"});
        this.segmentMap.put(SevenSegment.Segment.A, this.segmentA);
        this.segmentB = new Region();
        this.segmentB.getStyleClass().setAll((Object[])new String[]{"b"});
        this.segmentMap.put(SevenSegment.Segment.B, this.segmentB);
        this.segmentC = new Region();
        this.segmentC.getStyleClass().setAll((Object[])new String[]{"c"});
        this.segmentMap.put(SevenSegment.Segment.C, this.segmentC);
        this.segmentD = new Region();
        this.segmentD.getStyleClass().setAll((Object[])new String[]{"d"});
        this.segmentMap.put(SevenSegment.Segment.D, this.segmentD);
        this.segmentE = new Region();
        this.segmentE.getStyleClass().setAll((Object[])new String[]{"e"});
        this.segmentMap.put(SevenSegment.Segment.E, this.segmentE);
        this.segmentF = new Region();
        this.segmentF.getStyleClass().setAll((Object[])new String[]{"f"});
        this.segmentMap.put(SevenSegment.Segment.F, this.segmentF);
        this.segmentG = new Region();
        this.segmentG.getStyleClass().setAll((Object[])new String[]{"g"});
        this.segmentMap.put(SevenSegment.Segment.G, this.segmentG);
        this.segmentDot = new Region();
        this.segmentDot.getStyleClass().setAll((Object[])new String[]{"dot"});
        this.segmentMap.put(SevenSegment.Segment.DOT, this.segmentDot);
        this.pane.getChildren().setAll((Object[])new Node[]{this.segmentA, this.segmentB, this.segmentC, this.segmentD, this.segmentE, this.segmentF, this.segmentG, this.segmentDot});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.resize();
        this.update();
    }

    private void registerListeners() {
        ((SevenSegment)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SevenSegment)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SevenSegment)this.getSkinnable()).prefWidthProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((SevenSegment)this.getSkinnable()).prefHeightProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((SevenSegment)this.getSkinnable()).characterProperty().addListener(observable -> this.handleControlPropertyChanged("CHARACTER"));
        ((SevenSegment)this.getSkinnable()).dotOnProperty().addListener(observable -> this.handleControlPropertyChanged("DOT_ON"));
        ((SevenSegment)this.getSkinnable()).segmentStyleProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((SevenSegment)this.getSkinnable()).getStyleClass().addListener((ListChangeListener)new ListChangeListener<String>(){

            public void onChanged(ListChangeListener.Change<? extends String> change) {
                SevenSegmentSkin.this.resize();
                SevenSegmentSkin.this.update();
            }
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("UPDATE".equals(PROPERTY)) {
            this.update();
        } else if ("RESIZE".equals(PROPERTY)) {
            this.resize();
            this.update();
        } else if ("PREF_SIZE".equals(PROPERTY)) {
            aspectRatio = ((SevenSegment)this.getSkinnable()).getPrefHeight() / ((SevenSegment)this.getSkinnable()).getPrefWidth();
        } else if ("CHARACTER".equals(PROPERTY)) {
            this.update();
        } else if ("DOT_ON".equals(PROPERTY)) {
            this.update();
        }
    }

    private void update() {
        int ASCII = ((SevenSegment)this.getSkinnable()).getCharacter().isEmpty() ? 20 : (int)((SevenSegment)this.getSkinnable()).getCharacter().toUpperCase().charAt(0);
        String ON_STYLE = ((SevenSegment)this.getSkinnable()).getSegmentStyle().ON_CLASS;
        String OFF_STYLE = ((SevenSegment)this.getSkinnable()).getSegmentStyle().OFF_CLASS;
        for (SevenSegment.Segment segment : this.segmentMap.keySet()) {
            if (((SevenSegment)this.getSkinnable()).getSegmentMapping().containsKey(ASCII)) {
                if (((SevenSegment)this.getSkinnable()).getSegmentMapping().get(ASCII).contains((Object)segment)) {
                    this.segmentMap.get((Object)segment).getStyleClass().setAll((Object[])new String[]{segment.name().toLowerCase(), ON_STYLE});
                    continue;
                }
                this.segmentMap.get((Object)segment).getStyleClass().setAll((Object[])new String[]{segment.name().toLowerCase(), OFF_STYLE});
                continue;
            }
            this.segmentMap.get((Object)segment).getStyleClass().setAll((Object[])new String[]{segment.name().toLowerCase(), OFF_STYLE});
        }
        if (((SevenSegment)this.getSkinnable()).isDotOn()) {
            this.segmentMap.get((Object)SevenSegment.Segment.DOT).getStyleClass().setAll((Object[])new String[]{"dot", ON_STYLE});
        } else {
            this.segmentMap.get((Object)SevenSegment.Segment.DOT).getStyleClass().setAll((Object[])new String[]{"dot", OFF_STYLE});
        }
    }

    private void resize() {
        this.size = ((SevenSegment)this.getSkinnable()).getWidth() < ((SevenSegment)this.getSkinnable()).getHeight() ? ((SevenSegment)this.getSkinnable()).getWidth() : ((SevenSegment)this.getSkinnable()).getHeight();
        this.width = ((SevenSegment)this.getSkinnable()).getWidth();
        this.height = ((SevenSegment)this.getSkinnable()).getHeight();
        if (((SevenSegment)this.getSkinnable()).isKeepAspect()) {
            if (aspectRatio * this.width > this.height) {
                this.width = 1.0 / (aspectRatio / this.height);
            } else if (1.0 / (aspectRatio / this.height) > this.width) {
                this.height = aspectRatio * this.width;
            }
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.segmentA.setPrefSize(0.7078622846461055 * this.width, 0.12605043085349374 * this.height);
            this.segmentA.setTranslateX(0.11621808294040054 * this.width);
            this.segmentA.setTranslateY(0.0 * this.height);
            this.segmentB.setPrefSize(0.19782541758978545 * this.width, 0.4623330167027749 * this.height);
            this.segmentB.setTranslateX(0.6715775674848414 * this.width);
            this.segmentB.setTranslateY(0.03402365890203738 * this.height);
            this.segmentC.setPrefSize(0.20474943474157534 * this.width, 0.46794295110622375 * this.height);
            this.segmentC.setTranslateX(0.6267936478799848 * this.width);
            this.segmentC.setTranslateY(0.5036215902376575 * this.height);
            this.segmentD.setPrefSize(0.7041493885552705 * this.width, 0.12605042016806722 * this.height);
            this.segmentD.setTranslateX(0.04532256055234084 * this.width);
            this.segmentD.setTranslateY(0.8739495798319328 * this.height);
            this.segmentE.setPrefSize(0.20156638302020172 * this.width, 0.4595308704536502 * this.height);
            this.segmentE.setTranslateX(0.0 * this.width);
            this.segmentE.setTranslateY(0.5036443288252801 * this.height);
            this.segmentF.setPrefSize(0.20103195532044368 * this.width, 0.47076633998325895 * this.height);
            this.segmentF.setTranslateX(0.03783089367311392 * this.width);
            this.segmentF.setTranslateY(0.028435463998831956 * this.height);
            this.segmentG.setPrefSize(0.6134279165694962 * this.width, 0.12605042016806722 * this.height);
            this.segmentG.setTranslateX(0.12985323436224638 * this.width);
            this.segmentG.setTranslateY(0.4369747899159664 * this.height);
            this.segmentDot.setPrefSize(0.16791044776119404 * this.width, 0.12605042016806722 * this.height);
            this.segmentDot.setTranslateX(0.832089552238806 * this.width);
            this.segmentDot.setTranslateY(0.8739495798319328 * this.height);
        }
    }
}

