/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SwitchExpression;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FinallyFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Util;

public class FakedTrackingVariable
extends LocalDeclaration {
    private static final char[] UNASSIGNED_CLOSEABLE_NAME = "<unassigned Closeable value>".toCharArray();
    private static final char[] UNASSIGNED_CLOSEABLE_NAME_TEMPLATE = "<unassigned Closeable value from line {0}>".toCharArray();
    private static final char[] TEMPLATE_ARGUMENT = "{0}".toCharArray();
    private static final int CLOSE_SEEN = 1;
    private static final int SHARED_WITH_OUTSIDE = 2;
    private static final int OWNED_BY_OUTSIDE = 4;
    private static final int CLOSED_IN_NESTED_METHOD = 8;
    private static final int REPORTED_EXPLICIT_CLOSE = 16;
    private static final int REPORTED_POTENTIAL_LEAK = 32;
    private static final int REPORTED_DEFINITIVE_LEAK = 64;
    private static final int FOREACH_ELEMENT_VAR = 128;
    private static final int TWR_EFFECTIVELY_FINAL = 256;
    public MessageSend acquisition;
    public static boolean TEST_372319 = false;
    private int globalClosingState = 0;
    public LocalVariableBinding originalBinding;
    public FakedTrackingVariable innerTracker;
    public FakedTrackingVariable outerTracker;
    MethodScope methodScope;
    private HashMap recordedLocations;
    private ASTNode currentAssignment;
    private FlowContext tryContext;

    public FakedTrackingVariable(LocalVariableBinding localVariableBinding, ASTNode aSTNode, FlowInfo flowInfo, FlowContext flowContext, int n) {
        super(localVariableBinding.name, aSTNode.sourceStart, aSTNode.sourceEnd);
        this.type = new SingleTypeReference(TypeConstants.OBJECT, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
        this.methodScope = localVariableBinding.declaringScope.methodScope();
        this.originalBinding = localVariableBinding;
        while (flowContext != null) {
            if (flowContext instanceof FinallyFlowContext) {
                this.tryContext = ((FinallyFlowContext)flowContext).tryContext;
                break;
            }
            flowContext = flowContext.parent;
        }
        this.resolve(localVariableBinding.declaringScope);
        if (n != 0) {
            flowInfo.markNullStatus(this.binding, n);
        }
    }

    private FakedTrackingVariable(BlockScope blockScope, ASTNode aSTNode, FlowInfo flowInfo, int n) {
        super(UNASSIGNED_CLOSEABLE_NAME, aSTNode.sourceStart, aSTNode.sourceEnd);
        this.type = new SingleTypeReference(TypeConstants.OBJECT, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
        this.methodScope = blockScope.methodScope();
        this.originalBinding = null;
        this.resolve(blockScope);
        if (n != 0) {
            flowInfo.markNullStatus(this.binding, n);
        }
    }

    private void attachTo(LocalVariableBinding localVariableBinding) {
        localVariableBinding.closeTracker = this;
        this.originalBinding = localVariableBinding;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
    }

    @Override
    public void resolve(BlockScope blockScope) {
        this.binding = new LocalVariableBinding(this.name, (TypeBinding)blockScope.getJavaLangObject(), 0, false);
        this.binding.closeTracker = this;
        this.binding.declaringScope = blockScope;
        this.binding.setConstant(Constant.NotAConstant);
        this.binding.useFlag = 1;
        this.binding.id = blockScope.registerTrackingVariable(this);
    }

    public static FakedTrackingVariable getCloseTrackingVariable(Expression expression, FlowInfo flowInfo, FlowContext flowContext) {
        while (true) {
            if (expression instanceof CastExpression) {
                expression = ((CastExpression)expression).expression;
                continue;
            }
            if (!(expression instanceof Assignment)) break;
            expression = ((Assignment)expression).expression;
        }
        if (expression instanceof ConditionalExpression) {
            FakedTrackingVariable fakedTrackingVariable = FakedTrackingVariable.getCloseTrackingVariable(((ConditionalExpression)expression).valueIfFalse, flowInfo, flowContext);
            if (fakedTrackingVariable != null) {
                return fakedTrackingVariable;
            }
            return FakedTrackingVariable.getCloseTrackingVariable(((ConditionalExpression)expression).valueIfTrue, flowInfo, flowContext);
        }
        if (expression instanceof SwitchExpression) {
            for (Expression expression2 : ((SwitchExpression)expression).resultExpressions) {
                FakedTrackingVariable fakedTrackingVariable = FakedTrackingVariable.getCloseTrackingVariable(expression2, flowInfo, flowContext);
                if (fakedTrackingVariable == null) continue;
                return fakedTrackingVariable;
            }
            return null;
        }
        if (expression instanceof SingleNameReference) {
            SingleNameReference singleNameReference = (SingleNameReference)expression;
            if (singleNameReference.binding instanceof LocalVariableBinding) {
                LocalVariableBinding localVariableBinding = (LocalVariableBinding)singleNameReference.binding;
                if (localVariableBinding.closeTracker != null) {
                    return localVariableBinding.closeTracker;
                }
                if (!FakedTrackingVariable.isAnyCloseable(expression.resolvedType)) {
                    return null;
                }
                if ((localVariableBinding.tagBits & 0x2000L) != 0L) {
                    return null;
                }
                LocalDeclaration localDeclaration = localVariableBinding.declaration;
                localVariableBinding.closeTracker = new FakedTrackingVariable(localVariableBinding, localDeclaration, flowInfo, flowContext, 1);
                if (localVariableBinding.isParameter()) {
                    localVariableBinding.closeTracker.globalClosingState |= 4;
                }
                return localVariableBinding.closeTracker;
            }
        } else {
            if (expression instanceof AllocationExpression) {
                return ((AllocationExpression)expression).closeTracker;
            }
            if (expression instanceof MessageSend) {
                return ((MessageSend)expression).closeTracker;
            }
        }
        return null;
    }

    public static FakedTrackingVariable preConnectTrackerAcrossAssignment(ASTNode aSTNode, LocalVariableBinding localVariableBinding, Expression expression, FlowInfo flowInfo) {
        FakedTrackingVariable fakedTrackingVariable = null;
        if (FakedTrackingVariable.containsAllocation(expression)) {
            fakedTrackingVariable = localVariableBinding.closeTracker;
            if (fakedTrackingVariable == null && expression.resolvedType != TypeBinding.NULL) {
                fakedTrackingVariable = new FakedTrackingVariable(localVariableBinding, aSTNode, flowInfo, null, 1);
                if (localVariableBinding.isParameter()) {
                    fakedTrackingVariable.globalClosingState |= 4;
                }
            }
            if (fakedTrackingVariable != null) {
                fakedTrackingVariable.currentAssignment = aSTNode;
                FakedTrackingVariable.preConnectTrackerAcrossAssignment(aSTNode, localVariableBinding, flowInfo, fakedTrackingVariable, expression);
            }
        } else if (expression instanceof MessageSend) {
            fakedTrackingVariable = localVariableBinding.closeTracker;
            if (fakedTrackingVariable != null) {
                FakedTrackingVariable.handleReassignment(flowInfo, fakedTrackingVariable, aSTNode);
            }
            if (expression.resolvedType != TypeBinding.NULL) {
                fakedTrackingVariable = new FakedTrackingVariable(localVariableBinding, aSTNode, flowInfo, null, 1);
                fakedTrackingVariable.currentAssignment = aSTNode;
                ((MessageSend)expression).closeTracker = fakedTrackingVariable;
            }
        }
        return fakedTrackingVariable;
    }

    private static boolean containsAllocation(SwitchExpression switchExpression) {
        for (Expression expression : switchExpression.resultExpressions) {
            if (!FakedTrackingVariable.containsAllocation(expression)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsAllocation(ASTNode aSTNode) {
        if (aSTNode instanceof AllocationExpression) {
            return true;
        }
        if (aSTNode instanceof ConditionalExpression) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)aSTNode;
            return FakedTrackingVariable.containsAllocation(conditionalExpression.valueIfTrue) || FakedTrackingVariable.containsAllocation(conditionalExpression.valueIfFalse);
        }
        if (aSTNode instanceof SwitchExpression) {
            return FakedTrackingVariable.containsAllocation((SwitchExpression)aSTNode);
        }
        if (aSTNode instanceof CastExpression) {
            return FakedTrackingVariable.containsAllocation(((CastExpression)aSTNode).expression);
        }
        if (aSTNode instanceof MessageSend && FakedTrackingVariable.isFluentMethod(((MessageSend)aSTNode).binding)) {
            return FakedTrackingVariable.containsAllocation(((MessageSend)aSTNode).receiver);
        }
        return false;
    }

    private static void preConnectTrackerAcrossAssignment(ASTNode aSTNode, LocalVariableBinding localVariableBinding, FlowInfo flowInfo, FakedTrackingVariable fakedTrackingVariable, Expression expression) {
        if (expression instanceof AllocationExpression) {
            FakedTrackingVariable.preConnectTrackerAcrossAssignment(aSTNode, localVariableBinding, flowInfo, (AllocationExpression)expression, fakedTrackingVariable);
        } else if (expression instanceof ConditionalExpression) {
            FakedTrackingVariable.preConnectTrackerAcrossAssignment(aSTNode, localVariableBinding, flowInfo, (ConditionalExpression)expression, fakedTrackingVariable);
        } else if (expression instanceof SwitchExpression) {
            FakedTrackingVariable.preConnectTrackerAcrossAssignment(aSTNode, localVariableBinding, flowInfo, (SwitchExpression)expression, fakedTrackingVariable);
        } else if (expression instanceof CastExpression) {
            FakedTrackingVariable.preConnectTrackerAcrossAssignment(aSTNode, localVariableBinding, ((CastExpression)expression).expression, flowInfo);
        } else if (expression instanceof MessageSend && FakedTrackingVariable.isFluentMethod(((MessageSend)expression).binding)) {
            FakedTrackingVariable.preConnectTrackerAcrossAssignment(aSTNode, localVariableBinding, ((MessageSend)expression).receiver, flowInfo);
        }
    }

    private static void preConnectTrackerAcrossAssignment(ASTNode aSTNode, LocalVariableBinding localVariableBinding, FlowInfo flowInfo, ConditionalExpression conditionalExpression, FakedTrackingVariable fakedTrackingVariable) {
        FakedTrackingVariable.preConnectTrackerAcrossAssignment(aSTNode, localVariableBinding, flowInfo, fakedTrackingVariable, conditionalExpression.valueIfFalse);
        FakedTrackingVariable.preConnectTrackerAcrossAssignment(aSTNode, localVariableBinding, flowInfo, fakedTrackingVariable, conditionalExpression.valueIfTrue);
    }

    private static void preConnectTrackerAcrossAssignment(ASTNode aSTNode, LocalVariableBinding localVariableBinding, FlowInfo flowInfo, SwitchExpression switchExpression, FakedTrackingVariable fakedTrackingVariable) {
        for (Expression expression : switchExpression.resultExpressions) {
            FakedTrackingVariable.preConnectTrackerAcrossAssignment(aSTNode, localVariableBinding, flowInfo, fakedTrackingVariable, expression);
        }
    }

    private static void preConnectTrackerAcrossAssignment(ASTNode aSTNode, LocalVariableBinding localVariableBinding, FlowInfo flowInfo, AllocationExpression allocationExpression, FakedTrackingVariable fakedTrackingVariable) {
        FakedTrackingVariable fakedTrackingVariable2;
        allocationExpression.closeTracker = fakedTrackingVariable;
        if (allocationExpression.arguments != null && allocationExpression.arguments.length > 0 && (fakedTrackingVariable2 = FakedTrackingVariable.preConnectTrackerAcrossAssignment(aSTNode, localVariableBinding, allocationExpression.arguments[0], flowInfo)) != fakedTrackingVariable && fakedTrackingVariable.innerTracker == null) {
            fakedTrackingVariable.innerTracker = fakedTrackingVariable2;
        }
    }

    public static void analyseCloseableAllocation(BlockScope blockScope, FlowInfo flowInfo, AllocationExpression allocationExpression) {
        if (((ReferenceBinding)allocationExpression.resolvedType).hasTypeBit(8)) {
            if (allocationExpression.closeTracker != null) {
                allocationExpression.closeTracker.withdraw();
                allocationExpression.closeTracker = null;
            }
        } else if (((ReferenceBinding)allocationExpression.resolvedType).hasTypeBit(4)) {
            boolean bl = true;
            if (allocationExpression.arguments != null && allocationExpression.arguments.length > 0) {
                FakedTrackingVariable fakedTrackingVariable = FakedTrackingVariable.findCloseTracker(blockScope, flowInfo, allocationExpression.arguments[0]);
                if (fakedTrackingVariable != null) {
                    int n;
                    FakedTrackingVariable fakedTrackingVariable2 = fakedTrackingVariable;
                    do {
                        if (fakedTrackingVariable2 != allocationExpression.closeTracker) continue;
                        return;
                    } while ((fakedTrackingVariable2 = fakedTrackingVariable2.innerTracker) != null);
                    int n2 = 2;
                    if (allocationExpression.closeTracker == null) {
                        allocationExpression.closeTracker = new FakedTrackingVariable(blockScope, allocationExpression, flowInfo, 1);
                    } else if (blockScope.finallyInfo != null && (n = blockScope.finallyInfo.nullStatus(allocationExpression.closeTracker.binding)) != 1) {
                        n2 = n;
                    }
                    if (allocationExpression.closeTracker.innerTracker != null && allocationExpression.closeTracker.innerTracker != fakedTrackingVariable) {
                        fakedTrackingVariable = FakedTrackingVariable.pickMoreUnsafe(allocationExpression.closeTracker.innerTracker, fakedTrackingVariable, blockScope, flowInfo);
                    }
                    allocationExpression.closeTracker.innerTracker = fakedTrackingVariable;
                    fakedTrackingVariable.outerTracker = allocationExpression.closeTracker;
                    flowInfo.markNullStatus(allocationExpression.closeTracker.binding, n2);
                    if (n2 != 2) {
                        FakedTrackingVariable fakedTrackingVariable3 = fakedTrackingVariable;
                        while (fakedTrackingVariable3 != null) {
                            flowInfo.markNullStatus(fakedTrackingVariable3.binding, n2);
                            fakedTrackingVariable3.globalClosingState |= allocationExpression.closeTracker.globalClosingState;
                            fakedTrackingVariable3 = fakedTrackingVariable3.innerTracker;
                        }
                    }
                    return;
                }
                if (!FakedTrackingVariable.isAnyCloseable(allocationExpression.arguments[0].resolvedType)) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl) {
                if (allocationExpression.closeTracker != null) {
                    allocationExpression.closeTracker.withdraw();
                    allocationExpression.closeTracker = null;
                }
            } else {
                FakedTrackingVariable.handleRegularResource(blockScope, flowInfo, allocationExpression);
            }
        } else {
            FakedTrackingVariable.handleRegularResource(blockScope, flowInfo, allocationExpression);
        }
    }

    public static FlowInfo analyseCloseableAcquisition(BlockScope blockScope, FlowInfo flowInfo, MessageSend messageSend) {
        if (FakedTrackingVariable.isFluentMethod(messageSend.binding)) {
            messageSend.closeTracker = FakedTrackingVariable.findCloseTracker(blockScope, flowInfo, messageSend.receiver);
            return flowInfo;
        }
        if (((ReferenceBinding)messageSend.resolvedType).hasTypeBit(8)) {
            if (messageSend.closeTracker != null) {
                messageSend.closeTracker.withdraw();
                messageSend.closeTracker = null;
            }
            return flowInfo;
        }
        FakedTrackingVariable fakedTrackingVariable = messageSend.closeTracker;
        if (fakedTrackingVariable != null) {
            fakedTrackingVariable.withdraw();
            messageSend.closeTracker = null;
            return flowInfo;
        }
        messageSend.closeTracker = fakedTrackingVariable = new FakedTrackingVariable(blockScope, messageSend, flowInfo, 1);
        fakedTrackingVariable.acquisition = messageSend;
        FlowInfo flowInfo2 = flowInfo.copy();
        flowInfo2.markAsDefinitelyNonNull(fakedTrackingVariable.binding);
        flowInfo.markAsDefinitelyNull(fakedTrackingVariable.binding);
        return FlowInfo.conditional(flowInfo2, flowInfo);
    }

    private static boolean isFluentMethod(MethodBinding methodBinding) {
        if (methodBinding.isStatic()) {
            return false;
        }
        ReferenceBinding referenceBinding = methodBinding.declaringClass;
        if (referenceBinding.equals(methodBinding.returnType)) {
            for (char[][] cArray : TypeConstants.FLUENT_RESOURCE_CLASSES) {
                if (!CharOperation.equals(cArray, referenceBinding.compoundName)) continue;
                return true;
            }
        }
        return false;
    }

    private static FakedTrackingVariable pickMoreUnsafe(FakedTrackingVariable fakedTrackingVariable, FakedTrackingVariable fakedTrackingVariable2, BlockScope blockScope, FlowInfo flowInfo) {
        int n = flowInfo.nullStatus(fakedTrackingVariable.binding);
        int n2 = flowInfo.nullStatus(fakedTrackingVariable2.binding);
        if (n == 2 || n2 == 4) {
            return FakedTrackingVariable.pick(fakedTrackingVariable, fakedTrackingVariable2, blockScope);
        }
        if (n == 4 || n2 == 2) {
            return FakedTrackingVariable.pick(fakedTrackingVariable2, fakedTrackingVariable, blockScope);
        }
        if ((n & 0x10) != 0) {
            return FakedTrackingVariable.pick(fakedTrackingVariable, fakedTrackingVariable2, blockScope);
        }
        if ((n2 & 0x10) != 0) {
            return FakedTrackingVariable.pick(fakedTrackingVariable2, fakedTrackingVariable, blockScope);
        }
        return FakedTrackingVariable.pick(fakedTrackingVariable, fakedTrackingVariable2, blockScope);
    }

    private static FakedTrackingVariable pick(FakedTrackingVariable fakedTrackingVariable, FakedTrackingVariable fakedTrackingVariable2, BlockScope blockScope) {
        fakedTrackingVariable2.withdraw();
        return fakedTrackingVariable;
    }

    private static void handleRegularResource(BlockScope blockScope, FlowInfo flowInfo, AllocationExpression allocationExpression) {
        FakedTrackingVariable fakedTrackingVariable = allocationExpression.closeTracker;
        if (fakedTrackingVariable != null && fakedTrackingVariable.originalBinding != null) {
            FakedTrackingVariable.handleReassignment(flowInfo, fakedTrackingVariable, fakedTrackingVariable.currentAssignment);
        } else {
            allocationExpression.closeTracker = new FakedTrackingVariable(blockScope, allocationExpression, flowInfo, 1);
        }
        flowInfo.markAsDefinitelyNull(allocationExpression.closeTracker.binding);
    }

    private static void handleReassignment(FlowInfo flowInfo, FakedTrackingVariable fakedTrackingVariable, ASTNode aSTNode) {
        int n = flowInfo.nullStatus(fakedTrackingVariable.binding);
        if (n != 4 && n != 1 && !flowInfo.isDefinitelyNull(fakedTrackingVariable.originalBinding) && !(aSTNode instanceof LocalDeclaration)) {
            fakedTrackingVariable.recordErrorLocation(aSTNode, n);
        }
    }

    private static FakedTrackingVariable findCloseTracker(BlockScope blockScope, FlowInfo flowInfo, Expression expression) {
        Object object;
        while (expression instanceof Assignment) {
            object = (Assignment)expression;
            LocalVariableBinding localVariableBinding = ((Assignment)object).localVariableBinding();
            if (localVariableBinding != null) {
                return localVariableBinding.closeTracker;
            }
            expression = ((Assignment)object).expression;
        }
        if (expression instanceof SingleNameReference) {
            object = expression.localVariableBinding();
            if (object != null) {
                return ((LocalVariableBinding)object).closeTracker;
            }
        } else {
            if (expression instanceof AllocationExpression) {
                return ((AllocationExpression)expression).closeTracker;
            }
            if (expression instanceof MessageSend) {
                return ((MessageSend)expression).closeTracker;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static void handleResourceAssignment(BlockScope var0, FlowInfo var1_1, FlowInfo var2_2, FlowContext var3_3, ASTNode var4_4, Expression var5_5, LocalVariableBinding var6_6) {
        block20: {
            block21: {
                block22: {
                    var7_7 = null;
                    var8_8 = null;
                    if (var6_6.closeTracker != null) {
                        var7_7 = var6_6.closeTracker;
                        var9_9 = var1_1.nullStatus(var6_6);
                        if (var9_9 != 2 && var9_9 != 1) {
                            var8_8 = var7_7;
                        }
                    }
                    if (var5_5.resolvedType == TypeBinding.NULL) break block20;
                    var9_10 = FakedTrackingVariable.getCloseTrackingVariable(var5_5, var2_2, var3_3);
                    if (var9_10 == null) break block21;
                    if (var6_6.closeTracker != null) break block22;
                    if (var9_10.originalBinding != null) {
                        var6_6.closeTracker = var9_10;
                    }
                    if (var9_10.currentAssignment == var4_4) {
                        var9_10.globalClosingState &= -135;
                    }
                    break block20;
                }
                if (!(var5_5 instanceof AllocationExpression) && !(var5_5 instanceof ConditionalExpression) && !(var5_5 instanceof SwitchExpression) && !(var5_5 instanceof MessageSend)) ** GOTO lbl-1000
                if (var9_10 == var8_8) {
                    return;
                }
                if (var6_6.closeTracker == var9_10 && (var9_10.globalClosingState & 4) != 0) {
                    var6_6.closeTracker = new FakedTrackingVariable(var6_6, var4_4, var2_2, var3_3, 2);
                } else lbl-1000:
                // 2 sources

                {
                    var9_10.attachTo(var6_6);
                }
                break block20;
            }
            if (var7_7 != null) {
                var10_11 = var3_3;
                if (var7_7.tryContext != null) {
                    while (var10_11 != null) {
                        if (var7_7.tryContext != var10_11) {
                            var10_11 = var10_11.parent;
                            continue;
                        }
                        break;
                    }
                } else {
                    if ((var7_7.globalClosingState & 134) == 0 && var2_2.hasNullInfoFor(var7_7.binding)) {
                        var2_2.markAsDefinitelyNull(var7_7.binding);
                    }
                    var6_6.closeTracker = FakedTrackingVariable.analyseCloseableExpression(var2_2, var3_3, var6_6, var4_4, var5_5, var7_7);
                }
            } else {
                var9_10 = FakedTrackingVariable.analyseCloseableExpression(var2_2, var3_3, var6_6, var4_4, var5_5, null);
                if (var9_10 != null) {
                    var9_10.attachTo(var6_6);
                    if ((var9_10.globalClosingState & 134) == 0) {
                        var2_2.markAsDefinitelyNull(var9_10.binding);
                    }
                }
            }
        }
        if (var8_8 != null) {
            if (var8_8.innerTracker != null && var8_8.innerTracker.binding.declaringScope == var0) {
                var8_8.innerTracker.outerTracker = null;
                var0.pruneWrapperTrackingVar(var8_8);
            } else {
                var9_9 = var1_1.nullStatus(var8_8.binding);
                if (var9_9 != 4) {
                    var8_8.recordErrorLocation(var4_4, var9_9);
                }
            }
        }
    }

    private static FakedTrackingVariable analyseCloseableExpression(FlowInfo flowInfo, FlowContext flowContext, LocalVariableBinding localVariableBinding, ASTNode aSTNode, Expression expression, FakedTrackingVariable fakedTrackingVariable) {
        Object object;
        while (true) {
            if (expression instanceof Assignment) {
                expression = ((Assignment)expression).expression;
                continue;
            }
            if (!(expression instanceof CastExpression)) break;
            expression = ((CastExpression)expression).expression;
        }
        boolean bl = false;
        if (expression.resolvedType instanceof ReferenceBinding && ((TypeBinding)(object = (ReferenceBinding)expression.resolvedType)).hasTypeBit(8)) {
            if (FakedTrackingVariable.isBlacklistedMethod(expression)) {
                bl = true;
            } else {
                return null;
            }
        }
        if (expression instanceof AllocationExpression) {
            object = ((AllocationExpression)expression).closeTracker;
            if (object != null && ((FakedTrackingVariable)object).originalBinding == null) {
                return null;
            }
            return object;
        }
        if (expression instanceof MessageSend || expression instanceof ArrayReference) {
            object = new FakedTrackingVariable(localVariableBinding, aSTNode, flowInfo, flowContext, 16);
            if (!bl) {
                ((FakedTrackingVariable)object).globalClosingState |= 2;
            }
            return object;
        }
        if ((expression.bits & 7) == 1 || expression instanceof QualifiedNameReference && ((QualifiedNameReference)expression).isFieldAccess()) {
            object = new FakedTrackingVariable(localVariableBinding, aSTNode, flowInfo, flowContext, 1);
            ((FakedTrackingVariable)object).globalClosingState |= 4;
            return object;
        }
        if (localVariableBinding.closeTracker != null) {
            return localVariableBinding.closeTracker;
        }
        object = new FakedTrackingVariable(localVariableBinding, aSTNode, flowInfo, flowContext, 1);
        LocalVariableBinding localVariableBinding2 = expression.localVariableBinding();
        if (localVariableBinding2 != null && localVariableBinding2.isParameter()) {
            ((FakedTrackingVariable)object).globalClosingState |= 4;
        }
        return object;
    }

    private static boolean isBlacklistedMethod(Expression expression) {
        MethodBinding methodBinding;
        if (expression instanceof MessageSend && (methodBinding = ((MessageSend)expression).binding) != null && methodBinding.isValidBinding()) {
            return CharOperation.equals(methodBinding.declaringClass.compoundName, TypeConstants.JAVA_NIO_FILE_FILES);
        }
        return false;
    }

    public static void cleanUpAfterAssignment(BlockScope blockScope, int n, Expression expression) {
        while (true) {
            if (expression instanceof Assignment) {
                expression = ((Assignment)expression).expression;
                continue;
            }
            if (!(expression instanceof CastExpression)) break;
            expression = ((CastExpression)expression).expression;
        }
        if (expression instanceof AllocationExpression) {
            FakedTrackingVariable fakedTrackingVariable = ((AllocationExpression)expression).closeTracker;
            if (fakedTrackingVariable != null && fakedTrackingVariable.originalBinding == null) {
                fakedTrackingVariable.withdraw();
                ((AllocationExpression)expression).closeTracker = null;
            }
        } else if (expression instanceof MessageSend) {
            FakedTrackingVariable fakedTrackingVariable = ((MessageSend)expression).closeTracker;
            if (fakedTrackingVariable != null && fakedTrackingVariable.originalBinding == null) {
                fakedTrackingVariable.withdraw();
                ((MessageSend)expression).closeTracker = null;
            }
        } else {
            LocalVariableBinding localVariableBinding = expression.localVariableBinding();
            if (localVariableBinding != null && localVariableBinding.closeTracker != null && (n & 1) != 0) {
                localVariableBinding.closeTracker.withdraw();
            }
        }
    }

    public static void cleanUpUnassigned(BlockScope blockScope, ASTNode aSTNode, final FlowInfo flowInfo) {
        if (!blockScope.hasResourceTrackers()) {
            return;
        }
        aSTNode.traverse(new ASTVisitor(){

            @Override
            public boolean visit(MessageSend messageSend, BlockScope blockScope) {
                FakedTrackingVariable fakedTrackingVariable = messageSend.closeTracker;
                if (fakedTrackingVariable != null && fakedTrackingVariable.originalBinding == null) {
                    int n = flowInfo.nullStatus(fakedTrackingVariable.binding);
                    if ((n & 0x12) != 0) {
                        fakedTrackingVariable.reportError(blockScope.problemReporter(), messageSend, n);
                    }
                    fakedTrackingVariable.withdraw();
                }
                return true;
            }
        }, blockScope);
    }

    public static boolean isAnyCloseable(TypeBinding typeBinding) {
        return typeBinding instanceof ReferenceBinding && ((ReferenceBinding)typeBinding).hasTypeBit(3);
    }

    public int findMostSpecificStatus(FlowInfo flowInfo, BlockScope blockScope, BlockScope blockScope2) {
        int n = 1;
        FakedTrackingVariable fakedTrackingVariable = this;
        while (fakedTrackingVariable != null) {
            LocalVariableBinding localVariableBinding = fakedTrackingVariable.binding;
            int n2 = this.getNullStatusAggressively(localVariableBinding, flowInfo);
            if (blockScope2 != null) {
                n2 = this.mergeCloseStatus(blockScope2, n2, localVariableBinding, blockScope);
            }
            if (n2 == 4) {
                n = n2;
                break;
            }
            if (n == 2 || n == 1) {
                n = n2;
            }
            fakedTrackingVariable = fakedTrackingVariable.innerTracker;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNullStatusAggressively(LocalVariableBinding localVariableBinding, FlowInfo flowInfo) {
        if (flowInfo == FlowInfo.DEAD_END) {
            return 1;
        }
        int n = flowInfo.reachMode();
        int n2 = 0;
        try {
            if (n != 0) {
                flowInfo.tagBits &= 0xFFFFFFFC;
            }
            n2 = flowInfo.nullStatus(localVariableBinding);
            if (TEST_372319) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        finally {
            flowInfo.tagBits |= n;
        }
        if ((n2 & 2) != 0) {
            if ((n2 & 0x24) != 0) {
                return 16;
            }
            return 2;
        }
        if ((n2 & 4) != 0) {
            if ((n2 & 0x10) != 0) {
                return 16;
            }
            return 4;
        }
        if ((n2 & 0x10) != 0) {
            return 16;
        }
        if (n2 == 1 && this.originalBinding == null) {
            return 2;
        }
        return n2;
    }

    public int mergeCloseStatus(BlockScope blockScope, int n, LocalVariableBinding localVariableBinding, BlockScope blockScope2) {
        if (n != 4) {
            if (blockScope.finallyInfo != null) {
                int n2 = blockScope.finallyInfo.nullStatus(localVariableBinding);
                if (n2 == 4) {
                    return n2;
                }
                if (n2 != 2 && blockScope.finallyInfo.hasNullInfoFor(localVariableBinding)) {
                    n = 16;
                }
            }
            if (blockScope != blockScope2 && blockScope.parent instanceof BlockScope) {
                return this.mergeCloseStatus((BlockScope)blockScope.parent, n, localVariableBinding, blockScope2);
            }
        }
        return n;
    }

    public void markClose(FlowInfo flowInfo, FlowContext flowContext) {
        FakedTrackingVariable fakedTrackingVariable = this;
        do {
            flowInfo.markAsDefinitelyNonNull(fakedTrackingVariable.binding);
            fakedTrackingVariable.globalClosingState |= 1;
            flowContext.markFinallyNullStatus(fakedTrackingVariable.binding, 4);
        } while ((fakedTrackingVariable = fakedTrackingVariable.innerTracker) != null);
    }

    public void markClosedInNestedMethod() {
        this.globalClosingState |= 8;
    }

    public void markClosedEffectivelyFinal() {
        this.globalClosingState |= 0x100;
    }

    public static FlowInfo markPassedToOutside(BlockScope blockScope, Expression expression, FlowInfo flowInfo, FlowContext flowContext, boolean bl) {
        FakedTrackingVariable fakedTrackingVariable = FakedTrackingVariable.getCloseTrackingVariable(expression, flowInfo, flowContext);
        if (fakedTrackingVariable != null) {
            FlowInfo flowInfo2 = bl ? flowInfo : flowInfo.copy();
            int n = bl ? 4 : 2;
            do {
                fakedTrackingVariable.globalClosingState |= n;
                if (blockScope.methodScope() != fakedTrackingVariable.methodScope) {
                    fakedTrackingVariable.globalClosingState |= 8;
                }
                flowInfo2.markAsDefinitelyNonNull(fakedTrackingVariable.binding);
            } while ((fakedTrackingVariable = fakedTrackingVariable.innerTracker) != null);
            if (bl) {
                return flowInfo2;
            }
            return FlowInfo.conditional(flowInfo, flowInfo2).unconditionalCopy();
        }
        return flowInfo;
    }

    public static void markForeachElementVar(LocalDeclaration localDeclaration) {
        if (localDeclaration.binding != null && localDeclaration.binding.closeTracker != null) {
            localDeclaration.binding.closeTracker.globalClosingState |= 0x80;
        }
    }

    public boolean hasDefinitelyNoResource(FlowInfo flowInfo) {
        if (this.originalBinding == null) {
            return false;
        }
        if (flowInfo.isDefinitelyNull(this.originalBinding)) {
            return true;
        }
        return !flowInfo.isDefinitelyAssigned(this.originalBinding) && !flowInfo.isPotentiallyAssigned(this.originalBinding);
    }

    public boolean isClosedInFinallyOfEnclosing(BlockScope blockScope) {
        BlockScope blockScope2 = blockScope;
        while (blockScope2.finallyInfo == null || !blockScope2.finallyInfo.isDefinitelyNonNull(this.binding)) {
            if (!(blockScope2.parent instanceof BlockScope)) {
                return false;
            }
            blockScope2 = (BlockScope)blockScope2.parent;
        }
        return true;
    }

    public boolean isResourceBeingReturned(FakedTrackingVariable fakedTrackingVariable) {
        FakedTrackingVariable fakedTrackingVariable2 = this;
        do {
            if (fakedTrackingVariable2 != fakedTrackingVariable) continue;
            this.globalClosingState |= 0x40;
            return true;
        } while ((fakedTrackingVariable2 = fakedTrackingVariable2.innerTracker) != null);
        return false;
    }

    public void withdraw() {
        this.binding.declaringScope.removeTrackingVar(this);
    }

    public void recordErrorLocation(ASTNode aSTNode, int n) {
        if ((this.globalClosingState & 4) != 0) {
            return;
        }
        if (this.recordedLocations == null) {
            this.recordedLocations = new HashMap();
        }
        this.recordedLocations.put(aSTNode, n);
    }

    public boolean reportRecordedErrors(Scope scope, int n, boolean bl) {
        FakedTrackingVariable fakedTrackingVariable = this;
        while (fakedTrackingVariable.globalClosingState == 0) {
            fakedTrackingVariable = fakedTrackingVariable.innerTracker;
            if (fakedTrackingVariable != null) continue;
            if (bl && this.neverClosedAtLocations()) {
                n = 2;
            }
            if ((n & 0x32) == 0) break;
            this.reportError(scope.problemReporter(), null, n);
            return true;
        }
        boolean bl2 = false;
        if (this.recordedLocations != null) {
            Iterator iterator = this.recordedLocations.entrySet().iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                n2 |= this.reportError(scope.problemReporter(), (ASTNode)entry.getKey(), (Integer)entry.getValue());
                bl2 = true;
            }
            if (n2 != 0) {
                fakedTrackingVariable = this;
                do {
                    fakedTrackingVariable.globalClosingState |= n2;
                } while ((fakedTrackingVariable = fakedTrackingVariable.innerTracker) != null);
            }
        }
        return bl2;
    }

    private boolean neverClosedAtLocations() {
        if (this.recordedLocations != null) {
            for (Object v : this.recordedLocations.values()) {
                if (v.equals(2)) continue;
                return false;
            }
        }
        return true;
    }

    public int reportError(ProblemReporter problemReporter, ASTNode aSTNode, int n) {
        int n2;
        if ((this.globalClosingState & 4) != 0) {
            return 0;
        }
        boolean bl = false;
        if (n == 2) {
            if ((this.globalClosingState & 8) != 0) {
                bl = true;
            }
        } else if ((n & 0x30) != 0) {
            bl = true;
        }
        if (bl) {
            if ((this.globalClosingState & 0x60) != 0) {
                return 0;
            }
            problemReporter.potentiallyUnclosedCloseable(this, aSTNode);
        } else {
            if ((this.globalClosingState & 0x40) != 0) {
                return 0;
            }
            problemReporter.unclosedCloseable(this, aSTNode);
        }
        int n3 = n2 = bl ? 32 : 64;
        if (aSTNode == null) {
            FakedTrackingVariable fakedTrackingVariable = this;
            do {
                fakedTrackingVariable.globalClosingState |= n2;
            } while ((fakedTrackingVariable = fakedTrackingVariable.innerTracker) != null);
        }
        return n2;
    }

    public void reportExplicitClosing(ProblemReporter problemReporter) {
        if ((this.globalClosingState & 0x194) == 0) {
            this.globalClosingState |= 0x10;
            problemReporter.explicitlyClosedAutoCloseable(this);
        }
    }

    public String nameForReporting(ASTNode aSTNode, ReferenceContext referenceContext) {
        int n;
        int[] nArray;
        int n2;
        CompilationResult compilationResult;
        if (this.name == UNASSIGNED_CLOSEABLE_NAME && aSTNode != null && referenceContext != null && (compilationResult = referenceContext.compilationResult()) != null && (n2 = Util.getLineNumber(this.sourceStart, nArray = compilationResult.getLineSeparatorPositions(), 0, nArray.length - 1)) != (n = Util.getLineNumber(aSTNode.sourceStart, nArray, 0, nArray.length - 1))) {
            char[] cArray = Integer.toString(n2).toCharArray();
            return String.valueOf(CharOperation.replace(UNASSIGNED_CLOSEABLE_NAME_TEMPLATE, TEMPLATE_ARGUMENT, cArray));
        }
        return String.valueOf(this.name);
    }

    public static class IteratorForReporting
    implements Iterator<FakedTrackingVariable> {
        private final Set<FakedTrackingVariable> varSet;
        private final Scope scope;
        private final boolean atExit;
        private Stage stage;
        private Iterator<FakedTrackingVariable> iterator;
        private FakedTrackingVariable next;

        public IteratorForReporting(List<FakedTrackingVariable> list, Scope scope, boolean bl) {
            this.varSet = new HashSet<FakedTrackingVariable>(list);
            this.scope = scope;
            this.atExit = bl;
            this.setUpForStage(Stage.OuterLess);
        }

        @Override
        public boolean hasNext() {
            switch (this.stage.ordinal()) {
                case 0: {
                    FakedTrackingVariable fakedTrackingVariable2;
                    while (this.iterator.hasNext()) {
                        fakedTrackingVariable2 = this.iterator.next();
                        if (fakedTrackingVariable2.outerTracker != null) continue;
                        return this.found(fakedTrackingVariable2);
                    }
                    this.setUpForStage(Stage.InnerOfProcessed);
                }
                case 1: {
                    FakedTrackingVariable fakedTrackingVariable;
                    FakedTrackingVariable fakedTrackingVariable2;
                    while (this.iterator.hasNext()) {
                        fakedTrackingVariable2 = this.iterator.next();
                        fakedTrackingVariable = fakedTrackingVariable2.outerTracker;
                        if (fakedTrackingVariable.binding.declaringScope != this.scope || this.varSet.contains(fakedTrackingVariable)) continue;
                        return this.found(fakedTrackingVariable2);
                    }
                    this.setUpForStage(Stage.InnerOfNotEnclosing);
                }
                case 2: {
                    FakedTrackingVariable fakedTrackingVariable;
                    FakedTrackingVariable fakedTrackingVariable2;
                    block8: while (this.iterator.hasNext()) {
                        fakedTrackingVariable2 = this.iterator.next();
                        fakedTrackingVariable = fakedTrackingVariable2.outerTracker;
                        if (this.varSet.contains(fakedTrackingVariable)) continue;
                        BlockScope blockScope = fakedTrackingVariable.binding.declaringScope;
                        Scope scope = this.scope;
                        while ((scope = scope.parent) instanceof BlockScope) {
                            if (blockScope != scope) continue;
                            break block8;
                        }
                        return this.found(fakedTrackingVariable2);
                    }
                    this.setUpForStage(Stage.AtExit);
                }
                case 3: {
                    if (this.atExit && this.iterator.hasNext()) {
                        return this.found(this.iterator.next());
                    }
                    return false;
                }
            }
            throw new IllegalStateException("Unexpected Stage " + (Object)((Object)this.stage));
        }

        private boolean found(FakedTrackingVariable fakedTrackingVariable) {
            this.iterator.remove();
            this.next = fakedTrackingVariable;
            return true;
        }

        private void setUpForStage(Stage stage2) {
            this.iterator = this.varSet.iterator();
            this.stage = stage2;
        }

        @Override
        public FakedTrackingVariable next() {
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        static enum Stage {
            OuterLess,
            InnerOfProcessed,
            InnerOfNotEnclosing,
            AtExit;

        }
    }
}

