/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.HashMap;
import java.util.function.BiConsumer;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.IPolyExpression;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnlikelyArgumentCheck;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.IrritantSet;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImplicitNullAnnotationVerifier;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolymorphicMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;

public class MessageSend
extends Expression
implements IPolyExpression,
Invocation {
    public Expression receiver;
    public char[] selector;
    public Expression[] arguments;
    public MethodBinding binding;
    public MethodBinding syntheticAccessor;
    public TypeBinding expectedType;
    public long nameSourcePosition;
    public TypeBinding actualReceiverType;
    public TypeBinding valueCast;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;
    public ExpressionContext expressionContext = ExpressionContext.VANILLA_CONTEXT;
    private SimpleLookupTable inferenceContexts;
    private HashMap<TypeBinding, MethodBinding> solutionsPerTargetType;
    private InferenceContext18 outerInferenceContext;
    private boolean receiverIsType;
    protected boolean argsContainCast;
    public TypeBinding[] argumentTypes = Binding.NO_PARAMETERS;
    public boolean argumentsHaveErrors = false;
    public FakedTrackingVariable closeTracker;
    BiConsumer<FlowInfo, Boolean> flowUpdateOnBooleanResult;

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        int n;
        boolean bl;
        CompilerOptions compilerOptions;
        boolean bl2;
        boolean bl3;
        block23: {
            block24: {
                bl3 = !this.binding.isStatic();
                bl2 = (flowContext.tagBits & 0x1000) != 0;
                flowInfo = this.receiver.analyseCode(blockScope, flowContext, flowInfo, bl3).unconditionalInits();
                this.yieldQualifiedCheck(blockScope);
                compilerOptions = blockScope.compilerOptions();
                bl = compilerOptions.analyseResourceLeaks;
                if (!bl) break block23;
                if (!bl3) break block24;
                if (!CharOperation.equals(TypeConstants.CLOSE, this.selector)) break block23;
                this.recordCallingClose(blockScope, flowContext, flowInfo, this.receiver);
                break block23;
            }
            if (this.arguments != null && this.arguments.length > 0 && FakedTrackingVariable.isAnyCloseable(this.arguments[0].resolvedType)) {
                for (n = 0; n < TypeConstants.closeMethods.length; ++n) {
                    TypeConstants.CloseMethodRecord closeMethodRecord = TypeConstants.closeMethods[n];
                    if (!CharOperation.equals(closeMethodRecord.selector, this.selector) || !CharOperation.equals(closeMethodRecord.typeName, this.binding.declaringClass.compoundName)) continue;
                    int n2 = Math.min(closeMethodRecord.numCloseableArgs, this.arguments.length);
                    for (int i = 0; i < n2; ++i) {
                        this.recordCallingClose(blockScope, flowContext, flowInfo, this.arguments[i]);
                    }
                }
            }
            break block23;
            {
                break;
            }
        }
        if (compilerOptions.isAnyEnabled(IrritantSet.UNLIKELY_ARGUMENT_TYPE) && this.binding.isValidBinding() && this.arguments != null) {
            UnlikelyArgumentCheck unlikelyArgumentCheck;
            if (this.arguments.length == 1 && !this.binding.isStatic()) {
                UnlikelyArgumentCheck unlikelyArgumentCheck2 = UnlikelyArgumentCheck.determineCheckForNonStaticSingleArgumentMethod(this.argumentTypes[0], blockScope, this.selector, this.actualReceiverType, this.binding.parameters);
                if (unlikelyArgumentCheck2 != null && unlikelyArgumentCheck2.isDangerous(blockScope)) {
                    blockScope.problemReporter().unlikelyArgumentType(this.arguments[0], this.binding, this.argumentTypes[0], unlikelyArgumentCheck2.typeToReport, unlikelyArgumentCheck2.dangerousMethod);
                }
            } else if (this.arguments.length == 2 && this.binding.isStatic() && (unlikelyArgumentCheck = UnlikelyArgumentCheck.determineCheckForStaticTwoArgumentMethod(this.argumentTypes[1], blockScope, this.selector, this.argumentTypes[0], this.binding.parameters, this.actualReceiverType)) != null && unlikelyArgumentCheck.isDangerous(blockScope)) {
                blockScope.problemReporter().unlikelyArgumentType(this.arguments[1], this.binding, this.argumentTypes[1], unlikelyArgumentCheck.typeToReport, unlikelyArgumentCheck.dangerousMethod);
            }
        }
        if (bl3) {
            n = (this.bits & 0x100000) != 0 ? 3 : 2;
            this.receiver.checkNPE(blockScope, flowContext, flowInfo, n);
        }
        if (this.arguments != null) {
            n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                Expression expression = this.arguments[i];
                expression.checkNPEbyUnboxing(blockScope, flowContext, flowInfo);
                switch (this.detectAssertionUtility(i).ordinal()) {
                    case 1: {
                        flowInfo = this.analyseBooleanAssertion(blockScope, expression, flowContext, flowInfo, bl2, true);
                        break;
                    }
                    case 2: {
                        flowInfo = this.analyseBooleanAssertion(blockScope, expression, flowContext, flowInfo, bl2, false);
                        break;
                    }
                    case 4: {
                        flowInfo = this.analyseNullAssertion(blockScope, expression, flowContext, flowInfo, false);
                        break;
                    }
                    case 3: {
                        flowInfo = this.analyseNullAssertion(blockScope, expression, flowContext, flowInfo, true);
                        break;
                    }
                    case 5: {
                        this.recordFlowUpdateOnResult(((SingleNameReference)expression).localVariableBinding(), true, false);
                        flowInfo = expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                        break;
                    }
                    case 6: {
                        this.recordFlowUpdateOnResult(((SingleNameReference)expression).localVariableBinding(), true, true);
                        flowInfo = expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                        break;
                    }
                    case 7: {
                        this.recordFlowUpdateOnResult(((SingleNameReference)expression).localVariableBinding(), false, true);
                        flowInfo = expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                        break;
                    }
                    default: {
                        flowInfo = expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                    }
                }
                if (!bl) continue;
                flowInfo = FakedTrackingVariable.markPassedToOutside(blockScope, expression, flowInfo, flowContext, false);
            }
            this.analyseArguments(blockScope, flowContext, flowInfo, this.binding, this.arguments);
        }
        TypeBinding[] typeBindingArray = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions != Binding.NO_EXCEPTIONS) {
            if ((this.bits & 0x10000) != 0 && this.genericTypeArguments == null) {
                typeBindingArray = blockScope.environment().convertToRawTypes(this.binding.thrownExceptions, true, true);
            }
            flowContext.checkExceptionHandlers(typeBindingArray, (ASTNode)this, flowInfo.copy(), blockScope);
        }
        if (bl && FakedTrackingVariable.isAnyCloseable(this.resolvedType)) {
            flowInfo = FakedTrackingVariable.analyseCloseableAcquisition(blockScope, flowInfo, this);
        }
        this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
        flowContext.recordAbruptExit();
        flowContext.expireNullCheckedFieldInfo();
        return flowInfo;
    }

    public void recordFlowUpdateOnResult(LocalVariableBinding localVariableBinding, boolean bl, boolean bl2) {
        this.flowUpdateOnBooleanResult = (flowInfo, bl3) -> {
            if (bl3.booleanValue() || bl2) {
                if (bl3 == bl) {
                    flowInfo.markAsDefinitelyNonNull(localVariableBinding);
                } else {
                    flowInfo.markAsDefinitelyNull(localVariableBinding);
                }
            }
        };
    }

    @Override
    protected void updateFlowOnBooleanResult(FlowInfo flowInfo, boolean bl) {
        if (this.flowUpdateOnBooleanResult != null) {
            this.flowUpdateOnBooleanResult.accept(flowInfo, bl);
        }
    }

    private void yieldQualifiedCheck(BlockScope blockScope) {
        long l2 = blockScope.compilerOptions().sourceLevel;
        if (l2 < 0x3A0000L || !this.receiverIsImplicitThis()) {
            return;
        }
        if (this.selector == null || !"yield".equals(new String(this.selector))) {
            return;
        }
        if (l2 >= 0x3A0000L) {
            blockScope.problemReporter().switchExpressionsYieldUnqualifiedMethodError(this);
        } else {
            blockScope.problemReporter().switchExpressionsYieldUnqualifiedMethodWarning(this);
        }
    }

    private void recordCallingClose(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, Expression expression) {
        FakedTrackingVariable fakedTrackingVariable = FakedTrackingVariable.getCloseTrackingVariable(expression, flowInfo, flowContext);
        if (fakedTrackingVariable != null) {
            if (fakedTrackingVariable.methodScope == blockScope.methodScope()) {
                fakedTrackingVariable.markClose(flowInfo, flowContext);
            } else {
                fakedTrackingVariable.markClosedInNestedMethod();
            }
        }
    }

    private AssertUtil detectAssertionUtility(int n) {
        TypeBinding[] typeBindingArray = this.binding.original().parameters;
        if (n < typeBindingArray.length) {
            TypeBinding typeBinding = typeBindingArray[n];
            ReferenceBinding referenceBinding = this.binding.declaringClass;
            if (referenceBinding != null && typeBinding != null) {
                switch (referenceBinding.original().id) {
                    case 68: {
                        if (typeBinding.id == 5) {
                            return AssertUtil.TRUE_ASSERTION;
                        }
                        if (typeBinding.id != 1 || !CharOperation.equals(TypeConstants.IS_NOTNULL, this.selector)) break;
                        return AssertUtil.NONNULL_ASSERTION;
                    }
                    case 69: 
                    case 70: {
                        if (typeBinding.id == 5) {
                            if (CharOperation.equals(TypeConstants.ASSERT_TRUE, this.selector)) {
                                return AssertUtil.TRUE_ASSERTION;
                            }
                            if (!CharOperation.equals(TypeConstants.ASSERT_FALSE, this.selector)) break;
                            return AssertUtil.FALSE_ASSERTION;
                        }
                        if (typeBinding.id != 1) break;
                        if (CharOperation.equals(TypeConstants.ASSERT_NOTNULL, this.selector)) {
                            return AssertUtil.NONNULL_ASSERTION;
                        }
                        if (!CharOperation.equals(TypeConstants.ASSERT_NULL, this.selector)) break;
                        return AssertUtil.NULL_ASSERTION;
                    }
                    case 71: {
                        if (typeBinding.id == 5) {
                            if (!CharOperation.equals(TypeConstants.IS_TRUE, this.selector)) break;
                            return AssertUtil.TRUE_ASSERTION;
                        }
                        if (typeBinding.id != 1 || !CharOperation.equals(TypeConstants.NOT_NULL, this.selector)) break;
                        return AssertUtil.NONNULL_ASSERTION;
                    }
                    case 72: {
                        if (typeBinding.id == 5) {
                            if (!CharOperation.equals(TypeConstants.IS_TRUE, this.selector)) break;
                            return AssertUtil.TRUE_ASSERTION;
                        }
                        if (!typeBinding.isTypeVariable() || !CharOperation.equals(TypeConstants.NOT_NULL, this.selector)) break;
                        return AssertUtil.NONNULL_ASSERTION;
                    }
                    case 73: {
                        if (typeBinding.id == 5) {
                            if (!CharOperation.equals(TypeConstants.CHECK_ARGUMENT, this.selector) && !CharOperation.equals(TypeConstants.CHECK_STATE, this.selector)) break;
                            return AssertUtil.TRUE_ASSERTION;
                        }
                        if (!typeBinding.isTypeVariable() || !CharOperation.equals(TypeConstants.CHECK_NOT_NULL, this.selector)) break;
                        return AssertUtil.NONNULL_ASSERTION;
                    }
                    case 74: {
                        if (typeBinding.isTypeVariable() && CharOperation.equals(TypeConstants.REQUIRE_NON_NULL, this.selector)) {
                            return AssertUtil.NONNULL_ASSERTION;
                        }
                        if (!(this.arguments[n] instanceof SingleNameReference)) break;
                        SingleNameReference singleNameReference = (SingleNameReference)this.arguments[n];
                        if (!(singleNameReference.binding instanceof LocalVariableBinding)) break;
                        if (CharOperation.equals(TypeConstants.NON_NULL, this.selector)) {
                            return AssertUtil.ARG_NONNULL_IF_TRUE_NEGATABLE;
                        }
                        if (!CharOperation.equals(TypeConstants.IS_NULL, this.selector)) break;
                        return AssertUtil.ARG_NULL_IF_TRUE;
                    }
                    case 16: {
                        if (!CharOperation.equals(TypeConstants.IS_INSTANCE, this.selector) || !(this.arguments[n] instanceof SingleNameReference)) break;
                        SingleNameReference singleNameReference = (SingleNameReference)this.arguments[n];
                        if (!(singleNameReference.binding instanceof LocalVariableBinding)) break;
                        return AssertUtil.ARG_NONNULL_IF_TRUE;
                    }
                }
            }
        }
        return AssertUtil.NONE;
    }

    private FlowInfo analyseBooleanAssertion(BlockScope blockScope, Expression expression, FlowContext flowContext, FlowInfo flowInfo, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4;
        FlowInfo flowInfo2;
        UnconditionalFlowInfo unconditionalFlowInfo;
        Constant constant = expression.optimizedBooleanConstant();
        boolean bl5 = constant != Constant.NotAConstant && constant.booleanValue();
        boolean bl6 = constant != Constant.NotAConstant && !constant.booleanValue();
        int n = flowContext.tagBits;
        flowContext.tagBits |= 0x1000;
        if (!bl2) {
            flowContext.tagBits |= 4;
        }
        FlowInfo flowInfo3 = expression.analyseCode(blockScope, flowContext, flowInfo.copy());
        flowContext.extendTimeToLiveForNullCheckedField(2);
        flowContext.tagBits = n;
        if (bl2) {
            unconditionalFlowInfo = flowInfo3.initsWhenTrue().unconditionalInits();
            flowInfo2 = flowInfo3.initsWhenFalse();
            bl4 = bl5;
            bl3 = bl6;
        } else {
            unconditionalFlowInfo = flowInfo3.initsWhenFalse().unconditionalInits();
            flowInfo2 = flowInfo3.initsWhenTrue();
            bl4 = bl6;
            bl3 = bl5;
        }
        if (bl4) {
            flowInfo2.setReachMode(1);
        }
        if (!bl3) {
            flowInfo = flowInfo.mergedWith(flowInfo2.nullInfoLessUnconditionalCopy()).addInitializationsFrom(unconditionalFlowInfo.discardInitializationInfo());
        }
        return flowInfo;
    }

    private FlowInfo analyseNullAssertion(BlockScope blockScope, Expression expression, FlowContext flowContext, FlowInfo flowInfo, boolean bl) {
        FieldBinding fieldBinding;
        int n = expression.nullStatus(flowInfo, flowContext);
        boolean bl2 = n == (bl ? 4 : 2);
        flowInfo = expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
        LocalVariableBinding localVariableBinding = expression.localVariableBinding();
        if (localVariableBinding != null) {
            if (bl) {
                flowInfo.markAsDefinitelyNull(localVariableBinding);
            } else {
                flowInfo.markAsDefinitelyNonNull(localVariableBinding);
            }
        } else if (!bl && expression instanceof Reference && blockScope.compilerOptions().enableSyntacticNullAnalysisForFields && (fieldBinding = ((Reference)expression).lastFieldBinding()) != null && (fieldBinding.type.tagBits & 2L) == 0L) {
            flowContext.recordNullCheckedFieldReference((Reference)expression, 3);
        }
        if (bl2) {
            flowInfo.setReachMode(2);
        }
        return flowInfo;
    }

    @Override
    public boolean checkNPE(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, int n) {
        NullAnnotationMatching nullAnnotationMatching;
        int n2 = this.nullStatus(flowInfo, flowContext);
        if ((n2 & 0x10) != 0) {
            if (this.binding.returnType.isTypeVariable() && n2 == 48 && blockScope.environment().globalOptions.pessimisticNullAnalysisForFreeTypeVariablesEnabled) {
                blockScope.problemReporter().methodReturnTypeFreeTypeVariableReference(this.binding, this);
            } else {
                blockScope.problemReporter().messageSendPotentialNullReference(this.binding, this);
            }
        } else if ((this.resolvedType.tagBits & 0x100000000000000L) != 0L && (nullAnnotationMatching = NullAnnotationMatching.okNonNullStatus(this)).wantToReport()) {
            nullAnnotationMatching.report(blockScope);
        }
        return true;
    }

    @Override
    public void computeConversion(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding == null || typeBinding2 == null) {
            return;
        }
        if (this.binding != null && this.binding.isValidBinding()) {
            TypeBinding typeBinding3;
            MethodBinding methodBinding = this.binding.original();
            TypeBinding typeBinding4 = methodBinding.returnType;
            if (ArrayBinding.isArrayClone(this.actualReceiverType, this.binding) && typeBinding.id != 1 && scope.compilerOptions().sourceLevel >= 0x310000L) {
                this.valueCast = typeBinding;
            } else if (typeBinding4.leafComponentType().isTypeVariable()) {
                typeBinding3 = !typeBinding2.isBaseType() && typeBinding.isBaseType() ? typeBinding2 : typeBinding;
                this.valueCast = typeBinding4.genericCast(typeBinding3);
            }
            if (this.valueCast instanceof ReferenceBinding && !((ReferenceBinding)(typeBinding3 = (ReferenceBinding)this.valueCast)).canBeSeenBy(scope)) {
                scope.problemReporter().invalidType(this, new ProblemReferenceBinding(CharOperation.splitOn('.', ((ReferenceBinding)typeBinding3).shortReadableName()), (ReferenceBinding)typeBinding3, 2));
            }
        }
        super.computeConversion(scope, typeBinding, typeBinding2);
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        TypeBinding typeBinding;
        this.cleanUpInferenceContexts();
        int n = codeStream.position;
        MethodBinding methodBinding = this.binding instanceof PolymorphicMethodBinding ? this.binding : this.binding.original();
        boolean bl2 = methodBinding.isStatic();
        if (bl2) {
            this.receiver.generateCode(blockScope, codeStream, false);
        } else if ((this.bits & 0x1FE0) != 0 && this.receiver.isImplicitThis()) {
            typeBinding = blockScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
            Object[] objectArray = blockScope.getEmulationPath((ReferenceBinding)typeBinding, true, false);
            codeStream.generateOuterAccess(objectArray, this, typeBinding, blockScope);
        } else {
            this.receiver.generateCode(blockScope, codeStream, true);
            if ((this.bits & 0x40000) != 0) {
                codeStream.checkcast(this.actualReceiverType);
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
        this.generateArguments(this.binding, this.arguments, blockScope, codeStream);
        n = codeStream.position;
        if (this.syntheticAccessor == null) {
            typeBinding = CodeStream.getConstantPoolDeclaringClass((Scope)blockScope, methodBinding, this.actualReceiverType, this.receiver.isImplicitThis());
            if (bl2) {
                codeStream.invoke((byte)-72, methodBinding, typeBinding, this.typeArguments);
            } else if (this.receiver.isSuper() || !blockScope.enclosingSourceType().isNestmateOf(this.binding.declaringClass) && methodBinding.isPrivate()) {
                codeStream.invoke((byte)-73, methodBinding, typeBinding, this.typeArguments);
            } else if (typeBinding.isInterface()) {
                codeStream.invoke((byte)-71, methodBinding, typeBinding, this.typeArguments);
            } else {
                codeStream.invoke((byte)-74, methodBinding, typeBinding, this.typeArguments);
            }
        } else {
            codeStream.invoke((byte)-72, this.syntheticAccessor, null, this.typeArguments);
        }
        if (this.valueCast != null) {
            codeStream.checkcast(this.valueCast);
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            boolean bl3;
            boolean bl4 = bl3 = (this.implicitConversion & 0x400) != 0;
            if (bl3) {
                codeStream.generateImplicitConversion(this.implicitConversion);
            }
            switch (bl3 ? this.postConversionType((Scope)blockScope).id : methodBinding.returnType.id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(n, (int)(this.nameSourcePosition >>> 32));
    }

    @Override
    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    @Override
    public boolean isSuperAccess() {
        return this.receiver.isSuper();
    }

    @Override
    public boolean isTypeAccess() {
        return this.receiver != null && this.receiver.isTypeReference();
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        MethodBinding methodBinding = this.binding.original();
        if (this.binding.isPrivate()) {
            boolean bl;
            boolean bl2 = bl = blockScope.enclosingSourceType().isNestmateOf(methodBinding.declaringClass) && !(this.receiver instanceof QualifiedSuperReference);
            if (!bl && TypeBinding.notEquals(blockScope.enclosingSourceType(), methodBinding.declaringClass)) {
                this.syntheticAccessor = ((SourceTypeBinding)methodBinding.declaringClass).addSyntheticMethod(methodBinding, false);
                blockScope.problemReporter().needToEmulateMethodAccess(methodBinding, this);
                return;
            }
        } else {
            if (this.receiver instanceof QualifiedSuperReference) {
                if (this.actualReceiverType.isInterface()) {
                    return;
                }
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)((QualifiedSuperReference)this.receiver).currentCompatibleType;
                this.syntheticAccessor = sourceTypeBinding.addSyntheticMethod(methodBinding, this.isSuperAccess());
                blockScope.problemReporter().needToEmulateMethodAccess(methodBinding, this);
                return;
            }
            if (this.binding.isProtected() && (this.bits & 0x1FE0) != 0) {
                SourceTypeBinding sourceTypeBinding = blockScope.enclosingSourceType();
                if (methodBinding.declaringClass.getPackage() != sourceTypeBinding.getPackage()) {
                    SourceTypeBinding sourceTypeBinding2 = (SourceTypeBinding)sourceTypeBinding.enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                    this.syntheticAccessor = sourceTypeBinding2.addSyntheticMethod(methodBinding, this.isSuperAccess());
                    blockScope.problemReporter().needToEmulateMethodAccess(methodBinding, this);
                    return;
                }
            }
        }
    }

    @Override
    public int nullStatus(FlowInfo flowInfo, FlowContext flowContext) {
        if ((this.implicitConversion & 0x200) != 0) {
            return 4;
        }
        if (this.binding.isValidBinding()) {
            long l2 = this.binding.tagBits;
            if ((l2 & 0x180000000000000L) == 0L) {
                l2 = this.binding.returnType.tagBits & 0x180000000000000L;
            }
            if (l2 == 0L && this.binding.returnType.isFreeTypeVariable()) {
                return 48;
            }
            return FlowInfo.tagBitsToNullStatus(l2);
        }
        return 1;
    }

    @Override
    public TypeBinding postConversionType(Scope scope) {
        TypeBinding typeBinding = this.resolvedType;
        if (this.valueCast != null) {
            typeBinding = this.valueCast;
        }
        int n = (this.implicitConversion & 0xFF) >> 4;
        switch (n) {
            case 5: {
                typeBinding = TypeBinding.BOOLEAN;
                break;
            }
            case 3: {
                typeBinding = TypeBinding.BYTE;
                break;
            }
            case 4: {
                typeBinding = TypeBinding.SHORT;
                break;
            }
            case 2: {
                typeBinding = TypeBinding.CHAR;
                break;
            }
            case 10: {
                typeBinding = TypeBinding.INT;
                break;
            }
            case 9: {
                typeBinding = TypeBinding.FLOAT;
                break;
            }
            case 7: {
                typeBinding = TypeBinding.LONG;
                break;
            }
            case 8: {
                typeBinding = TypeBinding.DOUBLE;
                break;
            }
        }
        if ((this.implicitConversion & 0x200) != 0) {
            typeBinding = scope.environment().computeBoxingType(typeBinding);
        }
        return typeBinding;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2;
        if (!this.receiver.isImplicitThis()) {
            this.receiver.printExpression(0, stringBuffer).append('.');
        }
        if (this.typeArguments != null) {
            stringBuffer.append('<');
            n2 = this.typeArguments.length - 1;
            for (int i = 0; i < n2; ++i) {
                this.typeArguments[i].print(0, stringBuffer);
                stringBuffer.append(", ");
            }
            this.typeArguments[n2].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        stringBuffer.append(this.selector).append('(');
        if (this.arguments != null) {
            for (n2 = 0; n2 < this.arguments.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].printExpression(0, stringBuffer);
            }
        }
        return stringBuffer.append(')');
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        TypeBinding typeBinding;
        TypeBinding typeBinding2;
        Object object;
        Object object2;
        boolean bl;
        if (this.constant != Constant.NotAConstant) {
            int n;
            this.constant = Constant.NotAConstant;
            long l2 = blockScope.compilerOptions().sourceLevel;
            bl = false;
            if (this.receiver instanceof CastExpression) {
                this.receiver.bits |= 0x20;
                bl = true;
            }
            this.actualReceiverType = this.receiver.resolveType(blockScope);
            if (this.actualReceiverType instanceof InferenceVariable) {
                return null;
            }
            boolean bl2 = this.receiverIsType = this.receiver instanceof NameReference && (((NameReference)this.receiver).bits & 4) != 0;
            if (bl && this.actualReceiverType != null && TypeBinding.equalsEquals((TypeBinding)(object2 = ((CastExpression)this.receiver).expression.resolvedType), this.actualReceiverType) && (!blockScope.environment().usesNullTypeAnnotations() || !NullAnnotationMatching.analyse(this.actualReceiverType, (TypeBinding)object2, -1).isAnyMismatch())) {
                blockScope.problemReporter().unnecessaryCast((CastExpression)this.receiver);
            }
            if (this.typeArguments != null) {
                int n2 = this.typeArguments.length;
                this.argumentsHaveErrors = l2 < 0x310000L;
                this.genericTypeArguments = new TypeBinding[n2];
                for (n = 0; n < n2; ++n) {
                    object = this.typeArguments[n];
                    this.genericTypeArguments[n] = ((TypeReference)object).resolveType(blockScope, true, 64);
                    if (this.genericTypeArguments[n] == null) {
                        this.argumentsHaveErrors = true;
                    }
                    if (!this.argumentsHaveErrors || !(object instanceof Wildcard)) continue;
                    blockScope.problemReporter().illegalUsageOfWildcard((TypeReference)object);
                }
                if (this.argumentsHaveErrors) {
                    if (this.arguments != null) {
                        int n3 = this.arguments.length;
                        for (n = 0; n < n3; ++n) {
                            this.arguments[n].resolveType(blockScope);
                        }
                    }
                    return null;
                }
            }
            if (this.arguments != null) {
                this.argumentsHaveErrors = false;
                int n4 = this.arguments.length;
                this.argumentTypes = new TypeBinding[n4];
                for (n = 0; n < n4; ++n) {
                    object = this.arguments[n];
                    if (this.arguments[n].resolvedType != null) {
                        blockScope.problemReporter().genericInferenceError("Argument was unexpectedly found resolved", this);
                    }
                    if (object instanceof CastExpression) {
                        ((Expression)object).bits |= 0x20;
                        this.argsContainCast = true;
                    }
                    ((Expression)object).setExpressionContext(ExpressionContext.INVOCATION_CONTEXT);
                    this.argumentTypes[n] = ((Expression)object).resolveType(blockScope);
                    if (this.argumentTypes[n] != null) continue;
                    this.argumentsHaveErrors = true;
                }
                if (this.argumentsHaveErrors) {
                    if (this.actualReceiverType instanceof ReferenceBinding) {
                        MethodBinding methodBinding;
                        TypeBinding[] typeBindingArray = new TypeBinding[n4];
                        int n5 = n4;
                        while (--n5 >= 0) {
                            typeBindingArray[n5] = this.argumentTypes[n5] == null ? TypeBinding.NULL : this.argumentTypes[n5];
                        }
                        MethodBinding methodBinding2 = this.binding = this.receiver.isImplicitThis() ? blockScope.getImplicitMethod(this.selector, typeBindingArray, this) : blockScope.findMethod((ReferenceBinding)this.actualReceiverType, this.selector, typeBindingArray, this, false);
                        if (this.binding != null && !this.binding.isValidBinding() && (methodBinding = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                            if (methodBinding.original().typeVariables != Binding.NO_TYPE_VARIABLES) {
                                methodBinding = blockScope.environment().createParameterizedGenericMethod(methodBinding.original(), (RawTypeBinding)null);
                            }
                            this.binding = methodBinding;
                            MethodBinding methodBinding3 = methodBinding.original();
                            if (methodBinding3.isOrEnclosedByPrivateType() && !blockScope.isDefinedInMethod(methodBinding3)) {
                                methodBinding3.modifiers |= 0x8000000;
                            }
                        }
                    }
                    return null;
                }
            }
            if (this.actualReceiverType == null) {
                return null;
            }
            if (this.actualReceiverType.isBaseType()) {
                blockScope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, this.argumentTypes);
                return null;
            }
        }
        if ((typeBinding2 = this.findMethodBinding(blockScope)) != null && typeBinding2.isPolyType()) {
            this.resolvedType = this.binding.returnType.capture(blockScope, this.sourceStart, this.sourceEnd);
            return typeBinding2;
        }
        if (!this.binding.isValidBinding()) {
            ReferenceBinding referenceBinding;
            if (this.binding.declaringClass == null) {
                if (this.actualReceiverType instanceof ReferenceBinding) {
                    this.binding.declaringClass = (ReferenceBinding)this.actualReceiverType;
                } else {
                    blockScope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, this.argumentTypes);
                    return null;
                }
            }
            boolean bl3 = bl = (referenceBinding = this.binding.declaringClass) != null && referenceBinding.isAnonymousType() && referenceBinding.superclass() instanceof MissingTypeBinding;
            if (!bl) {
                blockScope.problemReporter().invalidMethod(this, this.binding, blockScope);
            }
            object2 = ((ProblemMethodBinding)this.binding).closestMatch;
            switch (this.binding.problemId()) {
                case 3: {
                    break;
                }
                case 23: 
                case 27: {
                    if (this.expressionContext != ExpressionContext.INVOCATION_CONTEXT) break;
                }
                case 2: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    if (object2 == null) break;
                    this.resolvedType = ((MethodBinding)object2).returnType;
                    break;
                }
                case 25: {
                    if (object2 == null || ((MethodBinding)object2).returnType == null) break;
                    this.resolvedType = ((MethodBinding)object2).returnType.withoutToplevelNullAnnotation();
                }
            }
            if (object2 != null) {
                this.binding = object2;
                MethodBinding methodBinding = ((MethodBinding)object2).original();
                if (methodBinding.isOrEnclosedByPrivateType() && !blockScope.isDefinedInMethod(methodBinding)) {
                    methodBinding.modifiers |= 0x8000000;
                }
            }
            return this.resolvedType != null && (this.resolvedType.tagBits & 0x80L) == 0L ? this.resolvedType : null;
        }
        CompilerOptions compilerOptions = blockScope.compilerOptions();
        if (compilerOptions.complianceLevel <= 0x320000L && this.binding.isPolymorphic()) {
            blockScope.problemReporter().polymorphicMethodNotBelow17(this);
            return null;
        }
        if (compilerOptions.isAnnotationBasedNullAnalysisEnabled) {
            ImplicitNullAnnotationVerifier.ensureNullnessIsKnown(this.binding, blockScope);
            if (compilerOptions.sourceLevel >= 0x340000L && this.binding instanceof ParameterizedGenericMethodBinding && this.typeArguments != null) {
                TypeBinding[] typeBindingArray = this.binding.original().typeVariables();
                for (int i = 0; i < this.typeArguments.length; ++i) {
                    this.typeArguments[i].checkNullConstraints(blockScope, (ParameterizedGenericMethodBinding)this.binding, typeBindingArray, i);
                }
            }
        }
        if ((this.bits & 0x100000) != 0 && this.binding.isPolymorphic()) {
            this.binding = blockScope.environment().updatePolymorphicMethodReturnType((PolymorphicMethodBinding)this.binding, TypeBinding.VOID);
        }
        if ((this.binding.tagBits & 0x80L) != 0L) {
            blockScope.problemReporter().missingTypeInMethod(this, this.binding);
        }
        if (!this.binding.isStatic()) {
            if (this.receiverIsType) {
                blockScope.problemReporter().mustUseAStaticMethod(this, this.binding);
                if (this.actualReceiverType.isRawType() && (this.receiver.bits & 0x40000000) == 0 && compilerOptions.getSeverity(0x20010000) != 256) {
                    blockScope.problemReporter().rawTypeReference(this.receiver, this.actualReceiverType);
                }
            } else {
                TypeBinding typeBinding3 = this.actualReceiverType;
                this.actualReceiverType = this.actualReceiverType.getErasureCompatibleType(this.binding.declaringClass);
                this.receiver.computeConversion(blockScope, this.actualReceiverType, this.actualReceiverType);
                if (TypeBinding.notEquals(this.actualReceiverType, typeBinding3) && TypeBinding.notEquals(this.receiver.postConversionType(blockScope), this.actualReceiverType)) {
                    this.bits |= 0x40000;
                }
            }
        } else {
            if (this.binding.declaringClass.isInterface() && (!this.isTypeAccess() && !this.receiver.isImplicitThis() || !TypeBinding.equalsEquals(this.binding.declaringClass, this.actualReceiverType))) {
                blockScope.problemReporter().nonStaticOrAlienTypeReceiver(this, this.binding);
            } else if (!(this.receiver.isImplicitThis() || this.receiver.isSuper() || this.receiverIsType)) {
                blockScope.problemReporter().nonStaticAccessToStaticMethod(this, this.binding);
            }
            if (!this.receiver.isImplicitThis() && TypeBinding.notEquals(this.binding.declaringClass, this.actualReceiverType)) {
                blockScope.problemReporter().indirectAccessToStaticMethod(this, this.binding);
            }
        }
        if (MessageSend.checkInvocationArguments(blockScope, this.receiver, this.actualReceiverType, this.binding, this.arguments, this.argumentTypes, this.argsContainCast, this)) {
            this.bits |= 0x10000;
        }
        if (this.binding.isAbstract() && this.receiver.isSuper()) {
            blockScope.problemReporter().cannotDireclyInvokeAbstractMethod(this, this.binding);
        }
        if (this.isMethodUseDeprecated(this.binding, blockScope, true, this)) {
            blockScope.problemReporter().deprecatedMethod(this.binding, this);
        }
        if ((this.bits & 0x10000) != 0 && this.genericTypeArguments == null) {
            typeBinding = this.binding.returnType;
            if (typeBinding != null) {
                typeBinding = blockScope.environment().convertToRawType(typeBinding.erasure(), true);
            }
        } else {
            typeBinding = this.binding.returnType;
            if (typeBinding != null) {
                typeBinding = typeBinding.capture(blockScope, this.sourceStart, this.sourceEnd);
            }
        }
        this.resolvedType = typeBinding;
        if (this.receiver.isSuper() && compilerOptions.getSeverity(0x20100000) != 256 && (object2 = blockScope.methodScope().referenceContext) instanceof AbstractMethodDeclaration) {
            AbstractMethodDeclaration abstractMethodDeclaration = (AbstractMethodDeclaration)object2;
            object = abstractMethodDeclaration.binding;
            if (((MethodBinding)object).isOverriding() && CharOperation.equals(this.binding.selector, ((MethodBinding)object).selector) && this.binding.areParametersEqual((MethodBinding)object)) {
                abstractMethodDeclaration.bits |= 0x10;
            }
        }
        if (this.receiver.isSuper() && this.actualReceiverType.isInterface()) {
            blockScope.checkAppropriateMethodAgainstSupers(this.selector, this.binding, this.argumentTypes, this);
        }
        if (this.typeArguments != null && this.binding.original().typeVariables == Binding.NO_TYPE_VARIABLES) {
            blockScope.problemReporter().unnecessaryTypeArgumentsForMethodInvocation(this.binding, this.genericTypeArguments, this.typeArguments);
        }
        return (this.resolvedType.tagBits & 0x80L) == 0L ? this.resolvedType : null;
    }

    protected TypeBinding findMethodBinding(BlockScope blockScope) {
        ReferenceContext referenceContext = blockScope.methodScope().referenceContext;
        if (referenceContext instanceof LambdaExpression) {
            this.outerInferenceContext = ((LambdaExpression)referenceContext).inferenceContext;
        }
        if (this.expectedType != null && this.binding instanceof PolyParameterizedGenericMethodBinding) {
            this.binding = this.solutionsPerTargetType.get(this.expectedType);
        }
        if (this.binding == null) {
            MethodBinding methodBinding = this.binding = this.receiver.isImplicitThis() ? blockScope.getImplicitMethod(this.selector, this.argumentTypes, this) : blockScope.getMethod(this.actualReceiverType, this.selector, this.argumentTypes, this);
            if (this.binding instanceof PolyParameterizedGenericMethodBinding) {
                this.solutionsPerTargetType = new HashMap();
                return new PolyTypeBinding(this);
            }
        }
        this.binding = MessageSend.resolvePolyExpressionArguments(this, this.binding, this.argumentTypes, blockScope);
        return this.binding.returnType;
    }

    @Override
    public void setActualReceiverType(ReferenceBinding referenceBinding) {
        if (referenceBinding == null) {
            return;
        }
        this.actualReceiverType = referenceBinding;
    }

    @Override
    public void setDepth(int n) {
        this.bits &= 0xFFFFE01F;
        if (n > 0) {
            this.bits |= (n & 0xFF) << 5;
        }
    }

    @Override
    public void setExpectedType(TypeBinding typeBinding) {
        this.expectedType = typeBinding;
    }

    @Override
    public void setExpressionContext(ExpressionContext expressionContext) {
        this.expressionContext = expressionContext;
    }

    @Override
    public boolean isPolyExpression() {
        return this.isPolyExpression(this.binding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBoxingCompatibleWith(TypeBinding typeBinding, Scope scope) {
        if (this.argumentsHaveErrors || this.binding == null || !this.binding.isValidBinding() || typeBinding == null || scope == null) {
            return false;
        }
        if (this.isPolyExpression() && !typeBinding.isPrimitiveOrBoxedPrimitiveType()) {
            return false;
        }
        TypeBinding typeBinding2 = this.expectedType;
        try {
            MethodBinding methodBinding;
            MethodBinding methodBinding2 = methodBinding = this.solutionsPerTargetType != null ? this.solutionsPerTargetType.get(typeBinding) : null;
            if (methodBinding == null) {
                this.expectedType = typeBinding;
                methodBinding = this.isPolyExpression() ? ParameterizedGenericMethodBinding.computeCompatibleMethod18(this.binding.shallowOriginal(), this.argumentTypes, scope, this) : this.binding;
                this.registerResult(typeBinding, methodBinding);
            }
            if (methodBinding == null || !methodBinding.isValidBinding() || methodBinding.returnType == null || !methodBinding.returnType.isValidBinding()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = super.isBoxingCompatible(methodBinding.returnType.capture(scope, this.sourceStart, this.sourceEnd), typeBinding, this, scope);
            return bl;
        }
        finally {
            this.expectedType = typeBinding2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCompatibleWith(TypeBinding typeBinding, Scope scope) {
        if (this.argumentsHaveErrors || this.binding == null || !this.binding.isValidBinding() || typeBinding == null || scope == null) {
            return false;
        }
        TypeBinding typeBinding2 = this.expectedType;
        try {
            TypeBinding typeBinding3;
            MethodBinding methodBinding;
            MethodBinding methodBinding2 = methodBinding = this.solutionsPerTargetType != null ? this.solutionsPerTargetType.get(typeBinding) : null;
            if (methodBinding == null) {
                this.expectedType = typeBinding;
                methodBinding = this.isPolyExpression() ? ParameterizedGenericMethodBinding.computeCompatibleMethod18(this.binding.shallowOriginal(), this.argumentTypes, scope, this) : this.binding;
                this.registerResult(typeBinding, methodBinding);
            }
            if (methodBinding == null || !methodBinding.isValidBinding() || (typeBinding3 = methodBinding.returnType) == null || !typeBinding3.isValidBinding()) {
                boolean bl = false;
                return bl;
            }
            if ((this.bits & 0x10000) != 0 && this.genericTypeArguments == null) {
                typeBinding3 = scope.environment().convertToRawType(typeBinding3.erasure(), true);
            }
            boolean bl = typeBinding3.capture(scope, this.sourceStart, this.sourceEnd).isCompatibleWith(typeBinding, scope);
            return bl;
        }
        finally {
            this.expectedType = typeBinding2;
        }
    }

    @Override
    public boolean isPolyExpression(MethodBinding methodBinding) {
        if (this.expressionContext != ExpressionContext.ASSIGNMENT_CONTEXT && this.expressionContext != ExpressionContext.INVOCATION_CONTEXT) {
            return false;
        }
        if (this.typeArguments != null && this.typeArguments.length > 0) {
            return false;
        }
        if (this.constant != Constant.NotAConstant) {
            throw new UnsupportedOperationException("Unresolved MessageSend can't be queried if it is a polyexpression");
        }
        if (methodBinding != null) {
            MethodBinding methodBinding2;
            if (methodBinding instanceof ParameterizedGenericMethodBinding) {
                methodBinding2 = (ParameterizedGenericMethodBinding)methodBinding;
                if (((ParameterizedGenericMethodBinding)methodBinding2).inferredReturnType) {
                    return true;
                }
            }
            if (methodBinding.returnType != null) {
                methodBinding2 = methodBinding.original();
                return methodBinding2.returnType.mentionsAny(methodBinding2.typeVariables(), -1);
            }
        }
        return false;
    }

    @Override
    public boolean sIsMoreSpecific(TypeBinding typeBinding, TypeBinding typeBinding2, Scope scope) {
        if (super.sIsMoreSpecific(typeBinding, typeBinding2, scope)) {
            return true;
        }
        return this.isPolyExpression() ? !typeBinding.isBaseType() && typeBinding2.isBaseType() : false;
    }

    @Override
    public void setFieldIndex(int n) {
    }

    @Override
    public TypeBinding invocationTargetType() {
        return this.expectedType;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            this.receiver.traverse(aSTVisitor, blockScope);
            if (this.typeArguments != null) {
                n2 = this.typeArguments.length;
                for (n = 0; n < n2; ++n) {
                    this.typeArguments[n].traverse(aSTVisitor, blockScope);
                }
            }
            if (this.arguments != null) {
                n = this.arguments.length;
                for (n2 = 0; n2 < n; ++n2) {
                    this.arguments[n2].traverse(aSTVisitor, blockScope);
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public boolean statementExpression() {
        return (this.bits & 0x1FE00000) == 0;
    }

    @Override
    public boolean receiverIsImplicitThis() {
        return this.receiver.isImplicitThis();
    }

    @Override
    public MethodBinding binding() {
        return this.binding;
    }

    @Override
    public void registerInferenceContext(ParameterizedGenericMethodBinding parameterizedGenericMethodBinding, InferenceContext18 inferenceContext18) {
        if (this.inferenceContexts == null) {
            this.inferenceContexts = new SimpleLookupTable();
        }
        this.inferenceContexts.put(parameterizedGenericMethodBinding, inferenceContext18);
    }

    @Override
    public void registerResult(TypeBinding typeBinding, MethodBinding methodBinding) {
        if (this.solutionsPerTargetType == null) {
            this.solutionsPerTargetType = new HashMap();
        }
        this.solutionsPerTargetType.put(typeBinding, methodBinding);
    }

    @Override
    public InferenceContext18 getInferenceContext(ParameterizedMethodBinding parameterizedMethodBinding) {
        if (this.inferenceContexts == null) {
            return null;
        }
        return (InferenceContext18)this.inferenceContexts.get(parameterizedMethodBinding);
    }

    @Override
    public void cleanUpInferenceContexts() {
        if (this.inferenceContexts == null) {
            return;
        }
        for (Object object : this.inferenceContexts.valueTable) {
            if (object == null) continue;
            ((InferenceContext18)object).cleanUp();
        }
        this.inferenceContexts = null;
        this.outerInferenceContext = null;
        this.solutionsPerTargetType = null;
    }

    @Override
    public Expression[] arguments() {
        return this.arguments;
    }

    @Override
    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    @Override
    public InferenceContext18 freshInferenceContext(Scope scope) {
        return new InferenceContext18(scope, this.arguments, this, this.outerInferenceContext);
    }

    @Override
    public boolean isQualifiedSuper() {
        return this.receiver.isQualifiedSuper();
    }

    @Override
    public int nameSourceStart() {
        return (int)(this.nameSourcePosition >>> 32);
    }

    @Override
    public int nameSourceEnd() {
        return (int)this.nameSourcePosition;
    }

    private static enum AssertUtil {
        NONE,
        TRUE_ASSERTION,
        FALSE_ASSERTION,
        NULL_ASSERTION,
        NONNULL_ASSERTION,
        ARG_NONNULL_IF_TRUE,
        ARG_NONNULL_IF_TRUE_NEGATABLE,
        ARG_NULL_IF_TRUE;

    }
}

