/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class MethodScope
extends BlockScope {
    public ReferenceContext referenceContext;
    public boolean isStatic;
    public boolean isConstructorCall = false;
    public FieldBinding initializedField;
    public int lastVisibleFieldID = -1;
    private static int baseAnalysisIndex = 0;
    public int analysisIndex = baseAnalysisIndex;
    public boolean isPropagatingInnerClassEmulation;
    public int lastIndex = 0;
    public long[] definiteInits = new long[4];
    public long[][] extraDefiniteInits = new long[4][];
    public SyntheticArgumentBinding[] extraSyntheticArguments;
    public boolean hasMissingSwitchDefault;
    public boolean isCompactConstructorScope = false;

    public MethodScope(Scope scope, ReferenceContext referenceContext, boolean bl) {
        super(2, scope);
        this.locals = new LocalVariableBinding[5];
        this.referenceContext = referenceContext;
        this.isStatic = bl;
        this.startIndex = 0;
    }

    public MethodScope(Scope scope, ReferenceContext referenceContext, boolean bl, int n) {
        this(scope, referenceContext, bl);
        this.lastVisibleFieldID = n;
    }

    @Override
    String basicToString(int n) {
        String string = "\n";
        int n2 = n;
        while (--n2 >= 0) {
            string = string + "\t";
        }
        String string2 = string + "--- Method Scope ---";
        string = string + "\t";
        string2 = string2 + string + "locals:";
        for (int i = 0; i < this.localIndex; ++i) {
            string2 = string2 + string + "\t" + this.locals[i].toString();
        }
        string2 = string2 + string + "startIndex = " + this.startIndex;
        string2 = string2 + string + "isConstructorCall = " + this.isConstructorCall;
        string2 = string2 + string + "initializedField = " + this.initializedField;
        string2 = string2 + string + "lastVisibleFieldID = " + this.lastVisibleFieldID;
        string2 = string2 + string + "referenceContext = " + this.referenceContext;
        return string2;
    }

    private void checkAndSetModifiersForConstructor(MethodBinding methodBinding) {
        int n;
        int n2;
        int n3 = methodBinding.modifiers;
        ReferenceBinding referenceBinding = methodBinding.declaringClass;
        if ((n3 & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForMethod(referenceBinding, (AbstractMethodDeclaration)this.referenceContext);
        }
        if ((((n2 = ((ConstructorDeclaration)this.referenceContext).bits) & 0x80) != 0 || (n2 & 0x400) != 0 && (n2 & 0x200) != 0) && (n = referenceBinding.modifiers & 0x4005) != 0) {
            if ((n & 0x4000) != 0) {
                n3 &= 0xFFFFFFF8;
                n3 |= 2;
            } else {
                n3 &= 0xFFFFFFF8;
                n3 |= n;
            }
        }
        n = n3 & 0xFFFF;
        if (referenceBinding.isEnum() && (((ConstructorDeclaration)this.referenceContext).bits & 0x80) == 0) {
            if ((n & 0xFFFFF7FD) != 0) {
                this.problemReporter().illegalModifierForEnumConstructor((AbstractMethodDeclaration)this.referenceContext);
                n3 &= 0xFFFF0802;
            } else if ((((AbstractMethodDeclaration)this.referenceContext).modifiers & 0x800) != 0) {
                this.problemReporter().illegalModifierForMethod((AbstractMethodDeclaration)this.referenceContext);
            }
            n3 |= 2;
        } else if ((n & 0xFFFFF7F8) != 0) {
            this.problemReporter().illegalModifierForMethod((AbstractMethodDeclaration)this.referenceContext);
            n3 &= 0xFFFF0807;
        } else if ((((AbstractMethodDeclaration)this.referenceContext).modifiers & 0x800) != 0) {
            this.problemReporter().illegalModifierForMethod((AbstractMethodDeclaration)this.referenceContext);
        }
        int n4 = n & 7;
        if ((n4 & n4 - 1) != 0) {
            this.problemReporter().illegalVisibilityModifierCombinationForMethod(referenceBinding, (AbstractMethodDeclaration)this.referenceContext);
            if ((n4 & 1) != 0) {
                if ((n4 & 4) != 0) {
                    n3 &= 0xFFFFFFFB;
                }
                if ((n4 & 2) != 0) {
                    n3 &= 0xFFFFFFFD;
                }
            } else if ((n4 & 4) != 0 && (n4 & 2) != 0) {
                n3 &= 0xFFFFFFFD;
            }
        }
        methodBinding.modifiers = n3;
    }

    private void checkAndSetModifiersForMethod(MethodBinding methodBinding) {
        int n;
        int n2 = methodBinding.modifiers;
        ReferenceBinding referenceBinding = methodBinding.declaringClass;
        if ((n2 & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForMethod(referenceBinding, (AbstractMethodDeclaration)this.referenceContext);
        }
        int n3 = n2 & 0xFFFF;
        long l2 = this.compilerOptions().sourceLevel;
        if (referenceBinding.isInterface()) {
            int n4 = 1025;
            boolean bl = (n2 & 0x10000) != 0;
            boolean bl2 = false;
            if (l2 >= 0x340000L && !referenceBinding.isAnnotationType()) {
                int n5;
                n4 |= 0x10808;
                n4 |= l2 >= 0x350000L ? 2 : 0;
                if (!methodBinding.isAbstract()) {
                    bl2 = bl && methodBinding.isStatic();
                } else {
                    boolean bl3 = bl2 = bl || methodBinding.isStatic();
                    if (methodBinding.isStrictfp()) {
                        this.problemReporter().illegalAbstractModifierCombinationForMethod((AbstractMethodDeclaration)this.referenceContext);
                    }
                }
                if (bl2) {
                    this.problemReporter().illegalModifierCombinationForInterfaceMethod((AbstractMethodDeclaration)this.referenceContext);
                }
                if (l2 >= 0x350000L && (methodBinding.modifiers & 2) != 0 && (n5 = n3 & ~n4) == 0) {
                    n5 = n3 & 0xFFFFF7F5;
                    if (bl || n5 != 0) {
                        this.problemReporter().illegalModifierCombinationForPrivateInterfaceMethod((AbstractMethodDeclaration)this.referenceContext);
                    }
                }
                if (bl) {
                    n3 |= 0x10000;
                }
            }
            if ((n3 & ~n4) != 0) {
                if ((referenceBinding.modifiers & 0x2000) != 0) {
                    this.problemReporter().illegalModifierForAnnotationMember((AbstractMethodDeclaration)this.referenceContext);
                } else {
                    this.problemReporter().illegalModifierForInterfaceMethod((AbstractMethodDeclaration)this.referenceContext, l2);
                }
                methodBinding.modifiers &= n4 | 0xFFFF0000;
            }
            return;
        }
        if (referenceBinding.isAnonymousType() && l2 >= 0x350000L) {
            LocalTypeBinding localTypeBinding = (LocalTypeBinding)referenceBinding;
            TypeReference typeReference = localTypeBinding.scope.referenceContext.allocation.type;
            if (typeReference != null && (typeReference.bits & 0x80000) != 0 && (n3 & 0xA) == 0) {
                methodBinding.tagBits |= 0x2000000000000L;
            }
        }
        if ((n3 & 0xFFFFF2C0) != 0) {
            this.problemReporter().illegalModifierForMethod((AbstractMethodDeclaration)this.referenceContext);
            n2 &= 0xFFFF0D3F;
        }
        if (((n = n3 & 7) & n - 1) != 0) {
            this.problemReporter().illegalVisibilityModifierCombinationForMethod(referenceBinding, (AbstractMethodDeclaration)this.referenceContext);
            if ((n & 1) != 0) {
                if ((n & 4) != 0) {
                    n2 &= 0xFFFFFFFB;
                }
                if ((n & 2) != 0) {
                    n2 &= 0xFFFFFFFD;
                }
            } else if ((n & 4) != 0 && (n & 2) != 0) {
                n2 &= 0xFFFFFFFD;
            }
        }
        if ((n2 & 0x400) != 0) {
            int n6 = 2362;
            if ((n2 & n6) != 0) {
                this.problemReporter().illegalAbstractModifierCombinationForMethod(referenceBinding, (AbstractMethodDeclaration)this.referenceContext);
            }
            if (!methodBinding.declaringClass.isAbstract()) {
                this.problemReporter().abstractMethodInAbstractClass((SourceTypeBinding)referenceBinding, (AbstractMethodDeclaration)this.referenceContext);
            }
        }
        if ((n2 & 0x100) != 0 && (n2 & 0x800) != 0) {
            this.problemReporter().nativeMethodsCannotBeStrictfp(referenceBinding, (AbstractMethodDeclaration)this.referenceContext);
        }
        if ((n3 & 8) != 0 && referenceBinding.isNestedType() && !referenceBinding.isStatic()) {
            this.problemReporter().unexpectedStaticModifierForMethod(referenceBinding, (AbstractMethodDeclaration)this.referenceContext);
        }
        methodBinding.modifiers = n2;
    }

    public void checkUnusedParameters(MethodBinding methodBinding) {
        LocalVariableBinding localVariableBinding;
        if (methodBinding.isAbstract() || methodBinding.isImplementing() && !this.compilerOptions().reportUnusedParameterWhenImplementingAbstract || methodBinding.isOverriding() && !methodBinding.isImplementing() && !this.compilerOptions().reportUnusedParameterWhenOverridingConcrete || methodBinding.isMain()) {
            return;
        }
        int n = this.localIndex;
        for (int i = 0; i < n && (localVariableBinding = this.locals[i]) != null && (localVariableBinding.tagBits & 0x400L) != 0L; ++i) {
            if (localVariableBinding.useFlag != 0 || (localVariableBinding.declaration.bits & 0x40000000) == 0) continue;
            this.problemReporter().unusedArgument(localVariableBinding.declaration);
        }
    }

    public void computeLocalVariablePositions(int n, CodeStream codeStream) {
        LocalVariableBinding localVariableBinding;
        int n2;
        this.offset = n;
        this.maxOffset = n;
        int n3 = this.localIndex;
        for (n2 = 0; n2 < n3 && (localVariableBinding = this.locals[n2]) != null && (localVariableBinding.tagBits & 0x400L) != 0L; ++n2) {
            codeStream.record(localVariableBinding);
            localVariableBinding.resolvedPosition = this.offset++;
            if (TypeBinding.equalsEquals(localVariableBinding.type, TypeBinding.LONG) || TypeBinding.equalsEquals(localVariableBinding.type, TypeBinding.DOUBLE)) {
                this.offset += 2;
            }
            if (this.offset <= 255) continue;
            this.problemReporter().noMoreAvailableSpaceForArgument(localVariableBinding, localVariableBinding.declaration);
        }
        if (this.extraSyntheticArguments != null) {
            for (SyntheticArgumentBinding syntheticArgumentBinding : this.extraSyntheticArguments) {
                syntheticArgumentBinding.resolvedPosition = this.offset++;
                if (TypeBinding.equalsEquals(syntheticArgumentBinding.type, TypeBinding.LONG) || TypeBinding.equalsEquals(syntheticArgumentBinding.type, TypeBinding.DOUBLE)) {
                    this.offset += 2;
                }
                if (this.offset <= 255) continue;
                this.problemReporter().noMoreAvailableSpaceForArgument(syntheticArgumentBinding, (ASTNode)((Object)this.referenceContext));
            }
        }
        this.computeLocalVariablePositions(n2, this.offset, codeStream);
    }

    MethodBinding createMethod(AbstractMethodDeclaration abstractMethodDeclaration) {
        Object object;
        int n;
        this.referenceContext = abstractMethodDeclaration;
        abstractMethodDeclaration.scope = this;
        long l2 = this.compilerOptions().sourceLevel;
        SourceTypeBinding sourceTypeBinding = this.referenceType().binding;
        int n2 = abstractMethodDeclaration.modifiers | 0x2000000;
        if (abstractMethodDeclaration.isConstructor()) {
            if (abstractMethodDeclaration.isDefaultConstructor()) {
                n2 |= 0x4000000;
            }
            abstractMethodDeclaration.binding = new MethodBinding(n2, null, null, sourceTypeBinding);
            this.checkAndSetModifiersForConstructor(abstractMethodDeclaration.binding);
        } else {
            if (sourceTypeBinding.isInterface() && (l2 < 0x350000L || (abstractMethodDeclaration.modifiers & 2) == 0)) {
                n2 = abstractMethodDeclaration.isDefaultMethod() || abstractMethodDeclaration.isStatic() ? (n2 |= 1) : (n2 |= 0x401);
            }
            abstractMethodDeclaration.binding = new MethodBinding(n2, abstractMethodDeclaration.selector, null, null, null, sourceTypeBinding);
            this.checkAndSetModifiersForMethod(abstractMethodDeclaration.binding);
        }
        this.isStatic = abstractMethodDeclaration.binding.isStatic();
        Argument[] argumentArray = abstractMethodDeclaration.arguments;
        int n3 = n = argumentArray == null ? 0 : argumentArray.length;
        if (n > 0) {
            object = argumentArray[n - 1];
            abstractMethodDeclaration.binding.parameterNames = new char[n][];
            abstractMethodDeclaration.binding.parameterNames[--n] = ((Argument)object).name;
            if (((Argument)object).isVarArgs() && l2 >= 0x310000L) {
                abstractMethodDeclaration.binding.modifiers |= 0x80;
            }
            if (CharOperation.equals(((Argument)object).name, ConstantPool.This)) {
                this.problemReporter().illegalThisDeclaration((Argument)object);
            }
            while (--n >= 0) {
                object = argumentArray[n];
                abstractMethodDeclaration.binding.parameterNames[n] = ((Argument)object).name;
                if (((Argument)object).isVarArgs() && l2 >= 0x310000L) {
                    this.problemReporter().illegalVararg((Argument)object, abstractMethodDeclaration);
                }
                if (!CharOperation.equals(((Argument)object).name, ConstantPool.This)) continue;
                this.problemReporter().illegalThisDeclaration((Argument)object);
            }
        }
        if (abstractMethodDeclaration.receiver != null) {
            if (l2 <= 0x330000L) {
                this.problemReporter().illegalSourceLevelForThis(abstractMethodDeclaration.receiver);
            }
            if (abstractMethodDeclaration.receiver.annotations != null) {
                abstractMethodDeclaration.bits |= 0x100000;
            }
        }
        if ((object = abstractMethodDeclaration.typeParameters()) == null || ((TypeParameter[])object).length == 0) {
            abstractMethodDeclaration.binding.typeVariables = Binding.NO_TYPE_VARIABLES;
        } else {
            abstractMethodDeclaration.binding.typeVariables = this.createTypeVariables((TypeParameter[])object, abstractMethodDeclaration.binding);
            abstractMethodDeclaration.binding.modifiers |= 0x40000000;
        }
        this.checkAndSetRecordCanonicalConsAndMethods(abstractMethodDeclaration);
        return abstractMethodDeclaration.binding;
    }

    private void checkAndSetRecordCanonicalConsAndMethods(AbstractMethodDeclaration abstractMethodDeclaration) {
        if (abstractMethodDeclaration.binding != null && (abstractMethodDeclaration.bits & 0x400) != 0) {
            abstractMethodDeclaration.binding.tagBits |= 0x1000L;
            abstractMethodDeclaration.binding.tagBits = abstractMethodDeclaration.binding.tagBits | ((abstractMethodDeclaration.bits & 0x200) != 0 ? 2048L : 0L);
        }
    }

    @Override
    public FieldBinding findField(TypeBinding typeBinding, char[] cArray, InvocationSite invocationSite, boolean bl) {
        FieldBinding fieldBinding = super.findField(typeBinding, cArray, invocationSite, bl);
        if (fieldBinding == null) {
            return null;
        }
        if (!fieldBinding.isValidBinding()) {
            return fieldBinding;
        }
        if (typeBinding.isInterface() && invocationSite.isQualifiedSuper()) {
            return new ProblemFieldBinding(fieldBinding, fieldBinding.declaringClass, cArray, 28);
        }
        if (fieldBinding.isStatic()) {
            return fieldBinding;
        }
        if (!this.isConstructorCall || TypeBinding.notEquals(typeBinding, this.enclosingSourceType())) {
            return fieldBinding;
        }
        if (invocationSite instanceof SingleNameReference) {
            return new ProblemFieldBinding(fieldBinding, fieldBinding.declaringClass, cArray, 6);
        }
        if (invocationSite instanceof QualifiedNameReference) {
            QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)invocationSite;
            if (qualifiedNameReference.binding == null) {
                return new ProblemFieldBinding(fieldBinding, fieldBinding.declaringClass, cArray, 6);
            }
        }
        return fieldBinding;
    }

    public boolean isInsideConstructor() {
        return this.referenceContext instanceof ConstructorDeclaration;
    }

    public boolean isInsideInitializer() {
        return this.referenceContext instanceof TypeDeclaration;
    }

    @Override
    public boolean isLambdaScope() {
        return this.referenceContext instanceof LambdaExpression;
    }

    public boolean isInsideInitializerOrConstructor() {
        return this.referenceContext instanceof TypeDeclaration || this.referenceContext instanceof ConstructorDeclaration;
    }

    @Override
    public ProblemReporter problemReporter() {
        ProblemReporter problemReporter = this.referenceCompilationUnit().problemReporter;
        problemReporter.referenceContext = this.referenceContext;
        return problemReporter;
    }

    public final int recordInitializationStates(FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return -1;
        }
        UnconditionalFlowInfo unconditionalFlowInfo = flowInfo.unconditionalInitsWithoutSideEffect();
        long[] lArray = unconditionalFlowInfo.extra == null ? null : unconditionalFlowInfo.extra[0];
        long l2 = unconditionalFlowInfo.definiteInits;
        int n = this.lastIndex;
        block0: while (--n >= 0) {
            if (this.definiteInits[n] != l2) continue;
            long[] lArray2 = this.extraDefiniteInits[n];
            if (lArray != null && lArray2 != null) {
                if (lArray.length != lArray2.length) continue;
                int n2 = lArray.length;
                for (int i = 0; i < n2; ++i) {
                    if (lArray[i] != lArray2[i]) continue block0;
                }
                return n;
            }
            if (lArray != null || lArray2 != null) continue;
            return n;
        }
        if (this.definiteInits.length == this.lastIndex) {
            this.definiteInits = new long[this.lastIndex + 20];
            System.arraycopy(this.definiteInits, 0, this.definiteInits, 0, this.lastIndex);
            long[][] lArrayArray = new long[this.lastIndex + 20][];
            this.extraDefiniteInits = lArrayArray;
            System.arraycopy(this.extraDefiniteInits, 0, lArrayArray, 0, this.lastIndex);
        }
        this.definiteInits[this.lastIndex] = l2;
        if (lArray != null) {
            this.extraDefiniteInits[this.lastIndex] = new long[lArray.length];
            System.arraycopy(lArray, 0, this.extraDefiniteInits[this.lastIndex], 0, lArray.length);
        }
        return this.lastIndex++;
    }

    public AbstractMethodDeclaration referenceMethod() {
        if (this.referenceContext instanceof AbstractMethodDeclaration) {
            return (AbstractMethodDeclaration)this.referenceContext;
        }
        return null;
    }

    public MethodBinding referenceMethodBinding() {
        if (this.referenceContext instanceof LambdaExpression) {
            return ((LambdaExpression)this.referenceContext).binding;
        }
        if (this.referenceContext instanceof AbstractMethodDeclaration) {
            return ((AbstractMethodDeclaration)this.referenceContext).binding;
        }
        return null;
    }

    @Override
    public TypeDeclaration referenceType() {
        ClassScope classScope = this.enclosingClassScope();
        return classScope == null ? null : classScope.referenceContext;
    }

    @Override
    void resolveTypeParameter(TypeParameter typeParameter) {
        typeParameter.resolve(this);
    }

    @Override
    public boolean hasDefaultNullnessFor(int n, int n2) {
        MethodBinding methodBinding;
        int n3 = this.localNonNullByDefaultValue(n2);
        if (n3 != 0) {
            return (n3 & n) != 0;
        }
        AbstractMethodDeclaration abstractMethodDeclaration = this.referenceMethod();
        if (abstractMethodDeclaration != null && (methodBinding = abstractMethodDeclaration.binding) != null && methodBinding.defaultNullness != 0) {
            return (methodBinding.defaultNullness & n) != 0;
        }
        return this.parent.hasDefaultNullnessFor(n, n2);
    }

    @Override
    public Binding checkRedundantDefaultNullness(int n, int n2) {
        MethodBinding methodBinding;
        Binding binding = this.localCheckRedundantDefaultNullness(n, n2);
        if (binding != null) {
            return binding;
        }
        AbstractMethodDeclaration abstractMethodDeclaration = this.referenceMethod();
        if (abstractMethodDeclaration != null && (methodBinding = abstractMethodDeclaration.binding) != null && methodBinding.defaultNullness != 0) {
            return methodBinding.defaultNullness == n ? methodBinding : null;
        }
        return this.parent.checkRedundantDefaultNullness(n, n2);
    }

    public boolean shouldCheckAPILeaks(ReferenceBinding referenceBinding, boolean bl) {
        if (this.environment().useModuleSystem) {
            return bl && referenceBinding.isPublic() && referenceBinding.fPackage.isExported();
        }
        return false;
    }

    public void detectAPILeaks(ASTNode aSTNode, TypeBinding typeBinding) {
        if (this.environment().useModuleSystem) {
            ASTVisitor aSTVisitor = new ASTVisitor(){

                @Override
                public boolean visit(SingleTypeReference singleTypeReference, BlockScope blockScope) {
                    if (singleTypeReference.resolvedType instanceof ReferenceBinding) {
                        this.checkType((ReferenceBinding)singleTypeReference.resolvedType, singleTypeReference.sourceStart, singleTypeReference.sourceEnd);
                    }
                    return true;
                }

                @Override
                public boolean visit(QualifiedTypeReference qualifiedTypeReference, BlockScope blockScope) {
                    if (qualifiedTypeReference.resolvedType instanceof ReferenceBinding) {
                        this.checkType((ReferenceBinding)qualifiedTypeReference.resolvedType, qualifiedTypeReference.sourceStart, qualifiedTypeReference.sourceEnd);
                    }
                    return true;
                }

                @Override
                public boolean visit(ArrayTypeReference arrayTypeReference, BlockScope blockScope) {
                    TypeBinding typeBinding = arrayTypeReference.resolvedType.leafComponentType();
                    if (typeBinding instanceof ReferenceBinding) {
                        this.checkType((ReferenceBinding)typeBinding, arrayTypeReference.sourceStart, arrayTypeReference.originalSourceEnd);
                    }
                    return true;
                }

                private void checkType(ReferenceBinding referenceBinding, int n, int n2) {
                    if (!referenceBinding.isValidBinding()) {
                        return;
                    }
                    ModuleBinding moduleBinding = referenceBinding.module();
                    if (moduleBinding == moduleBinding.environment.javaBaseModule()) {
                        return;
                    }
                    if (!this.isFullyPublic(referenceBinding)) {
                        MethodScope.this.problemReporter().nonPublicTypeInAPI(referenceBinding, n, n2);
                    } else if (!referenceBinding.fPackage.isExported()) {
                        MethodScope.this.problemReporter().notExportedTypeInAPI(referenceBinding, n, n2);
                    } else if (this.isUnrelatedModule(referenceBinding.fPackage)) {
                        MethodScope.this.problemReporter().missingRequiresTransitiveForTypeInAPI(referenceBinding, n, n2);
                    }
                }

                private boolean isFullyPublic(ReferenceBinding referenceBinding) {
                    if (!referenceBinding.isPublic()) {
                        return false;
                    }
                    if (referenceBinding instanceof NestedTypeBinding) {
                        return this.isFullyPublic(((NestedTypeBinding)referenceBinding).enclosingType);
                    }
                    return true;
                }

                private boolean isUnrelatedModule(PackageBinding packageBinding) {
                    ModuleBinding moduleBinding = packageBinding.enclosingModule;
                    ModuleBinding moduleBinding2 = MethodScope.this.module();
                    if (moduleBinding2 != moduleBinding) {
                        return !moduleBinding2.isTransitivelyRequired(moduleBinding);
                    }
                    return false;
                }
            };
            aSTNode.traverse(aSTVisitor, this);
        }
    }

    static {
        if (Boolean.getBoolean("jdt.flow.test.extra")) {
            baseAnalysisIndex = 64;
            System.out.println("JDT/Core testing with -Djdt.flow.test.extra=true");
        }
    }
}

