/*
 * Decompiled with CFR 0.152.
 */
package org.oorexx.datergf;

import java.io.Serializable;
import java.util.GregorianCalendar;
import org.oorexx.datergf.DateRGF;
import org.oorexx.datergf.TimeRGF;

public class DateTimeRGF
implements Cloneable,
Comparable,
Serializable {
    public static String version = "92.20060101";
    public DateRGF date = null;
    public TimeRGF time = null;

    public DateTimeRGF() {
        this.date = new DateRGF();
        this.time = new TimeRGF();
    }

    public DateTimeRGF(DateRGF dateRGF, TimeRGF timeRGF) {
        this.date = dateRGF;
        this.time = timeRGF;
    }

    public DateTimeRGF(int n, int n2, int n3, int n4, int n5, int n6) {
        this.date = new DateRGF(n, n2, n3);
        this.time = new TimeRGF(n4, n5, n6);
    }

    public DateTimeRGF(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.date = new DateRGF(n, n2, n3);
        this.time = new TimeRGF(n4, n5, n6, n7);
    }

    public DateTimeRGF add(int n, int n2) {
        n2 = this.time.raw_millis + n2;
        this.date.add(n += n2 / 86400000);
        this.time.set(-4, n2);
        return this;
    }

    public int[] subtract(DateTimeRGF dateTimeRGF) {
        int n = this.date.subtract(dateTimeRGF.date);
        int n2 = this.time.raw_millis - dateTimeRGF.time.raw_millis;
        if (n > 0 && n2 < 0) {
            n2 += 86400000;
        } else if (n < 0 && n2 > 0) {
            n2 -= 86400000;
        }
        return new int[]{--n, n2};
    }

    public DateTimeRGF assign(DateTimeRGF dateTimeRGF) {
        this.date.assign(dateTimeRGF.date);
        this.time.assign(dateTimeRGF.time);
        return this;
    }

    public int compareTo(Object object) {
        int n = this.date.compareTo(((DateTimeRGF)object).date);
        if (n == 0) {
            n = this.time.compareTo(((DateTimeRGF)object).time);
        }
        return n;
    }

    public Object clone() {
        DateTimeRGF dateTimeRGF = new DateTimeRGF();
        dateTimeRGF.date = (DateRGF)this.date.clone();
        dateTimeRGF.time = (TimeRGF)this.time.clone();
        return dateTimeRGF;
    }

    public boolean equals(DateTimeRGF dateTimeRGF) {
        return this.date.equals(dateTimeRGF.date) && this.time.equals(dateTimeRGF.time);
    }

    public String toString() {
        return this.date.toString() + " " + this.time.toString();
    }

    public long toLong(int n) {
        DateRGF dateRGF = null;
        dateRGF = n > 0 ? DateRGF.valueOf(-1, n) : DateRGF.valueOf(n, 0);
        int n2 = this.date.subtract(dateRGF);
        int n3 = this.time.raw_millis;
        if (n2 < 0 && n3 > 0) {
            --n2;
        }
        return (long)n2 * 86400000L + (long)n3;
    }

    public static DateTimeRGF valueOf(int n, long l) {
        DateTimeRGF dateTimeRGF = new DateTimeRGF(DateRGF.valueOf(n, 0), new TimeRGF());
        dateTimeRGF.add((int)(l / 86400000L), (int)(l % 86400000L));
        return dateTimeRGF;
    }

    public int toInt(int n) {
        DateRGF dateRGF = DateRGF.valueOf(n, 0);
        int n2 = this.date.subtract(dateRGF);
        if (n2 < 0) {
            return 0;
        }
        int n3 = this.time.raw_millis / 1000;
        if (n2 > 49710 || n2 == 49710 && n3 > 23295) {
            return 0;
        }
        return n2 * 5400 + (n3 >> 4) << 4 | n3 & 0xF;
    }

    public static DateTimeRGF valueOf(int n, int n2) {
        int n3;
        int n4;
        if (n2 < 0) {
            int n5 = n2 & 0xFFFF;
            int n6 = n2 >> 4 & 0xFFFFFFF;
            n4 = (n6 | n5 >> 4) / 5400;
            n3 = (n6 | n5 >> 4) % 5400 << 4 | n2 & 0xF;
        } else {
            n3 = n2 % 86400;
            n4 = (n2 >> 7 & 0x1FFFFFFF) / 675;
        }
        DateRGF dateRGF = DateRGF.valueOf(n, 0);
        dateRGF.add(n4);
        return new DateTimeRGF(dateRGF, TimeRGF.valueOf(-3, n3));
    }

    public DateTimeRGF update() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.date.year = gregorianCalendar.get(1);
        this.date.month = gregorianCalendar.get(2) + 1;
        this.date.day = gregorianCalendar.get(5);
        this.date.jdn = DateRGF.date2jdn(this.date);
        this.time.hour = gregorianCalendar.get(11);
        this.time.minute = gregorianCalendar.get(12);
        this.time.second = gregorianCalendar.get(13);
        this.time.millis = gregorianCalendar.get(14);
        this.time.raw_millis = this.time.hour * 3600000 + this.time.minute * 60000 + this.time.second * 1000 + this.time.millis;
        return this;
    }
}

