/*
 * Decompiled with CFR 0.152.
 */
package org.rexxla.bsf.engines.rexx;

import java.io.FileOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.CRC32;
import org.apache.bsf.BSFException;
import org.codehaus.janino.SimpleCompiler;
import org.rexxla.bsf.engines.rexx.RexxProxy;

public class ClassAdapter {
    private static final String STR_REXX_PROXY = "org.rexxla.bsf.engines.rexx.RexxProxy";
    private static final int METHOD_SIGNATURE = 1;
    private static final int THROWS_CLAUSE = 2;
    private static final boolean bDebug = false;
    public static boolean bTiming = false;
    public static boolean bShowSource = false;
    public static final String version = "104.20190829";
    public static boolean bFileNameWithSimpleName = true;
    static SimpleDateFormat sdf_dt = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
    static SimpleDateFormat sdf_d = new SimpleDateFormat("yyyyMMdd");
    public static boolean bFileNameWithDateTime = true;
    public static boolean bFileNameWithDateOnly = false;
    public static boolean bSaveToFilesystem = false;
    public static boolean bAddCRC32toNewName = false;
    public static boolean bAddCRC32toGeneratedClassName = true;
    public static boolean bAddHashToGeneratedClassName = false;
    public static String extensionIndicator = "$RexxExtendClass$";
    public static String packageName = "org.rexxla.bsf.engines.rexx.onTheFly";
    public static String pathToSaveTo = System.getProperty("java.io.tmpdir");
    private static String fileSeparator = System.getProperty("file.separator");

    public static void main(String[] stringArray) throws BSFException {
        if (stringArray.length != 0) {
            Class<?> clazz = null;
            String string = null;
            String[] stringArray2 = null;
            try {
                clazz = ClassAdapter.class.getClassLoader().loadClass(stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("--- The (premature) end. ---");
                System.exit(-1);
            }
            if (stringArray.length > 1) {
                string = stringArray[1];
            }
            if (stringArray.length > 2) {
                int n = stringArray.length - 2;
                stringArray2 = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray2[i] = stringArray[i + 2];
                }
            }
            try {
                bTiming = true;
                bShowSource = true;
                ClassAdapter.createProxiedJavaClass(clazz, string, stringArray2, null);
            }
            catch (Exception exception) {
                System.err.println(exception + "\n---");
            }
        }
    }

    private ClassAdapter() {
    }

    /*
     * WARNING - void declaration
     */
    public static Class createProxiedJavaClass(Class clazz, String string, String[] stringArray, Class[] classArray) throws BSFException {
        Object object2;
        Object object3;
        boolean bl;
        String string2 = string;
        long l = 0L;
        long l2 = 0L;
        if (bTiming) {
            l = System.currentTimeMillis();
        }
        if (clazz == null) {
            throw new BSFException(0, "ClassAdapter.createProxiedJavaClass(...): argument \"javaClassToProxy\" must not be null");
        }
        if (clazz.isArray()) {
            throw new BSFException(0, "ClassAdapter.createProxiedJavaClass(...): argument \"javaClassToProxy\" must not be an array class");
        }
        int n = clazz.getModifiers();
        if (!Modifier.isPublic(n)) {
            throw new BSFException(0, "ClassAdapter.createProxiedJavaClass(...): argument \"javaClassToProxy\", value=[" + clazz + "]: is not public");
        }
        if (Modifier.isFinal(n)) {
            throw new BSFException(0, "ClassAdapter.createProxiedJavaClass(...): argument \"javaClassToProxy\", value=[" + clazz + "]: must not be final");
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        if (bAddCRC32toGeneratedClassName || bSaveToFilesystem || bAddCRC32toNewName) {
            if (bSaveToFilesystem && bFileNameWithSimpleName) {
                string4 = clazz.getSimpleName();
            }
            string5 = clazz.getName();
            string6 = Arrays.toString(stringArray);
            string7 = Arrays.toString(classArray);
            string3 = ClassAdapter.calcCRC32(string5 + "-" + string2 + "-" + string6 + "-" + string7);
        }
        if (string2 == null) {
            string2 = (string5 != null ? string5 : clazz.getName()) + "_" + extensionIndicator;
            if (bAddCRC32toGeneratedClassName) {
                string2 = string2 + "_" + string3;
            }
            if (bAddHashToGeneratedClassName) {
                string2 = string2 + "_" + new Object().hashCode();
            }
        } else if (bAddCRC32toNewName) {
            string2 = string + "_" + string3;
        }
        String[] stringArray2 = null;
        boolean bl2 = Modifier.isAbstract(n);
        boolean bl3 = bl = stringArray != null && stringArray.length == 1 && stringArray[0].equals("*");
        if (bl) {
            object3 = clazz.getDeclaredMethods();
            object2 = new HashSet();
            for (int i = 0; i < ((Method[])object3).length; ++i) {
                String string8;
                int n2 = object3[i].getModifiers();
                if (!Modifier.isPublic(n2) && !Modifier.isProtected(n2) || (string8 = object3[i].getName()).equals("toString") || string8.equals("equals") || string8.equals("hashCode") || Modifier.isAbstract(n2)) continue;
                ((HashSet)object2).add(((Method)object3[i]).getName());
            }
            stringArray2 = ((HashSet)object2).toArray(new String[0]);
        } else {
            stringArray2 = stringArray;
        }
        object3 = new StringBuffer();
        object2 = new RunInfos();
        ((RunInfos)object2).uCN2clz.put(clazz.getName().toUpperCase(), clazz);
        String string9 = string2;
        String string10 = packageName;
        int n3 = string2.lastIndexOf(46);
        if (n3 >= 0) {
            if (string != null) {
                string10 = string2.substring(0, n3);
            } else if (packageName.length() == 0 || packageName.contains(" ")) {
                string10 = "";
            }
            string9 = string2.substring(n3 + 1);
        } else {
            string10 = null;
        }
        String string11 = string2;
        if (string10 != null) {
            if (string10.length() > 0) {
                ((StringBuffer)object3).append("package ").append(string10).append("; \n");
                string11 = string10 + "." + string9;
            } else {
                string11 = string2;
            }
        }
        ClassAdapter.createProlog((StringBuffer)object3, string9, clazz, classArray, (RunInfos)object2);
        ClassAdapter.createMethods((StringBuffer)object3, string9, clazz, stringArray2, (RunInfos)object2);
        ClassAdapter.createConstructorsBase((StringBuffer)object3, string9, clazz, false, (RunInfos)object2);
        Class clazz2 = clazz;
        do {
            int n2;
            void object;
            ClassAdapter.createConstructors((StringBuffer)object3, string9, clazz2, false, (RunInfos)object2);
            if (!Modifier.isAbstract(clazz2.getModifiers())) break;
            ((StringBuffer)object3).append("\n\t// --- creating methods for public and protected abstract methods in class [" + clazz2.getName() + "], if not yet created \n");
            Object var25_27 = null;
            if (((RunInfos)object2).clz2declMethods.containsKey(clazz2)) {
                Method[] methodArray = ((RunInfos)object2).clz2declMethods.get(clazz2);
            } else {
                Method[] methodArray = clazz2.getDeclaredMethods();
                ((RunInfos)object2).clz2declMethods.put(clazz2, methodArray);
            }
            for (int i = 0; i < ((void)object).length; ++i) {
                void var27_42 = object[i];
                n2 = var27_42.getModifiers();
                if (!Modifier.isAbstract(n2) || !Modifier.isPublic(n2) && !Modifier.isProtected(n2)) continue;
                ClassAdapter.createMethod((StringBuffer)object3, (Method)var27_42, string9, (RunInfos)object2);
            }
            Class<?>[] classArray2 = clazz2.getInterfaces();
            int n4 = classArray2.length;
            for (n2 = 0; n2 < n4; ++n2) {
                Class<?> clazz3 = classArray2[n2];
                ClassAdapter.createInterfaceMethods((StringBuffer)object3, string9, clazz3, (RunInfos)object2, clazz2);
            }
        } while (((clazz2 = clazz2.getSuperclass()) == null || Modifier.isAbstract(clazz2.getModifiers())) && clazz2 != null);
        if (classArray != null) {
            for (Class clazz4 : classArray) {
                ClassAdapter.createInterfaceMethods((StringBuffer)object3, string9, clazz4, (RunInfos)object2, clazz);
            }
        }
        ClassAdapter.createEpilog((StringBuffer)object3);
        if (bShowSource) {
            System.err.println("/// ClassAdapter.createProxiedJavaClass(...) ---> begin of generated code for class: [" + string9 + "], now: [" + string11 + "]\n" + ((StringBuffer)object3).toString() + "\n<--- end of generated code \\\\\\");
        }
        if (bTiming) {
            l2 = System.currentTimeMillis();
        }
        Object var25_32 = null;
        if (bSaveToFilesystem) {
            String string8 = ClassAdapter.createFileName(string4, string5, string9, string6, string7, string3);
            ((StringBuffer)object3).append("\n\n").append("// ClassAdapter:");
            ((StringBuffer)object3).append("\n//\targument # 1: ").append(clazz);
            ((StringBuffer)object3).append("\n//\targument # 2: ").append(string2).append(" | simpleNewClzName: ").append(string9);
            ((StringBuffer)object3).append("\n//\targument # 3: ").append(string6);
            ((StringBuffer)object3).append("\n//\targument # 4: ").append(string7);
            ((StringBuffer)object3).append("\n\n// storing in a file named: ").append(string8);
            ((StringBuffer)object3).append("\n");
            String string12 = ((StringBuffer)object3).toString();
            ClassAdapter.writeToFile(string8, string12);
        } else {
            String string13 = ((StringBuffer)object3).toString();
        }
        SimpleCompiler simpleCompiler = new SimpleCompiler();
        Class<?> clazz5 = null;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        try {
            void var25_35;
            if (bTiming) {
                l3 = System.currentTimeMillis();
            }
            if (Thread.currentThread().getContextClassLoader() == null) {
                simpleCompiler.setParentClassLoader(ClassAdapter.class.getClassLoader());
            }
            simpleCompiler.cook((String)var25_35);
            if (bTiming) {
                l4 = System.currentTimeMillis();
            }
            clazz5 = simpleCompiler.getClassLoader().loadClass(string11);
            if (bTiming) {
                l5 = System.currentTimeMillis();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BSFException(100, exception.toString(), exception);
        }
        if (bTiming) {
            System.err.println("clz=[" + clazz5 + "]");
            System.err.println("creating source  (in milliseconds): " + (l2 - l));
            System.err.println("compilation time (in milliseconds): " + (l4 - l3));
            System.err.println("load time        (in milliseconds): " + (l5 - l4));
        }
        return clazz5;
    }

    static void createProlog(StringBuffer stringBuffer, String string, Class clazz, Class[] classArray, RunInfos runInfos) throws BSFException {
        stringBuffer.append("import org.rexxla.bsf.engines.rexx.RexxProxy; \n");
        stringBuffer.append("import org.apache.bsf.BSFException; \n");
        stringBuffer.append("\npublic class ");
        stringBuffer.append(string);
        boolean bl = clazz.isInterface();
        if (!bl) {
            stringBuffer.append(" extends ").append(clazz.getName());
        }
        if (classArray != null && classArray.length > 0 || bl) {
            stringBuffer.append("\n\t\timplements");
            boolean bl2 = false;
            if (bl) {
                stringBuffer.append(' ').append(clazz.getName());
                bl2 = true;
            }
            if (classArray != null) {
                for (Class clazz2 : classArray) {
                    if (bl2) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(' ').append(clazz2.getName());
                    if (bl2) continue;
                    bl2 = true;
                }
            }
        }
        stringBuffer.append("\n{\n");
        stringBuffer.append("\tpublic  static          Object    classLock     =new Object(); \n");
        stringBuffer.append("\tprivate static volatile RexxProxy defaultHandler=null;         \n");
        stringBuffer.append("\tprivate                 RexxProxy target        =null;         \n\n");
        stringBuffer.append("\n\tpublic static RexxProxy getDefaultHandler() \n");
        stringBuffer.append("\t{\n");
        stringBuffer.append("\t\treturn defaultHandler; \n");
        stringBuffer.append("\t}\n\n");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("()");
        runInfos.uMN2setOfSignatures.put("getDefaultHandler", hashSet);
        stringBuffer.append("\n\tpublic static void setDefaultHandler(RexxProxy rexxproxy) \n");
        stringBuffer.append("\t{\n");
        stringBuffer.append("\t\tsynchronized (classLock)    \n");
        stringBuffer.append("\t\t{                           \n");
        stringBuffer.append("\t\t\tdefaultHandler=rexxproxy; \n");
        stringBuffer.append("\t\t}                           \n");
        stringBuffer.append("\t}\n\n");
        hashSet = new HashSet();
        hashSet.add("(org.rexxla.bsf.engines.rexx.RexxProxy)");
        runInfos.uMN2setOfSignatures.put("setDefaultHandler", hashSet);
        stringBuffer.append("\n\tpublic synchronized RexxProxy getTargetRexxProxy() \n");
        stringBuffer.append("\t{\n");
        stringBuffer.append("\t\treturn target; \n");
        stringBuffer.append("\t}\n\n");
        hashSet = new HashSet();
        hashSet.add("()");
        runInfos.uMN2setOfSignatures.put("getTargetRexxProxy", hashSet);
        stringBuffer.append("\n\tpublic synchronized void setTargetRexxProxy(RexxProxy newTarget) \n");
        stringBuffer.append("\t{\n");
        stringBuffer.append("\t\ttarget=newTarget; \n");
        stringBuffer.append("\t}\n\n");
        hashSet = new HashSet();
        hashSet.add("(org.rexxla.bsf.engines.rexx.RexxProxy)");
        runInfos.uMN2setOfSignatures.put("setTargetRexxProxy", hashSet);
    }

    static void createEpilog(StringBuffer stringBuffer) {
        stringBuffer.append("}\n");
    }

    static void createConstructorsBase(StringBuffer stringBuffer, String string, Class<?> clazz, boolean bl, RunInfos runInfos) {
        Object object;
        String[] stringArray = new String[]{"", ""};
        if (clazz.isInterface()) {
            stringBuffer.append("\n\t// --- creating base (default) constructor \n");
            stringBuffer.append("\n\tpublic " + string + "() \n");
            stringBuffer.append("\t{\n");
            stringBuffer.append("\t\tsuper();                    \n");
            stringBuffer.append("\t\ttarget=defaultHandler;      \n");
            if (bl) {
                stringBuffer.append("\t\ttry {\n");
                stringBuffer.append("\t\ttarget.invoke(this, \"<init>\", \"public " + string + "()\", null);   \n");
                stringBuffer.append("\t\t} \n\t\tcatch (BSFException be)\n");
                stringBuffer.append("\t\t{ \n\t\t\tthrow new RuntimeException(be.toString(), be); \n\t\t}\n");
            }
            stringBuffer.append("\t}\n\n");
            stringBuffer.append("\n\tpublic " + string + "(RexxProxy rexxproxy) \n");
            stringBuffer.append("\n");
            stringBuffer.append("\t{\n");
            stringBuffer.append("\t\tsuper();                 \n");
            stringBuffer.append("\t\ttarget=rexxproxy;        \n");
            stringBuffer.append("\t\tif (defaultHandler==null)   \n");
            stringBuffer.append("\t\t{                           \n");
            stringBuffer.append("\t\t\tdefaultHandler=rexxproxy; \n");
            stringBuffer.append("\t\t}                           \n");
            if (bl) {
                stringBuffer.append("\t\ttry {\n");
                stringBuffer.append("\t\ttarget.invoke(this, \"<init>\", \"public " + string + "(RexxProxy rexxproxy)\", new Object[] {rexxproxy});   \n");
                stringBuffer.append("\t\t} \n\t\tcatch (BSFException be)\n");
                stringBuffer.append("\t\t{ \n\t\t\tthrow new RuntimeException(be.toString(), be); \n\t\t}\n");
            }
            stringBuffer.append("\t}\n\n");
            return;
        }
        boolean bl2 = false;
        try {
            object = clazz.getDeclaredConstructor(new Class[0]);
            int n = ((Constructor)object).getModifiers();
            boolean bl3 = bl2 = Modifier.isPublic(n) || Modifier.isProtected(n);
            if (!bl2) {
                return;
            }
            stringArray = ClassAdapter.createThrowsClause(((Constructor)object).getExceptionTypes());
        }
        catch (Exception exception) {
            return;
        }
        object = "<INIT>";
        HashSet<String> hashSet = runInfos.uMN2setOfSignatures.get(object);
        if (hashSet == null) {
            hashSet = new HashSet();
            runInfos.uMN2setOfSignatures.put((String)object, hashSet);
        }
        String string2 = "public " + clazz.getName() + "()";
        String string3 = "()";
        if (bl2) {
            stringBuffer.append("\n\t// --- creating base (default) constructor \n");
            stringBuffer.append("\n\tpublic " + string + "() " + (bl ? stringArray[1] : stringArray[0]) + "\n");
            stringBuffer.append("\t{\n");
            if (bl2) {
                stringBuffer.append("\t\tsuper();                    \n");
            }
            stringBuffer.append("\t\ttarget=defaultHandler;      \n");
            if (bl) {
                stringBuffer.append("\t\ttry {\n");
                stringBuffer.append("\t\ttarget.invoke(this, \"<init>\", \"" + string2 + "\", null);   \n");
                stringBuffer.append("\t\t} \n\t\tcatch (BSFException be)\n");
                stringBuffer.append("\t\t{ \n\t\t\tthrow new RuntimeException(be.toString(), be); \n\t\t}\n");
            }
            stringBuffer.append("\t}\n\n");
            if (!hashSet.contains("()")) {
                Constructor<?> constructor = null;
                boolean bl4 = true;
                try {
                    constructor = clazz.getDeclaredConstructor(RexxProxy.class);
                    if (Modifier.isPrivate(constructor.getModifiers())) {
                        constructor = null;
                        stringArray = new String[]{"", "throws BSFException"};
                    } else {
                        stringArray = ClassAdapter.createThrowsClause(constructor.getExceptionTypes());
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    bl4 = false;
                }
                stringBuffer.append("\n\tpublic " + string + "(RexxProxy rexxproxy) " + (bl ? stringArray[1] : stringArray[0]) + " \n");
                stringBuffer.append("\t{\n");
                if (constructor == null) {
                    if (bl2) {
                        stringBuffer.append("\t\tsuper();                 \n");
                    }
                } else if (bl4) {
                    stringBuffer.append("\t\tsuper(rexxproxy);        \n");
                }
                stringBuffer.append("\t\ttarget=rexxproxy;        \n");
                stringBuffer.append("\t\tif (defaultHandler==null)   \n");
                stringBuffer.append("\t\t{                           \n");
                stringBuffer.append("\t\t\tdefaultHandler=rexxproxy; \n");
                stringBuffer.append("\t\t}                           \n");
                string2 = constructor != null ? constructor.toString() : "public " + clazz.getName() + "(" + STR_REXX_PROXY + ")";
                hashSet.add(string3);
                if (bl) {
                    stringBuffer.append("\t\ttry {\n");
                    stringBuffer.append("\t\ttarget.invoke(this, \"<init>\", \"" + string2 + "\", new Object[] {rexxproxy});   \n");
                    stringBuffer.append("\t\t} \n\t\tcatch (BSFException be)\n");
                    stringBuffer.append("\t\t{ \n\t\t\tthrow new RuntimeException(be.toString(), be); \n\t\t}\n");
                }
                stringBuffer.append("\t}\n\n");
            }
            hashSet.add(string3);
        }
    }

    static void createConstructors(StringBuffer stringBuffer, String string, Class clazz, boolean bl, RunInfos runInfos) {
        HashSet<String> hashSet = runInfos.uMN2setOfSignatures.get("<INIT>");
        if (hashSet == null) {
            hashSet = new HashSet();
            runInfos.uMN2setOfSignatures.put("<INIT>", hashSet);
        }
        Constructor<?> constructor = null;
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        if (constructorArray.length > 0) {
            stringBuffer.append("\n\t// --- creating constructors from existing public and protected constructors using [" + clazz.getName() + "] (if any) \n");
        }
        for (int i = 0; i < constructorArray.length; ++i) {
            Class[] classArray;
            String string2;
            constructor = constructorArray[i];
            int n = constructor.getModifiers();
            if (!Modifier.isPublic(n) && !Modifier.isProtected(n) || hashSet.contains(string2 = ClassAdapter.createListOfClassNames(classArray = constructor.getParameterTypes(), 1))) continue;
            String[] stringArray = ClassAdapter.createThrowsClause(constructor.getExceptionTypes());
            String[] stringArray2 = ClassAdapter.createArgumentHead(classArray, true, bl);
            stringBuffer.append("\n\tpublic " + string + stringArray2[0] + " " + (bl ? stringArray[1] : stringArray[0]) + "     \n");
            stringBuffer.append("\t{\n");
            stringBuffer.append("\t\tsuper" + stringArray2[1] + ";                    \n");
            stringBuffer.append("\t\ttarget=a0;      \n");
            stringBuffer.append("\t\tif (defaultHandler==null) \n");
            stringBuffer.append("\t\t{                         \n");
            stringBuffer.append("\t\t\tdefaultHandler=a0;      \n");
            stringBuffer.append("\t\t}                         \n");
            if (bl) {
                stringBuffer.append("\t\t" + stringArray2[2] + "\n");
                stringBuffer.append("\t\ttry {\n");
                stringBuffer.append("\t\ttarget.invoke(this, \"<init>\", \"" + constructor.toString() + "\", obj);   \n");
                stringBuffer.append("\t\t} \n\t\tcatch (BSFException be)\n");
                stringBuffer.append("\t\t{ \n\t\t\tthrow new RuntimeException(be.toString(), be); \n\t\t}\n");
            }
            stringBuffer.append("\t}\n\n");
            hashSet.add(string2);
        }
    }

    static void createInterfaceMethods(StringBuffer stringBuffer, String string, Class clazz, RunInfos runInfos, Class<?> clazz2) {
        ClassAdapter.createInterfaceMethodsWorker(stringBuffer, string, clazz, runInfos, clazz2);
        for (Class<?> clazz3 : clazz.getInterfaces()) {
            ClassAdapter.createInterfaceMethods(stringBuffer, string, clazz3, runInfos, clazz2);
        }
    }

    static void createInterfaceMethodsWorker(StringBuffer stringBuffer, String string, Class clazz, RunInfos runInfos, Class<?> clazz2) {
        stringBuffer.append("\n\t// --- creating methods for interface [" + clazz.getName() + "], if any and not yet created \n");
        Method[] methodArray = null;
        if (runInfos.clz2declMethods.containsKey(clazz)) {
            methodArray = runInfos.clz2declMethods.get(clazz);
        } else {
            methodArray = clazz.getDeclaredMethods();
            runInfos.clz2declMethods.put(clazz, methodArray);
        }
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!Modifier.isAbstract(method.getModifiers())) continue;
            try {
                Method method2 = clazz2.getDeclaredMethod(method.getName(), method.getParameterTypes());
                int n = method2.getModifiers();
                if (!Modifier.isAbstract(n)) continue;
                ClassAdapter.createMethod(stringBuffer, method, string, runInfos);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ClassAdapter.createMethod(stringBuffer, method, string, runInfos);
            }
        }
    }

    static void createMethods(StringBuffer stringBuffer, String string, Class object, String[] stringArray, RunInfos runInfos) throws BSFException {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        stringBuffer.append("\n\t// --- creating methods according to String array of methods to proxy (if any) \n");
        for (int i = 0; i < stringArray.length; ++i) {
            Object object2;
            if (stringArray[i] == null || stringArray[i].compareTo("") == 0) continue;
            String[] stringArray2 = ClassAdapter.parseMethod2Proxy(stringArray[i]);
            if (stringArray2 == null) {
                throw new BSFException("ClassAdapter.createMethods(): erroneous value for the " + (i + 1) + (i == 0 ? "st" : (i == 1 ? "nd" : (i == 2 ? "rd" : "th"))) + " (1-based) entry in the supplied String array of methods to proxy: [" + stringArray[i] + "].");
            }
            Object object3 = object;
            if (stringArray2[0] != null) {
                object3 = runInfos.uCN2clz.get(stringArray2[1]);
                if (object3 == null) {
                    for (object2 = object.getSuperclass(); object2 != null; object2 = object2.getSuperclass()) {
                        String string2 = object2.getName().toUpperCase();
                        if (runInfos.uCN2clz.containsKey(string2)) continue;
                        runInfos.uCN2clz.put(string2, (Class<?>)object2);
                        if (string2.compareTo(stringArray2[1]) != 0) continue;
                        object3 = object2;
                        string = stringArray2[0];
                        break;
                    }
                }
                if (object3 == null) {
                    throw new BSFException("ClassAdapter.createMethods(): erroneous value (class not found or not a superclass) for the " + (i + 1) + (i == 0 ? "st" : (i == 1 ? "nd" : (i == 2 ? "rd" : "th"))) + " (1-based) entry in the supplied String array of methods to proxy: [" + stringArray[i] + "].");
                }
            }
            if (stringArray2[3].compareTo("<INIT>") == 0) {
                ClassAdapter.createConstructors(stringBuffer, string, object3, true, runInfos);
                continue;
            }
            object2 = runInfos.clz2declMethods.get(object3);
            if (object2 == null) {
                object2 = object3.getDeclaredMethods();
                runInfos.clz2declMethods.put((Class<?>)object3, (Method[])object2);
            }
            boolean bl = false;
            for (int j = 0; j < ((Method[])object2).length; ++j) {
                int n;
                String string3;
                if (object2[j].isSynthetic() || (string3 = object2[j].getName().toUpperCase()).compareTo(stringArray2[3]) != 0 || ((n = object2[j].getModifiers()) & 0x12) != 0) continue;
                bl = true;
                ClassAdapter.createMethod(stringBuffer, object2[j], string, runInfos);
            }
            if (bl) continue;
            throw new BSFException("ClassAdapter.createMethods(): no public nor protected method definition to override found for the " + (i + 1) + (i == 0 ? "st" : (i == 1 ? "nd" : (i == 2 ? "rd" : "th"))) + " (1-based) entry in the supplied String array of methods to proxy: [" + stringArray[i] + "].");
        }
    }

    static void createMethod(StringBuffer stringBuffer, Method method, String string, RunInfos runInfos) {
        Class[] classArray = method.getParameterTypes();
        String string2 = ClassAdapter.createListOfClassNames(classArray, 1);
        String string3 = method.getName();
        HashSet<String> hashSet = runInfos.uMN2setOfSignatures.get(string3);
        if (hashSet == null) {
            hashSet = new HashSet();
            runInfos.uMN2setOfSignatures.put(string3, hashSet);
        } else if (hashSet.contains(string2)) {
            return;
        }
        String string4 = string3.toUpperCase();
        int n = method.getModifiers();
        boolean bl = !Modifier.isAbstract(n);
        String string5 = "public ";
        boolean bl2 = Modifier.isStatic(n);
        if (bl2) {
            string5 = string5 + "static ";
        }
        Class<?> clazz = method.getReturnType();
        String string6 = ClassAdapter.getEditedClassName(clazz);
        string5 = string5 + string6;
        String[] stringArray = ClassAdapter.createThrowsClause(method.getExceptionTypes());
        String[] stringArray2 = ClassAdapter.createArgumentHead(classArray, false, true);
        String string7 = ClassAdapter.createReturnStatements(clazz);
        stringBuffer.append("\n\t" + string5 + " " + string3 + stringArray2[0] + ' ' + stringArray[1] + "\n");
        stringBuffer.append("\t{\n");
        stringBuffer.append("\t\t" + stringArray2[2] + "\n");
        stringBuffer.append("\t\tObject    res=null;     \n");
        String string8 = "this";
        if (bl2) {
            stringBuffer.append("\t\tRexxProxy rpTarget=defaultHandler;     \n");
            string8 = string + ".class";
        } else {
            stringBuffer.append("\t\tRexxProxy rpTarget=(target==null ? defaultHandler : target);     \n");
        }
        stringBuffer.append("\t\ttry {\n");
        stringBuffer.append("\t\t\tres=rpTarget.invoke(" + string8 + ", \"" + string3 + "\", \"" + string5 + " " + string3 + string2 + "\", obj); \n");
        stringBuffer.append("\t\t} \n\t\tcatch (BSFException be)\n");
        stringBuffer.append("\t\t{ \n\t\t\tthrow new RuntimeException(be.toString(), be); \n\t\t}\n");
        stringBuffer.append(string7);
        stringBuffer.append("\t}\n\n");
        if (bl) {
            stringBuffer.append("\n\t" + string5 + " " + string3 + "_forwardToSuper" + stringArray2[0] + ' ' + stringArray[0] + "\n");
            stringBuffer.append("\t{\n");
            String string9 = "return ";
            if (clazz == Void.class || clazz == Void.TYPE) {
                string9 = "";
            }
            String string10 = "super";
            if (bl2) {
                string10 = ClassAdapter.getEditedClassName(method.getDeclaringClass());
            }
            stringBuffer.append("\t\t" + string9 + string10 + "." + string3 + stringArray2[1] + ";    \n");
            stringBuffer.append("\t}\n\n");
        }
        hashSet.add(string2);
    }

    static String[] parseMethod2Proxy(String string) {
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        int n = -1;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\t') continue;
            if (++n > 1) {
                return null;
            }
            stringBufferArray[n].append(c);
            ++i;
            while (i < n2 && (c = string.charAt(i)) != ' ' && c != '\t') {
                stringBufferArray[n].append(c);
                ++i;
            }
        }
        if (n < 0) {
            return null;
        }
        if (n == 0) {
            String string2 = stringBufferArray[0].toString();
            return new String[]{null, null, string2, string2.toUpperCase()};
        }
        String string3 = stringBufferArray[0].toString();
        String string4 = stringBufferArray[1].toString();
        return new String[]{string3, string3.toUpperCase(), string4, string4.toUpperCase()};
    }

    static String[] createArgumentHead(Class[] classArray, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = null;
        stringBuffer.append("(");
        if (bl) {
            stringBuffer.append(STR_REXX_PROXY).append(" a0");
            if (classArray.length > 0) {
                stringBuffer.append(", ");
            }
        }
        stringBuffer2.append("(");
        if (bl2) {
            stringBuffer3 = new StringBuffer();
            stringBuffer3.append("Object []obj=new Object[] { ");
        }
        for (int i = 0; i < classArray.length; ++i) {
            int n = i + 1;
            Class clazz = classArray[i];
            String string = ClassAdapter.getEditedClassName(clazz) + " a" + n;
            if (i > 0) {
                stringBuffer.append(", ");
                stringBuffer2.append(", ");
                if (bl2) {
                    stringBuffer3.append(", ");
                }
            }
            stringBuffer.append(string);
            stringBuffer2.append("a" + n);
            if (!bl2) continue;
            Object var10_10 = null;
            if (clazz.isPrimitive()) {
                if (clazz == Boolean.TYPE) {
                    stringBuffer3.append("Boolean.valueOf(a" + n + ")");
                    continue;
                }
                if (clazz == Byte.TYPE) {
                    stringBuffer3.append("new Byte(a" + n + ")");
                    continue;
                }
                if (clazz == Character.TYPE) {
                    stringBuffer3.append("new Character(a" + n + ")");
                    continue;
                }
                if (clazz == Short.TYPE) {
                    stringBuffer3.append("new Short(a" + n + ")");
                    continue;
                }
                if (clazz == Integer.TYPE) {
                    stringBuffer3.append("new Integer(a" + n + ")");
                    continue;
                }
                if (clazz == Float.TYPE) {
                    stringBuffer3.append("new Float(a" + n + ")");
                    continue;
                }
                if (clazz == Double.TYPE) {
                    stringBuffer3.append("new Double(a" + n + ")");
                    continue;
                }
                if (clazz != Long.TYPE) continue;
                stringBuffer3.append("new Long(a" + n + ")");
                continue;
            }
            stringBuffer3.append("a" + n);
        }
        stringBuffer.append(")");
        stringBuffer2.append(")");
        return new String[]{stringBuffer.toString(), stringBuffer2.toString(), stringBuffer3 == null ? null : stringBuffer3.append(" };").toString()};
    }

    static String createReturnStatements(Class clazz) {
        if (clazz == Void.class || clazz == Void.TYPE || clazz == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = ClassAdapter.getEditedClassName(clazz);
        if (!clazz.isPrimitive()) {
            if (clazz == Boolean.class || clazz == Byte.class || clazz == Character.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class) {
                stringBuffer.append("\t\tif (res instanceof String)    \n").append("\t\t{ \n");
                if (clazz == Boolean.class) {
                    stringBuffer.append("\t\t\tif ( ((String) res).compareTo(\"1\")==0 ) \n");
                    stringBuffer.append("\t\t\t{                   \n");
                    stringBuffer.append("\t\t\t\tres=Boolean.TRUE; \n");
                    stringBuffer.append("\t\t\t}                   \n");
                    stringBuffer.append("\t\t\telse                \n");
                    stringBuffer.append("\t\t\t{                   \n");
                    stringBuffer.append("\t\t\t\tres= new " + string + "((String) res); \n");
                    stringBuffer.append("\t\t\t}                   \n");
                } else if (clazz == Character.class) {
                    stringBuffer.append("\t\t\tres=((String) res).charAt(0); \n");
                } else {
                    stringBuffer.append("\t\t\tres= new " + string + "((String) res); \n");
                }
                stringBuffer.append("\t\t} \n");
            }
            return stringBuffer.append("\t\treturn (" + string + ") res; \n").toString();
        }
        String string2 = null;
        if (clazz == Boolean.TYPE) {
            string2 = "Boolean";
        } else if (clazz == Byte.TYPE) {
            string2 = "Byte";
        } else if (clazz == Character.TYPE) {
            string2 = "Character";
        } else if (clazz == Short.TYPE) {
            string2 = "Short";
        } else if (clazz == Integer.TYPE) {
            string2 = "Integer";
        } else if (clazz == Float.TYPE) {
            string2 = "Float";
        } else if (clazz == Double.TYPE) {
            string2 = "Double";
        } else if (clazz == Long.TYPE) {
            string2 = "Long";
        }
        stringBuffer.append("\t\tif (res==null)                   \n").append("\t\t{ \n").append("\t\t\tthrow new ClassCastException(\"Result returned from RexxProxy '\"+rpTarget+\"' is 'null', ").append("which cannot be cast to the primitive return type '").append(string + "'.\");    \n").append("\t\t} \n");
        stringBuffer.append("\t\tif (res instanceof String)    \n").append("\t\t{ \n");
        if (clazz == Boolean.TYPE) {
            stringBuffer.append("\t\t\tif ( ((String) res).compareTo(\"1\")==0 ) \n");
            stringBuffer.append("\t\t\t{                   \n");
            stringBuffer.append("\t\t\t\tres=Boolean.TRUE; \n");
            stringBuffer.append("\t\t\t}                   \n");
            stringBuffer.append("\t\t\telse                \n");
            stringBuffer.append("\t\t\t{                   \n");
            stringBuffer.append("\t\t\t\tres= new " + string2 + "((String) res); \n");
            stringBuffer.append("\t\t\t}                   \n");
        } else if (clazz == Character.TYPE) {
            stringBuffer.append("\t\t\tres=((String) res).charAt(0); \n");
        } else {
            stringBuffer.append("\t\t\tres= new " + string2 + "((String) res); \n");
        }
        stringBuffer.append("\t\t} \n");
        return stringBuffer.append("\t\treturn ((" + string2 + ") res)." + string + "Value(); \n").toString();
    }

    static String createListOfClassNames(Class[] classArray, int n) {
        if (classArray == null || classArray.length == 0) {
            if (n == 1) {
                return "()";
            }
            if (n == 2) {
                return null;
            }
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 1) {
            stringBuffer.append("(");
        } else if (n == 2) {
            stringBuffer.append("throws ");
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(ClassAdapter.getEditedClassName(classArray[i]));
        }
        if (n == 1) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    static String[] createThrowsClause(Class[] classArray) {
        String string = ClassAdapter.createListOfClassNames(classArray, 2);
        if (string == null) {
            return new String[]{"", ""};
        }
        return new String[]{string, string};
    }

    static String getEditedClassName(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        Class<?> clazz2 = clazz;
        int n = 0;
        while (clazz2.isArray()) {
            ++n;
            clazz2 = clazz2.getComponentType();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(clazz2.getName());
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("[]");
        }
        return stringBuffer.toString();
    }

    static boolean writeToFile(String string, String string2) throws BSFException {
        if (!bSaveToFilesystem) {
            return false;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(pathToSaveTo + fileSeparator + string);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BSFException(500, exception.toString(), exception);
        }
        return true;
    }

    public static String formatDateTime() {
        if (bFileNameWithDateOnly) {
            return sdf_d.format(new Date());
        }
        return sdf_dt.format(new Date());
    }

    public static String formatDateTime(Date date) {
        if (bFileNameWithDateOnly) {
            return sdf_d.format(date);
        }
        return sdf_dt.format(date);
    }

    public static String calcCRC32(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes();
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        return Long.toHexString(cRC32.getValue()).toUpperCase();
    }

    static String createFileName(String string, String string2, String string3, String string4, String string5, String string6) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bFileNameWithSimpleName) {
            stringBuffer.append(string).append("_");
        }
        stringBuffer.append(string2).append("_").append(extensionIndicator).append("_").append(string6);
        if (bFileNameWithDateTime) {
            stringBuffer.append("_").append(ClassAdapter.formatDateTime());
        }
        stringBuffer.append(".java");
        String string7 = stringBuffer.toString();
        return string7;
    }

    static class RunInfos {
        HashMap<String, HashSet<String>> uMN2setOfSignatures = new HashMap();
        HashMap<Class<?>, Method[]> clz2declMethods = new HashMap();
        HashMap<String, Class<?>> uCN2clz = new HashMap();

        RunInfos() {
        }
    }
}

