/*
 * Decompiled with CFR 0.152.
 */
package org.rexxla.bsf.engines.rexx;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Set;
import org.rexxla.bsf.engines.rexx.RexxAndJava;

public class RexxAnalyzeRegistry {
    static final String constBeanName = "!{beanname}!";
    public static final String version = "100.20220802";
    private static AnalyzedCategory analyzedData = null;

    private RexxAnalyzeRegistry() {
    }

    public static AnalyzedCategory getAnalyzedData() {
        RexxAnalyzeRegistry.updateAnalyzeData();
        return analyzedData;
    }

    public static String getAnalyzedDataAsString() {
        RexxAnalyzeRegistry.updateAnalyzeData();
        return analyzedData.toString();
    }

    public static void updateAnalyzeData() {
        Map<String, RexxAndJava.RAJBean> map = RexxAndJava.getRajRegistry();
        Map<String, ArrayList<RexxAndJava.RAJBean>> map2 = RexxAnalyzeRegistry.categorizeData(map);
        analyzedData = new AnalyzedCategory(map2, map.size());
    }

    static Map<String, ArrayList<RexxAndJava.RAJBean>> categorizeData(Map<String, RexxAndJava.RAJBean> map) {
        HashMap<String, ArrayList<RexxAndJava.RAJBean>> hashMap = new HashMap<String, ArrayList<RexxAndJava.RAJBean>>();
        Set<String> set = map.keySet();
        try {
            String[] stringArray;
            String[] stringArray2 = stringArray = set.toArray(new String[set.size()]);
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string;
                String string2 = string = stringArray2[i];
                if (string == null) continue;
                RexxAndJava.RAJBean rAJBean = map.get(string);
                int n2 = string.indexOf("@");
                string2 = n2 > 0 ? string.substring(0, n2) : constBeanName;
                ArrayList<Object> arrayList = null;
                if (hashMap.containsKey(string2)) {
                    arrayList = hashMap.get(string2);
                } else {
                    arrayList = new ArrayList();
                    hashMap.put(string2, arrayList);
                }
                arrayList.add(rAJBean);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(-1);
        }
        return hashMap;
    }

    static long calcSize(Object object) {
        long l = 0L;
        if (object != null) {
            Class<?> clazz;
            Class<?> clazz2 = clazz = object.getClass();
            int n = 0;
            if (clazz.isArray()) {
                n = 1;
                clazz2 = clazz.getComponentType();
                while (clazz2.isArray()) {
                    ++n;
                    clazz2 = clazz2.getComponentType();
                }
            }
            if (clazz2.isPrimitive()) {
                if (clazz2 == Boolean.TYPE || clazz2 == Byte.TYPE) {
                    l = 1L;
                } else if (clazz2 == Character.TYPE || clazz2 == Short.TYPE) {
                    l = 2L;
                } else if (clazz2 == Integer.TYPE || clazz2 == Float.TYPE) {
                    l = 4L;
                } else if (clazz2 == Long.TYPE || clazz2 == Double.TYPE) {
                    l = 8L;
                }
            } else if (clazz2 == Boolean.class || clazz2 == Byte.class) {
                l = 1L;
            } else if (clazz2 == Character.class || clazz2 == Short.class) {
                l = 2L;
            } else if (clazz2 == Integer.class || clazz2 == Float.class) {
                l = 4L;
            } else if (clazz2 == Long.class || clazz2 == Double.class) {
                l = 8L;
            }
            if (l > 0L || clazz2 == String.class || n > 0) {
                if (n > 0) {
                    int[] nArray = new int[n];
                    long l2 = 0L;
                    Object object2 = object;
                    for (int i = 0; i < n; ++i) {
                        nArray[i] = Array.getLength(object2);
                        long l3 = l2 = i == 0 ? (long)nArray[0] : l2 * (long)nArray[i];
                        if (nArray[i] == 0) break;
                        object2 = Array.get(object2, 0);
                    }
                    if (l > 0L) {
                        l *= l2;
                    } else {
                        int[] nArray2 = new int[n];
                        while (nArray2[0] < nArray[0]) {
                            Object object3 = object;
                            int n2 = n - 1;
                            int n3 = 0;
                            while (n3 < n2) {
                                object3 = Array.get(object3, nArray2[n3++]);
                            }
                            for (n3 = 0; n3 < nArray[n2]; ++n3) {
                                Object object4 = Array.get(object3, n3);
                                if (object4 == null || !(object4 instanceof String)) continue;
                                l += (long)((String)object4).getBytes().length;
                            }
                            n3 = n - 2;
                            if (n3 >= 0) {
                                nArray2[n3] = nArray2[n3] + 1;
                                if (nArray2[n3] >= nArray[n3]) {
                                    for (int i = n3 - 1; i >= 0; --i) {
                                        nArray2[i] = nArray2[i] + 1;
                                        if (nArray2[i] >= nArray[i]) continue;
                                        for (int j = i + 1; j < n; ++j) {
                                            nArray2[j] = 0;
                                        }
                                        break;
                                    }
                                }
                            }
                            if (n != 1) continue;
                            break;
                        }
                    }
                } else if (clazz2 == String.class) {
                    l = ((String)object).getBytes().length;
                }
            }
        }
        return l;
    }

    static String getAllCurrentThreadsAsStrings() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Currently running Java threads:\n\n");
        Set<Thread> set = Thread.getAllStackTraces().keySet();
        stringBuilder.append(String.format("%-15s \t %-15s \t %-15s \t %s\n", "Name", "State", "Priority", "isDaemon"));
        for (Thread thread : set) {
            stringBuilder.append(String.format("%-15s \t %-15s \t %-15d \t %s\n", new Object[]{thread.getName(), thread.getState(), thread.getPriority(), thread.isDaemon()}));
        }
        return stringBuilder.toString();
    }

    protected static class AnalyzedCategory {
        static final String strFormatTimeHeader = "RexxAnalyzeRegistry [%1$tY-%1$tm-%1$td %1$tT.%1$tN]%n";
        static final String strFormatCategoryHeader = "RexxAnalyzeRegistry category=[%s]%n";
        static final String strFormatRefCount = "                    - RefCount: entries=[%,7d] | references: min=[%,9d] max=[%,9d] avg=[%,9.1f] sum=[%,9d]%n";
        static final String strFormatMemSize = "                    - MemSize:  entries=[%,7d] | references: min=[%,9d] max=[%,9d] avg=[%,9.1f] sum=[%,9d]%n";
        static final String strFormatBeanName = "%-17s: refCount=[%,3d] memSize=[%,5d] getClass()=[%15s] toString()=[%s]";
        static final String strFormatClassObjectName = "%-45s: refCount=[%,5d] getName()=[%s]";
        static final int hintLength = 40;
        String strNrRegistryEntries = null;
        String strTimeHeader;
        String[] rawBeanNames = null;
        String strBeanNameWithInfos;
        String[] strClassObjectsWithInfos = null;
        String[] category;
        int[] refCount;
        long[] refMemSize;
        String[] strRefCountSummary;
        String[] strMemSizeSummary;

        public String getStrNrRegistryEntries() {
            return this.strNrRegistryEntries;
        }

        public String getStrTimeHeader() {
            return this.strTimeHeader;
        }

        public String[] getRawBeanNames() {
            return this.rawBeanNames;
        }

        public String getStrBeanNameWithInfos() {
            return this.strBeanNameWithInfos;
        }

        public String[] getCategory() {
            return this.category;
        }

        public int[] getRefCount() {
            return this.refCount;
        }

        public long[] getRefMemSize() {
            return this.refMemSize;
        }

        public String[] getStrRefCountSummary() {
            return this.strRefCountSummary;
        }

        public String[] getStrMemSizeSummary() {
            return this.strMemSizeSummary;
        }

        private AnalyzedCategory() {
        }

        AnalyzedCategory(Map<String, ArrayList<RexxAndJava.RAJBean>> map, int n) {
            this.strTimeHeader = String.format(strFormatTimeHeader, Calendar.getInstance());
            this.strNrRegistryEntries = String.format("RexxAnalyzeRegistry: number of entries in registry: %d\n", n);
            int n2 = map.size();
            this.category = new String[n2];
            this.refCount = new int[n2];
            this.strRefCountSummary = new String[n2];
            this.refMemSize = new long[n2];
            this.strMemSizeSummary = new String[n2];
            Set<String> set = map.keySet();
            Object[] objectArray = set.toArray(new String[set.size()]);
            Arrays.sort(objectArray);
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n3 = 0;
            for (Object object : objectArray) {
                Object object2;
                Object object3;
                String string3;
                bl2 = false;
                bl = ((String)object).equals(RexxAnalyzeRegistry.constBeanName);
                this.category[n3] = string3 = String.format(strFormatCategoryHeader, object);
                ArrayList<RexxAndJava.RAJBean> arrayList2 = map.get(object);
                int n4 = arrayList2.size();
                if (bl) {
                    this.rawBeanNames = new String[n4];
                }
                int[] nArray = new int[n4];
                long[] lArray = new long[n4];
                for (int i = 0; i < n4; ++i) {
                    String string4;
                    object3 = arrayList2.get(i);
                    int n5 = ((RexxAndJava.RAJBean)object3).refCount;
                    int n6 = n3;
                    this.refCount[n6] = this.refCount[n6] + n5;
                    nArray[i] = n5;
                    object2 = ((RexxAndJava.RAJBean)object3).javaObject;
                    long l = RexxAnalyzeRegistry.calcSize(object2);
                    if (bl) {
                        string4 = object2.toString();
                        if (string4.length() > 40) {
                            string4 = string4.substring(0, 40) + "...";
                        }
                        this.rawBeanNames[i] = String.format(strFormatBeanName, '\"' + ((RexxAndJava.RAJBean)object3).name + '\"', n5, l, object2.getClass().getName(), string4);
                    } else if (object2 instanceof Class) {
                        bl2 = true;
                        String string5 = string4 = ((Class)object2).getName();
                        if (string4.length() > 40) {
                            string5 = string4.substring(0, 40) + "...";
                        }
                        String string6 = String.format(strFormatClassObjectName, '\"' + string5 + '\"', n5, string4);
                        arrayList.add(string6);
                    }
                    int n7 = n3;
                    this.refMemSize[n7] = this.refMemSize[n7] + l;
                    lArray[i] = l;
                }
                IntSummaryStatistics intSummaryStatistics = Arrays.stream(nArray).summaryStatistics();
                this.strRefCountSummary[n3] = object3 = String.format(strFormatRefCount, intSummaryStatistics.getCount(), intSummaryStatistics.getMin(), intSummaryStatistics.getMax(), intSummaryStatistics.getAverage(), intSummaryStatistics.getSum());
                LongSummaryStatistics longSummaryStatistics = Arrays.stream(lArray).summaryStatistics();
                this.strMemSizeSummary[n3] = longSummaryStatistics.getSum() == 0L ? "" : (object2 = String.format(strFormatMemSize, longSummaryStatistics.getCount(), longSummaryStatistics.getMin(), longSummaryStatistics.getMax(), longSummaryStatistics.getAverage(), longSummaryStatistics.getSum()));
                if (bl) {
                    Arrays.sort(this.rawBeanNames, (string, string2) -> string.compareToIgnoreCase((String)string2));
                    this.strBeanNameWithInfos = Arrays.toString(this.rawBeanNames);
                } else if (bl2) {
                    this.strClassObjectsWithInfos = arrayList.toArray(new String[arrayList.size()]);
                    Arrays.sort(this.strClassObjectsWithInfos, (string, string2) -> string.compareToIgnoreCase((String)string2));
                }
                ++n3;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            char c = '\n';
            stringBuilder.append(this.strNrRegistryEntries).append(c).append(this.strTimeHeader).append(c);
            for (int i = 0; i < this.category.length; ++i) {
                int n;
                String string;
                int n2;
                int n3;
                stringBuilder.append(this.category[i]).append(this.strRefCountSummary[i]).append(this.strMemSizeSummary[i]);
                if (this.category[i].indexOf(RexxAnalyzeRegistry.constBeanName) > 0) {
                    n3 = this.rawBeanNames.length;
                    n2 = ("" + n3).length();
                    string = "\t... %" + n2 + "d/%" + n2 + "d: %s %n";
                    stringBuilder.append("\n\t... [" + n3 + "] bean names defined explicitly by programmers:\n").append(c);
                    n = 0;
                    for (String string2 : this.rawBeanNames) {
                        stringBuilder.append(String.format(string, ++n, n3, string2));
                    }
                } else if (this.category[i].indexOf("[java.lang.Class]") > 0) {
                    n3 = this.strClassObjectsWithInfos.length;
                    n2 = ("" + n3).length();
                    string = "\t... %" + n2 + "d/%" + n2 + "d: %s %n";
                    stringBuilder.append("\n\t... [" + n3 + "] \"java.lang.Class\" objects:\n").append(c);
                    n = 0;
                    for (String string2 : this.strClassObjectsWithInfos) {
                        stringBuilder.append(String.format(string, ++n, n3, string2));
                    }
                }
                stringBuilder.append(c);
            }
            stringBuilder.append(RexxAnalyzeRegistry.getAllCurrentThreadsAsStrings());
            stringBuilder.append(c);
            return stringBuilder.toString();
        }
    }
}

