/*
 * Decompiled with CFR 0.152.
 */
package org.rexxla.bsf.engines.rexx;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.rexxla.bsf.engines.rexx.RexxEngine;
import org.rexxla.bsf.engines.rexx.RexxScriptEngine;

public class RexxScriptEngineFactory
implements ScriptEngineFactory {
    private static final boolean bDebug = false;
    public static final RexxScriptEngineFactory DEFAULT_REXX_SCRIPT_ENGINE_FACTORY = new RexxScriptEngineFactory();
    protected static final String ENGINE_NAME = "Open Object Rexx (ooRexx)";
    protected static final String ENGINE_VERSION = "101.20250827";
    protected static final List<String> EXTENSIONS = Arrays.asList("rex", "rexx", "orx", "cls", "rxj", "rexxj", "jrexx", "rxo");
    protected static final String LANGUAGE_NAME = "ooRexx";
    protected static String LANGUAGE_VERSION = null;
    protected static final String SHORT_NAME = "rexx";
    protected static final List<String> MIME_TYPES = Arrays.asList("text/rexx", "text/oorexx", "application/rexx", "application/oorexx", "text/x-rexx", "text/x-rexx-java", "text/x-rexx-java-ooo");
    protected static final List<String> SCRIPT_ENGINE_SHORT_NAMES = Arrays.asList("rexx", "Rexx", "REXX", "oorexx", "ooRexx", "OOREXX", "orexx", "oRexx", "OREXX");
    protected static final String THREADING = "MULTITHREADED";
    public static boolean bSay4Output = true;

    @Override
    public String getEngineName() {
        return ENGINE_NAME;
    }

    @Override
    public String getEngineVersion() {
        return ENGINE_VERSION;
    }

    @Override
    public List<String> getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getLanguageName() {
        return LANGUAGE_NAME;
    }

    @Override
    public String getLanguageVersion() {
        if (LANGUAGE_VERSION == null) {
            LANGUAGE_VERSION = RexxEngine.getLanguageVersionString();
        }
        return LANGUAGE_VERSION;
    }

    public String getName() {
        return SHORT_NAME;
    }

    @Override
    public String getMethodCallSyntax(String string, String string2, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append('~').append(string2);
        if (stringArray != null && stringArray.length > 0) {
            stringBuilder.append('(');
            for (int i = 0; i < stringArray.length; ++i) {
                String string3;
                if (i > 0) {
                    stringBuilder.append(',');
                }
                if ((string3 = stringArray[i]) == null) {
                    stringBuilder.append(".nil");
                    continue;
                }
                stringBuilder.append(string3);
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    @Override
    public List<String> getMimeTypes() {
        return MIME_TYPES;
    }

    @Override
    public List<String> getNames() {
        return SCRIPT_ENGINE_SHORT_NAMES;
    }

    @Override
    public String getOutputStatement(String string) {
        if (bSay4Output) {
            return "SAY " + RexxScriptEngineFactory.getStringLiteral(string);
        }
        return ".output~charOut(" + RexxScriptEngineFactory.getStringLiteral(string) + ")";
    }

    public static String getStringLiteral(String string) {
        if (string == null) {
            return ".nil";
        }
        if (string.length() == 0) {
            return "\"\"";
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        boolean bl = true;
        boolean bl2 = true;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\r' || c == '\n') {
                if (i == 0) {
                    bl = false;
                    stringBuffer.append('\"');
                } else {
                    stringBuffer.append("\" || \"");
                }
                if (c == '\r') {
                    stringBuffer.append("0d");
                    if (i + 1 < cArray.length && cArray[i + 1] == '\n') {
                        stringBuffer.append("0a");
                        ++i;
                    }
                } else {
                    stringBuffer.append("0a");
                }
                stringBuffer.append("\"x");
                if (i + 1 == cArray.length) {
                    bl2 = false;
                    continue;
                }
                stringBuffer.append(" || \"");
                continue;
            }
            if (bl) {
                stringBuffer.append('\"');
                bl = false;
            }
            if (c == '\"') {
                stringBuffer.append("\"\"");
                continue;
            }
            stringBuffer.append(c);
        }
        if (bl2) {
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }

    @Override
    public Object getParameter(String string) {
        if (string.equals("THREADING")) {
            return THREADING;
        }
        if (string.equals("javax.script.name")) {
            return SHORT_NAME;
        }
        if (string.equals("javax.script.engine")) {
            return ENGINE_NAME;
        }
        if (string.equals("javax.script.engine_version")) {
            return ENGINE_VERSION;
        }
        if (string.equals("javax.script.language")) {
            return LANGUAGE_NAME;
        }
        if (string.equals("javax.script.language_version")) {
            return LANGUAGE_VERSION == null ? this.getLanguageVersion() : LANGUAGE_VERSION;
        }
        return null;
    }

    @Override
    public String getProgram(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.toString();
        string = string.substring(string.lastIndexOf(46));
        stringBuilder.append("/* --> begin of " + string + " --> " + RexxScriptEngineFactory.getGMTFormattedDateAsISO() + " --> */;\n");
        if (stringArray == null) {
            stringBuilder.append("\t/* -- no statements supplied (received \"null\") */;\n");
        } else if (stringArray.length == 0) {
            stringBuilder.append("\t/* -- no statements supplied (received an empty array) */; \n");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) {
                    stringBuilder.append("\t-- 'null' received!;\n");
                    continue;
                }
                stringBuilder.append("\t" + stringArray[i] + ";\n");
            }
        }
        stringBuilder.append("/* <-- end   of " + string + " <-- " + RexxScriptEngineFactory.getGMTFormattedDateAsISO() + " <-- */; \n");
        return stringBuilder.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        RexxScriptEngine rexxScriptEngine = new RexxScriptEngine();
        return rexxScriptEngine;
    }

    public static String getGMTFormattedDateAsISO() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(new Date());
    }
}

