/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.experimental.pbutton.skin;

import eu.hansolo.enzo.experimental.pbutton.PushButton;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;

public class PushButtonSkin
extends SkinBase<PushButton>
implements Skin<PushButton> {
    private static final double MINIMUM_WIDTH = 81.0;
    private static final double MINIMUM_HEIGHT = 43.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double PREFERRED_WIDTH = 81.0;
    private static final double PREFERRED_HEIGHT = 43.0;
    private double aspectRatio = 0.5308641975308642;
    private double width;
    private double height;
    private Pane pane = new Pane();
    private Region frame;
    private Region outerBorder;
    private Region innerBorder;
    private Region body;
    private Text text;

    public PushButtonSkin(PushButton CONTROL) {
        super((Control)CONTROL);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((PushButton)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((PushButton)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((PushButton)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((PushButton)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((PushButton)this.getSkinnable()).getPrefWidth() > 0.0 && ((PushButton)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((PushButton)this.getSkinnable()).setPrefSize(((PushButton)this.getSkinnable()).getPrefWidth(), ((PushButton)this.getSkinnable()).getPrefHeight());
            } else {
                ((PushButton)this.getSkinnable()).setPrefSize(81.0, 43.0);
            }
        }
        if (Double.compare(((PushButton)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((PushButton)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((PushButton)this.getSkinnable()).setMinSize(81.0, 43.0);
        }
        if (Double.compare(((PushButton)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((PushButton)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((PushButton)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
        if (((PushButton)this.getSkinnable()).getPrefWidth() != 81.0 || ((PushButton)this.getSkinnable()).getPrefHeight() != 43.0) {
            this.aspectRatio = ((PushButton)this.getSkinnable()).getPrefHeight() / ((PushButton)this.getSkinnable()).getPrefWidth();
        }
    }

    private void initGraphics() {
        this.frame = new Region();
        this.frame.getStyleClass().setAll((Object[])new String[]{"frame"});
        this.outerBorder = new Region();
        this.outerBorder.getStyleClass().setAll((Object[])new String[]{"outer-border"});
        this.innerBorder = new Region();
        this.innerBorder.getStyleClass().setAll((Object[])new String[]{"inner-border"});
        this.body = new Region();
        this.body.getStyleClass().setAll((Object[])new String[]{"body"});
        this.body.setMouseTransparent(true);
        this.text = new Text("Push");
        this.text.setTextOrigin(VPos.CENTER);
        this.text.setMouseTransparent(true);
        this.text.getStyleClass().setAll((Object[])new String[]{"text"});
        this.pane.getChildren().setAll((Object[])new Node[]{this.frame, this.outerBorder, this.innerBorder, this.body, this.text});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.resize();
    }

    private void registerListeners() {
        ((PushButton)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((PushButton)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((PushButton)this.getSkinnable()).prefWidthProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((PushButton)this.getSkinnable()).prefHeightProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((PushButton)this.getSkinnable()).selectedProperty().addListener(observable -> this.handleControlPropertyChanged("SELECTED"));
        this.innerBorder.setOnMousePressed(observable -> ((PushButton)this.getSkinnable()).setSelected(!((PushButton)this.getSkinnable()).isSelected()));
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("PREF_SIZE".equals(PROPERTY)) {
            this.aspectRatio = ((PushButton)this.getSkinnable()).getPrefHeight() / ((PushButton)this.getSkinnable()).getPrefWidth();
        } else if ("SELECTED".equals(PROPERTY)) {
            this.text.setTranslateY(((PushButton)this.getSkinnable()).isSelected() ? this.height * 0.5 - 1.0 : this.height * 0.5);
        }
    }

    protected double computeMinWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinWidth(Math.max(43.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMinHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinHeight(Math.max(81.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxWidth(Math.min(1024.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxHeight(Math.min(1024.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefHeight = 43.0;
        if (HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, HEIGHT - TOP_INSET - BOTTOM_INSET);
        }
        return super.computePrefWidth(prefHeight, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefWidth = 81.0;
        if (WIDTH != -1.0) {
            prefWidth = Math.max(0.0, WIDTH - LEFT_INSET - RIGHT_INSET);
        }
        return super.computePrefHeight(prefWidth, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    private void resize() {
        this.width = ((PushButton)this.getSkinnable()).getWidth();
        this.height = ((PushButton)this.getSkinnable()).getHeight();
        if (((PushButton)this.getSkinnable()).isKeepAspect()) {
            if (this.aspectRatio * this.width > this.height) {
                this.width = 1.0 / (this.aspectRatio / this.height);
            } else if (1.0 / (this.aspectRatio / this.height) > this.width) {
                this.height = this.aspectRatio * this.width;
            }
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.frame.setPrefSize(this.width, this.height);
            this.outerBorder.setPrefSize(0.9259259259259259 * this.width, 0.8604651162790697 * this.height);
            this.outerBorder.setTranslateX(0.037037037037037035 * this.width);
            this.outerBorder.setTranslateY(0.06976744186046512 * this.height);
            this.innerBorder.setPrefSize(0.8765432098765432 * this.width, 0.7906976744186046 * this.height);
            this.innerBorder.setTranslateX(0.06172839506172839 * this.width);
            this.innerBorder.setTranslateY(0.11627906976744186 * this.height);
            this.body.setPrefSize(0.8518518518518519 * this.width, 0.7441860465116279 * this.height);
            this.body.setTranslateX(0.07407407407407407 * this.width);
            this.body.setTranslateY(0.13953488372093023 * this.height);
            this.text.setTranslateX(0.2716049382716049 * this.width);
            this.text.setTranslateY(this.height * 0.5);
        }
    }
}

