/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.imgsplitflap;

import eu.hansolo.enzo.imgsplitflap.SplitFlap;
import eu.hansolo.enzo.imgsplitflap.SplitFlapBuilder;
import eu.hansolo.enzo.imgsplitflap.SplitFlapImgFactory;
import java.time.LocalDateTime;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.scene.Camera;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.stage.Stage;

public class FlipClock
extends Application {
    private static final String[] WEEK_DAYS = new String[]{"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"};
    private static final String[] MONTHS = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    private SplitFlap dayLeft;
    private SplitFlap dayMid;
    private SplitFlap dayRight;
    private SplitFlap dateLeft;
    private SplitFlap dateRight;
    private SplitFlap monthLeft;
    private SplitFlap monthMid;
    private SplitFlap monthRight;
    private SplitFlap hourLeft;
    private SplitFlap hourRight;
    private SplitFlap minLeft;
    private SplitFlap minRight;
    private SplitFlap secLeft;
    private SplitFlap secRight;
    private int date;
    private int hours;
    private int minutes;
    private int seconds;
    private long lastTimerCall;
    private AnimationTimer timer;

    public void init() {
        this.dayLeft = ((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)SplitFlapBuilder.create().prefWidth(146.0)).prefHeight(250.0)).flipTime(300.0)).selection(SplitFlap.ALPHA)).textColor(Color.WHITESMOKE)).build();
        this.dayMid = ((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)SplitFlapBuilder.create().prefWidth(146.0)).prefHeight(250.0)).flipTime(300.0)).selection(SplitFlap.ALPHA)).textColor(Color.WHITESMOKE)).build();
        this.dayRight = ((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)SplitFlapBuilder.create().prefWidth(146.0)).prefHeight(250.0)).flipTime(300.0)).selection(SplitFlap.ALPHA)).textColor(Color.WHITESMOKE)).build();
        this.dateLeft = ((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)SplitFlapBuilder.create().prefWidth(146.0)).prefHeight(250.0)).flipTime(300.0)).selection(SplitFlap.NUMERIC)).textColor(Color.WHITESMOKE)).build();
        this.dateRight = ((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)SplitFlapBuilder.create().prefWidth(146.0)).prefHeight(250.0)).flipTime(300.0)).selection(SplitFlap.NUMERIC)).textColor(Color.WHITESMOKE)).build();
        this.monthLeft = ((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)SplitFlapBuilder.create().prefWidth(146.0)).prefHeight(250.0)).flipTime(300.0)).selection(SplitFlap.ALPHA)).textColor(Color.WHITESMOKE)).build();
        this.monthMid = ((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)SplitFlapBuilder.create().prefWidth(146.0)).prefHeight(250.0)).flipTime(300.0)).selection(SplitFlap.ALPHA)).textColor(Color.WHITESMOKE)).build();
        this.monthRight = ((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)SplitFlapBuilder.create().prefWidth(146.0)).prefHeight(250.0)).flipTime(300.0)).selection(SplitFlap.ALPHA)).textColor(Color.WHITESMOKE)).build();
        this.hourLeft = ((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)SplitFlapBuilder.create().prefWidth(200.0)).prefHeight(343.0)).flipTime(300.0)).selection(SplitFlap.TIME_0_TO_5)).textColor(Color.WHITESMOKE)).build();
        this.hourRight = ((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)SplitFlapBuilder.create().prefWidth(200.0)).prefHeight(343.0)).flipTime(300.0)).selection(SplitFlap.TIME_0_TO_9)).textColor(Color.WHITESMOKE)).build();
        this.minLeft = ((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)SplitFlapBuilder.create().prefWidth(200.0)).prefHeight(343.0)).flipTime(300.0)).selection(SplitFlap.TIME_0_TO_5)).textColor(Color.WHITESMOKE)).build();
        this.minRight = ((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)SplitFlapBuilder.create().prefWidth(200.0)).prefHeight(343.0)).flipTime(300.0)).selection(SplitFlap.TIME_0_TO_9)).textColor(Color.WHITESMOKE)).build();
        this.secLeft = ((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)SplitFlapBuilder.create().prefWidth(200.0)).prefHeight(343.0)).flipTime(300.0)).selection(SplitFlap.TIME_0_TO_5)).textColor(Color.WHITESMOKE)).build();
        this.secRight = ((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)((SplitFlapBuilder)SplitFlapBuilder.create().prefWidth(200.0)).prefHeight(343.0)).flipTime(300.0)).selection(SplitFlap.TIME_0_TO_9)).textColor(Color.WHITESMOKE)).build();
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > FlipClock.this.lastTimerCall + 500000000L) {
                    String day = WEEK_DAYS[LocalDateTime.now().getDayOfWeek().getValue()];
                    if (day.equals("SAT") || day.equals("SUN")) {
                        if (!FlipClock.this.dayLeft.getTextColor().equals((Object)Color.CRIMSON)) {
                            FlipClock.this.dayLeft.setTextColor(Color.CRIMSON);
                            FlipClock.this.dayMid.setTextColor(Color.CRIMSON);
                            FlipClock.this.dayRight.setTextColor(Color.CRIMSON);
                        }
                    } else if (!FlipClock.this.dayLeft.getText().equals(Color.WHITESMOKE)) {
                        FlipClock.this.dayLeft.setTextColor(Color.WHITESMOKE);
                        FlipClock.this.dayMid.setTextColor(Color.WHITESMOKE);
                        FlipClock.this.dayRight.setTextColor(Color.WHITESMOKE);
                    }
                    FlipClock.this.dayLeft.setText(day.substring(0, 1));
                    FlipClock.this.dayMid.setText(day.substring(1, 2));
                    FlipClock.this.dayRight.setText(day.substring(2));
                    FlipClock.this.date = LocalDateTime.now().getDayOfMonth();
                    String dateString = Integer.toString(FlipClock.this.date);
                    if (FlipClock.this.date < 10) {
                        FlipClock.this.dateLeft.setText("0");
                        FlipClock.this.dateRight.setText(dateString.substring(0, 1));
                    } else {
                        FlipClock.this.dateLeft.setText(dateString.substring(0, 1));
                        FlipClock.this.dateRight.setText(dateString.substring(1));
                    }
                    String month = MONTHS[LocalDateTime.now().getMonthValue() - 1];
                    FlipClock.this.monthLeft.setText(month.substring(0, 1));
                    FlipClock.this.monthMid.setText(month.substring(1, 2));
                    FlipClock.this.monthRight.setText(month.substring(2));
                    FlipClock.this.hours = LocalDateTime.now().getHour();
                    String hourString = Integer.toString(FlipClock.this.hours);
                    if (FlipClock.this.hours < 10) {
                        FlipClock.this.hourLeft.setText("0");
                        FlipClock.this.hourRight.setText(hourString.substring(0, 1));
                    } else {
                        FlipClock.this.hourLeft.setText(hourString.substring(0, 1));
                        FlipClock.this.hourRight.setText(hourString.substring(1));
                    }
                    FlipClock.this.minutes = LocalDateTime.now().getMinute();
                    String minutesString = Integer.toString(FlipClock.this.minutes);
                    if (FlipClock.this.minutes < 10) {
                        FlipClock.this.minLeft.setText("0");
                        FlipClock.this.minRight.setText(minutesString.substring(0, 1));
                    } else {
                        FlipClock.this.minLeft.setText(minutesString.substring(0, 1));
                        FlipClock.this.minRight.setText(minutesString.substring(1));
                    }
                    FlipClock.this.seconds = LocalDateTime.now().getSecond();
                    String secondsString = Integer.toString(FlipClock.this.seconds);
                    if (FlipClock.this.seconds < 10) {
                        FlipClock.this.secLeft.setText("0");
                        FlipClock.this.secRight.setText(secondsString.substring(0, 1));
                    } else {
                        FlipClock.this.secLeft.setText(secondsString.substring(0, 1));
                        FlipClock.this.secRight.setText(secondsString.substring(1));
                    }
                    FlipClock.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) {
        SplitFlapImgFactory.INSTANCE.setFlapColor(Color.web((String)"#FF1200"));
        this.secLeft.setBackgroundImage(SplitFlapImgFactory.INSTANCE.createBackgroundImage(234.0, 402.0));
        this.secLeft.setFlapImage(SplitFlapImgFactory.INSTANCE.createFlapImage(234.0, 402.0));
        this.secRight.setBackgroundImage(SplitFlapImgFactory.INSTANCE.createBackgroundImage(234.0, 402.0));
        this.secRight.setFlapImage(SplitFlapImgFactory.INSTANCE.createFlapImage(234.0, 402.0));
        HBox dayBox = new HBox();
        dayBox.setSpacing(0.0);
        dayBox.getChildren().addAll((Object[])new Node[]{this.dayLeft, this.dayMid, this.dayRight});
        dayBox.setLayoutX(12.0);
        dayBox.setLayoutY(76.0);
        HBox dateBox = new HBox();
        dateBox.setSpacing(0.0);
        dateBox.getChildren().addAll((Object[])new Node[]{this.dateLeft, this.dateRight});
        dateBox.setLayoutX(495.0);
        dateBox.setLayoutY(76.0);
        HBox monthBox = new HBox();
        monthBox.setSpacing(0.0);
        monthBox.getChildren().addAll((Object[])new Node[]{this.monthLeft, this.monthMid, this.monthRight});
        monthBox.setLayoutX(833.0);
        monthBox.setLayoutY(76.0);
        HBox clockBox = new HBox();
        clockBox.setSpacing(0.0);
        HBox.setMargin((Node)this.hourRight, (Insets)new Insets(0.0, 40.0, 0.0, 0.0));
        HBox.setMargin((Node)this.minRight, (Insets)new Insets(0.0, 40.0, 0.0, 0.0));
        clockBox.getChildren().addAll((Object[])new Node[]{this.hourLeft, this.hourRight, this.minLeft, this.minRight, this.secLeft, this.secRight});
        clockBox.setLayoutY(375.0);
        Pane pane = new Pane(new Node[]{dayBox, dateBox, monthBox, clockBox});
        pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        Scene scene = new Scene((Parent)pane, 1280.0, 800.0, (Paint)new LinearGradient(0.0, 0.0, 0.0, 800.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)28, (int)27, (int)22)), new Stop(0.25, Color.rgb((int)38, (int)37, (int)32)), new Stop(1.0, Color.rgb((int)28, (int)27, (int)22))}));
        scene.setCamera((Camera)new PerspectiveCamera());
        stage.setScene(scene);
        stage.show();
        this.timer.start();
    }

    public static void main(String[] args) {
        FlipClock.launch((String[])args);
    }
}

