/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.lcd.skin;

import eu.hansolo.enzo.fonts.Fonts;
import eu.hansolo.enzo.lcd.Alarm;
import eu.hansolo.enzo.lcd.LcdClock;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.util.Random;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class LcdClockSkin
extends SkinBase<LcdClock>
implements Skin<LcdClock> {
    private static final double PREFERRED_WIDTH = 380.0;
    private static final double PREFERRED_HEIGHT = 200.0;
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final Color DARK_NOISE_COLOR = Color.rgb((int)100, (int)100, (int)100, (double)0.1);
    private static final Color BRIGHT_NOISE_COLOR = Color.rgb((int)200, (int)200, (int)200, (double)0.05);
    private static final DropShadow FOREGROUND_SHADOW = new DropShadow();
    private static double aspectRatio = 0.5263157894736842;
    private static Text oneTimeSegment = new Text("8");
    private static Text oneSecondSegment = new Text("8");
    private double width;
    private double height;
    private Pane pane;
    private Region main;
    private ImageView crystalOverlay;
    private Image crystalImage;
    private Rectangle crystalClip;
    private InnerShadow mainInnerShadow0;
    private InnerShadow mainInnerShadow1;
    private Region alarm;
    private Text timeText;
    private Text backgroundTimeText;
    private Text secondText;
    private Text backgroundSecondText;
    private Text title;
    private Text dateText;
    private Text dayOfWeekText;
    private DateTimeFormatter dateFormat;
    private double valueOffsetRight;
    private double digitalFontSizeFactor;
    private Font timeFont;
    private Font secondFont;
    private Font titleFont;
    private Font smallFont;
    private StringBuilder backgroundTextBuilder;
    private Group shadowGroup;

    public LcdClockSkin(LcdClock CONTROL) {
        super((Control)CONTROL);
        aspectRatio = 0.5263157894736842;
        this.valueOffsetRight = 0.0;
        this.digitalFontSizeFactor = 1.0;
        this.backgroundTextBuilder = new StringBuilder();
        FOREGROUND_SHADOW.setOffsetX(0.0);
        FOREGROUND_SHADOW.setOffsetY(1.0);
        FOREGROUND_SHADOW.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.5));
        FOREGROUND_SHADOW.setBlurType(BlurType.TWO_PASS_BOX);
        FOREGROUND_SHADOW.setRadius(2.0);
        this.adjustDateFormat();
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((LcdClock)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((LcdClock)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((LcdClock)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((LcdClock)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((LcdClock)this.getSkinnable()).getPrefWidth() > 0.0 && ((LcdClock)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((LcdClock)this.getSkinnable()).setPrefSize(((LcdClock)this.getSkinnable()).getPrefWidth(), ((LcdClock)this.getSkinnable()).getPrefHeight());
            } else {
                ((LcdClock)this.getSkinnable()).setPrefSize(380.0, 200.0);
            }
        }
        if (Double.compare(((LcdClock)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((LcdClock)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((LcdClock)this.getSkinnable()).setMinSize(5.0, 5.0);
        }
        if (Double.compare(((LcdClock)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((LcdClock)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((LcdClock)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.main = new Region();
        this.main.getStyleClass().setAll((Object[])new String[]{"main"});
        this.main.setOpacity(((LcdClock)this.getSkinnable()).isBackgroundVisible() ? 1.0 : 0.0);
        this.mainInnerShadow0 = new InnerShadow();
        this.mainInnerShadow0.setOffsetX(0.0);
        this.mainInnerShadow0.setOffsetY(0.0);
        this.mainInnerShadow0.setRadius(8.636363636363637);
        this.mainInnerShadow0.setColor(Color.web((String)"0xffffff80"));
        this.mainInnerShadow0.setBlurType(BlurType.TWO_PASS_BOX);
        this.mainInnerShadow1 = new InnerShadow();
        this.mainInnerShadow1.setOffsetX(0.0);
        this.mainInnerShadow1.setOffsetY(1.0);
        this.mainInnerShadow1.setRadius(5.757575757575758);
        this.mainInnerShadow1.setColor(Color.web((String)"0x000000a6"));
        this.mainInnerShadow1.setBlurType(BlurType.TWO_PASS_BOX);
        this.mainInnerShadow1.setInput((Effect)this.mainInnerShadow0);
        this.main.setEffect((Effect)(((LcdClock)this.getSkinnable()).isMainInnerShadowVisible() ? this.mainInnerShadow1 : null));
        this.crystalClip = new Rectangle(0.0, 0.0, 380.0, 200.0);
        this.crystalClip.setArcWidth(5.0);
        this.crystalClip.setArcHeight(5.0);
        this.crystalImage = this.createNoiseImage(380.0, 200.0, DARK_NOISE_COLOR, BRIGHT_NOISE_COLOR, 8.0);
        this.crystalOverlay = new ImageView(this.crystalImage);
        this.crystalOverlay.setClip((Node)this.crystalClip);
        this.crystalOverlay.setOpacity(((LcdClock)this.getSkinnable()).isCrystalOverlayVisible() ? 1.0 : 0.0);
        this.alarm = new Region();
        this.alarm.getStyleClass().setAll((Object[])new String[]{"alarm"});
        this.alarm.setOpacity(((LcdClock)this.getSkinnable()).getAlarms().isEmpty() || this.allAlarmsInactive() ? 0.0 : 1.0);
        this.backgroundTimeText = new Text("");
        this.backgroundTimeText.getStyleClass().setAll((Object[])new String[]{"fg-trsp"});
        this.backgroundTimeText.setOpacity(LcdClock.LcdFont.LCD == ((LcdClock)this.getSkinnable()).getTimeFont() || LcdClock.LcdFont.ELEKTRA == ((LcdClock)this.getSkinnable()).getTimeFont() ? 1.0 : 0.0);
        this.timeText = new Text("");
        this.timeText.getStyleClass().setAll((Object[])new String[]{"fg"});
        this.backgroundSecondText = new Text("");
        this.backgroundSecondText.getStyleClass().setAll((Object[])new String[]{"fg-trsp"});
        this.backgroundSecondText.setOpacity(LcdClock.LcdFont.LCD == ((LcdClock)this.getSkinnable()).getTimeFont() || LcdClock.LcdFont.ELEKTRA == ((LcdClock)this.getSkinnable()).getTimeFont() ? 1.0 : 0.0);
        this.secondText = new Text("");
        this.secondText.getStyleClass().setAll((Object[])new String[]{"fg"});
        this.title = new Text(((LcdClock)this.getSkinnable()).getTitle());
        this.title.getStyleClass().setAll((Object[])new String[]{"fg"});
        this.dateText = new Text(((LcdClock)this.getSkinnable()).getTime().getMonthValue() + "/" + ((LcdClock)this.getSkinnable()).getTime().getDayOfMonth() + "/" + ((LcdClock)this.getSkinnable()).getTime().getYear());
        this.dateText.getStyleClass().setAll((Object[])new String[]{"fg"});
        this.dayOfWeekText = new Text("");
        this.dayOfWeekText.getStyleClass().setAll((Object[])new String[]{"fg"});
        this.shadowGroup = new Group();
        this.shadowGroup.setEffect((Effect)(((LcdClock)this.getSkinnable()).isForegroundShadowVisible() ? FOREGROUND_SHADOW : null));
        this.shadowGroup.getChildren().setAll((Object[])new Node[]{this.alarm, this.timeText, this.secondText, this.title, this.dateText, this.dayOfWeekText});
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.main, this.crystalOverlay, this.backgroundTimeText, this.backgroundSecondText, this.shadowGroup});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.resize();
        this.updateLcd();
    }

    private void registerListeners() {
        ((LcdClock)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((LcdClock)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((LcdClock)this.getSkinnable()).clockProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((LcdClock)this.getSkinnable()).timeProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((LcdClock)this.getSkinnable()).titleProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((LcdClock)this.getSkinnable()).localeProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((LcdClock)this.getSkinnable()).prefWidthProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((LcdClock)this.getSkinnable()).prefHeightProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((LcdClock)this.getSkinnable()).timeFontProperty().addListener(observable -> this.handleControlPropertyChanged("FONT"));
        ((LcdClock)this.getSkinnable()).smallFontProperty().addListener(observable -> this.handleControlPropertyChanged("FONT"));
        ((LcdClock)this.getSkinnable()).backgroundVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("BACKGROUND_VISIBLE"));
        ((LcdClock)this.getSkinnable()).crystalOverlayVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("CRYSTAL_OVERLAY_VISIBLE"));
        ((LcdClock)this.getSkinnable()).mainInnerShadowVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("MAIN_INNER_SHADOW_VISIBLE"));
        ((LcdClock)this.getSkinnable()).foregroundShadowVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("FOREGROUND_SHADOW_VISIBLE"));
        ((LcdClock)this.getSkinnable()).dateFormatProperty().addListener(observable -> this.handleControlPropertyChanged("DATE_FORMAT"));
        ((LcdClock)this.getSkinnable()).dateSeparatorProperty().addListener(observable -> this.handleControlPropertyChanged("DATE_FORMAT"));
        ((LcdClock)this.getSkinnable()).getAlarms().addListener(change -> this.handleControlPropertyChanged("ALARM"));
        ((LcdClock)this.getSkinnable()).getStyleClass().addListener(change -> {
            this.resize();
            this.updateLcd();
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("UPDATE".equals(PROPERTY)) {
            this.updateLcd();
        } else if ("RESIZE".equals(PROPERTY)) {
            this.resize();
            this.updateLcd();
        } else if ("PREF_SIZE".equals(PROPERTY)) {
            aspectRatio = ((LcdClock)this.getSkinnable()).getPrefHeight() / ((LcdClock)this.getSkinnable()).getPrefWidth();
        } else if ("BACKGROUND_VISIBLE".equals(PROPERTY)) {
            this.main.setOpacity(((LcdClock)this.getSkinnable()).isBackgroundVisible() ? 1.0 : 0.0);
            this.crystalOverlay.setOpacity(((LcdClock)this.getSkinnable()).isBackgroundVisible() ? 1.0 : 0.0);
        } else if ("CRYSTAL_OVERLAY_VISIBLE".equals(PROPERTY)) {
            this.crystalOverlay.setOpacity(((LcdClock)this.getSkinnable()).isCrystalOverlayVisible() ? 1.0 : 0.0);
            this.resize();
        } else if ("MAIN_INNER_SHADOW_VISIBLE".equals(PROPERTY)) {
            this.main.setEffect((Effect)(((LcdClock)this.getSkinnable()).isMainInnerShadowVisible() ? this.mainInnerShadow1 : null));
        } else if ("FOREGROUND_SHADOW_VISIBLE".equals(PROPERTY)) {
            this.shadowGroup.setEffect((Effect)(((LcdClock)this.getSkinnable()).isForegroundShadowVisible() ? FOREGROUND_SHADOW : null));
        } else if ("FONT".equals(PROPERTY)) {
            this.updateFonts();
        } else if ("ALARM".equals(PROPERTY)) {
            this.alarm.setOpacity(((LcdClock)this.getSkinnable()).getAlarms().isEmpty() || this.allAlarmsInactive() ? 0.0 : 1.0);
        } else if ("DATE_FORMAT".equals(PROPERTY)) {
            this.adjustDateFormat();
            this.updateLcd();
        }
    }

    private String ensureTwoDigits(int NUMBER) {
        if (NUMBER < 10) {
            return "0" + NUMBER;
        }
        return Integer.toString(NUMBER);
    }

    private void adjustDateFormat() {
        switch (((LcdClock)this.getSkinnable()).getDateFormat()) {
            case DAY_MONTH_YEAR: {
                this.dateFormat = DateTimeFormatter.ofPattern("dd" + ((LcdClock)this.getSkinnable()).getDateSeparator().chr + "MM" + ((LcdClock)this.getSkinnable()).getDateSeparator().chr + "yyyy");
                break;
            }
            default: {
                this.dateFormat = DateTimeFormatter.ofPattern("yyyy" + ((LcdClock)this.getSkinnable()).getDateSeparator().chr + "MM" + ((LcdClock)this.getSkinnable()).getDateSeparator().chr + "dd");
            }
        }
    }

    private boolean allAlarmsInactive() {
        boolean allAlarmsInactive = true;
        for (Alarm alarm : ((LcdClock)this.getSkinnable()).getAlarms()) {
            if (!alarm.isArmed()) continue;
            allAlarmsInactive = false;
            break;
        }
        return allAlarmsInactive;
    }

    private Image createNoiseImage(double WIDTH, double HEIGHT, Color DARK_COLOR, Color BRIGHT_COLOR, double ALPHA_VARIATION_IN_PERCENT) {
        int width = WIDTH <= 0.0 ? 380 : (int)WIDTH;
        int height = HEIGHT <= 0.0 ? 200 : (int)HEIGHT;
        LcdClock cfr_ignored_0 = (LcdClock)this.getSkinnable();
        double alphaVariationInPercent = LcdClock.clamp(0.0, 100.0, ALPHA_VARIATION_IN_PERCENT);
        WritableImage IMAGE = new WritableImage(width, height);
        PixelWriter PIXEL_WRITER = IMAGE.getPixelWriter();
        Random BW_RND = new Random();
        Random ALPHA_RND = new Random();
        double ALPHA_START = alphaVariationInPercent / 100.0 / 2.0;
        double ALPHA_VARIATION = alphaVariationInPercent / 100.0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color NOISE_COLOR = BW_RND.nextBoolean() ? BRIGHT_COLOR : DARK_COLOR;
                LcdClock cfr_ignored_1 = (LcdClock)this.getSkinnable();
                double NOISE_ALPHA = LcdClock.clamp(0.0, 1.0, ALPHA_START + ALPHA_RND.nextDouble() * ALPHA_VARIATION);
                PIXEL_WRITER.setColor(x, y, Color.color((double)NOISE_COLOR.getRed(), (double)NOISE_COLOR.getGreen(), (double)NOISE_COLOR.getBlue(), (double)NOISE_ALPHA));
            }
        }
        return IMAGE;
    }

    private void updateFonts() {
        this.digitalFontSizeFactor = 1.0;
        switch (((LcdClock)this.getSkinnable()).getTimeFont()) {
            case LCD: {
                this.digitalFontSizeFactor = 1.05;
                this.timeFont = Fonts.digital(0.7 * this.height);
                this.secondFont = Fonts.digital(0.2 * this.height);
                break;
            }
            case DIGITAL: {
                this.digitalFontSizeFactor = 0.7;
                this.timeFont = Fonts.digitalReadout(0.7 * this.height);
                this.secondFont = Fonts.digitalReadout(0.2 * this.height);
                break;
            }
            case DIGITAL_BOLD: {
                this.digitalFontSizeFactor = 0.7;
                this.timeFont = Fonts.digitalReadoutBold(0.7 * this.height);
                this.secondFont = Fonts.digitalReadoutBold(0.2 * this.height);
                break;
            }
            case ELEKTRA: {
                this.digitalFontSizeFactor = 0.8;
                this.timeFont = Fonts.elektra(0.7 * this.height);
                this.secondFont = Fonts.elektra(0.186 * this.height);
                break;
            }
            default: {
                this.digitalFontSizeFactor = 0.7;
                this.timeFont = Fonts.robotoMedium(0.6 * this.height);
                this.secondFont = Fonts.robotoMedium(0.2 * this.height);
            }
        }
        this.backgroundTimeText.setFont(this.timeFont);
        this.backgroundTimeText.setOpacity(LcdClock.LcdFont.LCD == ((LcdClock)this.getSkinnable()).getTimeFont() || LcdClock.LcdFont.DIGITAL == ((LcdClock)this.getSkinnable()).getTimeFont() || LcdClock.LcdFont.DIGITAL_BOLD == ((LcdClock)this.getSkinnable()).getTimeFont() || LcdClock.LcdFont.ELEKTRA == ((LcdClock)this.getSkinnable()).getTimeFont() ? 1.0 : 0.0);
        this.backgroundSecondText.setFont(this.secondFont);
        this.backgroundSecondText.setOpacity(LcdClock.LcdFont.LCD == ((LcdClock)this.getSkinnable()).getTimeFont() || LcdClock.LcdFont.DIGITAL == ((LcdClock)this.getSkinnable()).getTimeFont() || LcdClock.LcdFont.DIGITAL_BOLD == ((LcdClock)this.getSkinnable()).getTimeFont() || LcdClock.LcdFont.ELEKTRA == ((LcdClock)this.getSkinnable()).getTimeFont() ? 1.0 : 0.0);
        this.timeText.setFont(this.timeFont);
        this.titleFont = Font.font((String)((LcdClock)this.getSkinnable()).getTitleFont(), (FontWeight)FontWeight.NORMAL, (double)(0.15 * this.height));
        this.smallFont = Font.font((String)((LcdClock)this.getSkinnable()).getSmallFont(), (FontWeight)FontWeight.LIGHT, (double)(0.12 * this.height));
    }

    private void updateBackgroundText() {
        this.backgroundTimeText.setTextOrigin(VPos.BASELINE);
        this.backgroundTimeText.setTextAlignment(TextAlignment.RIGHT);
        this.backgroundSecondText.setTextOrigin(VPos.BASELINE);
        this.backgroundSecondText.setTextAlignment(TextAlignment.RIGHT);
        oneTimeSegment.setFont(this.timeFont);
        if (LcdClock.LcdFont.LCD == ((LcdClock)this.getSkinnable()).getTimeFont()) {
            oneTimeSegment.setText("8");
        } else if (LcdClock.LcdFont.DIGITAL == ((LcdClock)this.getSkinnable()).getTimeFont()) {
            oneTimeSegment.setText("_");
        } else if (LcdClock.LcdFont.DIGITAL_BOLD == ((LcdClock)this.getSkinnable()).getTimeFont()) {
            oneTimeSegment.setText("_");
        } else if (LcdClock.LcdFont.ELEKTRA == ((LcdClock)this.getSkinnable()).getTimeFont()) {
            oneTimeSegment.setText("_");
        }
        oneSecondSegment.setFont(this.secondFont);
        if (LcdClock.LcdFont.LCD == ((LcdClock)this.getSkinnable()).getTimeFont()) {
            oneSecondSegment.setText("8");
        } else if (LcdClock.LcdFont.DIGITAL == ((LcdClock)this.getSkinnable()).getTimeFont()) {
            oneSecondSegment.setText("_");
        } else if (LcdClock.LcdFont.DIGITAL_BOLD == ((LcdClock)this.getSkinnable()).getTimeFont()) {
            oneSecondSegment.setText("_");
        } else if (LcdClock.LcdFont.ELEKTRA == ((LcdClock)this.getSkinnable()).getTimeFont()) {
            oneSecondSegment.setText("_");
        }
        this.backgroundTextBuilder.setLength(0);
        this.backgroundTextBuilder.append(oneTimeSegment.getText());
        this.backgroundTextBuilder.append(oneTimeSegment.getText());
        this.backgroundTextBuilder.append(":");
        this.backgroundTextBuilder.append(oneTimeSegment.getText());
        this.backgroundTextBuilder.append(oneTimeSegment.getText());
        this.backgroundTimeText.setText(this.backgroundTextBuilder.toString());
        this.backgroundSecondText.setText("88");
    }

    private void updateLcd() {
        this.timeText.setText(this.ensureTwoDigits(((LcdClock)this.getSkinnable()).getTime().getHour()) + ":" + this.ensureTwoDigits(((LcdClock)this.getSkinnable()).getTime().getMinute()));
        this.secondText.setText(this.ensureTwoDigits(((LcdClock)this.getSkinnable()).getTime().getSecond()));
        this.updateBackgroundText();
        this.backgroundTimeText.setX(this.width - 2.0 - this.backgroundTimeText.getLayoutBounds().getWidth() - this.valueOffsetRight);
        this.backgroundTimeText.setY(this.height - this.backgroundTimeText.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
        this.timeText.setX(this.width - 2.0 - this.timeText.getLayoutBounds().getWidth() - this.valueOffsetRight);
        this.title.setText(((LcdClock)this.getSkinnable()).getTitle());
        this.title.setX((this.width - this.title.getLayoutBounds().getWidth()) * 0.5);
        this.dayOfWeekText.setText(((LcdClock)this.getSkinnable()).getTime().getDayOfWeek().getDisplayName(TextStyle.FULL_STANDALONE, ((LcdClock)this.getSkinnable()).getLocale()));
        this.dayOfWeekText.setX(0.0416666667 * this.height);
        this.dateText.setText(this.dateFormat.format(((LcdClock)this.getSkinnable()).getTime()));
        this.dateText.setX(this.width - this.dateText.getLayoutBounds().getWidth() - 0.0416666667 * this.height);
        this.dateText.setY(this.main.getLayoutY() + this.height - 3.0 - 0.0416666667 * this.height);
    }

    private void resize() {
        this.width = ((LcdClock)this.getSkinnable()).getWidth();
        this.height = ((LcdClock)this.getSkinnable()).getHeight();
        if (((LcdClock)this.getSkinnable()).isKeepAspect()) {
            if (aspectRatio * this.width > this.height) {
                this.width = 1.0 / (aspectRatio / this.height);
            } else if (1.0 / (aspectRatio / this.height) > this.width) {
                this.height = aspectRatio * this.width;
            }
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.main.setPrefSize(this.width, this.height);
            this.mainInnerShadow0.setRadius(0.022727272727272728 * this.height);
            this.mainInnerShadow1.setRadius(0.015151515151515152 * this.height);
            if (this.crystalOverlay.isVisible()) {
                this.crystalClip.setWidth(this.width);
                this.crystalClip.setHeight(this.height);
                this.crystalOverlay.setImage(this.createNoiseImage(this.width, this.height, DARK_NOISE_COLOR, BRIGHT_NOISE_COLOR, 8.0));
                this.crystalOverlay.setCache(true);
            }
            this.alarm.setPrefSize(0.15 * this.height, 0.15 * this.height);
            this.alarm.setTranslateX(this.width - this.alarm.getPrefWidth() - this.height * 0.05);
            this.alarm.setTranslateY(this.height * 0.42 - this.alarm.getPrefHeight());
            this.updateFonts();
            this.secondText.setFont(this.secondFont);
            this.secondText.setTextOrigin(VPos.BASELINE);
            this.secondText.setTextAlignment(TextAlignment.RIGHT);
            this.secondText.setX(this.width - this.secondText.getLayoutBounds().getWidth() - this.height * 0.04);
            this.secondText.setY(this.height - this.timeText.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
            this.valueOffsetRight = this.secondText.getLayoutBounds().getWidth() + this.height * 0.0833333333;
            this.timeText.setX(this.width - 2.0 - this.timeText.getLayoutBounds().getWidth() - this.valueOffsetRight);
            this.timeText.setY(this.height - this.timeText.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
            this.updateBackgroundText();
            this.backgroundTimeText.setX(this.width - 2.0 - this.backgroundTimeText.getLayoutBounds().getWidth() - this.valueOffsetRight);
            this.backgroundTimeText.setY(this.height - this.backgroundTimeText.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
            this.backgroundSecondText.setX(this.width - this.secondText.getLayoutBounds().getWidth() - this.height * 0.04);
            this.backgroundSecondText.setY(this.height - this.timeText.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
            this.title.setFont(this.titleFont);
            this.title.setTextOrigin(VPos.BASELINE);
            this.title.setTextAlignment(TextAlignment.CENTER);
            this.title.setText(((LcdClock)this.getSkinnable()).getTime().getDayOfWeek().name());
            this.title.setX((this.width - this.title.getLayoutBounds().getWidth()) * 0.5);
            this.title.setY(this.main.getLayoutY() + this.title.getLayoutBounds().getHeight() - 0.04 * this.height + 2.0);
            this.dateText.setFont(this.smallFont);
            this.dateText.setTextOrigin(VPos.BASELINE);
            this.dateText.setTextAlignment(TextAlignment.RIGHT);
            this.dateText.setText(((LcdClock)this.getSkinnable()).getTime().getMonthValue() + "/" + ((LcdClock)this.getSkinnable()).getTime().getDayOfMonth() + "/" + ((LcdClock)this.getSkinnable()).getTime().getYear());
            this.dateText.setX(this.main.getLayoutX() + (this.width - this.dateText.getLayoutBounds().getWidth()) * 0.5);
            this.dateText.setY(this.main.getLayoutY() + this.height - 3.0 - 0.0416666667 * this.height);
            this.dayOfWeekText.setFont(this.smallFont);
            this.dayOfWeekText.setTextOrigin(VPos.BASELINE);
            this.dayOfWeekText.setTextAlignment(TextAlignment.LEFT);
            this.dayOfWeekText.setX(0.0416666667 * this.height);
            this.dayOfWeekText.setY(this.main.getLayoutY() + this.height - 3.0 - 0.0416666667 * this.height);
        }
    }
}

