/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.led;

import eu.hansolo.enzo.led.Led;
import eu.hansolo.enzo.led.LedBuilder;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class Demo1
extends Application {
    private static int noOfNodes = 0;
    private Led led;
    private boolean toggle;
    private long lastTimerCall;
    private AnimationTimer timer;

    public void init() {
        this.led = ((LedBuilder)((LedBuilder)LedBuilder.create().ledType(Led.LedType.ROUND).ledColor(Color.MAGENTA).prefWidth(64.0)).prefHeight(64.0)).build();
        this.toggle = false;
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > Demo1.this.lastTimerCall + 500000000L) {
                    Demo1.this.toggle = Demo1.this.toggle ^ true;
                    Demo1.this.led.setOn(Demo1.this.toggle);
                    Demo1.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane();
        pane.getChildren().addAll((Object[])new Node[]{this.led});
        Scene scene = new Scene((Parent)pane, 128.0, 128.0);
        stage.setScene(scene);
        stage.show();
        this.timer.start();
        Demo1.calcNoOfNodes((Node)scene.getRoot());
        System.out.println(noOfNodes + " Nodes in SceneGraph");
    }

    public void stop() {
        System.exit(0);
    }

    public static void main(String[] args) {
        Demo1.launch((String[])args);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                Demo1.calcNoOfNodes(n);
            }
        }
    }
}

