/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.qlocktwo;

import eu.hansolo.enzo.qlocktwo.Qlock;
import eu.hansolo.enzo.qlocktwo.QlockTwo;
import eu.hansolo.enzo.qlocktwo.QlockWord;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class QlockFrench
implements Qlock {
    private static final QlockTwo.Language LANGUAGE = QlockTwo.Language.FRENCH;
    private static final String[][] MATRIX = new String[][]{{"I", "L", "N", "E", "S", "T", "O", "D", "E", "U", "X"}, {"Q", "U", "A", "T", "R", "E", "T", "R", "O", "I", "S"}, {"N", "E", "U", "F", "U", "N", "E", "S", "E", "P", "T"}, {"H", "U", "I", "T", "S", "I", "X", "C", "I", "N", "Q"}, {"M", "I", "D", "I", "X", "M", "I", "N", "U", "I", "T"}, {"O", "N", "Z", "E", "R", "H", "E", "U", "R", "E", "S"}, {"M", "O", "I", "N", "S", "O", "L", "E", "D", "I", "X"}, {"E", "T", "R", "Q", "U", "A", "R", "T", "P", "M", "D"}, {"V", "I", "N", "G", "T", "-", "C", "I", "N", "Q", "U"}, {"E", "T", "S", "D", "E", "M", "I", "E", "P", "A", "M"}};
    private final ConcurrentHashMap<Integer, String> LOOKUP = new ConcurrentHashMap();
    private List<QlockWord> timeList;

    public QlockFrench() {
        this.LOOKUP.putAll(QlockTwo.Language.FRENCH.getLookup());
        this.timeList = new ArrayList<QlockWord>(10);
    }

    @Override
    public String[][] getMatrix() {
        return MATRIX;
    }

    @Override
    public List<QlockWord> getTime(int minute, int hour) {
        if (hour > 12) {
            hour -= 12;
        }
        if (hour <= 0) {
            hour += 12;
        }
        if (minute > 60) {
            minute -= 60;
            ++hour;
        }
        if (minute < 0) {
            minute += 60;
            --hour;
        }
        minute -= minute % 5;
        this.timeList.clear();
        this.timeList.add(QlockLanguage.IL);
        this.timeList.add(QlockLanguage.EST);
        switch (minute) {
            case 0: {
                if (hour == 12) {
                    this.timeList.add(QlockLanguage.MIDI);
                    break;
                }
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                this.timeList.add(hour == 1 ? QlockLanguage.HEURE : QlockLanguage.HEURES);
                break;
            }
            case 5: {
                if (hour == 12) {
                    this.timeList.add(QlockLanguage.MIDI);
                } else {
                    this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                    this.timeList.add(hour == 1 ? QlockLanguage.HEURE : QlockLanguage.HEURES);
                }
                this.timeList.add(QlockLanguage.CINQ1);
                break;
            }
            case 10: {
                if (hour == 12) {
                    this.timeList.add(QlockLanguage.MIDI);
                } else {
                    this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                    this.timeList.add(hour == 1 ? QlockLanguage.HEURE : QlockLanguage.HEURES);
                }
                this.timeList.add(QlockLanguage.DIX1);
                break;
            }
            case 15: {
                if (hour == 12) {
                    this.timeList.add(QlockLanguage.MIDI);
                } else {
                    this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                    this.timeList.add(hour == 1 ? QlockLanguage.HEURE : QlockLanguage.HEURES);
                }
                this.timeList.add(QlockLanguage.ET);
                this.timeList.add(QlockLanguage.QUART);
                break;
            }
            case 20: {
                if (hour == 12) {
                    this.timeList.add(QlockLanguage.MIDI);
                } else {
                    this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                    this.timeList.add(hour == 1 ? QlockLanguage.HEURE : QlockLanguage.HEURES);
                }
                this.timeList.add(QlockLanguage.VINGT);
                break;
            }
            case 25: {
                if (hour == 12) {
                    this.timeList.add(QlockLanguage.MIDI);
                } else {
                    this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                    this.timeList.add(hour == 1 ? QlockLanguage.HEURE : QlockLanguage.HEURES);
                }
                this.timeList.add(QlockLanguage.VINGT_CINQ);
                break;
            }
            case 30: {
                if (hour == 12) {
                    this.timeList.add(QlockLanguage.MIDI);
                } else {
                    this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                    this.timeList.add(hour == 1 ? QlockLanguage.HEURE : QlockLanguage.HEURES);
                }
                this.timeList.add(QlockLanguage.ET1);
                this.timeList.add(QlockLanguage.DEMIE);
                break;
            }
            case 35: {
                this.addHour(this.timeList, hour);
                if (hour != 11) {
                    this.timeList.add(hour == 1 ? QlockLanguage.HEURE : QlockLanguage.HEURES);
                }
                this.timeList.add(QlockLanguage.MOINS);
                this.timeList.add(QlockLanguage.VINGT_CINQ);
                break;
            }
            case 40: {
                this.addHour(this.timeList, hour);
                if (hour != 11) {
                    this.timeList.add(hour == 1 ? QlockLanguage.HEURE : QlockLanguage.HEURES);
                }
                this.timeList.add(QlockLanguage.MOINS);
                this.timeList.add(QlockLanguage.VINGT);
                break;
            }
            case 45: {
                this.addHour(this.timeList, hour);
                if (hour != 11) {
                    this.timeList.add(hour == 1 ? QlockLanguage.HEURE : QlockLanguage.HEURES);
                }
                this.timeList.add(QlockLanguage.MOINS);
                this.timeList.add(QlockLanguage.LE);
                this.timeList.add(QlockLanguage.QUART);
                break;
            }
            case 50: {
                this.addHour(this.timeList, hour);
                if (hour != 11) {
                    this.timeList.add(hour == 1 ? QlockLanguage.HEURE : QlockLanguage.HEURES);
                }
                this.timeList.add(QlockLanguage.MOINS);
                this.timeList.add(QlockLanguage.DIX1);
                break;
            }
            case 55: {
                this.addHour(this.timeList, hour);
                if (hour != 11) {
                    this.timeList.add(hour == 1 ? QlockLanguage.HEURE : QlockLanguage.HEURES);
                }
                this.timeList.add(QlockLanguage.MOINS);
                this.timeList.add(QlockLanguage.CINQ1);
            }
        }
        return this.timeList;
    }

    @Override
    public QlockTwo.Language getLanguage() {
        return LANGUAGE;
    }

    private void addHour(List<QlockWord> timeList, int HOUR) {
        if (HOUR == 12) {
            timeList.add(QlockLanguage.UNE);
        } else if (HOUR == 5) {
            timeList.add(QlockLanguage.CINQ1);
        } else if (HOUR == 11) {
            timeList.add(QlockLanguage.MIDI);
        } else {
            timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(HOUR + 1)));
        }
    }

    private static enum QlockLanguage implements QlockWord
    {
        UNE(2, 4, 6),
        DEUX(0, 7, 10),
        TROIS(1, 6, 10),
        QUATRE(1, 0, 5),
        CINQ(3, 7, 10),
        CINQ1(8, 6, 9),
        SIX(3, 4, 6),
        SEPT(2, 7, 10),
        HUIT(3, 0, 3),
        NEUF(2, 0, 3),
        DIX(4, 2, 4),
        DIX1(6, 8, 10),
        ONZE(5, 0, 3),
        IL(0, 0, 1),
        EST(0, 3, 5),
        ET(7, 0, 1),
        HEURE(5, 5, 9),
        HEURES(5, 5, 10),
        LE(6, 6, 7),
        QUART(7, 3, 7),
        VINGT(8, 0, 4),
        MIDI(4, 0, 3),
        VINGT_CINQ(8, 0, 9),
        MOINS(6, 0, 4),
        ET1(9, 0, 1),
        DEMI(9, 3, 6),
        DEMIE(9, 3, 7);

        private final int ROW;
        private final int START;
        private final int STOP;

        private QlockLanguage(int ROW, int START, int STOP) {
            this.ROW = ROW;
            this.START = START;
            this.STOP = STOP;
        }

        @Override
        public int getRow() {
            return this.ROW;
        }

        @Override
        public int getStart() {
            return this.START;
        }

        @Override
        public int getStop() {
            return this.STOP;
        }
    }
}

