/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util.event.generator;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.bsf.BSF_Log;
import org.apache.bsf.BSF_LogFactory;

public class AdapterClassLoader
extends ClassLoader {
    private static Hashtable classCache = new Hashtable();
    private Class c;
    private BSF_Log logger = BSF_LogFactory.getLog(this.getClass().getName());

    public synchronized Class defineClass(String string, byte[] byArray) throws Throwable {
        this.c = this.getLoadedClass(string);
        if (this.c == null) {
            String string2 = string.replace('/', '.');
            try {
                this.c = this.defineClass(string2, byArray, 0, byArray.length);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    try {
                        LocalThreadClassLoader localThreadClassLoader = new LocalThreadClassLoader(classLoader);
                        return localThreadClassLoader.defineClass(string2, byArray);
                    }
                    catch (NoClassDefFoundError noClassDefFoundError2) {
                        this.logger.error("AdapterClassLoader: NoClassDefFoundError ERROR for class [" + string2 + "]!");
                        throw noClassDefFoundError2;
                    }
                }
                this.logger.error("AdapterClassLoader: NoClassDefFoundError ERROR for class [" + string2 + "] (info: Thread context class loader is 'null'.)!");
                throw noClassDefFoundError;
            }
            this.put(string, this.c);
        } else {
            this.logger.error("AdapterClassLoader: " + this.c + " previously loaded. Can not redefine class.");
        }
        return this.c;
    }

    protected final Class findClass(String string) {
        return this.get(string);
    }

    protected final Class get(String string) {
        return (Class)classCache.get(string);
    }

    public synchronized Class getLoadedClass(String string) {
        LocalThreadClassLoader localThreadClassLoader;
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.findSystemClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            clazz = this.findClass(string);
        }
        if (clazz == null && (clazz = (localThreadClassLoader = new LocalThreadClassLoader(Thread.currentThread().getContextClassLoader())).findLoadedClass(string, '0')) == null) {
            try {
                clazz = localThreadClassLoader.findSystemClass(string, '0');
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    clazz = localThreadClassLoader.findClass(string, '0');
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
        }
        return clazz;
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.getLoadedClass(string);
        if (clazz != null && bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected final void put(String string, Class clazz) {
        classCache.put(string, clazz);
    }

    private static String getPrintStackAsString(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        return byteArrayOutputStream.toString();
    }

    private static void RgfMsgBox(String string, char c) {
        final JFrame jFrame = new JFrame("RgfMsgBox");
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                jFrame.dispose();
            }
        });
        if (c == '1') {
            JOptionPane.showMessageDialog(jFrame, string, "information", 1);
        } else {
            JOptionPane.showMessageDialog(jFrame, string, "error", 0);
        }
        jFrame.dispose();
    }

    class LocalThreadClassLoader
    extends ClassLoader {
        public LocalThreadClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        public Class defineClass(String string, byte[] byArray) {
            return this.defineClass(string, byArray, 0, byArray.length);
        }

        Class findLoadedClass(String string, char c) {
            return this.findLoadedClass(string);
        }

        Class findClass(String string, char c) throws ClassNotFoundException {
            return this.findClass(string);
        }

        Class findSystemClass(String string, char c) throws ClassNotFoundException {
            return this.findSystemClass(string);
        }
    }
}

