/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExportsStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ModuleDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.OpensStatement;
import org.eclipse.jdt.internal.compiler.ast.PackageVisibilityStatement;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.RecordComponent;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.ast.RequiresStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.AnnotationContext;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.eclipse.jdt.internal.compiler.codegen.StackMapFrame;
import org.eclipse.jdt.internal.compiler.codegen.StackMapFrameCodeStream;
import org.eclipse.jdt.internal.compiler.codegen.TypeAnnotationCodeStream;
import org.eclipse.jdt.internal.compiler.codegen.VerificationTypeInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolymorphicMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ShouldNotImplement;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ClassFile
implements TypeConstants,
TypeIds {
    private byte[] bytes;
    public CodeStream codeStream;
    public ConstantPool constantPool;
    public int constantPoolOffset;
    public byte[] contents;
    public int contentsOffset;
    protected boolean creatingProblemType;
    public ClassFile enclosingClassFile;
    public byte[] header;
    public int headerOffset;
    public Map<TypeBinding, Boolean> innerClassesBindings;
    public List<ASTNode> bootstrapMethods = null;
    public int methodCount;
    public int methodCountOffset;
    boolean isShared = false;
    public int produceAttributes;
    public SourceTypeBinding referenceBinding;
    public boolean isNestedType;
    public long targetJDK;
    public List<TypeBinding> missingTypes = null;
    public Set<TypeBinding> visitedTypes;
    public static final int INITIAL_CONTENTS_SIZE = 400;
    public static final int INITIAL_HEADER_SIZE = 1500;
    public static final int INNER_CLASSES_SIZE = 5;
    public static final int NESTED_MEMBER_SIZE = 5;
    public static final String ALTMETAFACTORY_STRING = new String(ConstantPool.ALTMETAFACTORY);
    public static final String METAFACTORY_STRING = new String(ConstantPool.METAFACTORY);
    public static final String BOOTSTRAP_STRING = new String(ConstantPool.BOOTSTRAP);
    public static final String[] BOOTSTRAP_METHODS = new String[]{ALTMETAFACTORY_STRING, METAFACTORY_STRING, BOOTSTRAP_STRING};

    public static void createProblemType(TypeDeclaration typeDeclaration, CompilationResult compilationResult) {
        ClassFile.createProblemType(typeDeclaration, null, compilationResult);
    }

    /*
     * WARNING - void declaration
     */
    private static void createProblemType(TypeDeclaration typeDeclaration, ClassFile classFile, CompilationResult compilationResult) {
        void var8_12;
        int n;
        SourceTypeBinding sourceTypeBinding = typeDeclaration.binding;
        ClassFile classFile2 = ClassFile.getNewInstance(sourceTypeBinding);
        classFile2.initialize(sourceTypeBinding, classFile, true);
        if (sourceTypeBinding.hasMemberTypes()) {
            ReferenceBinding[] referenceBindingArray = sourceTypeBinding.memberTypes;
            n = referenceBindingArray.length;
            for (int i = 0; i < n; ++i) {
                classFile2.recordInnerClasses(referenceBindingArray[i]);
            }
        }
        if (sourceTypeBinding.isNestedType()) {
            classFile2.recordInnerClasses(sourceTypeBinding);
        }
        for (ReferenceBinding categorizedProblemArray2 : sourceTypeBinding.typeVariables()) {
            if ((((TypeVariableBinding)categorizedProblemArray2).tagBits & 0x800L) == 0L) continue;
            Util.recordNestedType(classFile2, categorizedProblemArray2);
        }
        FieldBinding[] fieldBindingArray = sourceTypeBinding.fields();
        if (fieldBindingArray != null && fieldBindingArray != Binding.NO_FIELDS) {
            classFile2.addFieldInfos();
        } else {
            if (classFile2.contentsOffset + 2 >= classFile2.contents.length) {
                classFile2.resizeContents(2);
            }
            classFile2.contents[classFile2.contentsOffset++] = 0;
            classFile2.contents[classFile2.contentsOffset++] = 0;
        }
        classFile2.setForMethodInfos();
        CategorizedProblem[] categorizedProblemArray = compilationResult.getErrors();
        if (categorizedProblemArray == null) {
            CategorizedProblem[] categorizedProblemArray2 = new CategorizedProblem[]{};
        }
        n = ((void)var8_12).length;
        CategorizedProblem[] categorizedProblemArray3 = new CategorizedProblem[n];
        System.arraycopy(var8_12, 0, categorizedProblemArray3, 0, n);
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = typeDeclaration.methods;
        boolean bl = false;
        if (abstractMethodDeclarationArray != null) {
            if (sourceTypeBinding.isInterface()) {
                if (sourceTypeBinding.scope.compilerOptions().sourceLevel < 0x340000L) {
                    bl = true;
                }
                classFile2.addProblemClinit(categorizedProblemArray3);
            }
            for (AbstractMethodDeclaration abstractMethodDeclaration : abstractMethodDeclarationArray) {
                MethodBinding methodBinding = abstractMethodDeclaration.binding;
                if (methodBinding == null) continue;
                if (bl) {
                    methodBinding.modifiers = 1025;
                }
                if (methodBinding.isConstructor()) {
                    if (sourceTypeBinding.isInterface()) continue;
                    classFile2.addProblemConstructor(abstractMethodDeclaration, methodBinding, categorizedProblemArray3);
                    continue;
                }
                if (methodBinding.isAbstract()) {
                    classFile2.addAbstractMethod(abstractMethodDeclaration, methodBinding);
                    continue;
                }
                classFile2.addProblemMethod(abstractMethodDeclaration, methodBinding, categorizedProblemArray3);
            }
            classFile2.addDefaultAbstractMethods();
        }
        if (typeDeclaration.memberTypes != null) {
            for (TypeDeclaration typeDeclaration2 : typeDeclaration.memberTypes) {
                if (typeDeclaration2.binding == null) continue;
                ClassFile.createProblemType(typeDeclaration2, classFile2, compilationResult);
            }
        }
        classFile2.addAttributes();
        compilationResult.record(sourceTypeBinding.constantPoolName(), classFile2);
    }

    public static ClassFile getNewInstance(SourceTypeBinding sourceTypeBinding) {
        LookupEnvironment lookupEnvironment = sourceTypeBinding.scope.environment();
        return lookupEnvironment.classFilePool.acquire(sourceTypeBinding);
    }

    protected ClassFile() {
    }

    public ClassFile(SourceTypeBinding sourceTypeBinding) {
        this.constantPool = new ConstantPool(this);
        CompilerOptions compilerOptions = sourceTypeBinding.scope.compilerOptions();
        this.targetJDK = compilerOptions.targetJDK;
        this.produceAttributes = compilerOptions.produceDebugAttributes;
        this.referenceBinding = sourceTypeBinding;
        this.isNestedType = sourceTypeBinding.isNestedType();
        if (this.targetJDK >= 0x320000L) {
            this.produceAttributes |= 8;
            if (this.targetJDK >= 0x340000L) {
                this.produceAttributes |= 0x20;
                this.codeStream = new TypeAnnotationCodeStream(this);
                if (compilerOptions.produceMethodParameters) {
                    this.produceAttributes |= 0x40;
                }
            } else {
                this.codeStream = new StackMapFrameCodeStream(this);
            }
        } else if (this.targetJDK == 2949124L) {
            this.targetJDK = 2949123L;
            this.produceAttributes |= 0x10;
            this.codeStream = new StackMapFrameCodeStream(this);
        } else {
            this.codeStream = new CodeStream(this);
        }
        this.initByteArrays(this.referenceBinding.methods().length + this.referenceBinding.fields().length);
    }

    public ClassFile(ModuleBinding moduleBinding, CompilerOptions compilerOptions) {
        this.constantPool = new ConstantPool(this);
        this.targetJDK = compilerOptions.targetJDK;
        this.produceAttributes = 1;
        this.isNestedType = false;
        this.codeStream = new StackMapFrameCodeStream(this);
        this.initByteArrays(0);
    }

    public void addAbstractMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(methodBinding);
        this.completeMethodInfo(methodBinding, n, n2);
    }

    public void addAttributes() {
        Object[] objectArray;
        TypeDeclaration typeDeclaration;
        int n;
        Object object;
        this.contents[this.methodCountOffset++] = (byte)(this.methodCount >> 8);
        this.contents[this.methodCountOffset] = (byte)this.methodCount;
        int n2 = 0;
        int n3 = this.contentsOffset;
        this.contentsOffset += 2;
        if ((this.produceAttributes & 1) != 0) {
            object = new String(this.referenceBinding.scope.referenceCompilationUnit().getFileName());
            n = ((String)(object = ((String)object).replace('\\', '/'))).lastIndexOf(47);
            if (n != -1) {
                object = ((String)object).substring(n + 1, ((String)object).length());
            }
            n2 += this.generateSourceAttribute((String)object);
        }
        if (this.referenceBinding.isDeprecated()) {
            n2 += this.generateDeprecatedAttribute();
        }
        if ((object = this.referenceBinding.genericSignature()) != null) {
            n2 += this.generateSignatureAttribute((char[])object);
        }
        if (this.targetJDK >= 0x310000L && this.referenceBinding.isNestedType() && !this.referenceBinding.isMemberType()) {
            n2 += this.generateEnclosingMethodAttribute();
        }
        if (this.targetJDK >= 0x300000L && (typeDeclaration = this.referenceBinding.scope.referenceContext) != null && (objectArray = typeDeclaration.annotations) != null) {
            long l = typeDeclaration.isPackageInfo() ? 0x80000000000L : (this.referenceBinding.isAnnotationType() ? 0x41000000000L : 0x20001000000000L);
            n2 += this.generateRuntimeAnnotations((Annotation[])objectArray, l);
        }
        if (this.referenceBinding.isHierarchyInconsistent()) {
            ReferenceBinding referenceBinding = this.referenceBinding.superclass;
            if (referenceBinding != null) {
                this.missingTypes = referenceBinding.collectMissingTypes(this.missingTypes);
            }
            objectArray = this.referenceBinding.superInterfaces();
            int n4 = objectArray.length;
            for (int i = 0; i < n4; ++i) {
                this.missingTypes = ((TypeBinding)objectArray[i]).collectMissingTypes(this.missingTypes);
            }
            n2 += this.generateHierarchyInconsistentAttribute();
        }
        if (this.bootstrapMethods != null && !this.bootstrapMethods.isEmpty()) {
            n2 += this.generateBootstrapMethods(this.bootstrapMethods);
        }
        if (this.targetJDK >= 0x3B0000L) {
            n2 += this.generatePermittedTypeAttributes();
        }
        int n5 = n = this.innerClassesBindings == null ? 0 : this.innerClassesBindings.size();
        if (n != 0) {
            objectArray = new ReferenceBinding[n];
            this.innerClassesBindings.keySet().toArray(objectArray);
            Arrays.sort(objectArray, new Comparator<ReferenceBinding>(){

                @Override
                public int compare(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
                    Boolean bl = ClassFile.this.innerClassesBindings.get(referenceBinding);
                    Boolean bl2 = ClassFile.this.innerClassesBindings.get(referenceBinding2);
                    if (bl.booleanValue()) {
                        if (!bl2.booleanValue()) {
                            return 1;
                        }
                    } else if (bl2.booleanValue()) {
                        return -1;
                    }
                    return CharOperation.compareTo(referenceBinding.constantPoolName(), referenceBinding2.constantPoolName());
                }
            });
            n2 += this.generateInnerClassAttribute(n, (ReferenceBinding[])objectArray);
        }
        if (this.missingTypes != null) {
            this.generateMissingTypesAttribute();
            ++n2;
        }
        n2 += this.generateTypeAnnotationAttributeForTypeDeclaration();
        if (this.targetJDK >= 0x370000L) {
            n2 += this.generateNestAttributes();
        }
        if (this.targetJDK >= 0x3A0000L) {
            n2 += this.generateRecordAttributes();
        }
        if (n3 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n3++] = (byte)(n2 >> 8);
        this.contents[n3] = (byte)n2;
        this.header = this.constantPool.poolContent;
        this.headerOffset = this.constantPool.currentOffset;
        int n6 = this.constantPool.currentIndex;
        this.header[this.constantPoolOffset++] = (byte)(n6 >> 8);
        this.header[this.constantPoolOffset] = (byte)n6;
    }

    public void addModuleAttributes(ModuleBinding moduleBinding, Annotation[] annotationArray, CompilationUnitDeclaration compilationUnitDeclaration) {
        char[][] cArray;
        char[] cArray2;
        int n = 0;
        int n2 = this.contentsOffset;
        this.contentsOffset += 2;
        if ((this.produceAttributes & 1) != 0) {
            String string = new String(compilationUnitDeclaration.getFileName());
            int n3 = (string = string.replace('\\', '/')).lastIndexOf(47);
            if (n3 != -1) {
                string = string.substring(n3 + 1, string.length());
            }
            n += this.generateSourceAttribute(string);
        }
        n += this.generateModuleAttribute(compilationUnitDeclaration.moduleDeclaration);
        if (annotationArray != null) {
            long l = 0x2000000000000000L;
            n += this.generateRuntimeAnnotations(annotationArray, l);
        }
        if ((cArray2 = compilationUnitDeclaration.moduleDeclaration.binding.mainClassName) != null) {
            n += this.generateModuleMainClassAttribute(CharOperation.replaceOnCopy(cArray2, '.', '/'));
        }
        if ((cArray = compilationUnitDeclaration.moduleDeclaration.binding.getPackageNamesForClassFile()) != null) {
            n += this.generateModulePackagesAttribute(cArray);
        }
        if (n2 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n2++] = (byte)(n >> 8);
        this.contents[n2] = (byte)n;
        this.header = this.constantPool.poolContent;
        this.headerOffset = this.constantPool.currentOffset;
        int n4 = this.constantPool.currentIndex;
        this.header[this.constantPoolOffset++] = (byte)(n4 >> 8);
        this.header[this.constantPoolOffset] = (byte)n4;
    }

    public void addDefaultAbstractMethods() {
        for (MethodBinding methodBinding : this.referenceBinding.getDefaultAbstractMethods()) {
            this.generateMethodInfoHeader(methodBinding);
            int n = this.contentsOffset;
            int n2 = this.generateMethodInfoAttributes(methodBinding);
            this.completeMethodInfo(methodBinding, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addFieldAttributes(FieldBinding fieldBinding, int n) {
        FieldDeclaration fieldDeclaration;
        char[] cArray;
        int n2 = 0;
        Constant constant = fieldBinding.constant();
        if (constant != Constant.NotAConstant) {
            n2 += this.generateConstantValueAttribute(constant, fieldBinding, n);
        }
        if (this.targetJDK < 0x310000L && fieldBinding.isSynthetic()) {
            n2 += this.generateSyntheticAttribute();
        }
        if (fieldBinding.isDeprecated()) {
            n2 += this.generateDeprecatedAttribute();
        }
        if ((cArray = fieldBinding.genericSignature()) != null) {
            n2 += this.generateSignatureAttribute(cArray);
        }
        if (this.targetJDK >= 0x300000L && (fieldDeclaration = fieldBinding.sourceField()) != null) {
            try {
                Annotation[] annotationArray;
                Statement statement;
                if (fieldDeclaration.isARecordComponent) {
                    long l = 0x20002000000000L;
                    statement = this.getRecordComponent(fieldBinding.declaringClass, fieldBinding.name);
                    if (statement != null) {
                        fieldDeclaration.annotations = ASTNode.getRelevantAnnotations(((RecordComponent)statement).annotations, l, null);
                    }
                }
                if ((annotationArray = fieldDeclaration.annotations) != null) {
                    n2 += this.generateRuntimeAnnotations(annotationArray, 0x2000000000L);
                }
                if ((this.produceAttributes & 0x20) != 0) {
                    ArrayList<AnnotationContext> arrayList = new ArrayList<AnnotationContext>();
                    if (annotationArray != null && (fieldDeclaration.bits & 0x100000) != 0) {
                        fieldDeclaration.getAllAnnotationContexts(19, arrayList);
                    }
                    if ((statement = fieldDeclaration.type) != null && (((TypeReference)statement).bits & 0x100000) != 0) {
                        ((TypeReference)statement).getAllAnnotationContexts(19, arrayList);
                    }
                    int n3 = arrayList.size();
                    n2 = this.completeRuntimeTypeAnnotations(n2, null, aSTNode -> n3 > 0, () -> arrayList);
                }
            }
            finally {
                if (fieldDeclaration.isARecordComponent) {
                    fieldDeclaration.annotations = null;
                }
            }
        }
        if ((fieldBinding.tagBits & 0x80L) != 0L) {
            this.missingTypes = fieldBinding.type.collectMissingTypes(this.missingTypes);
        }
        return n2;
    }

    private RecordComponent getRecordComponent(ReferenceBinding referenceBinding, char[] cArray) {
        SourceTypeBinding sourceTypeBinding;
        RecordComponentBinding recordComponentBinding;
        if (referenceBinding instanceof SourceTypeBinding && (recordComponentBinding = (sourceTypeBinding = (SourceTypeBinding)referenceBinding).getRecordComponent(cArray)) != null) {
            RecordComponent recordComponent = recordComponentBinding.sourceRecordComponent();
            return recordComponent;
        }
        return null;
    }

    private int addComponentAttributes(RecordComponentBinding recordComponentBinding, int n) {
        RecordComponent recordComponent;
        int n2 = 0;
        char[] cArray = recordComponentBinding.genericSignature();
        if (cArray != null) {
            n2 += this.generateSignatureAttribute(cArray);
        }
        if ((recordComponent = recordComponentBinding.sourceRecordComponent()) != null) {
            Annotation[] annotationArray = recordComponent.annotations;
            if (annotationArray != null) {
                n2 += this.generateRuntimeAnnotations(annotationArray, 0x40000000L);
            }
            if ((this.produceAttributes & 0x20) != 0) {
                TypeReference typeReference;
                ArrayList<AnnotationContext> arrayList = new ArrayList<AnnotationContext>();
                if (annotationArray != null && (recordComponent.bits & 0x100000) != 0) {
                    recordComponent.getAllAnnotationContexts(19, arrayList);
                }
                if ((typeReference = recordComponent.type) != null && (typeReference.bits & 0x100000) != 0) {
                    typeReference.getAllAnnotationContexts(19, arrayList);
                }
                int n3 = arrayList.size();
                n2 = this.completeRuntimeTypeAnnotations(n2, null, aSTNode -> n3 > 0, () -> arrayList);
            }
        }
        if ((recordComponentBinding.tagBits & 0x80L) != 0L) {
            this.missingTypes = recordComponentBinding.type.collectMissingTypes(this.missingTypes);
        }
        return n2;
    }

    private void addComponentInfo(RecordComponentBinding recordComponentBinding) {
        if (this.contentsOffset + 6 >= this.contents.length) {
            this.resizeContents(6);
        }
        int n = this.constantPool.literalIndex(recordComponentBinding.name);
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndex(recordComponentBinding.type);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        int n3 = this.contentsOffset;
        int n4 = 0;
        this.contentsOffset += 2;
        n4 += this.addComponentAttributes(recordComponentBinding, n3);
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n3++] = (byte)(n4 >> 8);
        this.contents[n3] = (byte)n4;
    }

    private void addFieldInfo(FieldBinding fieldBinding) {
        if (this.contentsOffset + 8 >= this.contents.length) {
            this.resizeContents(8);
        }
        int n = fieldBinding.getAccessFlags();
        if (this.targetJDK < 0x310000L) {
            n &= 0xFFFFEFFF;
        }
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndex(fieldBinding.name);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        int n3 = this.constantPool.literalIndex(fieldBinding.type);
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        int n4 = this.contentsOffset;
        int n5 = 0;
        this.contentsOffset += 2;
        n5 += this.addFieldAttributes(fieldBinding, n4);
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n4++] = (byte)(n5 >> 8);
        this.contents[n4] = (byte)n5;
    }

    public void addFieldInfos() {
        int n;
        int n2;
        SourceTypeBinding sourceTypeBinding = this.referenceBinding;
        FieldBinding[] fieldBindingArray = sourceTypeBinding.syntheticFields();
        int n3 = sourceTypeBinding.fieldCount() + (fieldBindingArray == null ? 0 : fieldBindingArray.length);
        if (n3 > 65535) {
            this.referenceBinding.scope.problemReporter().tooManyFields(this.referenceBinding.scope.referenceType());
        }
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        FieldDeclaration[] fieldDeclarationArray = sourceTypeBinding.scope.referenceContext.fields;
        int n4 = n2 = fieldDeclarationArray == null ? 0 : fieldDeclarationArray.length;
        for (n = 0; n < n2; ++n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n];
            if (fieldDeclaration.binding == null) continue;
            this.addFieldInfo(fieldDeclaration.binding);
        }
        if (fieldBindingArray != null) {
            n2 = fieldBindingArray.length;
            for (n = 0; n < n2; ++n) {
                this.addFieldInfo(fieldBindingArray[n]);
            }
        }
    }

    private void addMissingAbstractProblemMethod(MethodDeclaration methodDeclaration, MethodBinding methodBinding, CategorizedProblem categorizedProblem, CompilationResult compilationResult) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(methodBinding);
        ++n2;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        StringBuffer stringBuffer = new StringBuffer(25);
        stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
        stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
        String string = stringBuffer.toString();
        this.codeStream.init(this);
        this.codeStream.preserveUnusedLocals = true;
        this.codeStream.initializeMaxLocals(methodBinding);
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        this.completeCodeAttributeForMissingAbstractProblemMethod(methodBinding, n3, compilationResult.getLineSeparatorPositions(), categorizedProblem.getSourceLineNumber());
        this.completeMethodInfo(methodBinding, n, n2);
    }

    public void addProblemClinit(CategorizedProblem[] categorizedProblemArray) {
        this.generateMethodInfoHeaderForClinit();
        this.contentsOffset -= 2;
        int n = this.contentsOffset;
        this.contentsOffset += 2;
        int n2 = 0;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.resetForProblemClinit(this);
        String string = "";
        int n4 = 0;
        if (categorizedProblemArray != null) {
            int n5 = categorizedProblemArray.length;
            StringBuffer stringBuffer = new StringBuffer(25);
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                CategorizedProblem categorizedProblem = categorizedProblemArray[i];
                if (categorizedProblem == null || !categorizedProblem.isError()) continue;
                stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
                ++n6;
                if (n4 == 0) {
                    n4 = categorizedProblem.getSourceLineNumber();
                }
                categorizedProblemArray[i] = null;
            }
            if (n6 > 1) {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            string = stringBuffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        ++n2;
        this.completeCodeAttributeForClinit(n3, n4, null);
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addProblemConstructor(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray) {
        if (methodBinding.declaringClass.isInterface()) {
            abstractMethodDeclaration.abort(8, null);
        }
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(methodBinding);
        ++n2;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.reset(abstractMethodDeclaration, this);
        String string = "";
        int n4 = 0;
        if (categorizedProblemArray != null) {
            int n5 = categorizedProblemArray.length;
            StringBuffer stringBuffer = new StringBuffer(25);
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                CategorizedProblem categorizedProblem = categorizedProblemArray[i];
                if (categorizedProblem == null || !categorizedProblem.isError()) continue;
                stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
                ++n6;
                if (n4 != 0) continue;
                n4 = categorizedProblem.getSourceLineNumber();
            }
            if (n6 > 1) {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            string = stringBuffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        this.completeCodeAttributeForProblemMethod(abstractMethodDeclaration, methodBinding, n3, ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions(), n4);
        this.completeMethodInfo(methodBinding, n, n2);
    }

    public void addProblemConstructor(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray, int n) {
        this.contentsOffset = n;
        --this.methodCount;
        this.addProblemConstructor(abstractMethodDeclaration, methodBinding, categorizedProblemArray);
    }

    public void addProblemMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray) {
        if (methodBinding.isAbstract() && methodBinding.declaringClass.isInterface()) {
            abstractMethodDeclaration.abort(8, null);
        }
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(methodBinding);
        ++n2;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.reset(abstractMethodDeclaration, this);
        String string = "";
        int n4 = 0;
        if (categorizedProblemArray != null) {
            int n5 = categorizedProblemArray.length;
            StringBuffer stringBuffer = new StringBuffer(25);
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                CategorizedProblem categorizedProblem = categorizedProblemArray[i];
                if (categorizedProblem == null || !categorizedProblem.isError() || categorizedProblem.getSourceStart() < abstractMethodDeclaration.declarationSourceStart || categorizedProblem.getSourceEnd() > abstractMethodDeclaration.declarationSourceEnd) continue;
                stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
                ++n6;
                if (n4 == 0) {
                    n4 = categorizedProblem.getSourceLineNumber();
                }
                categorizedProblemArray[i] = null;
            }
            if (n6 > 1) {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            string = stringBuffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        this.completeCodeAttributeForProblemMethod(abstractMethodDeclaration, methodBinding, n3, ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions(), n4);
        this.completeMethodInfo(methodBinding, n, n2);
    }

    public void addProblemMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray, int n) {
        this.contentsOffset = n;
        --this.methodCount;
        this.addProblemMethod(abstractMethodDeclaration, methodBinding, categorizedProblemArray);
    }

    public void addSpecialMethods(TypeDeclaration typeDeclaration) {
        int n;
        this.generateMissingAbstractMethods(this.referenceBinding.scope.referenceType().missingAbstractMethods, this.referenceBinding.scope.referenceCompilationUnit().compilationResult);
        for (MethodBinding methodBinding : this.referenceBinding.getDefaultAbstractMethods()) {
            this.generateMethodInfoHeader(methodBinding);
            int n2 = this.contentsOffset;
            n = this.generateMethodInfoAttributes(methodBinding);
            this.completeMethodInfo(methodBinding, n2, n);
        }
        int n3 = 0;
        SyntheticMethodBinding syntheticMethodBinding = null;
        boolean bl = true;
        while (bl) {
            bl = false;
            SyntheticMethodBinding[] syntheticMethodBindingArray = this.referenceBinding.syntheticMethods();
            n = syntheticMethodBindingArray == null ? 0 : syntheticMethodBindingArray.length;
            if (n3 == n) continue;
            int n4 = n;
            block21: for (int i = n3; i < n4; ++i) {
                SyntheticMethodBinding syntheticMethodBinding2 = syntheticMethodBindingArray[i];
                switch (syntheticMethodBinding2.purpose) {
                    case 1: 
                    case 3: {
                        this.addSyntheticFieldReadAccessMethod(syntheticMethodBinding2);
                        continue block21;
                    }
                    case 2: 
                    case 4: {
                        this.addSyntheticFieldWriteAccessMethod(syntheticMethodBinding2);
                        continue block21;
                    }
                    case 5: 
                    case 7: 
                    case 8: {
                        this.addSyntheticMethodAccessMethod(syntheticMethodBinding2);
                        continue block21;
                    }
                    case 6: {
                        this.addSyntheticConstructorAccessMethod(syntheticMethodBinding2);
                        continue block21;
                    }
                    case 9: {
                        this.addSyntheticEnumValuesMethod(syntheticMethodBinding2);
                        continue block21;
                    }
                    case 10: {
                        this.addSyntheticEnumValueOfMethod(syntheticMethodBinding2);
                        continue block21;
                    }
                    case 11: {
                        this.addSyntheticSwitchTable(syntheticMethodBinding2);
                        continue block21;
                    }
                    case 12: {
                        this.addSyntheticEnumInitializationMethod(syntheticMethodBinding2);
                        continue block21;
                    }
                    case 13: {
                        syntheticMethodBinding2.lambda.generateCode(this.referenceBinding.scope, this);
                        bl = true;
                        continue block21;
                    }
                    case 14: {
                        this.addSyntheticArrayConstructor(syntheticMethodBinding2);
                        continue block21;
                    }
                    case 15: {
                        this.addSyntheticArrayClone(syntheticMethodBinding2);
                        continue block21;
                    }
                    case 16: {
                        this.addSyntheticFactoryMethod(syntheticMethodBinding2);
                        continue block21;
                    }
                    case 17: {
                        syntheticMethodBinding = syntheticMethodBinding2;
                        continue block21;
                    }
                    case 18: {
                        continue block21;
                    }
                    case 19: 
                    case 20: 
                    case 21: {
                        this.addSyntheticRecordOverrideMethods(typeDeclaration, syntheticMethodBinding2, syntheticMethodBinding2.purpose);
                    }
                }
            }
            n3 = n;
        }
        if (syntheticMethodBinding != null) {
            int n5 = 0;
            this.codeStream.wideMode = false;
            n = 0;
            do {
                try {
                    n5 = this.contentsOffset;
                    this.addSyntheticDeserializeLambda(syntheticMethodBinding, this.referenceBinding.syntheticMethods());
                    n = 0;
                }
                catch (AbortMethod abortMethod) {
                    if (abortMethod.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                        this.contentsOffset = n5;
                        --this.methodCount;
                        this.codeStream.resetInWideMode();
                        n = 1;
                        continue;
                    }
                    throw new AbortType(this.referenceBinding.scope.referenceContext.compilationResult, abortMethod.problem);
                }
            } while (n != 0);
        }
    }

    private void addSyntheticRecordOverrideMethods(TypeDeclaration typeDeclaration, SyntheticMethodBinding syntheticMethodBinding, int n) {
        if (this.bootstrapMethods == null) {
            this.bootstrapMethods = new ArrayList<ASTNode>(3);
        }
        if (!this.bootstrapMethods.contains(typeDeclaration)) {
            this.bootstrapMethods.add(typeDeclaration);
        }
        int n2 = this.bootstrapMethods.indexOf(typeDeclaration);
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        int n4 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n5 = this.contentsOffset;
        ++n4;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        switch (n) {
            case 21: {
                this.codeStream.generateSyntheticBodyForRecordEquals(syntheticMethodBinding, n2);
                break;
            }
            case 20: {
                this.codeStream.generateSyntheticBodyForRecordHashCode(syntheticMethodBinding, n2);
                break;
            }
            case 19: {
                this.codeStream.generateSyntheticBodyForRecordToString(syntheticMethodBinding, n2);
                break;
            }
        }
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n5, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n3++] = (byte)(n4 >> 8);
        this.contents[n3] = (byte)n4;
    }

    public void addSyntheticArrayConstructor(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForArrayConstructor(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticArrayClone(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForArrayClone(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticFactoryMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForFactoryMethod(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticConstructorAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForConstructorAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticEnumValueOfMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        ++n2;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForEnumValueOf(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        if ((this.produceAttributes & 0x40) != 0) {
            n2 += this.generateMethodParameters(syntheticMethodBinding);
        }
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticEnumValuesMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForEnumValues(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticEnumInitializationMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForEnumInitializationMethod(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticFieldReadAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForFieldReadAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticFieldWriteAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForFieldWriteAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticMethodAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForMethodAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticSwitchTable(SyntheticMethodBinding syntheticMethodBinding) {
        SwitchStatement switchStatement;
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        ++n2;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForSwitchTable(syntheticMethodBinding);
        int n4 = this.codeStream.position;
        if (n4 > 65535 && (switchStatement = syntheticMethodBinding.switchStatement) != null) {
            switchStatement.scope.problemReporter().bytecodeExceeds64KLimit(switchStatement);
        }
        this.completeCodeAttributeForSyntheticMethod(true, syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions(), ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope);
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void completeCodeAttribute(int n, MethodScope methodScope) {
        int n2;
        this.contents = this.codeStream.bCodeStream;
        int n3 = this.codeStream.classFileOffset;
        int n4 = this.codeStream.position;
        if (n4 > 65535) {
            if (this.codeStream.methodDeclaration != null) {
                this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration);
            } else {
                this.codeStream.lambdaExpression.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.lambdaExpression);
            }
        }
        if (n3 + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n5 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n5 >> 8);
        this.contents[n + 7] = (byte)n5;
        int n6 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n6 >> 8);
        this.contents[n + 9] = (byte)n6;
        this.contents[n + 10] = (byte)(n4 >> 24);
        this.contents[n + 11] = (byte)(n4 >> 16);
        this.contents[n + 12] = (byte)(n4 >> 8);
        this.contents[n + 13] = (byte)n4;
        boolean bl = (this.produceAttributes & 8) != 0;
        ExceptionLabel[] exceptionLabelArray = this.codeStream.exceptionLabels;
        int n7 = 0;
        int n8 = this.codeStream.exceptionLabelsCounter;
        for (n2 = 0; n2 < n8; ++n2) {
            n7 += this.codeStream.exceptionLabels[n2].getCount() / 2;
        }
        n2 = n7 * 8 + 2;
        if (n2 + n3 >= this.contents.length) {
            this.resizeContents(n2);
        }
        this.contents[n3++] = (byte)(n7 >> 8);
        this.contents[n3++] = (byte)n7;
        int n9 = this.codeStream.exceptionLabelsCounter;
        for (n8 = 0; n8 < n9; ++n8) {
            ExceptionLabel exceptionLabel = exceptionLabelArray[n8];
            if (exceptionLabel == null) continue;
            int n10 = 0;
            int n11 = exceptionLabel.getCount();
            if ((n11 & 1) != 0) {
                if (this.codeStream.methodDeclaration != null) {
                    this.codeStream.methodDeclaration.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(this.codeStream.methodDeclaration.selector)), this.codeStream.methodDeclaration);
                } else {
                    this.codeStream.lambdaExpression.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(this.codeStream.lambdaExpression.binding.selector)), this.codeStream.lambdaExpression);
                }
            }
            while (n10 < n11) {
                int n12 = exceptionLabel.ranges[n10++];
                this.contents[n3++] = (byte)(n12 >> 8);
                this.contents[n3++] = (byte)n12;
                int n13 = exceptionLabel.ranges[n10++];
                this.contents[n3++] = (byte)(n13 >> 8);
                this.contents[n3++] = (byte)n13;
                int n14 = exceptionLabel.position;
                if (bl) {
                    StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
                    stackMapFrameCodeStream.addFramePosition(n14);
                }
                this.contents[n3++] = (byte)(n14 >> 8);
                this.contents[n3++] = (byte)n14;
                if (exceptionLabel.exceptionType == null) {
                    this.contents[n3++] = 0;
                    this.contents[n3++] = 0;
                    continue;
                }
                int n15 = exceptionLabel.exceptionType == TypeBinding.NULL ? this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName) : this.constantPool.literalIndexForType(exceptionLabel.exceptionType);
                this.contents[n3++] = (byte)(n15 >> 8);
                this.contents[n3++] = (byte)n15;
            }
        }
        n8 = n3;
        n9 = 0;
        if ((n3 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contentsOffset = n3;
        if ((this.produceAttributes & 2) != 0) {
            n9 += this.generateLineNumberAttribute();
        }
        if ((this.produceAttributes & 4) != 0) {
            boolean bl2 = this.codeStream.methodDeclaration != null ? this.codeStream.methodDeclaration.isStatic() : this.codeStream.lambdaExpression.binding.isStatic();
            n9 += this.generateLocalVariableTableAttribute(n4, bl2, false);
        }
        if (bl) {
            n9 += this.generateStackMapTableAttribute(this.codeStream.methodDeclaration != null ? this.codeStream.methodDeclaration.binding : this.codeStream.lambdaExpression.binding, n4, n, n6, false, methodScope);
        }
        if ((this.produceAttributes & 0x10) != 0) {
            n9 += this.generateStackMapAttribute(this.codeStream.methodDeclaration != null ? this.codeStream.methodDeclaration.binding : this.codeStream.lambdaExpression.binding, n4, n, n6, false, methodScope);
        }
        if ((this.produceAttributes & 0x20) != 0) {
            n9 += this.generateTypeAnnotationsOnCodeAttribute();
        }
        this.contents[n8++] = (byte)(n9 >> 8);
        this.contents[n8] = (byte)n9;
        int n16 = this.contentsOffset - (n + 6);
        this.contents[n + 2] = (byte)(n16 >> 24);
        this.contents[n + 3] = (byte)(n16 >> 16);
        this.contents[n + 4] = (byte)(n16 >> 8);
        this.contents[n + 5] = (byte)n16;
    }

    public int generateTypeAnnotationsOnCodeAttribute() {
        Object object;
        int n = 0;
        List<AnnotationContext> list = ((TypeAnnotationCodeStream)this.codeStream).allTypeAnnotationContexts;
        int n2 = this.codeStream.allLocalsCounter;
        for (int i = 0; i < n2; ++i) {
            LocalVariableBinding localVariableBinding = this.codeStream.locals[i];
            if (localVariableBinding.isCatchParameter() || (object = localVariableBinding.declaration) == null || ((LocalDeclaration)object).isArgument() && (((LocalDeclaration)object).bits & 0x20000000) == 0 || localVariableBinding.initializationCount == 0 || (((LocalDeclaration)object).bits & 0x100000) == 0) continue;
            int n3 = (localVariableBinding.tagBits & 0x2000L) == 0L ? 64 : 65;
            ((LocalDeclaration)object).getAllAnnotationContexts(n3, localVariableBinding, list);
        }
        ExceptionLabel[] exceptionLabelArray = this.codeStream.exceptionLabels;
        int n4 = this.codeStream.exceptionLabelsCounter;
        for (n2 = 0; n2 < n4; ++n2) {
            object = exceptionLabelArray[n2];
            if (((ExceptionLabel)object).exceptionTypeReference == null || (((ExceptionLabel)object).exceptionTypeReference.bits & 0x100000) == 0) continue;
            ((ExceptionLabel)object).exceptionTypeReference.getAllAnnotationContexts(66, n2, list, ((ExceptionLabel)object).se7Annotations);
        }
        n2 = list.size();
        n = this.completeRuntimeTypeAnnotations(n, null, aSTNode -> n3 > 0, () -> arrayList);
        return n;
    }

    public void completeCodeAttributeForClinit(int n, Scope scope) {
        int n2;
        this.contents = this.codeStream.bCodeStream;
        int n3 = this.codeStream.classFileOffset;
        int n4 = this.codeStream.position;
        if (n4 > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration.scope.referenceType());
        }
        if (n3 + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n5 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n5 >> 8);
        this.contents[n + 7] = (byte)n5;
        int n6 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n6 >> 8);
        this.contents[n + 9] = (byte)n6;
        this.contents[n + 10] = (byte)(n4 >> 24);
        this.contents[n + 11] = (byte)(n4 >> 16);
        this.contents[n + 12] = (byte)(n4 >> 8);
        this.contents[n + 13] = (byte)n4;
        boolean bl = (this.produceAttributes & 8) != 0;
        ExceptionLabel[] exceptionLabelArray = this.codeStream.exceptionLabels;
        int n7 = 0;
        int n8 = this.codeStream.exceptionLabelsCounter;
        for (n2 = 0; n2 < n8; ++n2) {
            n7 += this.codeStream.exceptionLabels[n2].getCount() / 2;
        }
        n2 = n7 * 8 + 2;
        if (n2 + n3 >= this.contents.length) {
            this.resizeContents(n2);
        }
        this.contents[n3++] = (byte)(n7 >> 8);
        this.contents[n3++] = (byte)n7;
        int n9 = this.codeStream.exceptionLabelsCounter;
        for (n8 = 0; n8 < n9; ++n8) {
            ExceptionLabel exceptionLabel = exceptionLabelArray[n8];
            if (exceptionLabel == null) continue;
            int n10 = 0;
            int n11 = exceptionLabel.getCount();
            if ((n11 & 1) != 0) {
                this.codeStream.methodDeclaration.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(this.codeStream.methodDeclaration.selector)), this.codeStream.methodDeclaration);
            }
            while (n10 < n11) {
                int n12 = exceptionLabel.ranges[n10++];
                this.contents[n3++] = (byte)(n12 >> 8);
                this.contents[n3++] = (byte)n12;
                int n13 = exceptionLabel.ranges[n10++];
                this.contents[n3++] = (byte)(n13 >> 8);
                this.contents[n3++] = (byte)n13;
                int n14 = exceptionLabel.position;
                this.contents[n3++] = (byte)(n14 >> 8);
                this.contents[n3++] = (byte)n14;
                if (bl) {
                    StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
                    stackMapFrameCodeStream.addFramePosition(n14);
                }
                if (exceptionLabel.exceptionType == null) {
                    this.contents[n3++] = 0;
                    this.contents[n3++] = 0;
                    continue;
                }
                int n15 = exceptionLabel.exceptionType == TypeBinding.NULL ? this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName) : this.constantPool.literalIndexForType(exceptionLabel.exceptionType);
                this.contents[n3++] = (byte)(n15 >> 8);
                this.contents[n3++] = (byte)n15;
            }
        }
        n8 = n3;
        n9 = 0;
        if ((n3 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contentsOffset = n3;
        if ((this.produceAttributes & 2) != 0) {
            n9 += this.generateLineNumberAttribute();
        }
        if ((this.produceAttributes & 4) != 0) {
            n9 += this.generateLocalVariableTableAttribute(n4, true, false);
        }
        if ((this.produceAttributes & 8) != 0) {
            n9 += this.generateStackMapTableAttribute(null, n4, n, n6, true, scope);
        }
        if ((this.produceAttributes & 0x10) != 0) {
            n9 += this.generateStackMapAttribute(null, n4, n, n6, true, scope);
        }
        if ((this.produceAttributes & 0x20) != 0) {
            n9 += this.generateTypeAnnotationsOnCodeAttribute();
        }
        if (n8 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n8++] = (byte)(n9 >> 8);
        this.contents[n8] = (byte)n9;
        int n16 = this.contentsOffset - (n + 6);
        this.contents[n + 2] = (byte)(n16 >> 24);
        this.contents[n + 3] = (byte)(n16 >> 16);
        this.contents[n + 4] = (byte)(n16 >> 8);
        this.contents[n + 5] = (byte)n16;
    }

    public void completeCodeAttributeForClinit(int n, int n2, MethodScope methodScope) {
        int n3;
        this.contents = this.codeStream.bCodeStream;
        int n4 = this.codeStream.classFileOffset;
        int n5 = this.codeStream.position;
        if (n5 > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration.scope.referenceType());
        }
        if (n4 + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n6 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n6 >> 8);
        this.contents[n + 7] = (byte)n6;
        int n7 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n7 >> 8);
        this.contents[n + 9] = (byte)n7;
        this.contents[n + 10] = (byte)(n5 >> 24);
        this.contents[n + 11] = (byte)(n5 >> 16);
        this.contents[n + 12] = (byte)(n5 >> 8);
        this.contents[n + 13] = (byte)n5;
        this.contents[n4++] = 0;
        this.contents[n4++] = 0;
        int n8 = n4;
        int n9 = 0;
        if ((n4 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contentsOffset = n4;
        if ((this.produceAttributes & 2) != 0) {
            n9 += this.generateLineNumberAttribute(n2);
        }
        n4 = this.contentsOffset;
        if ((this.produceAttributes & 4) != 0) {
            n3 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (n4 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[n4++] = (byte)(n3 >> 8);
            this.contents[n4++] = (byte)n3;
            this.contents[n4++] = 0;
            this.contents[n4++] = 0;
            this.contents[n4++] = 0;
            this.contents[n4++] = 2;
            this.contents[n4++] = 0;
            this.contents[n4++] = 0;
            ++n9;
        }
        this.contentsOffset = n4;
        if ((this.produceAttributes & 8) != 0) {
            n9 += this.generateStackMapTableAttribute(null, n5, n, n7, true, methodScope);
        }
        if ((this.produceAttributes & 0x10) != 0) {
            n9 += this.generateStackMapAttribute(null, n5, n, n7, true, methodScope);
        }
        if ((this.produceAttributes & 0x20) != 0) {
            n9 += this.generateTypeAnnotationsOnCodeAttribute();
        }
        if (n8 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n8++] = (byte)(n9 >> 8);
        this.contents[n8] = (byte)n9;
        n3 = this.contentsOffset - (n + 6);
        this.contents[n + 2] = (byte)(n3 >> 24);
        this.contents[n + 3] = (byte)(n3 >> 16);
        this.contents[n + 4] = (byte)(n3 >> 8);
        this.contents[n + 5] = (byte)n3;
    }

    public void completeCodeAttributeForMissingAbstractProblemMethod(MethodBinding methodBinding, int n, int[] nArray, int n2) {
        this.contents = this.codeStream.bCodeStream;
        int n3 = this.codeStream.classFileOffset;
        int n4 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n4 >> 8);
        this.contents[n + 7] = (byte)n4;
        int n5 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n5 >> 8);
        this.contents[n + 9] = (byte)n5;
        int n6 = this.codeStream.position;
        this.contents[n + 10] = (byte)(n6 >> 24);
        this.contents[n + 11] = (byte)(n6 >> 16);
        this.contents[n + 12] = (byte)(n6 >> 8);
        this.contents[n + 13] = (byte)n6;
        if (n3 + 50 >= this.contents.length) {
            this.resizeContents(50);
        }
        this.contents[n3++] = 0;
        this.contents[n3++] = 0;
        int n7 = n3;
        int n8 = 0;
        if ((n3 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contentsOffset = n3;
        if ((this.produceAttributes & 2) != 0) {
            if (n2 == 0) {
                n2 = Util.getLineNumber(methodBinding.sourceStart(), nArray, 0, nArray.length - 1);
            }
            n8 += this.generateLineNumberAttribute(n2);
        }
        if ((this.produceAttributes & 8) != 0) {
            n8 += this.generateStackMapTableAttribute(methodBinding, n6, n, n5, false, null);
        }
        if ((this.produceAttributes & 0x10) != 0) {
            n8 += this.generateStackMapAttribute(methodBinding, n6, n, n5, false, null);
        }
        if (n7 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n7++] = (byte)(n8 >> 8);
        this.contents[n7] = (byte)n8;
        int n9 = this.contentsOffset - (n + 6);
        this.contents[n + 2] = (byte)(n9 >> 24);
        this.contents[n + 3] = (byte)(n9 >> 16);
        this.contents[n + 4] = (byte)(n9 >> 8);
        this.contents[n + 5] = (byte)n9;
    }

    public void completeCodeAttributeForProblemMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, int n, int[] nArray, int n2) {
        int n3;
        this.contents = this.codeStream.bCodeStream;
        int n4 = this.codeStream.classFileOffset;
        int n5 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n5 >> 8);
        this.contents[n + 7] = (byte)n5;
        int n6 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n6 >> 8);
        this.contents[n + 9] = (byte)n6;
        int n7 = this.codeStream.position;
        this.contents[n + 10] = (byte)(n7 >> 24);
        this.contents[n + 11] = (byte)(n7 >> 16);
        this.contents[n + 12] = (byte)(n7 >> 8);
        this.contents[n + 13] = (byte)n7;
        if (n4 + 50 >= this.contents.length) {
            this.resizeContents(50);
        }
        this.contents[n4++] = 0;
        this.contents[n4++] = 0;
        int n8 = n4;
        int n9 = 0;
        if ((n4 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contentsOffset = n4;
        if ((this.produceAttributes & 2) != 0) {
            if (n2 == 0) {
                n2 = Util.getLineNumber(methodBinding.sourceStart(), nArray, 0, nArray.length - 1);
            }
            n9 += this.generateLineNumberAttribute(n2);
        }
        if ((this.produceAttributes & 4) != 0) {
            n3 = this.codeStream.methodDeclaration.isStatic();
            n9 += this.generateLocalVariableTableAttribute(n7, n3 != 0, false);
        }
        if ((this.produceAttributes & 8) != 0) {
            n9 += this.generateStackMapTableAttribute(methodBinding, n7, n, n6, false, null);
        }
        if ((this.produceAttributes & 0x10) != 0) {
            n9 += this.generateStackMapAttribute(methodBinding, n7, n, n6, false, null);
        }
        if (n8 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n8++] = (byte)(n9 >> 8);
        this.contents[n8] = (byte)n9;
        n3 = this.contentsOffset - (n + 6);
        this.contents[n + 2] = (byte)(n3 >> 24);
        this.contents[n + 3] = (byte)(n3 >> 16);
        this.contents[n + 4] = (byte)(n3 >> 8);
        this.contents[n + 5] = (byte)n3;
    }

    public void completeCodeAttributeForSyntheticMethod(boolean bl, SyntheticMethodBinding syntheticMethodBinding, int n, int[] nArray, Scope scope) {
        int n2;
        int n3;
        boolean bl2;
        this.contents = this.codeStream.bCodeStream;
        int n4 = this.codeStream.classFileOffset;
        int n5 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n5 >> 8);
        this.contents[n + 7] = (byte)n5;
        int n6 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n6 >> 8);
        this.contents[n + 9] = (byte)n6;
        int n7 = this.codeStream.position;
        this.contents[n + 10] = (byte)(n7 >> 24);
        this.contents[n + 11] = (byte)(n7 >> 16);
        this.contents[n + 12] = (byte)(n7 >> 8);
        this.contents[n + 13] = (byte)n7;
        if (n4 + 40 >= this.contents.length) {
            this.resizeContents(40);
        }
        boolean bl3 = bl2 = (this.produceAttributes & 8) != 0;
        if (bl) {
            ExceptionLabel[] exceptionLabelArray = this.codeStream.exceptionLabels;
            n3 = 0;
            int n8 = this.codeStream.exceptionLabelsCounter;
            for (n2 = 0; n2 < n8; ++n2) {
                n3 += this.codeStream.exceptionLabels[n2].getCount() / 2;
            }
            n2 = n3 * 8 + 2;
            if (n2 + n4 >= this.contents.length) {
                this.resizeContents(n2);
            }
            this.contents[n4++] = (byte)(n3 >> 8);
            this.contents[n4++] = (byte)n3;
            int n9 = this.codeStream.exceptionLabelsCounter;
            for (n8 = 0; n8 < n9; ++n8) {
                ExceptionLabel exceptionLabel = exceptionLabelArray[n8];
                if (exceptionLabel == null) continue;
                int n10 = 0;
                int n11 = exceptionLabel.getCount();
                if ((n11 & 1) != 0) {
                    this.referenceBinding.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(syntheticMethodBinding.selector), this.referenceBinding.scope.problemReporter().referenceContext));
                }
                while (n10 < n11) {
                    int n12;
                    int n13 = exceptionLabel.ranges[n10++];
                    this.contents[n4++] = (byte)(n13 >> 8);
                    this.contents[n4++] = (byte)n13;
                    int n14 = exceptionLabel.ranges[n10++];
                    this.contents[n4++] = (byte)(n14 >> 8);
                    this.contents[n4++] = (byte)n14;
                    int n15 = exceptionLabel.position;
                    if (bl2) {
                        StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
                        stackMapFrameCodeStream.addFramePosition(n15);
                    }
                    this.contents[n4++] = (byte)(n15 >> 8);
                    this.contents[n4++] = (byte)n15;
                    if (exceptionLabel.exceptionType == null) {
                        this.contents[n4++] = 0;
                        this.contents[n4++] = 0;
                        continue;
                    }
                    switch (exceptionLabel.exceptionType.id) {
                        case 12: {
                            n12 = this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName);
                            break;
                        }
                        case 7: {
                            n12 = this.constantPool.literalIndexForType(ConstantPool.JavaLangNoSuchFieldErrorConstantPoolName);
                            break;
                        }
                        default: {
                            n12 = this.constantPool.literalIndexForType(exceptionLabel.exceptionType);
                        }
                    }
                    this.contents[n4++] = (byte)(n12 >> 8);
                    this.contents[n4++] = (byte)n12;
                }
            }
        } else {
            this.contents[n4++] = 0;
            this.contents[n4++] = 0;
        }
        int n16 = n4;
        n3 = 0;
        if ((n4 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contentsOffset = n4;
        if ((this.produceAttributes & 2) != 0) {
            n2 = Util.getLineNumber(syntheticMethodBinding.sourceStart, nArray, 0, nArray.length - 1);
            n3 += this.generateLineNumberAttribute(n2);
        }
        if ((this.produceAttributes & 4) != 0) {
            n2 = syntheticMethodBinding.isStatic() ? 1 : 0;
            n3 += this.generateLocalVariableTableAttribute(n7, n2 != 0, true);
        }
        if (bl2) {
            n3 += this.generateStackMapTableAttribute(syntheticMethodBinding, n7, n, n6, false, scope);
        }
        if ((this.produceAttributes & 0x10) != 0) {
            n3 += this.generateStackMapAttribute(syntheticMethodBinding, n7, n, n6, false, scope);
        }
        if (n16 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n16++] = (byte)(n3 >> 8);
        this.contents[n16] = (byte)n3;
        n2 = this.contentsOffset - (n + 6);
        this.contents[n + 2] = (byte)(n2 >> 24);
        this.contents[n + 3] = (byte)(n2 >> 16);
        this.contents[n + 4] = (byte)(n2 >> 8);
        this.contents[n + 5] = (byte)n2;
    }

    public void completeCodeAttributeForSyntheticMethod(SyntheticMethodBinding syntheticMethodBinding, int n, int[] nArray) {
        this.completeCodeAttributeForSyntheticMethod(false, syntheticMethodBinding, n, nArray, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope);
    }

    private void completeArgumentAnnotationInfo(Argument[] argumentArray, List<AnnotationContext> list) {
        int n = argumentArray.length;
        for (int i = 0; i < n; ++i) {
            Argument argument = argumentArray[i];
            if ((argument.bits & 0x100000) == 0) continue;
            argument.getAllAnnotationContexts(22, i, list);
        }
    }

    public void completeMethodInfo(MethodBinding methodBinding, int n, int n2) {
        if ((this.produceAttributes & 0x20) != 0) {
            Statement[] statementArray;
            ArrayList<AnnotationContext> arrayList = new ArrayList<AnnotationContext>();
            AbstractMethodDeclaration abstractMethodDeclaration = methodBinding.sourceMethod();
            if (abstractMethodDeclaration != null) {
                int n3;
                Object object;
                Object object2;
                if ((abstractMethodDeclaration.bits & 0x100000) != 0) {
                    statementArray = abstractMethodDeclaration.arguments;
                    if (statementArray != null) {
                        this.completeArgumentAnnotationInfo((Argument[])statementArray, arrayList);
                    }
                    if ((object2 = abstractMethodDeclaration.receiver) != null && (object2.type.bits & 0x100000) != 0) {
                        object2.type.getAllAnnotationContexts(21, arrayList);
                    }
                }
                if ((statementArray = abstractMethodDeclaration.annotations) != null && !abstractMethodDeclaration.isClinit() && (abstractMethodDeclaration.isConstructor() || methodBinding.returnType.id != 6)) {
                    abstractMethodDeclaration.getAllAnnotationContexts(20, arrayList);
                }
                if (!abstractMethodDeclaration.isConstructor() && !abstractMethodDeclaration.isClinit() && methodBinding.returnType.id != 6) {
                    object2 = (MethodDeclaration)abstractMethodDeclaration;
                    object = object2.returnType;
                    if ((((TypeReference)object).bits & 0x100000) != 0) {
                        ((TypeReference)object).getAllAnnotationContexts(20, arrayList);
                    }
                }
                if ((object2 = abstractMethodDeclaration.thrownExceptions) != null) {
                    n3 = ((TypeReference[])object2).length;
                    for (int i = 0; i < n3; ++i) {
                        TypeReference typeReference = object2[i];
                        typeReference.getAllAnnotationContexts(23, i, arrayList);
                    }
                }
                if ((object = abstractMethodDeclaration.typeParameters()) != null) {
                    int n4 = ((TypeParameter[])object).length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        TypeParameter typeParameter = object[n3];
                        if ((typeParameter.bits & 0x100000) == 0) continue;
                        typeParameter.getAllAnnotationContexts(1, n3, arrayList);
                    }
                }
            } else if (methodBinding.sourceLambda() != null) {
                statementArray = methodBinding.sourceLambda();
                if ((statementArray.bits & 0x100000) != 0 && statementArray.arguments != null) {
                    this.completeArgumentAnnotationInfo(statementArray.arguments, arrayList);
                }
            }
            int n5 = arrayList.size();
            n2 = this.completeRuntimeTypeAnnotations(n2, null, aSTNode -> n3 > 0, () -> arrayList);
        }
        if ((this.produceAttributes & 0x40) != 0) {
            n2 += this.generateMethodParameters(methodBinding);
        }
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    private void dumpLocations(int[] nArray) {
        if (nArray == null) {
            if (this.contentsOffset + 1 >= this.contents.length) {
                this.resizeContents(1);
            }
            this.contents[this.contentsOffset++] = 0;
        } else {
            int n = nArray.length;
            if (this.contentsOffset + n >= this.contents.length) {
                this.resizeContents(n + 1);
            }
            this.contents[this.contentsOffset++] = (byte)(nArray.length / 2);
            for (int i = 0; i < n; ++i) {
                this.contents[this.contentsOffset++] = (byte)nArray[i];
            }
        }
    }

    private void dumpTargetTypeContents(int n, AnnotationContext annotationContext) {
        switch (n) {
            case 0: 
            case 1: {
                this.contents[this.contentsOffset++] = (byte)annotationContext.info;
                break;
            }
            case 17: {
                this.contents[this.contentsOffset++] = (byte)annotationContext.info;
                this.contents[this.contentsOffset++] = (byte)annotationContext.info2;
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 22: {
                this.contents[this.contentsOffset++] = (byte)annotationContext.info;
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                this.contents[this.contentsOffset++] = (byte)(annotationContext.info >> 8);
                this.contents[this.contentsOffset++] = (byte)annotationContext.info;
                break;
            }
            case 71: {
                this.contents[this.contentsOffset++] = (byte)(annotationContext.info >> 8);
                this.contents[this.contentsOffset++] = (byte)annotationContext.info;
                this.contents[this.contentsOffset++] = (byte)annotationContext.info2;
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                this.contents[this.contentsOffset++] = (byte)(annotationContext.info >> 8);
                this.contents[this.contentsOffset++] = (byte)annotationContext.info;
                this.contents[this.contentsOffset++] = (byte)annotationContext.info2;
                break;
            }
            case 16: 
            case 23: {
                this.contents[this.contentsOffset++] = (byte)(annotationContext.info >> 8);
                this.contents[this.contentsOffset++] = (byte)annotationContext.info;
                break;
            }
            case 64: 
            case 65: {
                int n2 = this.contentsOffset;
                LocalVariableBinding localVariableBinding = annotationContext.variableBinding;
                int n3 = 0;
                int n4 = localVariableBinding.initializationCount;
                if (this.contentsOffset + (n3 += 2 + 6 * n4) >= this.contents.length) {
                    this.resizeContents(n3);
                }
                this.contentsOffset += 2;
                int n5 = 0;
                for (int i = 0; i < n4; ++i) {
                    int n6 = localVariableBinding.initializationPCs[i << 1];
                    int n7 = localVariableBinding.initializationPCs[(i << 1) + 1];
                    if (n6 == n7) continue;
                    ++n5;
                    this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n6;
                    int n8 = n7 - n6;
                    this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n8;
                    int n9 = localVariableBinding.resolvedPosition;
                    this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n9;
                }
                this.contents[n2++] = (byte)(n5 >> 8);
                this.contents[n2] = (byte)n5;
                break;
            }
            case 18: {
                this.contents[this.contentsOffset++] = (byte)annotationContext.info;
                this.contents[this.contentsOffset++] = (byte)annotationContext.info2;
            }
        }
    }

    public char[] fileName() {
        return this.constantPool.UTF8Cache.returnKeyFor(2);
    }

    private void generateAnnotation(Annotation annotation, int n) {
        TypeBinding typeBinding;
        int n2 = n;
        if (this.contentsOffset + 4 >= this.contents.length) {
            this.resizeContents(4);
        }
        if ((typeBinding = annotation.resolvedType) == null) {
            this.contentsOffset = n2;
            return;
        }
        if (typeBinding.isMemberType()) {
            this.recordInnerClasses(typeBinding);
        }
        int n3 = this.constantPool.literalIndex(typeBinding.signature());
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            MemberValuePair[] memberValuePairArray = normalAnnotation.memberValuePairs;
            int n4 = this.contentsOffset;
            if (memberValuePairArray != null) {
                int n5 = 0;
                int n6 = this.contentsOffset;
                this.contentsOffset += 2;
                int n7 = this.contentsOffset;
                for (MemberValuePair memberValuePair : memberValuePairArray) {
                    if (this.contentsOffset + 2 >= this.contents.length) {
                        this.resizeContents(2);
                    }
                    int n8 = this.constantPool.literalIndex(memberValuePair.name);
                    this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n8;
                    MethodBinding methodBinding = memberValuePair.binding;
                    if (methodBinding == null) {
                        this.contentsOffset = n7;
                        continue;
                    }
                    try {
                        this.generateElementValue(memberValuePair.value, methodBinding.returnType, n4);
                        if (this.contentsOffset == n4) {
                            this.contents[this.contentsOffset++] = 0;
                            this.contents[this.contentsOffset++] = 0;
                            break;
                        }
                        ++n5;
                        n7 = this.contentsOffset;
                    }
                    catch (ClassCastException | ShouldNotImplement runtimeException) {
                        this.contentsOffset = n7;
                    }
                }
                this.contents[n6++] = (byte)(n5 >> 8);
                this.contents[n6++] = (byte)n5;
            } else {
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
            }
        } else if (annotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 1;
            if (this.contentsOffset + 2 >= this.contents.length) {
                this.resizeContents(2);
            }
            int n9 = this.constantPool.literalIndex(VALUE);
            this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
            this.contents[this.contentsOffset++] = (byte)n9;
            MethodBinding methodBinding = singleMemberAnnotation.memberValuePairs()[0].binding;
            if (methodBinding == null) {
                this.contentsOffset = n2;
            } else {
                int n10 = this.contentsOffset;
                try {
                    this.generateElementValue(singleMemberAnnotation.memberValue, methodBinding.returnType, n10);
                    if (this.contentsOffset == n10) {
                        this.contentsOffset = n2;
                    }
                }
                catch (ClassCastException | ShouldNotImplement runtimeException) {
                    this.contentsOffset = n2;
                }
            }
        } else {
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
        }
    }

    private int generateAnnotationDefaultAttribute(AnnotationMethodDeclaration annotationMethodDeclaration, int n) {
        int n2 = 0;
        int n3 = this.constantPool.literalIndex(AttributeNamesConstants.AnnotationDefaultName);
        if (this.contentsOffset + 6 >= this.contents.length) {
            this.resizeContents(6);
        }
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        int n4 = this.contentsOffset;
        this.contentsOffset += 4;
        this.generateElementValue(annotationMethodDeclaration.defaultValue, annotationMethodDeclaration.binding.returnType, n);
        if (this.contentsOffset != n) {
            int n5 = this.contentsOffset - n4 - 4;
            this.contents[n4++] = (byte)(n5 >> 24);
            this.contents[n4++] = (byte)(n5 >> 16);
            this.contents[n4++] = (byte)(n5 >> 8);
            this.contents[n4++] = (byte)n5;
            ++n2;
        }
        return n2;
    }

    public void generateCodeAttributeHeader() {
        if (this.contentsOffset + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n = this.constantPool.literalIndex(AttributeNamesConstants.CodeName);
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        this.contentsOffset += 12;
    }

    private int generateConstantValueAttribute(Constant constant, FieldBinding fieldBinding, int n) {
        int n2 = this.contentsOffset;
        int n3 = 1;
        if (n2 + 8 >= this.contents.length) {
            this.resizeContents(8);
        }
        int n4 = this.constantPool.literalIndex(AttributeNamesConstants.ConstantValueName);
        this.contents[n2++] = (byte)(n4 >> 8);
        this.contents[n2++] = (byte)n4;
        this.contents[n2++] = 0;
        this.contents[n2++] = 0;
        this.contents[n2++] = 0;
        this.contents[n2++] = 2;
        switch (constant.typeID()) {
            case 5: {
                int n5 = this.constantPool.literalIndex(constant.booleanValue() ? 1 : 0);
                this.contents[n2++] = (byte)(n5 >> 8);
                this.contents[n2++] = (byte)n5;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                int n6 = this.constantPool.literalIndex(constant.intValue());
                this.contents[n2++] = (byte)(n6 >> 8);
                this.contents[n2++] = (byte)n6;
                break;
            }
            case 9: {
                int n7 = this.constantPool.literalIndex(constant.floatValue());
                this.contents[n2++] = (byte)(n7 >> 8);
                this.contents[n2++] = (byte)n7;
                break;
            }
            case 8: {
                int n8 = this.constantPool.literalIndex(constant.doubleValue());
                this.contents[n2++] = (byte)(n8 >> 8);
                this.contents[n2++] = (byte)n8;
                break;
            }
            case 7: {
                int n9 = this.constantPool.literalIndex(constant.longValue());
                this.contents[n2++] = (byte)(n9 >> 8);
                this.contents[n2++] = (byte)n9;
                break;
            }
            case 11: {
                int n10 = this.constantPool.literalIndex(((StringConstant)constant).stringValue());
                if (n10 == -1) {
                    if (!this.creatingProblemType) {
                        TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
                        FieldDeclaration[] fieldDeclarationArray = typeDeclaration.fields;
                        int n11 = fieldDeclarationArray == null ? 0 : fieldDeclarationArray.length;
                        for (int i = 0; i < n11; ++i) {
                            if (fieldDeclarationArray[i].binding != fieldBinding) continue;
                            typeDeclaration.scope.problemReporter().stringConstantIsExceedingUtf8Limit(fieldDeclarationArray[i]);
                        }
                        break;
                    }
                    this.contentsOffset = n;
                    n3 = 0;
                    break;
                }
                this.contents[n2++] = (byte)(n10 >> 8);
                this.contents[n2++] = (byte)n10;
            }
        }
        this.contentsOffset = n2;
        return n3;
    }

    private int generateDeprecatedAttribute() {
        int n = this.contentsOffset;
        if (n + 6 >= this.contents.length) {
            this.resizeContents(6);
        }
        int n2 = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contentsOffset = n;
        return 1;
    }

    private int generateNestHostAttribute() {
        SourceTypeBinding sourceTypeBinding = this.referenceBinding.getNestHost();
        if (sourceTypeBinding == null) {
            return 0;
        }
        int n = this.contentsOffset;
        if (n + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        int n2 = this.constantPool.literalIndex(AttributeNamesConstants.NestHost);
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 2;
        int n3 = this.constantPool.literalIndexForType(sourceTypeBinding.constantPoolName());
        this.contents[n++] = (byte)(n3 >> 8);
        this.contents[n++] = (byte)n3;
        this.contentsOffset = n;
        return 1;
    }

    private int generateNestMembersAttribute() {
        int n;
        int n2 = this.contentsOffset;
        List<String> list = this.referenceBinding.getNestMembers();
        int n3 = n = list != null ? list.size() : 0;
        if (n == 0) {
            return 0;
        }
        int n4 = 8 + 2 * n;
        if (n4 + n2 >= this.contents.length) {
            this.resizeContents(n4);
        }
        int n5 = this.constantPool.literalIndex(AttributeNamesConstants.NestMembers);
        this.contents[n2++] = (byte)(n5 >> 8);
        this.contents[n2++] = (byte)n5;
        int n6 = (n << 1) + 2;
        this.contents[n2++] = (byte)(n6 >> 24);
        this.contents[n2++] = (byte)(n6 >> 16);
        this.contents[n2++] = (byte)(n6 >> 8);
        this.contents[n2++] = (byte)n6;
        this.contents[n2++] = (byte)(n >> 8);
        this.contents[n2++] = (byte)n;
        for (int i = 0; i < n; ++i) {
            char[] cArray = list.get(i).toCharArray();
            int n7 = this.constantPool.literalIndexForType(cArray);
            this.contents[n2++] = (byte)(n7 >> 8);
            this.contents[n2++] = (byte)n7;
        }
        this.contentsOffset = n2;
        return 1;
    }

    private int generateNestAttributes() {
        int n = this.generateNestMembersAttribute();
        return n += this.generateNestHostAttribute();
    }

    private int generatePermittedTypeAttributes() {
        int n;
        SourceTypeBinding sourceTypeBinding = this.referenceBinding;
        int n2 = this.contentsOffset;
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.permittedTypes();
        int n3 = n = referenceBindingArray != null ? referenceBindingArray.length : 0;
        if (n == 0) {
            return 0;
        }
        int n4 = 8 + 2 * n;
        if (n4 + n2 >= this.contents.length) {
            this.resizeContents(n4);
        }
        int n5 = this.constantPool.literalIndex(AttributeNamesConstants.PermittedSubclasses);
        this.contents[n2++] = (byte)(n5 >> 8);
        this.contents[n2++] = (byte)n5;
        int n6 = (n << 1) + 2;
        this.contents[n2++] = (byte)(n6 >> 24);
        this.contents[n2++] = (byte)(n6 >> 16);
        this.contents[n2++] = (byte)(n6 >> 8);
        this.contents[n2++] = (byte)n6;
        this.contents[n2++] = (byte)(n >> 8);
        this.contents[n2++] = (byte)n;
        for (int i = 0; i < n; ++i) {
            int n7 = this.constantPool.literalIndexForType(referenceBindingArray[i]);
            this.contents[n2++] = (byte)(n7 >> 8);
            this.contents[n2++] = (byte)n7;
        }
        this.contentsOffset = n2;
        return 1;
    }

    private int generateRecordAttributes() {
        int n;
        SourceTypeBinding sourceTypeBinding = this.referenceBinding;
        if (sourceTypeBinding == null || !sourceTypeBinding.isRecord()) {
            return 0;
        }
        int n2 = this.contentsOffset;
        RecordComponentBinding[] recordComponentBindingArray = this.referenceBinding.components();
        if (recordComponentBindingArray == null) {
            return 0;
        }
        int n3 = recordComponentBindingArray.length;
        int n4 = 8 + 2 * n3;
        if (n4 + n2 >= this.contents.length) {
            this.resizeContents(n4);
        }
        int n5 = this.constantPool.literalIndex(AttributeNamesConstants.RecordClass);
        this.contents[n2++] = (byte)(n5 >> 8);
        this.contents[n2++] = (byte)n5;
        int n6 = n2;
        int n7 = n2 += 4;
        this.contents[n2++] = (byte)(n3 >> 8);
        this.contents[n2++] = (byte)n3;
        this.contentsOffset = n2;
        for (n = 0; n < n3; ++n) {
            this.addComponentInfo(recordComponentBindingArray[n]);
        }
        n = this.contentsOffset - n7;
        this.contents[n6++] = (byte)(n >> 24);
        this.contents[n6++] = (byte)(n >> 16);
        this.contents[n6++] = (byte)(n >> 8);
        this.contents[n6++] = (byte)n;
        return 1;
    }

    private int generateModuleAttribute(ModuleDeclaration moduleDeclaration) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Object object;
        int n9;
        SourceModuleBinding sourceModuleBinding = moduleDeclaration.binding;
        int n10 = this.contentsOffset;
        if (n10 + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        int n11 = this.constantPool.literalIndex(AttributeNamesConstants.ModuleName);
        this.contents[n10++] = (byte)(n11 >> 8);
        this.contents[n10++] = (byte)n11;
        int n12 = n10;
        n10 += 4;
        int n13 = this.constantPool.literalIndexForModule(sourceModuleBinding.moduleName);
        this.contents[n10++] = (byte)(n13 >> 8);
        this.contents[n10++] = (byte)n13;
        int n14 = moduleDeclaration.modifiers & 0xFFFF7FFF;
        this.contents[n10++] = (byte)(n14 >> 8);
        this.contents[n10++] = (byte)n14;
        String string = moduleDeclaration.getModuleVersion();
        int n15 = string == null ? 0 : this.constantPool.literalIndex(string.toCharArray());
        this.contents[n10++] = (byte)(n15 >> 8);
        this.contents[n10++] = (byte)n15;
        int n16 = 6;
        int n17 = n10;
        int n18 = moduleDeclaration.requiresCount;
        int n19 = 2 + n18 * 6;
        if (n10 + n19 >= this.contents.length) {
            this.resizeContents(n19);
        }
        n10 += 2;
        ModuleBinding moduleBinding = null;
        for (n9 = 0; n9 < moduleDeclaration.requiresCount; ++n9) {
            RequiresStatement requiresStatement = moduleDeclaration.requires[n9];
            object = requiresStatement.resolvedBinding;
            if (CharOperation.equals(((ModuleBinding)object).moduleName, TypeConstants.JAVA_BASE)) {
                moduleBinding = object;
            }
            n8 = this.constantPool.literalIndexForModule(((ModuleBinding)object).moduleName);
            this.contents[n10++] = (byte)(n8 >> 8);
            this.contents[n10++] = (byte)n8;
            n14 = requiresStatement.modifiers;
            this.contents[n10++] = (byte)(n14 >> 8);
            this.contents[n10++] = (byte)n14;
            n7 = 0;
            this.contents[n10++] = (byte)(n7 >> 8);
            this.contents[n10++] = (byte)n7;
        }
        if (!CharOperation.equals(sourceModuleBinding.moduleName, TypeConstants.JAVA_BASE) && moduleBinding == null) {
            if (n10 + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            moduleBinding = sourceModuleBinding.environment.javaBaseModule();
            n9 = this.constantPool.literalIndexForModule(moduleBinding.moduleName);
            this.contents[n10++] = (byte)(n9 >> 8);
            this.contents[n10++] = (byte)n9;
            n14 = 32768;
            this.contents[n10++] = (byte)(n14 >> 8);
            this.contents[n10++] = (byte)n14;
            int n20 = 0;
            this.contents[n10++] = (byte)(n20 >> 8);
            this.contents[n10++] = (byte)n20;
            ++n18;
        }
        this.contents[n17++] = (byte)(n18 >> 8);
        this.contents[n17++] = (byte)n18;
        n16 += 2 + 6 * n18;
        n9 = 2 + moduleDeclaration.exportsCount * 6;
        if (n10 + n9 >= this.contents.length) {
            this.resizeContents(n9);
        }
        this.contents[n10++] = (byte)(moduleDeclaration.exportsCount >> 8);
        this.contents[n10++] = (byte)moduleDeclaration.exportsCount;
        for (n6 = 0; n6 < moduleDeclaration.exportsCount; ++n6) {
            object = moduleDeclaration.exports[n6];
            if (n10 + 6 >= this.contents.length) {
                this.resizeContents((moduleDeclaration.exportsCount - n6) * 6);
            }
            n8 = this.constantPool.literalIndexForPackage(CharOperation.replaceOnCopy(((ExportsStatement)object).pkgName, '.', '/'));
            this.contents[n10++] = (byte)(n8 >> 8);
            this.contents[n10++] = (byte)n8;
            this.contents[n10++] = 0;
            this.contents[n10++] = 0;
            n7 = ((PackageVisibilityStatement)object).isQualified() ? ((ExportsStatement)object).targets.length : 0;
            this.contents[n10++] = (byte)(n7 >> 8);
            this.contents[n10++] = (byte)n7;
            if (n7 <= 0) continue;
            n5 = 2 * n7;
            if (n10 + n5 >= this.contents.length) {
                this.resizeContents(n5);
            }
            for (n4 = 0; n4 < n7; ++n4) {
                n8 = this.constantPool.literalIndexForModule(((ExportsStatement)object).targets[n4].moduleName);
                this.contents[n10++] = (byte)(n8 >> 8);
                this.contents[n10++] = (byte)n8;
            }
            n16 += n5;
        }
        n16 += n9;
        n6 = 2 + moduleDeclaration.opensCount * 6;
        if (n10 + n6 >= this.contents.length) {
            this.resizeContents(n6);
        }
        this.contents[n10++] = (byte)(moduleDeclaration.opensCount >> 8);
        this.contents[n10++] = (byte)moduleDeclaration.opensCount;
        for (n3 = 0; n3 < moduleDeclaration.opensCount; ++n3) {
            OpensStatement opensStatement = moduleDeclaration.opens[n3];
            if (n10 + 6 >= this.contents.length) {
                this.resizeContents((moduleDeclaration.opensCount - n3) * 6);
            }
            n7 = this.constantPool.literalIndexForPackage(CharOperation.replaceOnCopy(opensStatement.pkgName, '.', '/'));
            this.contents[n10++] = (byte)(n7 >> 8);
            this.contents[n10++] = (byte)n7;
            this.contents[n10++] = 0;
            this.contents[n10++] = 0;
            n5 = opensStatement.isQualified() ? opensStatement.targets.length : 0;
            this.contents[n10++] = (byte)(n5 >> 8);
            this.contents[n10++] = (byte)n5;
            if (n5 <= 0) continue;
            n4 = 2 * n5;
            if (n10 + n4 >= this.contents.length) {
                this.resizeContents(n4);
            }
            for (n2 = 0; n2 < n5; ++n2) {
                n7 = this.constantPool.literalIndexForModule(opensStatement.targets[n2].moduleName);
                this.contents[n10++] = (byte)(n7 >> 8);
                this.contents[n10++] = (byte)n7;
            }
            n16 += n4;
        }
        n16 += n6;
        n3 = 2 + 2 * moduleDeclaration.usesCount;
        if (n10 + n3 >= this.contents.length) {
            this.resizeContents(n3);
        }
        this.contents[n10++] = (byte)(moduleDeclaration.usesCount >> 8);
        this.contents[n10++] = (byte)moduleDeclaration.usesCount;
        for (n = 0; n < moduleDeclaration.usesCount; ++n) {
            n7 = this.constantPool.literalIndexForType(moduleDeclaration.uses[n].serviceInterface.resolvedType.constantPoolName());
            this.contents[n10++] = (byte)(n7 >> 8);
            this.contents[n10++] = (byte)n7;
        }
        n16 += n3;
        n = 2 + 4 * moduleDeclaration.servicesCount;
        if (n10 + n >= this.contents.length) {
            this.resizeContents(n);
        }
        this.contents[n10++] = (byte)(moduleDeclaration.servicesCount >> 8);
        this.contents[n10++] = (byte)moduleDeclaration.servicesCount;
        for (n7 = 0; n7 < moduleDeclaration.servicesCount; ++n7) {
            if (n10 + 4 >= this.contents.length) {
                this.resizeContents((moduleDeclaration.servicesCount - n7) * 4);
            }
            n5 = this.constantPool.literalIndexForType(moduleDeclaration.services[n7].serviceInterface.resolvedType.constantPoolName());
            this.contents[n10++] = (byte)(n5 >> 8);
            this.contents[n10++] = (byte)n5;
            TypeReference[] typeReferenceArray = moduleDeclaration.services[n7].implementations;
            n2 = typeReferenceArray.length;
            this.contents[n10++] = (byte)(n2 >> 8);
            this.contents[n10++] = (byte)n2;
            int n21 = n2 * 2;
            if (n10 + n21 >= this.contents.length) {
                this.resizeContents(n21);
            }
            for (int i = 0; i < n2; ++i) {
                n5 = this.constantPool.literalIndexForType(typeReferenceArray[i].resolvedType.constantPoolName());
                this.contents[n10++] = (byte)(n5 >> 8);
                this.contents[n10++] = (byte)n5;
            }
            n16 += n21;
        }
        this.contents[n12++] = (byte)((n16 += n) >> 24);
        this.contents[n12++] = (byte)(n16 >> 16);
        this.contents[n12++] = (byte)(n16 >> 8);
        this.contents[n12++] = (byte)n16;
        this.contentsOffset = n10;
        return 1;
    }

    private int generateModuleMainClassAttribute(char[] cArray) {
        int n = this.contentsOffset;
        if (n + 8 >= this.contents.length) {
            this.resizeContents(8);
        }
        int n2 = this.constantPool.literalIndex(AttributeNamesConstants.ModuleMainClass);
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        int n3 = 2;
        this.contents[n++] = (byte)(n3 >> 24);
        this.contents[n++] = (byte)(n3 >> 16);
        this.contents[n++] = (byte)(n3 >> 8);
        this.contents[n++] = (byte)n3;
        int n4 = this.constantPool.literalIndexForType(cArray);
        this.contents[n++] = (byte)(n4 >> 8);
        this.contents[n++] = (byte)n4;
        this.contentsOffset = n;
        return 1;
    }

    private int generateModulePackagesAttribute(char[][] cArray) {
        int n = this.contentsOffset;
        int n2 = 6 + 2 * cArray.length;
        if (n + n2 >= this.contents.length) {
            this.resizeContents(n2);
        }
        int n3 = this.constantPool.literalIndex(AttributeNamesConstants.ModulePackages);
        this.contents[n++] = (byte)(n3 >> 8);
        this.contents[n++] = (byte)n3;
        int n4 = n;
        int n5 = n += 4;
        n += 2;
        int n6 = 0;
        for (char[] cArray2 : cArray) {
            if (cArray2 == null || cArray2.length == 0) continue;
            int n7 = this.constantPool.literalIndexForPackage(cArray2);
            this.contents[n++] = (byte)(n7 >> 8);
            this.contents[n++] = (byte)n7;
            ++n6;
        }
        this.contents[n5++] = (byte)(n6 >> 8);
        this.contents[n5++] = (byte)n6;
        int n8 = 2 + 2 * n6;
        this.contents[n4++] = (byte)(n8 >> 24);
        this.contents[n4++] = (byte)(n8 >> 16);
        this.contents[n4++] = (byte)(n8 >> 8);
        this.contents[n4++] = (byte)n8;
        this.contentsOffset = n;
        return 1;
    }

    private void generateElementValue(Expression expression, TypeBinding typeBinding, int n) {
        Constant constant = expression.constant;
        TypeBinding typeBinding2 = expression.resolvedType;
        if (typeBinding2 == null) {
            this.contentsOffset = n;
        } else {
            if (typeBinding2.isMemberType()) {
                this.recordInnerClasses(typeBinding2);
            }
            if (typeBinding.isMemberType()) {
                this.recordInnerClasses(typeBinding);
            }
            if (typeBinding.isArrayType() && !typeBinding2.isArrayType()) {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 91;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 1;
            }
            if (constant != null && constant != Constant.NotAConstant) {
                this.generateElementValue(n, expression, constant, typeBinding.leafComponentType());
            } else {
                this.generateElementValueForNonConstantExpression(expression, n, typeBinding2);
            }
        }
    }

    private void generateElementValue(int n, Expression expression, Constant constant, TypeBinding typeBinding) {
        if (this.contentsOffset + 3 >= this.contents.length) {
            this.resizeContents(3);
        }
        switch (typeBinding.id) {
            case 5: {
                this.contents[this.contentsOffset++] = 90;
                int n2 = this.constantPool.literalIndex(constant.booleanValue() ? 1 : 0);
                this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
                this.contents[this.contentsOffset++] = (byte)n2;
                break;
            }
            case 3: {
                this.contents[this.contentsOffset++] = 66;
                int n3 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
                this.contents[this.contentsOffset++] = (byte)n3;
                break;
            }
            case 2: {
                this.contents[this.contentsOffset++] = 67;
                int n4 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
                this.contents[this.contentsOffset++] = (byte)n4;
                break;
            }
            case 10: {
                this.contents[this.contentsOffset++] = 73;
                int n5 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
                this.contents[this.contentsOffset++] = (byte)n5;
                break;
            }
            case 4: {
                this.contents[this.contentsOffset++] = 83;
                int n6 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
                this.contents[this.contentsOffset++] = (byte)n6;
                break;
            }
            case 9: {
                this.contents[this.contentsOffset++] = 70;
                int n7 = this.constantPool.literalIndex(constant.floatValue());
                this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
                this.contents[this.contentsOffset++] = (byte)n7;
                break;
            }
            case 8: {
                this.contents[this.contentsOffset++] = 68;
                int n8 = this.constantPool.literalIndex(constant.doubleValue());
                this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
                this.contents[this.contentsOffset++] = (byte)n8;
                break;
            }
            case 7: {
                this.contents[this.contentsOffset++] = 74;
                int n9 = this.constantPool.literalIndex(constant.longValue());
                this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
                this.contents[this.contentsOffset++] = (byte)n9;
                break;
            }
            case 11: {
                this.contents[this.contentsOffset++] = 115;
                int n10 = this.constantPool.literalIndex(((StringConstant)constant).stringValue().toCharArray());
                if (n10 == -1) {
                    if (!this.creatingProblemType) {
                        TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
                        typeDeclaration.scope.problemReporter().stringConstantIsExceedingUtf8Limit(expression);
                        break;
                    }
                    this.contentsOffset = n;
                    break;
                }
                this.contents[this.contentsOffset++] = (byte)(n10 >> 8);
                this.contents[this.contentsOffset++] = (byte)n10;
            }
        }
    }

    private void generateElementValueForNonConstantExpression(Expression expression, int n, TypeBinding typeBinding) {
        if (typeBinding != null) {
            if (typeBinding.isEnum()) {
                NameReference nameReference;
                if (this.contentsOffset + 5 >= this.contents.length) {
                    this.resizeContents(5);
                }
                this.contents[this.contentsOffset++] = 101;
                FieldBinding fieldBinding = null;
                if (expression instanceof QualifiedNameReference) {
                    nameReference = (QualifiedNameReference)expression;
                    fieldBinding = (FieldBinding)nameReference.binding;
                } else if (expression instanceof SingleNameReference) {
                    nameReference = (SingleNameReference)expression;
                    fieldBinding = (FieldBinding)((SingleNameReference)nameReference).binding;
                } else {
                    this.contentsOffset = n;
                }
                if (fieldBinding != null) {
                    int n2 = this.constantPool.literalIndex(fieldBinding.type.signature());
                    int n3 = this.constantPool.literalIndex(fieldBinding.name);
                    this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n2;
                    this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n3;
                }
            } else if (typeBinding.isAnnotationType()) {
                if (this.contentsOffset + 1 >= this.contents.length) {
                    this.resizeContents(1);
                }
                this.contents[this.contentsOffset++] = 64;
                this.generateAnnotation((Annotation)expression, n);
            } else if (typeBinding.isArrayType()) {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 91;
                if (expression instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                    int n4 = arrayInitializer.expressions != null ? arrayInitializer.expressions.length : 0;
                    this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n4;
                    for (int i = 0; i < n4; ++i) {
                        this.generateElementValue(arrayInitializer.expressions[i], typeBinding.leafComponentType(), n);
                    }
                } else {
                    this.contentsOffset = n;
                }
            } else {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 99;
                if (expression instanceof ClassLiteralAccess) {
                    ClassLiteralAccess classLiteralAccess = (ClassLiteralAccess)expression;
                    int n5 = this.constantPool.literalIndex(classLiteralAccess.targetType.signature());
                    this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n5;
                } else {
                    this.contentsOffset = n;
                }
            }
        } else {
            this.contentsOffset = n;
        }
    }

    private int generateEnclosingMethodAttribute() {
        MethodBinding methodBinding;
        int n = this.contentsOffset;
        if (n + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        int n2 = this.constantPool.literalIndex(AttributeNamesConstants.EnclosingMethodName);
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 4;
        int n3 = this.constantPool.literalIndexForType(this.referenceBinding.enclosingType().constantPoolName());
        this.contents[n++] = (byte)(n3 >> 8);
        this.contents[n++] = (byte)n3;
        byte by = 0;
        byte by2 = 0;
        if (this.referenceBinding instanceof LocalTypeBinding && (methodBinding = ((LocalTypeBinding)this.referenceBinding).enclosingMethod) != null) {
            int n4 = this.constantPool.literalIndexForNameAndType(methodBinding.selector, methodBinding.signature(this));
            by = (byte)(n4 >> 8);
            by2 = (byte)n4;
        }
        this.contents[n++] = by;
        this.contents[n++] = by2;
        this.contentsOffset = n;
        return 1;
    }

    private int generateExceptionsAttribute(ReferenceBinding[] referenceBindingArray) {
        int n = this.contentsOffset;
        int n2 = referenceBindingArray.length;
        int n3 = 8 + n2 * 2;
        if (n3 + this.contentsOffset >= this.contents.length) {
            this.resizeContents(n3);
        }
        int n4 = this.constantPool.literalIndex(AttributeNamesConstants.ExceptionsName);
        this.contents[n++] = (byte)(n4 >> 8);
        this.contents[n++] = (byte)n4;
        int n5 = n2 * 2 + 2;
        this.contents[n++] = (byte)(n5 >> 24);
        this.contents[n++] = (byte)(n5 >> 16);
        this.contents[n++] = (byte)(n5 >> 8);
        this.contents[n++] = (byte)n5;
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        for (int i = 0; i < n2; ++i) {
            int n6 = this.constantPool.literalIndexForType(referenceBindingArray[i]);
            this.contents[n++] = (byte)(n6 >> 8);
            this.contents[n++] = (byte)n6;
        }
        this.contentsOffset = n;
        return 1;
    }

    private int generateHierarchyInconsistentAttribute() {
        int n = this.contentsOffset;
        if (n + 6 >= this.contents.length) {
            this.resizeContents(6);
        }
        int n2 = this.constantPool.literalIndex(AttributeNamesConstants.InconsistentHierarchy);
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contentsOffset = n;
        return 1;
    }

    private int generateInnerClassAttribute(int n, ReferenceBinding[] referenceBindingArray) {
        int n2 = 8 * n + 8;
        int n3 = this.contentsOffset;
        if (n2 + n3 >= this.contents.length) {
            this.resizeContents(n2);
        }
        int n4 = this.constantPool.literalIndex(AttributeNamesConstants.InnerClassName);
        this.contents[n3++] = (byte)(n4 >> 8);
        this.contents[n3++] = (byte)n4;
        int n5 = (n << 3) + 2;
        this.contents[n3++] = (byte)(n5 >> 24);
        this.contents[n3++] = (byte)(n5 >> 16);
        this.contents[n3++] = (byte)(n5 >> 8);
        this.contents[n3++] = (byte)n5;
        this.contents[n3++] = (byte)(n >> 8);
        this.contents[n3++] = (byte)n;
        for (int i = 0; i < n; ++i) {
            int n6;
            ReferenceBinding referenceBinding = referenceBindingArray[i];
            int n7 = referenceBinding.getAccessFlags();
            int n8 = this.constantPool.literalIndexForType(referenceBinding.constantPoolName());
            this.contents[n3++] = (byte)(n8 >> 8);
            this.contents[n3++] = (byte)n8;
            if (referenceBinding.isMemberType()) {
                n6 = this.constantPool.literalIndexForType(referenceBinding.enclosingType().constantPoolName());
                this.contents[n3++] = (byte)(n6 >> 8);
                this.contents[n3++] = (byte)n6;
            } else {
                this.contents[n3++] = 0;
                this.contents[n3++] = 0;
            }
            if (!referenceBinding.isAnonymousType()) {
                n6 = this.constantPool.literalIndex(referenceBinding.sourceName());
                this.contents[n3++] = (byte)(n6 >> 8);
                this.contents[n3++] = (byte)n6;
            } else {
                this.contents[n3++] = 0;
                this.contents[n3++] = 0;
            }
            if (referenceBinding.isAnonymousType()) {
                n7 &= 0xFFFFFFEF;
            } else if (referenceBinding.isMemberType() && referenceBinding.isInterface()) {
                n7 |= 8;
            }
            this.contents[n3++] = (byte)(n7 >> 8);
            this.contents[n3++] = (byte)n7;
        }
        this.contentsOffset = n3;
        return 1;
    }

    private Map<String, Integer> createInitBootStrapMethodsMap() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(BOOTSTRAP_METHODS.length);
        for (String string : BOOTSTRAP_METHODS) {
            hashMap.put(string, 0);
        }
        return hashMap;
    }

    private int generateBootstrapMethods(List<ASTNode> list) {
        int n;
        ReferenceBinding referenceBinding = this.referenceBinding.scope.getJavaLangInvokeMethodHandlesLookup();
        if (referenceBinding == null) {
            return 0;
        }
        this.recordInnerClasses(referenceBinding);
        int n2 = list != null ? list.size() : 0;
        int n3 = this.contentsOffset;
        int n4 = 10 * n2 + 8;
        if (n4 + n3 >= this.contents.length) {
            this.resizeContents(n4);
        }
        int n5 = this.constantPool.literalIndex(AttributeNamesConstants.BootstrapMethodsName);
        this.contents[n3++] = (byte)(n5 >> 8);
        this.contents[n3++] = (byte)n5;
        int n6 = n3;
        n3 += 4;
        this.contents[n3++] = (byte)(n2 >> 8);
        this.contents[n3++] = (byte)n2;
        Map<String, Integer> map = this.createInitBootStrapMethodsMap();
        for (n = 0; n < n2; ++n) {
            ASTNode aSTNode = this.bootstrapMethods.get(n);
            if (aSTNode instanceof FunctionalExpression) {
                n3 = this.addBootStrapLambdaEntry(n3, (FunctionalExpression)aSTNode, map);
                continue;
            }
            if (!(aSTNode instanceof TypeDeclaration)) continue;
            n3 = this.addBootStrapRecordEntry(n3, (TypeDeclaration)aSTNode, map);
        }
        n = n3 - n6 - 4;
        this.contents[n6++] = (byte)(n >> 24);
        this.contents[n6++] = (byte)(n >> 16);
        this.contents[n6++] = (byte)(n >> 8);
        this.contents[n6++] = (byte)n;
        this.contentsOffset = n3;
        return 1;
    }

    private int addBootStrapLambdaEntry(int n, FunctionalExpression functionalExpression, Map<String, Integer> map) {
        MethodBinding[] methodBindingArray = functionalExpression.getRequiredBridges();
        TypeBinding[] typeBindingArray = null;
        int n2 = map.get(ALTMETAFACTORY_STRING);
        int n3 = map.get(METAFACTORY_STRING);
        if (functionalExpression instanceof LambdaExpression && (typeBindingArray = ((LambdaExpression)functionalExpression).getMarkerInterfaces()) != null || methodBindingArray != null || functionalExpression.isSerializable) {
            int n4;
            int n5;
            int n6;
            int n7 = 2;
            if (typeBindingArray != null) {
                n7 += 2 + 2 * typeBindingArray.length;
            }
            if (methodBindingArray != null) {
                n7 += 2 + 2 * methodBindingArray.length;
            }
            if (n7 + 10 + n >= this.contents.length) {
                this.resizeContents(n7 + 10);
            }
            if (n2 == 0) {
                ReferenceBinding referenceBinding = this.referenceBinding.scope.getJavaLangInvokeLambdaMetafactory();
                n2 = this.constantPool.literalIndexForMethodHandle(6, referenceBinding, ConstantPool.ALTMETAFACTORY, ConstantPool.JAVA_LANG_INVOKE_LAMBDAMETAFACTORY_ALTMETAFACTORY_SIGNATURE, false);
                map.put(ALTMETAFACTORY_STRING, n2);
            }
            this.contents[n++] = (byte)(n2 >> 8);
            this.contents[n++] = (byte)n2;
            this.contents[n++] = 0;
            this.contents[n++] = (byte)(4 + (typeBindingArray == null ? 0 : 1 + typeBindingArray.length) + (methodBindingArray == null ? 0 : 1 + methodBindingArray.length));
            int n8 = this.constantPool.literalIndexForMethodType(functionalExpression.descriptor.original().signature());
            this.contents[n++] = (byte)(n8 >> 8);
            this.contents[n++] = (byte)n8;
            int n9 = this.constantPool.literalIndexForMethodHandle(functionalExpression.binding.original());
            this.contents[n++] = (byte)(n9 >> 8);
            this.contents[n++] = (byte)n9;
            char[] cArray = functionalExpression.descriptor.signature();
            int n10 = this.constantPool.literalIndexForMethodType(cArray);
            this.contents[n++] = (byte)(n10 >> 8);
            this.contents[n++] = (byte)n10;
            int n11 = 0;
            if (functionalExpression.isSerializable) {
                n11 |= 1;
            }
            if (typeBindingArray != null) {
                n11 |= 2;
            }
            if (methodBindingArray != null) {
                n11 |= 4;
            }
            int n12 = this.constantPool.literalIndex(n11);
            this.contents[n++] = (byte)(n12 >> 8);
            this.contents[n++] = (byte)n12;
            if (typeBindingArray != null) {
                n6 = this.constantPool.literalIndex(typeBindingArray.length);
                this.contents[n++] = (byte)(n6 >> 8);
                this.contents[n++] = (byte)n6;
                n5 = typeBindingArray.length;
                for (n4 = 0; n4 < n5; ++n4) {
                    int n13 = this.constantPool.literalIndexForType(typeBindingArray[n4]);
                    this.contents[n++] = (byte)(n13 >> 8);
                    this.contents[n++] = (byte)n13;
                }
            }
            if (methodBindingArray != null) {
                n6 = this.constantPool.literalIndex(methodBindingArray.length);
                this.contents[n++] = (byte)(n6 >> 8);
                this.contents[n++] = (byte)n6;
                n5 = methodBindingArray.length;
                for (n4 = 0; n4 < n5; ++n4) {
                    char[] cArray2 = methodBindingArray[n4].signature();
                    int n14 = this.constantPool.literalIndexForMethodType(cArray2);
                    this.contents[n++] = (byte)(n14 >> 8);
                    this.contents[n++] = (byte)n14;
                }
            }
        } else {
            if (10 + n >= this.contents.length) {
                this.resizeContents(10);
            }
            if (n3 == 0) {
                ReferenceBinding referenceBinding = this.referenceBinding.scope.getJavaLangInvokeLambdaMetafactory();
                n3 = this.constantPool.literalIndexForMethodHandle(6, referenceBinding, ConstantPool.METAFACTORY, ConstantPool.JAVA_LANG_INVOKE_LAMBDAMETAFACTORY_METAFACTORY_SIGNATURE, false);
                map.put(METAFACTORY_STRING, n3);
            }
            this.contents[n++] = (byte)(n3 >> 8);
            this.contents[n++] = (byte)n3;
            this.contents[n++] = 0;
            this.contents[n++] = 3;
            int n15 = this.constantPool.literalIndexForMethodType(functionalExpression.descriptor.original().signature());
            this.contents[n++] = (byte)(n15 >> 8);
            this.contents[n++] = (byte)n15;
            int n16 = this.constantPool.literalIndexForMethodHandle(functionalExpression.binding instanceof PolymorphicMethodBinding ? functionalExpression.binding : functionalExpression.binding.original());
            this.contents[n++] = (byte)(n16 >> 8);
            this.contents[n++] = (byte)n16;
            char[] cArray = functionalExpression.descriptor.signature();
            int n17 = this.constantPool.literalIndexForMethodType(cArray);
            this.contents[n++] = (byte)(n17 >> 8);
            this.contents[n++] = (byte)n17;
        }
        return n;
    }

    private int addBootStrapRecordEntry(int n, TypeDeclaration typeDeclaration, Map<String, Integer> map) {
        SourceTypeBinding sourceTypeBinding = typeDeclaration.binding;
        assert (((TypeBinding)sourceTypeBinding).isRecord());
        int n2 = map.get(BOOTSTRAP_STRING);
        if (10 + n >= this.contents.length) {
            this.resizeContents(10);
        }
        if (n2 == 0) {
            ReferenceBinding referenceBinding = this.referenceBinding.scope.getJavaLangRuntimeObjectMethods();
            n2 = this.constantPool.literalIndexForMethodHandle(6, referenceBinding, ConstantPool.BOOTSTRAP, ConstantPool.JAVA_LANG_RUNTIME_OBJECTMETHOD_BOOTSTRAP_SIGNATURE, false);
            map.put(BOOTSTRAP_STRING, n2);
        }
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        int n3 = n;
        n += 2;
        char[] cArray = ((TypeBinding)sourceTypeBinding).constantPoolName();
        int n4 = this.constantPool.literalIndexForType(cArray);
        this.contents[n++] = (byte)(n4 >> 8);
        this.contents[n++] = (byte)n4;
        assert (sourceTypeBinding instanceof SourceTypeBinding);
        SourceTypeBinding sourceTypeBinding2 = sourceTypeBinding;
        FieldBinding[] fieldBindingArray = sourceTypeBinding2.getImplicitComponentFields();
        int n5 = 2 + fieldBindingArray.length;
        this.contents[n3++] = (byte)(n5 >> 8);
        this.contents[n3] = (byte)n5;
        String string3 = Arrays.stream(fieldBindingArray).map(fieldBinding -> new String(fieldBinding.name)).reduce((string, string2) -> string + ";" + string2).orElse(Util.EMPTY_STRING);
        int n6 = this.constantPool.literalIndex(string3);
        this.contents[n++] = (byte)(n6 >> 8);
        this.contents[n++] = (byte)n6;
        if (fieldBindingArray.length * 2 + n >= this.contents.length) {
            this.resizeContents(fieldBindingArray.length * 2);
        }
        for (FieldBinding fieldBinding2 : fieldBindingArray) {
            int n7 = this.constantPool.literalIndexForMethodHandleFieldRef(1, cArray, fieldBinding2.name, fieldBinding2.type.signature());
            this.contents[n++] = (byte)(n7 >> 8);
            this.contents[n++] = (byte)n7;
        }
        return n;
    }

    private int generateLineNumberAttribute() {
        int n = this.contentsOffset;
        int n2 = 0;
        int[] nArray = this.codeStream.pcToSourceMap;
        if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
            int n3 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            if (n + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[n++] = (byte)(n3 >> 8);
            this.contents[n++] = (byte)n3;
            int n4 = n;
            n += 6;
            int n5 = 0;
            int n6 = this.codeStream.pcToSourceMapSize;
            int n7 = 0;
            while (n7 < n6) {
                if (n + 4 >= this.contents.length) {
                    this.resizeContents(4);
                }
                int n8 = nArray[n7++];
                this.contents[n++] = (byte)(n8 >> 8);
                this.contents[n++] = (byte)n8;
                int n9 = nArray[n7++];
                this.contents[n++] = (byte)(n9 >> 8);
                this.contents[n++] = (byte)n9;
                ++n5;
            }
            n7 = n5 * 4 + 2;
            this.contents[n4++] = (byte)(n7 >> 24);
            this.contents[n4++] = (byte)(n7 >> 16);
            this.contents[n4++] = (byte)(n7 >> 8);
            this.contents[n4++] = (byte)n7;
            this.contents[n4++] = (byte)(n5 >> 8);
            this.contents[n4++] = (byte)n5;
            n2 = 1;
        }
        this.contentsOffset = n;
        return n2;
    }

    private int generateLineNumberAttribute(int n) {
        int n2 = this.contentsOffset;
        if (n2 + 12 >= this.contents.length) {
            this.resizeContents(12);
        }
        int n3 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
        this.contents[n2++] = (byte)(n3 >> 8);
        this.contents[n2++] = (byte)n3;
        this.contents[n2++] = 0;
        this.contents[n2++] = 0;
        this.contents[n2++] = 0;
        this.contents[n2++] = 6;
        this.contents[n2++] = 0;
        this.contents[n2++] = 1;
        this.contents[n2++] = 0;
        this.contents[n2++] = 0;
        this.contents[n2++] = (byte)(n >> 8);
        this.contents[n2++] = (byte)n;
        this.contentsOffset = n2;
        return 1;
    }

    private int generateLocalVariableTableAttribute(int n, boolean bl, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Binding binding;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = 0;
        int n12 = this.contentsOffset;
        int n13 = 0;
        int n14 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
        int n15 = 8 + 10 * (bl ? 0 : 1);
        for (n10 = 0; n10 < this.codeStream.allLocalsCounter; ++n10) {
            LocalVariableBinding localVariableBinding = this.codeStream.locals[n10];
            n15 += 10 * localVariableBinding.initializationCount;
        }
        if (n12 + n15 >= this.contents.length) {
            this.resizeContents(n15);
        }
        this.contents[n12++] = (byte)(n14 >> 8);
        this.contents[n12++] = (byte)n14;
        n10 = n12;
        n12 += 6;
        SourceTypeBinding sourceTypeBinding = null;
        if (!bl && !bl2) {
            ++n13;
            this.contents[n12++] = 0;
            this.contents[n12++] = 0;
            this.contents[n12++] = (byte)(n >> 8);
            this.contents[n12++] = (byte)n;
            int n16 = this.constantPool.literalIndex(ConstantPool.This);
            this.contents[n12++] = (byte)(n16 >> 8);
            this.contents[n12++] = (byte)n16;
            sourceTypeBinding = (SourceTypeBinding)(this.codeStream.methodDeclaration != null ? this.codeStream.methodDeclaration.binding.declaringClass : this.codeStream.lambdaExpression.binding.declaringClass);
            n9 = this.constantPool.literalIndex(sourceTypeBinding.signature());
            this.contents[n12++] = (byte)(n9 >> 8);
            this.contents[n12++] = (byte)n9;
            this.contents[n12++] = 0;
            this.contents[n12++] = 0;
        }
        int n17 = 0;
        LocalVariableBinding[] localVariableBindingArray = null;
        int n18 = 0;
        int n19 = this.codeStream.allLocalsCounter;
        for (n8 = 0; n8 < n19; ++n8) {
            LocalVariableBinding localVariableBinding = this.codeStream.locals[n8];
            n7 = localVariableBinding.initializationCount;
            if (n7 == 0 || localVariableBinding.declaration == null) continue;
            binding = localVariableBinding.type;
            int n20 = n6 = binding.isParameterizedType() || binding.isTypeVariable() ? 1 : 0;
            if (n6 != 0) {
                if (localVariableBindingArray == null) {
                    localVariableBindingArray = new LocalVariableBinding[n19];
                }
                localVariableBindingArray[n17++] = localVariableBinding;
            }
            for (n5 = 0; n5 < n7; ++n5) {
                n4 = localVariableBinding.initializationPCs[n5 << 1];
                n3 = localVariableBinding.initializationPCs[(n5 << 1) + 1];
                if (n4 == n3) continue;
                if (n3 == -1) {
                    localVariableBinding.declaringScope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidAttribute, new String(localVariableBinding.name)), (ASTNode)((Object)localVariableBinding.declaringScope.methodScope().referenceContext));
                }
                if (n6 != 0) {
                    ++n18;
                }
                ++n13;
                this.contents[n12++] = (byte)(n4 >> 8);
                this.contents[n12++] = (byte)n4;
                n2 = n3 - n4;
                this.contents[n12++] = (byte)(n2 >> 8);
                this.contents[n12++] = (byte)n2;
                int n21 = this.constantPool.literalIndex(localVariableBinding.name);
                this.contents[n12++] = (byte)(n21 >> 8);
                this.contents[n12++] = (byte)n21;
                n9 = this.constantPool.literalIndex(binding.signature());
                this.contents[n12++] = (byte)(n9 >> 8);
                this.contents[n12++] = (byte)n9;
                int n22 = localVariableBinding.resolvedPosition;
                this.contents[n12++] = (byte)(n22 >> 8);
                this.contents[n12++] = (byte)n22;
            }
        }
        n8 = n13 * 10 + 2;
        this.contents[n10++] = (byte)(n8 >> 24);
        this.contents[n10++] = (byte)(n8 >> 16);
        this.contents[n10++] = (byte)(n8 >> 8);
        this.contents[n10++] = (byte)n8;
        this.contents[n10++] = (byte)(n13 >> 8);
        this.contents[n10] = (byte)n13;
        ++n11;
        int n23 = n19 = !bl && sourceTypeBinding != null && sourceTypeBinding.typeVariables != Binding.NO_TYPE_VARIABLES ? 1 : 0;
        if (n17 != 0 || n19 != 0) {
            n15 = 8 + (n18 += n19 != 0 ? 1 : 0) * 10;
            if (n12 + n15 >= this.contents.length) {
                this.resizeContents(n15);
            }
            int n24 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
            this.contents[n12++] = (byte)(n24 >> 8);
            this.contents[n12++] = (byte)n24;
            n8 = n18 * 10 + 2;
            this.contents[n12++] = (byte)(n8 >> 24);
            this.contents[n12++] = (byte)(n8 >> 16);
            this.contents[n12++] = (byte)(n8 >> 8);
            this.contents[n12++] = (byte)n8;
            this.contents[n12++] = (byte)(n18 >> 8);
            this.contents[n12++] = (byte)n18;
            if (n19 != 0) {
                this.contents[n12++] = 0;
                this.contents[n12++] = 0;
                this.contents[n12++] = (byte)(n >> 8);
                this.contents[n12++] = (byte)n;
                int n25 = this.constantPool.literalIndex(ConstantPool.This);
                this.contents[n12++] = (byte)(n25 >> 8);
                this.contents[n12++] = (byte)n25;
                n9 = this.constantPool.literalIndex(sourceTypeBinding.genericTypeSignature());
                this.contents[n12++] = (byte)(n9 >> 8);
                this.contents[n12++] = (byte)n9;
                this.contents[n12++] = 0;
                this.contents[n12++] = 0;
            }
            for (n7 = 0; n7 < n17; ++n7) {
                binding = localVariableBindingArray[n7];
                for (n6 = 0; n6 < ((LocalVariableBinding)binding).initializationCount; ++n6) {
                    n5 = ((LocalVariableBinding)binding).initializationPCs[n6 << 1];
                    n4 = ((LocalVariableBinding)binding).initializationPCs[(n6 << 1) + 1];
                    if (n5 == n4) continue;
                    this.contents[n12++] = (byte)(n5 >> 8);
                    this.contents[n12++] = (byte)n5;
                    n3 = n4 - n5;
                    this.contents[n12++] = (byte)(n3 >> 8);
                    this.contents[n12++] = (byte)n3;
                    int n26 = this.constantPool.literalIndex(((LocalVariableBinding)binding).name);
                    this.contents[n12++] = (byte)(n26 >> 8);
                    this.contents[n12++] = (byte)n26;
                    n9 = this.constantPool.literalIndex(((LocalVariableBinding)binding).type.genericTypeSignature());
                    this.contents[n12++] = (byte)(n9 >> 8);
                    this.contents[n12++] = (byte)n9;
                    n2 = ((LocalVariableBinding)binding).resolvedPosition;
                    this.contents[n12++] = (byte)(n2 >> 8);
                    this.contents[n12++] = (byte)n2;
                }
            }
            ++n11;
        }
        this.contentsOffset = n12;
        return n11;
    }

    public int generateMethodInfoAttributes(MethodBinding methodBinding) {
        char[] cArray;
        this.contentsOffset += 2;
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        int n = 0;
        ReferenceBinding[] referenceBindingArray = methodBinding.thrownExceptions;
        if (methodBinding.thrownExceptions != Binding.NO_EXCEPTIONS) {
            n += this.generateExceptionsAttribute(referenceBindingArray);
        }
        if (methodBinding.isDeprecated()) {
            n += this.generateDeprecatedAttribute();
        }
        if (this.targetJDK < 0x310000L) {
            if (methodBinding.isSynthetic()) {
                n += this.generateSyntheticAttribute();
            }
            if (methodBinding.isVarargs()) {
                n += this.generateVarargsAttribute();
            }
        }
        if ((cArray = methodBinding.genericSignature()) != null) {
            n += this.generateSignatureAttribute(cArray);
        }
        if (this.targetJDK >= 0x300000L) {
            Object object;
            AbstractMethodDeclaration abstractMethodDeclaration = methodBinding.sourceMethod();
            if (methodBinding instanceof SyntheticMethodBinding) {
                object = (Annotation[])methodBinding;
                if (object.purpose == 7 && CharOperation.equals(object.selector, object.targetMethod.selector)) {
                    abstractMethodDeclaration = ((SyntheticMethodBinding)methodBinding).targetMethod.sourceMethod();
                }
                if (object.recordComponentBinding != null) {
                    Annotation[] annotationArray;
                    assert (abstractMethodDeclaration == null);
                    long l = 0x20004000000000L;
                    ReferenceBinding referenceBinding = methodBinding.declaringClass;
                    RecordComponent recordComponent = this.getRecordComponent(referenceBinding, methodBinding.selector);
                    if (recordComponent != null && (annotationArray = ASTNode.getRelevantAnnotations(recordComponent.annotations, l, null)) != null) {
                        assert (!methodBinding.isConstructor());
                        n += this.generateRuntimeAnnotations(annotationArray, 0x4000000000L);
                        Supplier<List<AnnotationContext>> supplier = () -> {
                            ArrayList<AnnotationContext> arrayList = new ArrayList<AnnotationContext>();
                            recordComponent.getAllAnnotationContexts(20, arrayList);
                            return arrayList;
                        };
                        n = this.completeRuntimeTypeAnnotations(n, recordComponent, aSTNode -> (recordComponent.bits & 0x100000) != 0, supplier);
                    }
                }
            }
            if (abstractMethodDeclaration != null) {
                Argument[] argumentArray;
                object = abstractMethodDeclaration.annotations;
                if (object != null) {
                    n += this.generateRuntimeAnnotations((Annotation[])object, methodBinding.isConstructor() ? 0x10000000000L : 0x4000000000L);
                }
                if ((methodBinding.tagBits & 0x400L) != 0L && (argumentArray = abstractMethodDeclaration.arguments) != null) {
                    this.propagateRecordComponentArguments(abstractMethodDeclaration);
                    n += this.generateRuntimeAnnotationsForParameters(argumentArray);
                }
            } else {
                Argument[] argumentArray;
                object = methodBinding.sourceLambda();
                if (object != null && (methodBinding.tagBits & 0x400L) != 0L && (argumentArray = object.arguments()) != null) {
                    int n2 = methodBinding.parameters.length;
                    int n3 = argumentArray.length;
                    if (n2 > n3) {
                        int n4 = n2 - n3;
                        Argument[] argumentArray2 = argumentArray;
                        argumentArray = new Argument[n2];
                        System.arraycopy(argumentArray2, 0, argumentArray, n4, n3);
                        for (int i = 0; i < n4; ++i) {
                            argumentArray[i] = new Argument(CharOperation.NO_CHAR, 0L, null, 0);
                        }
                    }
                    n += this.generateRuntimeAnnotationsForParameters(argumentArray);
                }
            }
        }
        if ((methodBinding.tagBits & 0x80L) != 0L) {
            this.missingTypes = methodBinding.collectMissingTypes(this.missingTypes);
        }
        return n;
    }

    private int completeRuntimeTypeAnnotations(int n, ASTNode aSTNode, Predicate<ASTNode> predicate, Supplier<List<AnnotationContext>> supplier) {
        List<AnnotationContext> list;
        int n2 = 0;
        int n3 = 0;
        if (predicate.test(aSTNode) && (list = supplier.get()).size() > 0) {
            AnnotationContext[] annotationContextArray = new AnnotationContext[list.size()];
            list.toArray(annotationContextArray);
            int n4 = annotationContextArray.length;
            for (int i = 0; i < n4; ++i) {
                AnnotationContext annotationContext = annotationContextArray[i];
                if ((annotationContext.visibility & 2) != 0) {
                    ++n2;
                    continue;
                }
                ++n3;
            }
            n += this.generateRuntimeTypeAnnotations(annotationContextArray, n3, n2);
        }
        return n;
    }

    private void propagateRecordComponentArguments(AbstractMethodDeclaration abstractMethodDeclaration) {
        if ((abstractMethodDeclaration.bits & 0x600) == 0) {
            return;
        }
        ReferenceBinding referenceBinding = abstractMethodDeclaration.binding.declaringClass;
        if (referenceBinding instanceof SourceTypeBinding) {
            assert (referenceBinding.isRecord());
            RecordComponentBinding[] recordComponentBindingArray = ((SourceTypeBinding)referenceBinding).components();
            Argument[] argumentArray = abstractMethodDeclaration.arguments;
            int n = recordComponentBindingArray.length;
            for (int i = 0; i < n; ++i) {
                RecordComponentBinding recordComponentBinding = recordComponentBindingArray[i];
                RecordComponent recordComponent = recordComponentBinding.sourceRecordComponent();
                if ((recordComponent.bits & 0x100000) != 0) {
                    abstractMethodDeclaration.bits |= 0x100000;
                    argumentArray[i].bits |= 0x100000;
                }
                long l = 0x20008000000000L;
                argumentArray[i].annotations = ASTNode.getRelevantAnnotations(recordComponent.annotations, l, null);
            }
        }
    }

    public int generateMethodInfoAttributes(MethodBinding methodBinding, AnnotationMethodDeclaration annotationMethodDeclaration) {
        int n = this.generateMethodInfoAttributes(methodBinding);
        int n2 = this.contentsOffset;
        if ((annotationMethodDeclaration.modifiers & 0x20000) != 0) {
            n += this.generateAnnotationDefaultAttribute(annotationMethodDeclaration, n2);
        }
        return n;
    }

    public void generateMethodInfoHeader(MethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers);
    }

    public void generateMethodInfoHeader(MethodBinding methodBinding, int n) {
        ++this.methodCount;
        if (this.contentsOffset + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        if (this.targetJDK < 0x310000L) {
            n &= 0xFFFFEF7F;
        }
        if ((methodBinding.tagBits & 0x200L) != 0L) {
            n &= 0xFFFFFFFD;
        }
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndex(methodBinding.selector);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        int n3 = this.constantPool.literalIndex(methodBinding.signature(this));
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
    }

    public void addSyntheticDeserializeLambda(SyntheticMethodBinding syntheticMethodBinding, SyntheticMethodBinding[] syntheticMethodBindingArray) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        ++n2;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForDeserializeLambda(syntheticMethodBinding, syntheticMethodBindingArray);
        int n4 = this.codeStream.position;
        if (n4 > 65535) {
            this.referenceBinding.scope.problemReporter().bytecodeExceeds64KLimit(syntheticMethodBinding, this.referenceBinding.sourceStart(), this.referenceBinding.sourceEnd());
        }
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void generateMethodInfoHeaderForClinit() {
        ++this.methodCount;
        if (this.contentsOffset + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 8;
        int n = this.constantPool.literalIndex(ConstantPool.Clinit);
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndex(ConstantPool.ClinitSignature);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 1;
    }

    public void generateMissingAbstractMethods(MethodDeclaration[] methodDeclarationArray, CompilationResult compilationResult) {
        if (methodDeclarationArray != null) {
            TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
            int n = typeDeclaration.sourceStart();
            int n2 = typeDeclaration.sourceEnd();
            for (MethodDeclaration methodDeclaration : methodDeclarationArray) {
                MethodBinding methodBinding = methodDeclaration.binding;
                String string = new String(methodBinding.readableName());
                CategorizedProblem[] categorizedProblemArray = compilationResult.problems;
                int n3 = compilationResult.problemCount;
                for (int i = 0; i < n3; ++i) {
                    CategorizedProblem categorizedProblem = categorizedProblemArray[i];
                    if (categorizedProblem == null || categorizedProblem.getID() != 67109264 || categorizedProblem.getMessage().indexOf(string) == -1 || categorizedProblem.getSourceStart() < n || categorizedProblem.getSourceEnd() > n2) continue;
                    this.addMissingAbstractProblemMethod(methodDeclaration, methodBinding, categorizedProblem, compilationResult);
                }
            }
        }
    }

    private void generateMissingTypesAttribute() {
        int n;
        int n2;
        int n3 = this.missingTypes.size();
        int[] nArray = new int[n3];
        int n4 = 0;
        if (n3 > 1) {
            Collections.sort(this.missingTypes, new Comparator<TypeBinding>(){

                @Override
                public int compare(TypeBinding typeBinding, TypeBinding typeBinding2) {
                    return CharOperation.compareTo(typeBinding.constantPoolName(), typeBinding2.constantPoolName());
                }
            });
        }
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.constantPool.literalIndexForType(this.missingTypes.get(n2));
            if (n5 == n) continue;
            n5 = n;
            nArray[n4++] = n;
        }
        n2 = n4 * 2 + 2;
        if (this.contentsOffset + n2 + 6 >= this.contents.length) {
            this.resizeContents(n2 + 6);
        }
        n = this.constantPool.literalIndex(AttributeNamesConstants.MissingTypesName);
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        this.contents[this.contentsOffset++] = (byte)(n2 >> 24);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 16);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
        this.contents[this.contentsOffset++] = (byte)n4;
        for (int i = 0; i < n4; ++i) {
            int n6 = nArray[i];
            this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
            this.contents[this.contentsOffset++] = (byte)n6;
        }
    }

    private boolean jdk16packageInfoAnnotation(long l, long l2) {
        return this.targetJDK <= 0x320000L && l2 == 0x80000000000L && l != 0L && (l & 0x80000000000L) == 0L;
    }

    private int generateRuntimeAnnotations(Annotation[] annotationArray, long l) {
        int n;
        long l2;
        Annotation annotation;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = annotationArray.length;
        int n8 = 0;
        int n9 = 0;
        for (n5 = 0; n5 < n7; ++n5) {
            long l3;
            Annotation annotation2 = annotationArray[n5].getPersistibleAnnotation();
            if (annotation2 == null) continue;
            long l4 = l3 = annotation2.resolvedType != null ? annotation2.resolvedType.getAnnotationTagBits() & 0x20600FF840000000L : 0L;
            if (l3 != 0L && (l3 & l) == 0L && !this.jdk16packageInfoAnnotation(l3, l)) continue;
            if (annotation2.isRuntimeInvisible() || annotation2.isRuntimeTypeInvisible()) {
                ++n9;
                continue;
            }
            if (!annotation2.isRuntimeVisible() && !annotation2.isRuntimeTypeVisible()) continue;
            ++n8;
        }
        n5 = this.contentsOffset;
        if (n9 != 0) {
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            int n10 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeInvisibleAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n10 >> 8);
            this.contents[this.contentsOffset++] = (byte)n10;
            int n11 = this.contentsOffset;
            this.contentsOffset += 4;
            n4 = this.contentsOffset;
            this.contentsOffset += 2;
            n3 = 0;
            for (n2 = 0; n2 < n7 && n9 != 0; ++n2) {
                annotation = annotationArray[n2].getPersistibleAnnotation();
                if (annotation == null) continue;
                long l5 = l2 = annotation.resolvedType != null ? annotation.resolvedType.getAnnotationTagBits() & 0x20600FF840000000L : 0L;
                if (l2 != 0L && (l2 & l) == 0L && !this.jdk16packageInfoAnnotation(l2, l) || !annotation.isRuntimeInvisible() && !annotation.isRuntimeTypeInvisible()) continue;
                n = this.contentsOffset;
                this.generateAnnotation(annotation, n);
                --n9;
                if (this.contentsOffset == n) continue;
                ++n3;
            }
            if (n3 != 0) {
                this.contents[n4++] = (byte)(n3 >> 8);
                this.contents[n4++] = (byte)n3;
                n2 = this.contentsOffset - n11 - 4;
                this.contents[n11++] = (byte)(n2 >> 24);
                this.contents[n11++] = (byte)(n2 >> 16);
                this.contents[n11++] = (byte)(n2 >> 8);
                this.contents[n11++] = (byte)n2;
                ++n6;
            } else {
                this.contentsOffset = n5;
            }
        }
        n5 = this.contentsOffset;
        if (n8 != 0) {
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            int n12 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeVisibleAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n12 >> 8);
            this.contents[this.contentsOffset++] = (byte)n12;
            int n13 = this.contentsOffset;
            this.contentsOffset += 4;
            n4 = this.contentsOffset;
            this.contentsOffset += 2;
            n3 = 0;
            for (n2 = 0; n2 < n7 && n8 != 0; ++n2) {
                annotation = annotationArray[n2].getPersistibleAnnotation();
                if (annotation == null) continue;
                long l6 = l2 = annotation.resolvedType != null ? annotation.resolvedType.getAnnotationTagBits() & 0x20600FF840000000L : 0L;
                if (l2 != 0L && (l2 & l) == 0L && !this.jdk16packageInfoAnnotation(l2, l) || !annotation.isRuntimeVisible() && !annotation.isRuntimeTypeVisible()) continue;
                --n8;
                n = this.contentsOffset;
                this.generateAnnotation(annotation, n);
                if (this.contentsOffset == n) continue;
                ++n3;
            }
            if (n3 != 0) {
                this.contents[n4++] = (byte)(n3 >> 8);
                this.contents[n4++] = (byte)n3;
                n2 = this.contentsOffset - n13 - 4;
                this.contents[n13++] = (byte)(n2 >> 24);
                this.contents[n13++] = (byte)(n2 >> 16);
                this.contents[n13++] = (byte)(n2 >> 8);
                this.contents[n13++] = (byte)n2;
                ++n6;
            } else {
                this.contentsOffset = n5;
            }
        }
        return n6;
    }

    private int generateRuntimeAnnotationsForParameters(Argument[] argumentArray) {
        int n;
        long l;
        Annotation annotation;
        int n2;
        int n3;
        Annotation[] annotationArray;
        Argument argument;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = argumentArray.length;
        int n10 = 0;
        int n11 = 0;
        int[][] nArray = new int[n9][2];
        for (n8 = 0; n8 < n9; ++n8) {
            Argument argument2 = argumentArray[n8];
            Annotation[] annotationArray2 = argument2.annotations;
            if (annotationArray2 == null) continue;
            n7 = annotationArray2.length;
            for (n6 = 0; n6 < n7; ++n6) {
                long l2;
                Annotation annotation2 = annotationArray2[n6].getPersistibleAnnotation();
                if (annotation2 == null) continue;
                long l3 = l2 = annotation2.resolvedType != null ? annotation2.resolvedType.getAnnotationTagBits() & 0x20600FF840000000L : 0L;
                if (l2 != 0L && (l2 & 0x8000000000L) == 0L) continue;
                if (annotation2.isRuntimeInvisible()) {
                    int[] nArray2 = nArray[n8];
                    nArray2[1] = nArray2[1] + 1;
                    ++n10;
                    continue;
                }
                if (!annotation2.isRuntimeVisible()) continue;
                int[] nArray3 = nArray[n8];
                nArray3[0] = nArray3[0] + 1;
                ++n11;
            }
        }
        n8 = 0;
        int n12 = this.contentsOffset;
        if (n10 != 0) {
            int n13;
            int n14 = 0;
            if (this.contentsOffset + 7 >= this.contents.length) {
                this.resizeContents(7);
            }
            n6 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeInvisibleParameterAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
            this.contents[this.contentsOffset++] = (byte)n6;
            n7 = this.contentsOffset;
            this.contentsOffset += 4;
            this.contents[this.contentsOffset++] = (byte)n9;
            for (n13 = 0; n13 < n9; ++n13) {
                if (this.contentsOffset + 2 >= this.contents.length) {
                    this.resizeContents(2);
                }
                if (n10 == 0) {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                    continue;
                }
                int n15 = nArray[n13][1];
                n5 = this.contentsOffset;
                this.contentsOffset += 2;
                n4 = 0;
                if (n15 != 0) {
                    argument = argumentArray[n13];
                    annotationArray = argument.annotations;
                    n3 = annotationArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        annotation = annotationArray[n2].getPersistibleAnnotation();
                        if (annotation == null) continue;
                        long l4 = l = annotation.resolvedType != null ? annotation.resolvedType.getAnnotationTagBits() & 0x20600FF840000000L : 0L;
                        if (l != 0L && (l & 0x8000000000L) == 0L || !annotation.isRuntimeInvisible()) continue;
                        n = this.contentsOffset;
                        this.generateAnnotation(annotation, n);
                        if (this.contentsOffset != n) {
                            ++n4;
                            ++n14;
                        }
                        --n10;
                    }
                }
                this.contents[n5++] = (byte)(n4 >> 8);
                this.contents[n5] = (byte)n4;
            }
            if (n14 != 0) {
                n13 = this.contentsOffset - n7 - 4;
                this.contents[n7++] = (byte)(n13 >> 24);
                this.contents[n7++] = (byte)(n13 >> 16);
                this.contents[n7++] = (byte)(n13 >> 8);
                this.contents[n7++] = (byte)n13;
                ++n8;
            } else {
                this.contentsOffset = n12;
            }
        }
        if (n11 != 0) {
            int n16;
            int n17 = 0;
            if (this.contentsOffset + 7 >= this.contents.length) {
                this.resizeContents(7);
            }
            n6 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeVisibleParameterAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
            this.contents[this.contentsOffset++] = (byte)n6;
            n7 = this.contentsOffset;
            this.contentsOffset += 4;
            this.contents[this.contentsOffset++] = (byte)n9;
            for (n16 = 0; n16 < n9; ++n16) {
                if (this.contentsOffset + 2 >= this.contents.length) {
                    this.resizeContents(2);
                }
                if (n11 == 0) {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                    continue;
                }
                int n18 = nArray[n16][0];
                n5 = this.contentsOffset;
                this.contentsOffset += 2;
                n4 = 0;
                if (n18 != 0) {
                    argument = argumentArray[n16];
                    annotationArray = argument.annotations;
                    n3 = annotationArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        annotation = annotationArray[n2].getPersistibleAnnotation();
                        if (annotation == null) continue;
                        long l5 = l = annotation.resolvedType != null ? annotation.resolvedType.getAnnotationTagBits() & 0x20600FF840000000L : 0L;
                        if (l != 0L && (l & 0x8000000000L) == 0L || !annotation.isRuntimeVisible()) continue;
                        n = this.contentsOffset;
                        this.generateAnnotation(annotation, n);
                        if (this.contentsOffset != n) {
                            ++n4;
                            ++n17;
                        }
                        --n11;
                    }
                }
                this.contents[n5++] = (byte)(n4 >> 8);
                this.contents[n5] = (byte)n4;
            }
            if (n17 != 0) {
                n16 = this.contentsOffset - n7 - 4;
                this.contents[n7++] = (byte)(n16 >> 24);
                this.contents[n7++] = (byte)(n16 >> 16);
                this.contents[n7++] = (byte)(n16 >> 8);
                this.contents[n7++] = (byte)n16;
                ++n8;
            } else {
                this.contentsOffset = n12;
            }
        }
        return n8;
    }

    private int generateRuntimeTypeAnnotations(AnnotationContext[] annotationContextArray, int n, int n2) {
        int n3;
        AnnotationContext annotationContext;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = 0;
        int n10 = annotationContextArray.length;
        int n11 = n;
        int n12 = n2;
        int n13 = this.contentsOffset;
        if (n12 != 0) {
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            n8 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeInvisibleTypeAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
            this.contents[this.contentsOffset++] = (byte)n8;
            n7 = this.contentsOffset;
            this.contentsOffset += 4;
            n6 = this.contentsOffset;
            this.contentsOffset += 2;
            n5 = 0;
            for (n4 = 0; n4 < n10 && n12 != 0; ++n4) {
                annotationContext = annotationContextArray[n4];
                if ((annotationContext.visibility & 2) == 0) continue;
                n3 = this.contentsOffset;
                this.generateTypeAnnotation(annotationContext, n3);
                --n12;
                if (this.contentsOffset == n3) continue;
                ++n5;
            }
            if (n5 != 0) {
                this.contents[n6++] = (byte)(n5 >> 8);
                this.contents[n6++] = (byte)n5;
                n4 = this.contentsOffset - n7 - 4;
                this.contents[n7++] = (byte)(n4 >> 24);
                this.contents[n7++] = (byte)(n4 >> 16);
                this.contents[n7++] = (byte)(n4 >> 8);
                this.contents[n7++] = (byte)n4;
                ++n9;
            } else {
                this.contentsOffset = n13;
            }
        }
        n13 = this.contentsOffset;
        if (n11 != 0) {
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            n8 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeVisibleTypeAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
            this.contents[this.contentsOffset++] = (byte)n8;
            n7 = this.contentsOffset;
            this.contentsOffset += 4;
            n6 = this.contentsOffset;
            this.contentsOffset += 2;
            n5 = 0;
            for (n4 = 0; n4 < n10 && n11 != 0; ++n4) {
                annotationContext = annotationContextArray[n4];
                if ((annotationContext.visibility & 1) == 0) continue;
                --n11;
                n3 = this.contentsOffset;
                this.generateTypeAnnotation(annotationContext, n3);
                if (this.contentsOffset == n3) continue;
                ++n5;
            }
            if (n5 != 0) {
                this.contents[n6++] = (byte)(n5 >> 8);
                this.contents[n6++] = (byte)n5;
                n4 = this.contentsOffset - n7 - 4;
                this.contents[n7++] = (byte)(n4 >> 24);
                this.contents[n7++] = (byte)(n4 >> 16);
                this.contents[n7++] = (byte)(n4 >> 8);
                this.contents[n7++] = (byte)n4;
                ++n9;
            } else {
                this.contentsOffset = n13;
            }
        }
        return n9;
    }

    private int generateMethodParameters(MethodBinding methodBinding) {
        int n;
        int n2;
        int n3;
        boolean bl;
        if (methodBinding.sourceLambda() != null) {
            return 0;
        }
        int n4 = this.contentsOffset;
        int n5 = 0;
        AbstractMethodDeclaration abstractMethodDeclaration = methodBinding.sourceMethod();
        boolean bl2 = methodBinding.isConstructor();
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        ReferenceBinding referenceBinding = methodBinding.declaringClass;
        if (referenceBinding.isEnum()) {
            if (bl2) {
                n5 = this.writeArgumentName(ConstantPool.EnumName, 4096, n5);
                n5 = this.writeArgumentName(ConstantPool.EnumOrdinal, 4096, n5);
            } else if (methodBinding instanceof SyntheticMethodBinding && CharOperation.equals(ConstantPool.ValueOf, methodBinding.selector)) {
                n5 = this.writeArgumentName(ConstantPool.Name, 32768, n5);
                typeBindingArray = Binding.NO_PARAMETERS;
            }
        }
        boolean bl3 = bl = bl2 && referenceBinding.isNestedType();
        if (bl) {
            n3 = referenceBinding.isAnonymousType() && referenceBinding.superclass().isLocalType() ? 1 : 0;
            n2 = referenceBinding.isAnonymousType() && referenceBinding.superclass().isNestedType() ? 1 : 0;
            n = (!referenceBinding.isPrivate() || referenceBinding.isAnonymousType()) && n3 == 0 ? 1 : 0;
            ReferenceBinding[] referenceBindingArray = referenceBinding.syntheticEnclosingInstanceTypes();
            if (referenceBindingArray != null) {
                int n6 = referenceBindingArray.length;
                for (int i = 0; i < n6; ++i) {
                    boolean bl4 = n2 != 0 ? referenceBinding.superclass().enclosingType().equals(referenceBindingArray[i]) : true;
                    int n7 = bl4 && n != 0 ? 32768 : 4096;
                    char[] cArray = CharOperation.concat(TypeConstants.SYNTHETIC_ENCLOSING_INSTANCE_PREFIX, String.valueOf(i).toCharArray());
                    n5 = this.writeArgumentName(cArray, n7 | 0x10, n5);
                }
            }
            if (methodBinding instanceof SyntheticMethodBinding) {
                typeBindingArray = ((SyntheticMethodBinding)methodBinding).targetMethod.parameters;
                abstractMethodDeclaration = ((SyntheticMethodBinding)methodBinding).targetMethod.sourceMethod();
            }
        }
        if (typeBindingArray != Binding.NO_PARAMETERS) {
            int n8;
            Argument[] argumentArray = null;
            if (abstractMethodDeclaration != null && abstractMethodDeclaration.arguments != null) {
                argumentArray = abstractMethodDeclaration.arguments;
            }
            n = typeBindingArray.length;
            int n9 = n8 = argumentArray != null ? argumentArray.length : 0;
            for (n2 = 0; n2 < n; ++n2) {
                if (n8 > n2 && argumentArray[n2] != null) {
                    Argument argument = argumentArray[n2];
                    n5 = this.writeArgumentName(argument.name, argument.binding.modifiers, n5);
                    continue;
                }
                n5 = this.writeArgumentName(null, 4096, n5);
            }
        }
        if (bl) {
            SyntheticArgumentBinding[] syntheticArgumentBindingArray = referenceBinding.syntheticOuterLocalVariables();
            n2 = syntheticArgumentBindingArray == null ? 0 : syntheticArgumentBindingArray.length;
            for (n = 0; n < n2; ++n) {
                n5 = this.writeArgumentName(syntheticArgumentBindingArray[n].name, syntheticArgumentBindingArray[n].modifiers | 0x1000, n5);
            }
            int n10 = methodBinding.parameters.length;
            for (n = typeBindingArray.length; n < n10; ++n) {
                TypeBinding typeBinding = methodBinding.parameters[n];
                n5 = this.writeArgumentName(typeBinding.constantPoolName(), 4096, n5);
            }
        }
        if (n5 > 0) {
            n3 = 1 + 4 * n5;
            if (this.contentsOffset + 6 + n3 >= this.contents.length) {
                this.resizeContents(6 + n3);
            }
            n2 = this.constantPool.literalIndex(AttributeNamesConstants.MethodParametersName);
            this.contents[n4++] = (byte)(n2 >> 8);
            this.contents[n4++] = (byte)n2;
            this.contents[n4++] = (byte)(n3 >> 24);
            this.contents[n4++] = (byte)(n3 >> 16);
            this.contents[n4++] = (byte)(n3 >> 8);
            this.contents[n4++] = (byte)n3;
            this.contents[n4++] = (byte)n5;
            return 1;
        }
        return 0;
    }

    private int writeArgumentName(char[] cArray, int n, int n2) {
        int n3 = 4;
        if (n2 == 0) {
            n3 += 7;
            this.contentsOffset += 7;
        }
        if (this.contentsOffset + n3 > this.contents.length) {
            this.resizeContents(n3);
        }
        int n4 = cArray == null ? 0 : this.constantPool.literalIndex(cArray);
        this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
        this.contents[this.contentsOffset++] = (byte)n4;
        int n5 = n & 0x9010;
        this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
        this.contents[this.contentsOffset++] = (byte)n5;
        return n2 + 1;
    }

    private int generateSignatureAttribute(char[] cArray) {
        int n = this.contentsOffset;
        if (n + 8 >= this.contents.length) {
            this.resizeContents(8);
        }
        int n2 = this.constantPool.literalIndex(AttributeNamesConstants.SignatureName);
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 2;
        int n3 = this.constantPool.literalIndex(cArray);
        this.contents[n++] = (byte)(n3 >> 8);
        this.contents[n++] = (byte)n3;
        this.contentsOffset = n;
        return 1;
    }

    private int generateSourceAttribute(String string) {
        int n = this.contentsOffset;
        if (n + 8 >= this.contents.length) {
            this.resizeContents(8);
        }
        int n2 = this.constantPool.literalIndex(AttributeNamesConstants.SourceName);
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 2;
        int n3 = this.constantPool.literalIndex(string.toCharArray());
        this.contents[n++] = (byte)(n3 >> 8);
        this.contents[n++] = (byte)n3;
        this.contentsOffset = n;
        return 1;
    }

    private int generateStackMapAttribute(MethodBinding methodBinding, int n, int n2, int n3, boolean bl, Scope scope) {
        HashMap<Integer, StackMapFrame> hashMap;
        List<StackMapFrame> list;
        int n4;
        int n5 = 0;
        int n6 = this.contentsOffset;
        StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
        stackMapFrameCodeStream.removeFramePosition(n);
        if (stackMapFrameCodeStream.hasFramePositions() && (n4 = (list = this.traverse(bl ? null : methodBinding, n3, this.contents, n2 + 14, n, hashMap = new HashMap<Integer, StackMapFrame>(), bl, scope)).size()) > 1) {
            int n7;
            int n8 = n6;
            if (n6 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int n9 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapName);
            this.contents[n6++] = (byte)(n9 >> 8);
            this.contents[n6++] = (byte)n9;
            int n10 = n6;
            if ((n6 += 4) + 4 >= this.contents.length) {
                this.resizeContents(4);
            }
            int n11 = n6;
            if ((n6 += 2) + 2 >= this.contents.length) {
                this.resizeContents(2);
            }
            StackMapFrame stackMapFrame = list.get(0);
            for (n7 = 1; n7 < n4; ++n7) {
                int n12;
                int n13;
                stackMapFrame = list.get(n7);
                int n14 = stackMapFrame.pc;
                if (n6 + 5 >= this.contents.length) {
                    this.resizeContents(5);
                }
                this.contents[n6++] = (byte)(n14 >> 8);
                this.contents[n6++] = (byte)n14;
                int n15 = n6;
                n6 += 2;
                int n16 = 0;
                int n17 = stackMapFrame.getNumberOfLocals();
                int n18 = 0;
                int n19 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                for (n13 = 0; n13 < n19 && n16 < n17; ++n13) {
                    VerificationTypeInfo verificationTypeInfo;
                    if (n6 + 3 >= this.contents.length) {
                        this.resizeContents(3);
                    }
                    if ((verificationTypeInfo = stackMapFrame.locals[n13]) == null) {
                        this.contents[n6++] = 0;
                    } else {
                        block0 : switch (verificationTypeInfo.id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n6++] = 1;
                                break;
                            }
                            case 9: {
                                this.contents[n6++] = 2;
                                break;
                            }
                            case 7: {
                                this.contents[n6++] = 4;
                                ++n13;
                                break;
                            }
                            case 8: {
                                this.contents[n6++] = 3;
                                ++n13;
                                break;
                            }
                            case 12: {
                                this.contents[n6++] = 5;
                                break;
                            }
                            default: {
                                this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                switch (verificationTypeInfo.tag) {
                                    case 8: {
                                        int n20 = verificationTypeInfo.offset;
                                        this.contents[n6++] = (byte)(n20 >> 8);
                                        this.contents[n6++] = (byte)n20;
                                        break block0;
                                    }
                                    case 7: {
                                        n12 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                        this.contents[n6++] = (byte)(n12 >> 8);
                                        this.contents[n6++] = (byte)n12;
                                    }
                                }
                            }
                        }
                        ++n16;
                    }
                    ++n18;
                }
                if (n6 + 4 >= this.contents.length) {
                    this.resizeContents(4);
                }
                this.contents[n15++] = (byte)(n18 >> 8);
                this.contents[n15] = (byte)n18;
                n13 = stackMapFrame.numberOfStackItems;
                this.contents[n6++] = (byte)(n13 >> 8);
                this.contents[n6++] = (byte)n13;
                block24: for (int i = 0; i < n13; ++i) {
                    VerificationTypeInfo verificationTypeInfo;
                    if (n6 + 3 >= this.contents.length) {
                        this.resizeContents(3);
                    }
                    if ((verificationTypeInfo = stackMapFrame.stackItems[i]) == null) {
                        this.contents[n6++] = 0;
                        continue;
                    }
                    switch (verificationTypeInfo.id()) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 10: {
                            this.contents[n6++] = 1;
                            continue block24;
                        }
                        case 9: {
                            this.contents[n6++] = 2;
                            continue block24;
                        }
                        case 7: {
                            this.contents[n6++] = 4;
                            continue block24;
                        }
                        case 8: {
                            this.contents[n6++] = 3;
                            continue block24;
                        }
                        case 12: {
                            this.contents[n6++] = 5;
                            continue block24;
                        }
                        default: {
                            this.contents[n6++] = (byte)verificationTypeInfo.tag;
                            switch (verificationTypeInfo.tag) {
                                case 8: {
                                    n12 = verificationTypeInfo.offset;
                                    this.contents[n6++] = (byte)(n12 >> 8);
                                    this.contents[n6++] = (byte)n12;
                                    continue block24;
                                }
                                case 7: {
                                    int n21 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                    this.contents[n6++] = (byte)(n21 >> 8);
                                    this.contents[n6++] = (byte)n21;
                                }
                            }
                        }
                    }
                }
            }
            if (--n4 != 0) {
                this.contents[n11++] = (byte)(n4 >> 8);
                this.contents[n11] = (byte)n4;
                n7 = n6 - n10 - 4;
                this.contents[n10++] = (byte)(n7 >> 24);
                this.contents[n10++] = (byte)(n7 >> 16);
                this.contents[n10++] = (byte)(n7 >> 8);
                this.contents[n10] = (byte)n7;
                ++n5;
            } else {
                n6 = n8;
            }
        }
        this.contentsOffset = n6;
        return n5;
    }

    private int generateStackMapTableAttribute(MethodBinding methodBinding, int n, int n2, int n3, boolean bl, Scope scope) {
        HashMap<Integer, StackMapFrame> hashMap;
        List<StackMapFrame> list;
        int n4;
        int n5 = 0;
        int n6 = this.contentsOffset;
        StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
        stackMapFrameCodeStream.removeFramePosition(n);
        if (stackMapFrameCodeStream.hasFramePositions() && (n4 = (list = this.traverse(bl ? null : methodBinding, n3, this.contents, n2 + 14, n, hashMap = new HashMap<Integer, StackMapFrame>(), bl, scope)).size()) > 1) {
            int n7;
            int n8 = n6;
            if (n6 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int n9 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[n6++] = (byte)(n9 >> 8);
            this.contents[n6++] = (byte)n9;
            int n10 = n6;
            if ((n6 += 4) + 4 >= this.contents.length) {
                this.resizeContents(4);
            }
            int n11 = n6;
            if ((n6 += 2) + 2 >= this.contents.length) {
                this.resizeContents(2);
            }
            StackMapFrame stackMapFrame = list.get(0);
            StackMapFrame stackMapFrame2 = null;
            block63: for (n7 = 1; n7 < n4; ++n7) {
                stackMapFrame2 = stackMapFrame;
                stackMapFrame = list.get(n7);
                int n12 = stackMapFrame.getOffsetDelta(stackMapFrame2);
                switch (stackMapFrame.getFrameType(stackMapFrame2)) {
                    case 2: {
                        int n13;
                        int n14;
                        int n15;
                        if (n6 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int n16 = stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n6++] = (byte)(251 + n16);
                        this.contents[n6++] = (byte)(n12 >> 8);
                        this.contents[n6++] = (byte)n12;
                        int n17 = stackMapFrame.getIndexOfDifferentLocals(n16);
                        int n18 = stackMapFrame.getNumberOfLocals();
                        for (n15 = n17; n15 < stackMapFrame.locals.length && n16 > 0; ++n15) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n6 + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n15]) == null) {
                                this.contents[n6++] = 0;
                                continue;
                            }
                            block8 : switch (verificationTypeInfo.id()) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 10: {
                                    this.contents[n6++] = 1;
                                    break;
                                }
                                case 9: {
                                    this.contents[n6++] = 2;
                                    break;
                                }
                                case 7: {
                                    this.contents[n6++] = 4;
                                    ++n15;
                                    break;
                                }
                                case 8: {
                                    this.contents[n6++] = 3;
                                    ++n15;
                                    break;
                                }
                                case 12: {
                                    this.contents[n6++] = 5;
                                    break;
                                }
                                default: {
                                    this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                    switch (verificationTypeInfo.tag) {
                                        case 8: {
                                            n14 = verificationTypeInfo.offset;
                                            this.contents[n6++] = (byte)(n14 >> 8);
                                            this.contents[n6++] = (byte)n14;
                                            break block8;
                                        }
                                        case 7: {
                                            n13 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                            this.contents[n6++] = (byte)(n13 >> 8);
                                            this.contents[n6++] = (byte)n13;
                                        }
                                    }
                                }
                            }
                            --n16;
                        }
                        continue block63;
                    }
                    case 0: {
                        if (n6 + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[n6++] = (byte)n12;
                        continue block63;
                    }
                    case 3: {
                        if (n6 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[n6++] = -5;
                        this.contents[n6++] = (byte)(n12 >> 8);
                        this.contents[n6++] = (byte)n12;
                        continue block63;
                    }
                    case 1: {
                        if (n6 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int n16 = -stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n6++] = (byte)(251 - n16);
                        this.contents[n6++] = (byte)(n12 >> 8);
                        this.contents[n6++] = (byte)n12;
                        continue block63;
                    }
                    case 5: {
                        int n13;
                        int n14;
                        if (n6 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n6++] = (byte)(n12 + 64);
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n6++] = 0;
                            continue block63;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n6++] = 1;
                                continue block63;
                            }
                            case 9: {
                                this.contents[n6++] = 2;
                                continue block63;
                            }
                            case 7: {
                                this.contents[n6++] = 4;
                                continue block63;
                            }
                            case 8: {
                                this.contents[n6++] = 3;
                                continue block63;
                            }
                            case 12: {
                                this.contents[n6++] = 5;
                                continue block63;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        byte by = (byte)verificationTypeInfo.tag;
                        this.contents[n6++] = by;
                        switch (by) {
                            case 8: {
                                n14 = verificationTypeInfo.offset;
                                this.contents[n6++] = (byte)(n14 >> 8);
                                this.contents[n6++] = (byte)n14;
                                break;
                            }
                            case 7: {
                                n13 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n6++] = (byte)(n13 >> 8);
                                this.contents[n6++] = (byte)n13;
                            }
                        }
                        continue block63;
                    }
                    case 6: {
                        int n13;
                        int n14;
                        if (n6 + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[n6++] = -9;
                        this.contents[n6++] = (byte)(n12 >> 8);
                        this.contents[n6++] = (byte)n12;
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n6++] = 0;
                            continue block63;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n6++] = 1;
                                continue block63;
                            }
                            case 9: {
                                this.contents[n6++] = 2;
                                continue block63;
                            }
                            case 7: {
                                this.contents[n6++] = 4;
                                continue block63;
                            }
                            case 8: {
                                this.contents[n6++] = 3;
                                continue block63;
                            }
                            case 12: {
                                this.contents[n6++] = 5;
                                continue block63;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        byte by = (byte)verificationTypeInfo.tag;
                        this.contents[n6++] = by;
                        switch (by) {
                            case 8: {
                                n14 = verificationTypeInfo.offset;
                                this.contents[n6++] = (byte)(n14 >> 8);
                                this.contents[n6++] = (byte)n14;
                                break;
                            }
                            case 7: {
                                n13 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n6++] = (byte)(n13 >> 8);
                                this.contents[n6++] = (byte)n13;
                            }
                        }
                        continue block63;
                    }
                    default: {
                        int n19;
                        int n20;
                        if (n6 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n6++] = -1;
                        this.contents[n6++] = (byte)(n12 >> 8);
                        this.contents[n6++] = (byte)n12;
                        int n15 = n6;
                        n6 += 2;
                        byte by = 0;
                        int n18 = stackMapFrame.getNumberOfLocals();
                        int n14 = 0;
                        int n13 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                        for (n20 = 0; n20 < n13 && by < n18; ++n20) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n6 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n20]) == null) {
                                this.contents[n6++] = 0;
                            } else {
                                block41 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n6++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n6++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n6++] = 4;
                                        ++n20;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n6++] = 3;
                                        ++n20;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n6++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n21 = verificationTypeInfo.offset;
                                                this.contents[n6++] = (byte)(n21 >> 8);
                                                this.contents[n6++] = (byte)n21;
                                                break block41;
                                            }
                                            case 7: {
                                                n19 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n6++] = (byte)(n19 >> 8);
                                                this.contents[n6++] = (byte)n19;
                                            }
                                        }
                                    }
                                }
                                by = (byte)(by + 1);
                            }
                            ++n14;
                        }
                        if (n6 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n15++] = (byte)(n14 >> 8);
                        this.contents[n15] = (byte)n14;
                        n20 = stackMapFrame.numberOfStackItems;
                        this.contents[n6++] = (byte)(n20 >> 8);
                        this.contents[n6++] = (byte)n20;
                        block66: for (int i = 0; i < n20; ++i) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n6 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.stackItems[i]) == null) {
                                this.contents[n6++] = 0;
                                continue;
                            }
                            switch (verificationTypeInfo.id()) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 10: {
                                    this.contents[n6++] = 1;
                                    continue block66;
                                }
                                case 9: {
                                    this.contents[n6++] = 2;
                                    continue block66;
                                }
                                case 7: {
                                    this.contents[n6++] = 4;
                                    continue block66;
                                }
                                case 8: {
                                    this.contents[n6++] = 3;
                                    continue block66;
                                }
                                case 12: {
                                    this.contents[n6++] = 5;
                                    continue block66;
                                }
                                default: {
                                    this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                    switch (verificationTypeInfo.tag) {
                                        case 8: {
                                            n19 = verificationTypeInfo.offset;
                                            this.contents[n6++] = (byte)(n19 >> 8);
                                            this.contents[n6++] = (byte)n19;
                                            continue block66;
                                        }
                                        case 7: {
                                            int n22 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                            this.contents[n6++] = (byte)(n22 >> 8);
                                            this.contents[n6++] = (byte)n22;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (--n4 != 0) {
                this.contents[n11++] = (byte)(n4 >> 8);
                this.contents[n11] = (byte)n4;
                n7 = n6 - n10 - 4;
                this.contents[n10++] = (byte)(n7 >> 24);
                this.contents[n10++] = (byte)(n7 >> 16);
                this.contents[n10++] = (byte)(n7 >> 8);
                this.contents[n10] = (byte)n7;
                ++n5;
            } else {
                n6 = n8;
            }
        }
        this.contentsOffset = n6;
        return n5;
    }

    private int generateSyntheticAttribute() {
        int n = this.contentsOffset;
        if (n + 6 >= this.contents.length) {
            this.resizeContents(6);
        }
        int n2 = this.constantPool.literalIndex(AttributeNamesConstants.SyntheticName);
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contentsOffset = n;
        return 1;
    }

    private void generateTypeAnnotation(AnnotationContext annotationContext, int n) {
        Annotation annotation = annotationContext.annotation.getPersistibleAnnotation();
        if (annotation == null || annotation.resolvedType == null) {
            return;
        }
        int n2 = annotationContext.targetType;
        int[] nArray = Annotation.getLocations(annotationContext.typeReference, annotationContext.annotation);
        if (this.contentsOffset + 5 >= this.contents.length) {
            this.resizeContents(5);
        }
        this.contents[this.contentsOffset++] = (byte)n2;
        this.dumpTargetTypeContents(n2, annotationContext);
        this.dumpLocations(nArray);
        this.generateAnnotation(annotation, n);
    }

    private int generateTypeAnnotationAttributeForTypeDeclaration() {
        TypeParameter[] typeParameterArray;
        TypeReference[] typeReferenceArray;
        TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
        if ((typeDeclaration.bits & 0x100000) == 0) {
            return 0;
        }
        int n = 0;
        TypeReference typeReference = typeDeclaration.superclass;
        ArrayList<AnnotationContext> arrayList = new ArrayList<AnnotationContext>();
        if (typeReference != null && (typeReference.bits & 0x100000) != 0) {
            typeReference.getAllAnnotationContexts(16, -1, arrayList);
        }
        if ((typeReferenceArray = typeDeclaration.superInterfaces) != null) {
            for (int i = 0; i < typeReferenceArray.length; ++i) {
                TypeReference typeReference2 = typeReferenceArray[i];
                if ((typeReference2.bits & 0x100000) == 0) continue;
                typeReference2.getAllAnnotationContexts(16, i, arrayList);
            }
        }
        if ((typeParameterArray = typeDeclaration.typeParameters) != null) {
            int n2 = typeParameterArray.length;
            for (int i = 0; i < n2; ++i) {
                TypeParameter typeParameter = typeParameterArray[i];
                if ((typeParameter.bits & 0x100000) == 0) continue;
                typeParameter.getAllAnnotationContexts(0, i, arrayList);
            }
        }
        int n3 = arrayList.size();
        n = this.completeRuntimeTypeAnnotations(n, null, aSTNode -> n3 > 0, () -> arrayList);
        return n;
    }

    private int generateVarargsAttribute() {
        int n = this.contentsOffset;
        if (n + 6 >= this.contents.length) {
            this.resizeContents(6);
        }
        int n2 = this.constantPool.literalIndex(AttributeNamesConstants.VarargsName);
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contentsOffset = n;
        return 1;
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            this.bytes = new byte[this.headerOffset + this.contentsOffset];
            System.arraycopy(this.header, 0, this.bytes, 0, this.headerOffset);
            System.arraycopy(this.contents, 0, this.bytes, this.headerOffset, this.contentsOffset);
        }
        return this.bytes;
    }

    public char[][] getCompoundName() {
        return CharOperation.splitOn('/', this.fileName());
    }

    private int getParametersCount(char[] cArray) {
        char c;
        int n = CharOperation.indexOf('(', cArray);
        if ((c = cArray[++n]) == ')') {
            return 0;
        }
        int n2 = 0;
        block5: while (true) {
            if ((c = cArray[n]) == ')') {
                return n2;
            }
            switch (c) {
                case '[': {
                    int n3 = this.scanType(cArray, n + 1);
                    ++n2;
                    n = n3 + 1;
                    continue block5;
                }
                case 'L': {
                    int n3 = CharOperation.indexOf(';', cArray, n + 1);
                    ++n2;
                    n = n3 + 1;
                    continue block5;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    ++n2;
                    ++n;
                    continue block5;
                }
            }
            break;
        }
        throw new IllegalArgumentException("Invalid starting type character : " + c);
    }

    private char[] getReturnType(char[] cArray) {
        int n = CharOperation.lastIndexOf(')', cArray);
        return CharOperation.subarray(cArray, n + 1, cArray.length);
    }

    private final int i4At(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        return ((byArray[n3++] & 0xFF) << 24) + ((byArray[n3++] & 0xFF) << 16) + ((byArray[n3++] & 0xFF) << 8) + (byArray[n3] & 0xFF);
    }

    protected void initByteArrays(int n) {
        this.header = new byte[1500];
        this.contents = new byte[n < 15 ? 400 : 1500];
    }

    private void initializeHeader(ClassFile classFile, int n) {
        this.header[this.headerOffset++] = -54;
        this.header[this.headerOffset++] = -2;
        this.header[this.headerOffset++] = -70;
        this.header[this.headerOffset++] = -66;
        long l = this.targetJDK;
        this.header[this.headerOffset++] = (byte)(l >> 8);
        this.header[this.headerOffset++] = (byte)(l >> 0);
        this.header[this.headerOffset++] = (byte)(l >> 24);
        this.header[this.headerOffset++] = (byte)(l >> 16);
        this.constantPoolOffset = this.headerOffset;
        this.headerOffset += 2;
        this.constantPool.initialize(this);
        this.enclosingClassFile = classFile;
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
    }

    public void initialize(SourceTypeBinding sourceTypeBinding, ClassFile classFile, boolean bl) {
        int n;
        int n2 = sourceTypeBinding.getAccessFlags();
        if (sourceTypeBinding.isPrivate()) {
            n2 &= 0xFFFFFFFE;
        }
        if (sourceTypeBinding.isProtected()) {
            n2 |= 1;
        }
        n2 &= 0xFFFFF6D1;
        if (!sourceTypeBinding.isInterface()) {
            n2 |= 0x20;
        }
        if (sourceTypeBinding.isAnonymousType()) {
            n2 &= 0xFFFFFFEF;
        }
        if ((n2 & (n = 1040)) == n) {
            n2 &= ~n;
        }
        this.initializeHeader(classFile, n2);
        int n3 = this.constantPool.literalIndexForType(sourceTypeBinding);
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        int n4 = sourceTypeBinding.isInterface() ? this.constantPool.literalIndexForType(ConstantPool.JavaLangObjectConstantPoolName) : (sourceTypeBinding.superclass != null ? ((sourceTypeBinding.superclass.tagBits & 0x80L) != 0L ? this.constantPool.literalIndexForType(ConstantPool.JavaLangObjectConstantPoolName) : this.constantPool.literalIndexForType(sourceTypeBinding.superclass)) : 0);
        this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
        this.contents[this.contentsOffset++] = (byte)n4;
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.superInterfaces();
        int n5 = referenceBindingArray.length;
        int n6 = this.contentsOffset;
        this.contentsOffset += 2;
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            ReferenceBinding referenceBinding = referenceBindingArray[i];
            if ((referenceBinding.tagBits & 0x80L) != 0L) continue;
            if (this.contentsOffset + 4 >= this.contents.length) {
                this.resizeContents(4);
            }
            ++n7;
            int n8 = this.constantPool.literalIndexForType(referenceBinding);
            this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
            this.contents[this.contentsOffset++] = (byte)n8;
        }
        this.contents[n6++] = (byte)(n7 >> 8);
        this.contents[n6] = (byte)n7;
        this.creatingProblemType = bl;
        this.codeStream.maxFieldCount = sourceTypeBinding.scope.outerMostClassScope().referenceType().maxFieldCount;
    }

    public void initializeForModule(ModuleBinding moduleBinding) {
        this.initializeHeader(null, 32768);
        int n = this.constantPool.literalIndexForType(TypeConstants.MODULE_INFO_NAME);
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        this.codeStream.maxFieldCount = 0;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
    }

    private void initializeDefaultLocals(StackMapFrame stackMapFrame, MethodBinding methodBinding, int n, int n2) {
        block22: {
            Object object;
            int n3;
            block23: {
                block24: {
                    SyntheticArgumentBinding[] syntheticArgumentBindingArray;
                    if (n == 0) break block22;
                    n3 = 0;
                    boolean bl = methodBinding.isConstructor();
                    if (bl || !methodBinding.isStatic()) {
                        object = new LocalVariableBinding(ConstantPool.This, (TypeBinding)methodBinding.declaringClass, 0, false);
                        ((LocalVariableBinding)object).resolvedPosition = 0;
                        this.codeStream.record((LocalVariableBinding)object);
                        ((LocalVariableBinding)object).recordInitializationStartPC(0);
                        ((LocalVariableBinding)object).recordInitializationEndPC(n2);
                        stackMapFrame.putLocal(n3, new VerificationTypeInfo(bl ? 6 : 7, methodBinding.declaringClass));
                        ++n3;
                    }
                    if (!bl) break block23;
                    if (methodBinding.declaringClass.isEnum()) {
                        object = new LocalVariableBinding(" name".toCharArray(), (TypeBinding)this.referenceBinding.scope.getJavaLangString(), 0, false);
                        ((LocalVariableBinding)object).resolvedPosition = n3;
                        this.codeStream.record((LocalVariableBinding)object);
                        ((LocalVariableBinding)object).recordInitializationStartPC(0);
                        ((LocalVariableBinding)object).recordInitializationEndPC(n2);
                        stackMapFrame.putLocal(n3, new VerificationTypeInfo(this.referenceBinding.scope.getJavaLangString()));
                        object = new LocalVariableBinding(" ordinal".toCharArray(), (TypeBinding)TypeBinding.INT, 0, false);
                        ((LocalVariableBinding)object).resolvedPosition = ++n3;
                        this.codeStream.record((LocalVariableBinding)object);
                        ((LocalVariableBinding)object).recordInitializationStartPC(0);
                        ((LocalVariableBinding)object).recordInitializationEndPC(n2);
                        stackMapFrame.putLocal(n3, new VerificationTypeInfo(TypeBinding.INT));
                        ++n3;
                    }
                    if (!methodBinding.declaringClass.isNestedType()) break block24;
                    object = methodBinding.declaringClass.syntheticEnclosingInstanceTypes();
                    if (object != null) {
                        int n4 = ((Object)object).length;
                        for (int i = 0; i < n4; ++i) {
                            LocalVariableBinding localVariableBinding = new LocalVariableBinding((" enclosingType" + i).toCharArray(), (TypeBinding)object[i], 0, false);
                            localVariableBinding.resolvedPosition = n3;
                            this.codeStream.record(localVariableBinding);
                            localVariableBinding.recordInitializationStartPC(0);
                            localVariableBinding.recordInitializationEndPC(n2);
                            stackMapFrame.putLocal(n3, new VerificationTypeInfo((TypeBinding)object[i]));
                            ++n3;
                        }
                    }
                    TypeBinding[] typeBindingArray = methodBinding.parameters;
                    if (methodBinding.parameters != null) {
                        block13: for (TypeBinding typeBinding : typeBindingArray) {
                            stackMapFrame.putLocal(n3, new VerificationTypeInfo(typeBinding));
                            switch (typeBinding.id) {
                                case 7: 
                                case 8: {
                                    n3 += 2;
                                    continue block13;
                                }
                                default: {
                                    ++n3;
                                }
                            }
                        }
                    }
                    if ((syntheticArgumentBindingArray = methodBinding.declaringClass.syntheticOuterLocalVariables()) == null) break block22;
                    int n5 = syntheticArgumentBindingArray.length;
                    block14: for (int i = 0; i < n5; ++i) {
                        TypeBinding typeBinding = syntheticArgumentBindingArray[i].type;
                        LocalVariableBinding localVariableBinding = new LocalVariableBinding((" synthetic" + i).toCharArray(), typeBinding, 0, false);
                        localVariableBinding.resolvedPosition = n3;
                        this.codeStream.record(localVariableBinding);
                        localVariableBinding.recordInitializationStartPC(0);
                        localVariableBinding.recordInitializationEndPC(n2);
                        stackMapFrame.putLocal(n3, new VerificationTypeInfo(typeBinding));
                        switch (typeBinding.id) {
                            case 7: 
                            case 8: {
                                n3 += 2;
                                continue block14;
                            }
                            default: {
                                ++n3;
                            }
                        }
                    }
                    break block22;
                }
                object = methodBinding.parameters;
                if (methodBinding.parameters == null) break block22;
                block15: for (Object object2 : object) {
                    stackMapFrame.putLocal(n3, new VerificationTypeInfo((TypeBinding)object2));
                    switch (((TypeBinding)object2).id) {
                        case 7: 
                        case 8: {
                            n3 += 2;
                            continue block15;
                        }
                        default: {
                            ++n3;
                        }
                    }
                }
                break block22;
            }
            object = methodBinding.parameters;
            if (methodBinding.parameters != null) {
                int n6 = ((TypeBinding[])object).length;
                block16: for (int i = 0; i < n6; ++i) {
                    Object object3 = object[i];
                    LocalVariableBinding localVariableBinding = new LocalVariableBinding((" synthetic" + i).toCharArray(), (TypeBinding)object3, 0, true);
                    localVariableBinding.resolvedPosition = i;
                    this.codeStream.record(localVariableBinding);
                    localVariableBinding.recordInitializationStartPC(0);
                    localVariableBinding.recordInitializationEndPC(n2);
                    stackMapFrame.putLocal(n3, new VerificationTypeInfo((TypeBinding)object3));
                    switch (((TypeBinding)object3).id) {
                        case 7: 
                        case 8: {
                            n3 += 2;
                            continue block16;
                        }
                        default: {
                            ++n3;
                        }
                    }
                }
            }
        }
    }

    private void initializeLocals(boolean bl, int n, StackMapFrame stackMapFrame) {
        VerificationTypeInfo[] verificationTypeInfoArray = stackMapFrame.locals;
        int n2 = verificationTypeInfoArray.length;
        int n3 = 0;
        if (!bl) {
            n3 = 1;
        }
        while (n3 < n2) {
            verificationTypeInfoArray[n3] = null;
            ++n3;
        }
        int n4 = this.codeStream.allLocalsCounter;
        block1: for (n3 = 0; n3 < n4; ++n3) {
            LocalVariableBinding localVariableBinding = this.codeStream.locals[n3];
            if (localVariableBinding == null) continue;
            int n5 = localVariableBinding.resolvedPosition;
            TypeBinding typeBinding = localVariableBinding.type;
            for (int i = 0; i < localVariableBinding.initializationCount; ++i) {
                int n6 = localVariableBinding.initializationPCs[i << 1];
                int n7 = localVariableBinding.initializationPCs[(i << 1) + 1];
                if (n < n6 || n >= n7) continue;
                if (stackMapFrame.locals[n5] != null) continue block1;
                stackMapFrame.locals[n5] = new VerificationTypeInfo(typeBinding);
                continue block1;
            }
        }
    }

    public ClassFile outerMostEnclosingClassFile() {
        ClassFile classFile = this;
        while (classFile.enclosingClassFile != null) {
            classFile = classFile.enclosingClassFile;
        }
        return classFile;
    }

    public void recordInnerClasses(TypeBinding typeBinding) {
        this.recordInnerClasses(typeBinding, false);
    }

    public void recordInnerClasses(TypeBinding typeBinding, boolean bl) {
        if (this.innerClassesBindings == null) {
            this.innerClassesBindings = new HashMap<TypeBinding, Boolean>(5);
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        this.innerClassesBindings.put(referenceBinding.erasure().unannotated(), bl);
        for (ReferenceBinding referenceBinding2 = referenceBinding.enclosingType(); referenceBinding2 != null && referenceBinding2.isNestedType(); referenceBinding2 = referenceBinding2.enclosingType()) {
            this.innerClassesBindings.put(referenceBinding2.erasure().unannotated(), bl);
        }
    }

    public int recordBootstrapMethod(FunctionalExpression functionalExpression) {
        if (this.bootstrapMethods == null) {
            this.bootstrapMethods = new ArrayList<ASTNode>();
        }
        if (functionalExpression instanceof ReferenceExpression) {
            for (int i = 0; i < this.bootstrapMethods.size(); ++i) {
                ASTNode aSTNode = this.bootstrapMethods.get(i);
                if (!(aSTNode instanceof FunctionalExpression)) continue;
                FunctionalExpression functionalExpression2 = (FunctionalExpression)aSTNode;
                if (functionalExpression2.binding != functionalExpression.binding || !TypeBinding.equalsEquals(functionalExpression2.expectedType(), functionalExpression.expectedType())) continue;
                functionalExpression.bootstrapMethodNumber = i;
                return functionalExpression.bootstrapMethodNumber;
            }
        }
        this.bootstrapMethods.add(functionalExpression);
        functionalExpression.bootstrapMethodNumber = this.bootstrapMethods.size() - 1;
        return functionalExpression.bootstrapMethodNumber;
    }

    public void reset(SourceTypeBinding sourceTypeBinding, CompilerOptions compilerOptions) {
        if (sourceTypeBinding != null) {
            this.referenceBinding = sourceTypeBinding;
            this.isNestedType = sourceTypeBinding.isNestedType();
        } else {
            this.referenceBinding = null;
            this.isNestedType = false;
        }
        this.targetJDK = compilerOptions.targetJDK;
        this.produceAttributes = compilerOptions.produceDebugAttributes;
        if (this.targetJDK >= 0x320000L) {
            this.produceAttributes |= 8;
            if (this.targetJDK >= 0x340000L) {
                this.produceAttributes |= 0x20;
                if (!(this.codeStream instanceof TypeAnnotationCodeStream) && this.referenceBinding != null) {
                    this.codeStream = new TypeAnnotationCodeStream(this);
                }
                if (compilerOptions.produceMethodParameters) {
                    this.produceAttributes |= 0x40;
                }
            }
        } else if (this.targetJDK == 2949124L) {
            this.targetJDK = 2949123L;
            this.produceAttributes |= 0x10;
        }
        this.bytes = null;
        this.constantPool.reset();
        this.codeStream.reset(this);
        this.constantPoolOffset = 0;
        this.contentsOffset = 0;
        this.creatingProblemType = false;
        this.enclosingClassFile = null;
        this.headerOffset = 0;
        this.methodCount = 0;
        this.methodCountOffset = 0;
        if (this.innerClassesBindings != null) {
            this.innerClassesBindings.clear();
        }
        if (this.bootstrapMethods != null) {
            this.bootstrapMethods.clear();
        }
        this.missingTypes = null;
        this.visitedTypes = null;
    }

    private final void resizeContents(int n) {
        int n2 = this.contents.length;
        int n3 = n2;
        if (n3 < n) {
            n3 = n;
        }
        this.contents = new byte[n2 + n3];
        System.arraycopy(this.contents, 0, this.contents, 0, n2);
    }

    private VerificationTypeInfo retrieveLocal(int n, int n2) {
        int n3 = this.codeStream.allLocalsCounter;
        for (int i = 0; i < n3; ++i) {
            LocalVariableBinding localVariableBinding = this.codeStream.locals[i];
            if (localVariableBinding == null || n2 != localVariableBinding.resolvedPosition) continue;
            for (int j = 0; j < localVariableBinding.initializationCount; ++j) {
                int n4 = localVariableBinding.initializationPCs[j << 1];
                int n5 = localVariableBinding.initializationPCs[(j << 1) + 1];
                if (n < n4 || n >= n5) continue;
                return new VerificationTypeInfo(localVariableBinding.type);
            }
        }
        return null;
    }

    private int scanType(char[] cArray, int n) {
        switch (cArray[n]) {
            case '[': {
                return this.scanType(cArray, n + 1);
            }
            case 'L': {
                return CharOperation.indexOf(';', cArray, n + 1);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n;
            }
        }
        throw ClassFile.newIllegalArgumentException(cArray, n);
    }

    private static IllegalArgumentException newIllegalArgumentException(char[] cArray, int n) {
        return new IllegalArgumentException("\"" + String.valueOf(cArray) + "\" at " + n);
    }

    public void setForMethodInfos() {
        this.methodCountOffset = this.contentsOffset;
        this.contentsOffset += 2;
    }

    private List<StackMapFrame> filterFakeFrames(Set<Integer> set, Map<Integer, StackMapFrame> map, int n) {
        set.remove(n);
        ArrayList<StackMapFrame> arrayList = new ArrayList<StackMapFrame>();
        for (Integer n2 : set) {
            StackMapFrame stackMapFrame = map.get(n2);
            if (stackMapFrame == null) continue;
            arrayList.add(stackMapFrame);
        }
        Collections.sort(arrayList, new Comparator<StackMapFrame>(){

            @Override
            public int compare(StackMapFrame stackMapFrame, StackMapFrame stackMapFrame2) {
                return stackMapFrame.pc - stackMapFrame2.pc;
            }
        });
        return arrayList;
    }

    private TypeBinding getTypeBinding(char[] cArray, Scope scope, boolean bl) {
        if (cArray.length == 1) {
            switch (cArray[0]) {
                case 'Z': {
                    return TypeBinding.BOOLEAN;
                }
                case 'B': {
                    return TypeBinding.BYTE;
                }
                case 'C': {
                    return TypeBinding.CHAR;
                }
                case 'D': {
                    return TypeBinding.DOUBLE;
                }
                case 'F': {
                    return TypeBinding.FLOAT;
                }
                case 'I': {
                    return TypeBinding.INT;
                }
                case 'J': {
                    return TypeBinding.LONG;
                }
                case 'S': {
                    return TypeBinding.SHORT;
                }
            }
            return null;
        }
        if (cArray[0] == '[') {
            int n = this.getDimensions(cArray);
            if (cArray.length - n == 1) {
                BaseTypeBinding baseTypeBinding = null;
                switch (cArray[cArray.length - 1]) {
                    case 'Z': {
                        baseTypeBinding = TypeBinding.BOOLEAN;
                        break;
                    }
                    case 'B': {
                        baseTypeBinding = TypeBinding.BYTE;
                        break;
                    }
                    case 'C': {
                        baseTypeBinding = TypeBinding.CHAR;
                        break;
                    }
                    case 'D': {
                        baseTypeBinding = TypeBinding.DOUBLE;
                        break;
                    }
                    case 'F': {
                        baseTypeBinding = TypeBinding.FLOAT;
                        break;
                    }
                    case 'I': {
                        baseTypeBinding = TypeBinding.INT;
                        break;
                    }
                    case 'J': {
                        baseTypeBinding = TypeBinding.LONG;
                        break;
                    }
                    case 'S': {
                        baseTypeBinding = TypeBinding.SHORT;
                        break;
                    }
                    case 'V': {
                        baseTypeBinding = TypeBinding.VOID;
                    }
                }
                return scope.createArrayType(baseTypeBinding, n);
            }
            char[] cArray2 = CharOperation.subarray(cArray, n + 1, cArray.length - 1);
            TypeBinding typeBinding = (TypeBinding)scope.getTypeOrPackage(CharOperation.splitOn('/', cArray2));
            if (!typeBinding.isValidBinding()) {
                ProblemReferenceBinding problemReferenceBinding = (ProblemReferenceBinding)typeBinding;
                if ((problemReferenceBinding.problemId() & 4) != 0 || (problemReferenceBinding.problemId() & 2) != 0) {
                    typeBinding = problemReferenceBinding.closestMatch();
                } else if ((problemReferenceBinding.problemId() & 1) != 0 && this.innerClassesBindings != null) {
                    Set<TypeBinding> set = this.innerClassesBindings.keySet();
                    for (TypeBinding typeBinding2 : set) {
                        if (!CharOperation.equals(typeBinding2.constantPoolName(), cArray2)) continue;
                        typeBinding = typeBinding2;
                        break;
                    }
                }
            }
            return scope.createArrayType(typeBinding, n);
        }
        char[] cArray3 = bl ? cArray : CharOperation.subarray(cArray, 1, cArray.length - 1);
        TypeBinding typeBinding = (TypeBinding)scope.getTypeOrPackage(CharOperation.splitOn('/', cArray3));
        if (!typeBinding.isValidBinding()) {
            ProblemReferenceBinding problemReferenceBinding = (ProblemReferenceBinding)typeBinding;
            if ((problemReferenceBinding.problemId() & 4) != 0 || (problemReferenceBinding.problemId() & 2) != 0) {
                typeBinding = problemReferenceBinding.closestMatch();
            } else if ((problemReferenceBinding.problemId() & 1) != 0 && this.innerClassesBindings != null) {
                Set<TypeBinding> set = this.innerClassesBindings.keySet();
                for (TypeBinding typeBinding3 : set) {
                    if (!CharOperation.equals(typeBinding3.constantPoolName(), cArray3)) continue;
                    typeBinding = typeBinding3;
                    break;
                }
            }
        }
        return typeBinding;
    }

    private TypeBinding getNewTypeBinding(char[] cArray, Scope scope) {
        Object object;
        Object object2;
        char[] cArray2 = cArray;
        if (this.innerClassesBindings != null && this.isLikelyLocalTypeName(cArray2)) {
            object2 = this.innerClassesBindings.keySet();
            object = object2.iterator();
            while (object.hasNext()) {
                TypeBinding typeBinding = (TypeBinding)object.next();
                if (!CharOperation.equals(typeBinding.constantPoolName(), cArray2)) continue;
                return typeBinding;
            }
        }
        if (!(((Binding)(object2 = (TypeBinding)scope.getTypeOrPackage(CharOperation.splitOn('/', cArray2)))).isValidBinding() || (((ProblemReferenceBinding)(object = (ProblemReferenceBinding)object2)).problemId() & 4) == 0 && (((ProblemReferenceBinding)object).problemId() & 2) == 0)) {
            object2 = ((ProblemReferenceBinding)object).closestMatch();
        }
        return object2;
    }

    private boolean isLikelyLocalTypeName(char[] cArray) {
        int n = CharOperation.lastIndexOf('$', cArray);
        while (n != -1 && n + 1 < cArray.length) {
            if (Character.isDigit(cArray[n + 1])) {
                return true;
            }
            n = CharOperation.lastIndexOf('$', cArray, 0, n - 1);
        }
        return false;
    }

    private TypeBinding getANewArrayTypeBinding(char[] cArray, Scope scope) {
        if (cArray[0] == '[') {
            int n = this.getDimensions(cArray);
            if (cArray.length - n == 1) {
                BaseTypeBinding baseTypeBinding = null;
                switch (cArray[cArray.length - 1]) {
                    case 'Z': {
                        baseTypeBinding = TypeBinding.BOOLEAN;
                        break;
                    }
                    case 'B': {
                        baseTypeBinding = TypeBinding.BYTE;
                        break;
                    }
                    case 'C': {
                        baseTypeBinding = TypeBinding.CHAR;
                        break;
                    }
                    case 'D': {
                        baseTypeBinding = TypeBinding.DOUBLE;
                        break;
                    }
                    case 'F': {
                        baseTypeBinding = TypeBinding.FLOAT;
                        break;
                    }
                    case 'I': {
                        baseTypeBinding = TypeBinding.INT;
                        break;
                    }
                    case 'J': {
                        baseTypeBinding = TypeBinding.LONG;
                        break;
                    }
                    case 'S': {
                        baseTypeBinding = TypeBinding.SHORT;
                        break;
                    }
                    case 'V': {
                        baseTypeBinding = TypeBinding.VOID;
                    }
                }
                return scope.createArrayType(baseTypeBinding, n);
            }
            char[] cArray2 = CharOperation.subarray(cArray, n + 1, cArray.length - 1);
            TypeBinding typeBinding = (TypeBinding)scope.getTypeOrPackage(CharOperation.splitOn('/', cArray2));
            if (!typeBinding.isValidBinding()) {
                ProblemReferenceBinding problemReferenceBinding = (ProblemReferenceBinding)typeBinding;
                if ((problemReferenceBinding.problemId() & 4) != 0 || (problemReferenceBinding.problemId() & 2) != 0) {
                    typeBinding = problemReferenceBinding.closestMatch();
                } else if ((problemReferenceBinding.problemId() & 1) != 0 && this.innerClassesBindings != null) {
                    Set<TypeBinding> set = this.innerClassesBindings.keySet();
                    for (TypeBinding typeBinding2 : set) {
                        if (!CharOperation.equals(typeBinding2.constantPoolName(), cArray2)) continue;
                        typeBinding = typeBinding2;
                        break;
                    }
                }
            }
            return scope.createArrayType(typeBinding, n);
        }
        TypeBinding typeBinding = (TypeBinding)scope.getTypeOrPackage(CharOperation.splitOn('/', cArray));
        if (!typeBinding.isValidBinding()) {
            ProblemReferenceBinding problemReferenceBinding = (ProblemReferenceBinding)typeBinding;
            if ((problemReferenceBinding.problemId() & 4) != 0 || (problemReferenceBinding.problemId() & 2) != 0) {
                typeBinding = problemReferenceBinding.closestMatch();
            } else if ((problemReferenceBinding.problemId() & 1) != 0 && this.innerClassesBindings != null) {
                Set<TypeBinding> set = this.innerClassesBindings.keySet();
                for (TypeBinding typeBinding3 : set) {
                    if (!CharOperation.equals(typeBinding3.constantPoolName(), cArray)) continue;
                    typeBinding = typeBinding3;
                    break;
                }
            }
        }
        return typeBinding;
    }

    public List<StackMapFrame> traverse(MethodBinding methodBinding, int n, byte[] byArray, int n2, int n3, Map<Integer, StackMapFrame> map, boolean bl, Scope scope) {
        Object object;
        int n4;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
        int[] nArray = stackMapFrameCodeStream.getFramePositions();
        int n5 = n2;
        int[] nArray2 = this.constantPool.offsets;
        byte[] byArray2 = this.constantPool.poolContent;
        int n6 = 0;
        int n7 = nArray.length;
        int n8 = nArray[0];
        int n9 = 0;
        StackMapFrameCodeStream.ExceptionMarker[] exceptionMarkerArray = stackMapFrameCodeStream.getExceptionMarkers();
        int n10 = exceptionMarkerArray == null ? 0 : exceptionMarkerArray.length;
        boolean bl2 = n10 != 0;
        StackMapFrameCodeStream.ExceptionMarker exceptionMarker = null;
        if (bl2) {
            exceptionMarker = exceptionMarkerArray[0];
        }
        StackMapFrame stackMapFrame = new StackMapFrame(n);
        if (!bl) {
            this.initializeDefaultLocals(stackMapFrame, methodBinding, n, n3);
        }
        stackMapFrame.pc = -1;
        this.add(map, stackMapFrame.duplicate(), scope);
        this.addRealJumpTarget(hashSet, -1);
        int n11 = this.codeStream.exceptionLabelsCounter;
        for (n4 = 0; n4 < n11; ++n4) {
            object = this.codeStream.exceptionLabels[n4];
            if (object == null) continue;
            this.addRealJumpTarget(hashSet, ((ExceptionLabel)object).position);
        }
        block155: do {
            n4 = n5 - n2;
            if (bl2 && exceptionMarker.pc == n4) {
                stackMapFrame.numberOfStackItems = 0;
                stackMapFrame.addStackItem(new VerificationTypeInfo(exceptionMarker.getBinding()));
                if (++n9 < n10) {
                    exceptionMarker = exceptionMarkerArray[n9];
                } else {
                    bl2 = false;
                }
            }
            if (n8 < n4) {
                while ((n8 = ++n6 < n7 ? nArray[n6] : Integer.MAX_VALUE) < n4) {
                }
            }
            if (n8 == n4) {
                StackMapFrame stackMapFrame2 = map.get(n4);
                if (stackMapFrame2 == null) {
                    stackMapFrame2 = this.createNewFrame(n4, stackMapFrame, bl, methodBinding);
                    this.add(map, stackMapFrame2, scope);
                } else {
                    stackMapFrame = stackMapFrame2.merge(stackMapFrame.duplicate(), scope).duplicate();
                }
                n8 = ++n6 < n7 ? nArray[n6] : Integer.MAX_VALUE;
            }
            n11 = (byte)this.u1At(byArray, 0, n5);
            switch (n11) {
                case 0: {
                    ++n5;
                    break;
                }
                case 1: {
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.NULL));
                    ++n5;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.INT));
                    ++n5;
                    break;
                }
                case 9: 
                case 10: {
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.LONG));
                    ++n5;
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.FLOAT));
                    ++n5;
                    break;
                }
                case 14: 
                case 15: {
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.DOUBLE));
                    ++n5;
                    break;
                }
                case 16: {
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.BYTE));
                    n5 += 2;
                    break;
                }
                case 17: {
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.SHORT));
                    n5 += 3;
                    break;
                }
                case 18: {
                    int n12 = this.u1At(byArray, 1, n5);
                    switch (this.u1At(byArray2, 0, nArray2[n12])) {
                        case 8: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(scope.getJavaLangString()));
                            break;
                        }
                        case 3: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.INT));
                            break;
                        }
                        case 4: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.FLOAT));
                            break;
                        }
                        case 7: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(scope.getJavaLangClass()));
                        }
                    }
                    n5 += 2;
                    break;
                }
                case 19: {
                    int n12 = this.u2At(byArray, 1, n5);
                    switch (this.u1At(byArray2, 0, nArray2[n12])) {
                        case 8: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(scope.getJavaLangString()));
                            break;
                        }
                        case 3: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.INT));
                            break;
                        }
                        case 4: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.FLOAT));
                            break;
                        }
                        case 7: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(scope.getJavaLangClass()));
                        }
                    }
                    n5 += 3;
                    break;
                }
                case 20: {
                    int n12 = this.u2At(byArray, 1, n5);
                    switch (this.u1At(byArray2, 0, nArray2[n12])) {
                        case 6: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.DOUBLE));
                            break;
                        }
                        case 5: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.LONG));
                        }
                    }
                    n5 += 3;
                    break;
                }
                case 21: {
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.INT));
                    n5 += 2;
                    break;
                }
                case 22: {
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.LONG));
                    n5 += 2;
                    break;
                }
                case 23: {
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.FLOAT));
                    n5 += 2;
                    break;
                }
                case 24: {
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.DOUBLE));
                    n5 += 2;
                    break;
                }
                case 25: {
                    int n12 = this.u1At(byArray, 1, n5);
                    object = this.retrieveLocal(n4, n12);
                    stackMapFrame.addStackItem((VerificationTypeInfo)object);
                    n5 += 2;
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.INT));
                    ++n5;
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.LONG));
                    ++n5;
                    break;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.FLOAT));
                    ++n5;
                    break;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.DOUBLE));
                    ++n5;
                    break;
                }
                case 42: {
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.locals[0];
                    if (verificationTypeInfo == null || verificationTypeInfo.tag != 6) {
                        verificationTypeInfo = this.retrieveLocal(n4, 0);
                    }
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    ++n5;
                    break;
                }
                case 43: {
                    VerificationTypeInfo verificationTypeInfo = this.retrieveLocal(n4, 1);
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    ++n5;
                    break;
                }
                case 44: {
                    VerificationTypeInfo verificationTypeInfo = this.retrieveLocal(n4, 2);
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    ++n5;
                    break;
                }
                case 45: {
                    VerificationTypeInfo verificationTypeInfo = this.retrieveLocal(n4, 3);
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    ++n5;
                    break;
                }
                case 46: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.INT));
                    ++n5;
                    break;
                }
                case 47: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.LONG));
                    ++n5;
                    break;
                }
                case 48: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.FLOAT));
                    ++n5;
                    break;
                }
                case 49: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.DOUBLE));
                    ++n5;
                    break;
                }
                case 50: {
                    --stackMapFrame.numberOfStackItems;
                    stackMapFrame.replaceWithElementType();
                    ++n5;
                    break;
                }
                case 51: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.BYTE));
                    ++n5;
                    break;
                }
                case 52: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.CHAR));
                    ++n5;
                    break;
                }
                case 53: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.SHORT));
                    ++n5;
                    break;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    --stackMapFrame.numberOfStackItems;
                    n5 += 2;
                    break;
                }
                case 58: {
                    int n12 = this.u1At(byArray, 1, n5);
                    --stackMapFrame.numberOfStackItems;
                    n5 += 2;
                    break;
                }
                case 75: {
                    stackMapFrame.locals[0] = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    ++n5;
                    break;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 76: 
                case 77: 
                case 78: {
                    --stackMapFrame.numberOfStackItems;
                    ++n5;
                    break;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    stackMapFrame.numberOfStackItems -= 3;
                    ++n5;
                    break;
                }
                case 87: {
                    --stackMapFrame.numberOfStackItems;
                    ++n5;
                    break;
                }
                case 88: {
                    int n13 = stackMapFrame.numberOfStackItems--;
                    switch (stackMapFrame.stackItems[n13 - 1].id()) {
                        case 7: 
                        case 8: {
                            break;
                        }
                        default: {
                            stackMapFrame.numberOfStackItems -= 2;
                        }
                    }
                    ++n5;
                    break;
                }
                case 89: {
                    stackMapFrame.addStackItem(stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1]);
                    ++n5;
                    break;
                }
                case 90: {
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    VerificationTypeInfo verificationTypeInfo2 = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    stackMapFrame.addStackItem(verificationTypeInfo2);
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    ++n5;
                    break;
                }
                case 91: {
                    int n13;
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    VerificationTypeInfo verificationTypeInfo2 = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    switch (verificationTypeInfo2.id()) {
                        case 7: 
                        case 8: {
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            break;
                        }
                        default: {
                            n13 = stackMapFrame.numberOfStackItems--;
                            VerificationTypeInfo verificationTypeInfo3 = stackMapFrame.stackItems[n13 - 1];
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo3);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                        }
                    }
                    ++n5;
                    break;
                }
                case 92: {
                    VerificationTypeInfo verificationTypeInfo2;
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    switch (verificationTypeInfo.id()) {
                        case 7: 
                        case 8: {
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            break;
                        }
                        default: {
                            verificationTypeInfo2 = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                            --stackMapFrame.numberOfStackItems;
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                        }
                    }
                    ++n5;
                    break;
                }
                case 93: {
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    VerificationTypeInfo verificationTypeInfo2 = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    switch (verificationTypeInfo.id()) {
                        case 7: 
                        case 8: {
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            break;
                        }
                        default: {
                            VerificationTypeInfo verificationTypeInfo4 = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                            --stackMapFrame.numberOfStackItems;
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo4);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                        }
                    }
                    ++n5;
                    break;
                }
                case 94: {
                    int n13 = stackMapFrame.numberOfStackItems--;
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[n13 - 1];
                    VerificationTypeInfo verificationTypeInfo2 = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    block123 : switch (verificationTypeInfo.id()) {
                        case 7: 
                        case 8: {
                            switch (verificationTypeInfo2.id()) {
                                case 7: 
                                case 8: {
                                    stackMapFrame.addStackItem(verificationTypeInfo);
                                    stackMapFrame.addStackItem(verificationTypeInfo2);
                                    stackMapFrame.addStackItem(verificationTypeInfo);
                                    break block123;
                                }
                            }
                            n13 = stackMapFrame.numberOfStackItems--;
                            VerificationTypeInfo verificationTypeInfo5 = stackMapFrame.stackItems[n13 - 1];
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo5);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            break;
                        }
                        default: {
                            n13 = stackMapFrame.numberOfStackItems--;
                            VerificationTypeInfo verificationTypeInfo6 = stackMapFrame.stackItems[n13 - 1];
                            switch (verificationTypeInfo6.id()) {
                                case 7: 
                                case 8: {
                                    stackMapFrame.addStackItem(verificationTypeInfo2);
                                    stackMapFrame.addStackItem(verificationTypeInfo);
                                    stackMapFrame.addStackItem(verificationTypeInfo6);
                                    stackMapFrame.addStackItem(verificationTypeInfo2);
                                    stackMapFrame.addStackItem(verificationTypeInfo);
                                    break block123;
                                }
                            }
                            n13 = stackMapFrame.numberOfStackItems--;
                            VerificationTypeInfo verificationTypeInfo7 = stackMapFrame.stackItems[n13 - 1];
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo7);
                            stackMapFrame.addStackItem(verificationTypeInfo6);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                        }
                    }
                    ++n5;
                    break;
                }
                case 95: {
                    VerificationTypeInfo verificationTypeInfo2;
                    int n13 = stackMapFrame.numberOfStackItems;
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[n13 - 1];
                    stackMapFrame.stackItems[n13 - 1] = verificationTypeInfo2 = stackMapFrame.stackItems[n13 - 2];
                    stackMapFrame.stackItems[n13 - 2] = verificationTypeInfo;
                    ++n5;
                    break;
                }
                case -128: 
                case -127: 
                case -126: 
                case -125: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    --stackMapFrame.numberOfStackItems;
                    ++n5;
                    break;
                }
                case 116: 
                case 117: 
                case 118: 
                case 119: {
                    ++n5;
                    break;
                }
                case -124: {
                    n5 += 3;
                    break;
                }
                case -123: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.LONG);
                    ++n5;
                    break;
                }
                case -122: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.FLOAT);
                    ++n5;
                    break;
                }
                case -121: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.DOUBLE);
                    ++n5;
                    break;
                }
                case -120: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.INT);
                    ++n5;
                    break;
                }
                case -119: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.FLOAT);
                    ++n5;
                    break;
                }
                case -118: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.DOUBLE);
                    ++n5;
                    break;
                }
                case -117: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.INT);
                    ++n5;
                    break;
                }
                case -116: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.LONG);
                    ++n5;
                    break;
                }
                case -115: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.DOUBLE);
                    ++n5;
                    break;
                }
                case -114: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.INT);
                    ++n5;
                    break;
                }
                case -113: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.LONG);
                    ++n5;
                    break;
                }
                case -112: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.FLOAT);
                    ++n5;
                    break;
                }
                case -111: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.BYTE);
                    ++n5;
                    break;
                }
                case -110: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.CHAR);
                    ++n5;
                    break;
                }
                case -109: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.SHORT);
                    ++n5;
                    break;
                }
                case -108: 
                case -107: 
                case -106: 
                case -105: 
                case -104: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.INT));
                    ++n5;
                    break;
                }
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: {
                    --stackMapFrame.numberOfStackItems;
                    int n14 = n4 + this.i2At(byArray, 1, n5);
                    this.addRealJumpTarget(hashSet, n14, map, this.createNewFrame(n14, stackMapFrame, bl, methodBinding), scope);
                    n5 += 3;
                    break;
                }
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: 
                case -91: 
                case -90: {
                    stackMapFrame.numberOfStackItems -= 2;
                    int n15 = n4 + this.i2At(byArray, 1, n5);
                    this.addRealJumpTarget(hashSet, n15, map, this.createNewFrame(n15, stackMapFrame, bl, methodBinding), scope);
                    n5 += 3;
                    break;
                }
                case -89: {
                    int n16 = n4 + this.i2At(byArray, 1, n5);
                    this.addRealJumpTarget(hashSet, n16, map, this.createNewFrame(n16, stackMapFrame, bl, methodBinding), scope);
                    this.addRealJumpTarget(hashSet, (n5 += 3) - n2);
                    break;
                }
                case -86: {
                    int n17;
                    --stackMapFrame.numberOfStackItems;
                    ++n5;
                    while ((n5 - n2 & 3) != 0) {
                        ++n5;
                    }
                    int n18 = n4 + this.i4At(byArray, 0, n5);
                    this.addRealJumpTarget(hashSet, n18, map, this.createNewFrame(n18, stackMapFrame, bl, methodBinding), scope);
                    int n19 = this.i4At(byArray, 0, n5 += 4);
                    int n20 = this.i4At(byArray, 0, n5 += 4);
                    n5 += 4;
                    int n21 = n20 - n19 + 1;
                    for (n17 = 0; n17 < n21; ++n17) {
                        n18 = n4 + this.i4At(byArray, 0, n5);
                        this.addRealJumpTarget(hashSet, n18, map, this.createNewFrame(n18, stackMapFrame, bl, methodBinding), scope);
                        n5 += 4;
                    }
                    continue block155;
                }
                case -85: {
                    int n22;
                    --stackMapFrame.numberOfStackItems;
                    ++n5;
                    while ((n5 - n2 & 3) != 0) {
                        ++n5;
                    }
                    int n23 = n4 + this.i4At(byArray, 0, n5);
                    this.addRealJumpTarget(hashSet, n23, map, this.createNewFrame(n23, stackMapFrame, bl, methodBinding), scope);
                    int n17 = (int)this.u4At(byArray, 0, n5 += 4);
                    n5 += 4;
                    for (n22 = 0; n22 < n17; ++n22) {
                        n23 = n4 + this.i4At(byArray, 0, n5 += 4);
                        this.addRealJumpTarget(hashSet, n23, map, this.createNewFrame(n23, stackMapFrame, bl, methodBinding), scope);
                        n5 += 4;
                    }
                    continue block155;
                }
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: {
                    --stackMapFrame.numberOfStackItems;
                    this.addRealJumpTarget(hashSet, ++n5 - n2);
                    break;
                }
                case -79: {
                    this.addRealJumpTarget(hashSet, ++n5 - n2);
                    break;
                }
                case -78: {
                    int n12 = this.u2At(byArray, 1, n5);
                    int n22 = this.u2At(byArray2, 3, nArray2[n12]);
                    int n24 = this.u2At(byArray2, 3, nArray2[n22]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n24] + 3, this.u2At(byArray2, 1, nArray2[n24]));
                    TypeBinding typeBinding = this.getTypeBinding(cArray, scope, false);
                    if (typeBinding != null) {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(typeBinding));
                    }
                    n5 += 3;
                    break;
                }
                case -77: {
                    --stackMapFrame.numberOfStackItems;
                    n5 += 3;
                    break;
                }
                case -76: {
                    int n12 = this.u2At(byArray, 1, n5);
                    int n22 = this.u2At(byArray2, 3, nArray2[n12]);
                    int n24 = this.u2At(byArray2, 3, nArray2[n22]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n24] + 3, this.u2At(byArray2, 1, nArray2[n24]));
                    --stackMapFrame.numberOfStackItems;
                    TypeBinding typeBinding = this.getTypeBinding(cArray, scope, false);
                    if (typeBinding != null) {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(typeBinding));
                    }
                    n5 += 3;
                    break;
                }
                case -75: {
                    stackMapFrame.numberOfStackItems -= 2;
                    n5 += 3;
                    break;
                }
                case -74: {
                    int n12 = this.u2At(byArray, 1, n5);
                    int n22 = this.u2At(byArray2, 3, nArray2[n12]);
                    int n24 = this.u2At(byArray2, 3, nArray2[n22]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n24] + 3, this.u2At(byArray2, 1, nArray2[n24]));
                    n24 = this.u2At(byArray2, 1, nArray2[n22]);
                    char[] cArray2 = this.utf8At(byArray2, nArray2[n24] + 3, this.u2At(byArray2, 1, nArray2[n24]));
                    stackMapFrame.numberOfStackItems -= this.getParametersCount(cArray) + 1;
                    char[] cArray3 = this.getReturnType(cArray);
                    TypeBinding typeBinding = this.getTypeBinding(cArray3, scope, false);
                    if (typeBinding != null) {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(typeBinding));
                    }
                    n5 += 3;
                    break;
                }
                case -70: {
                    int n12 = this.u2At(byArray, 1, n5);
                    int n22 = this.u2At(byArray2, 3, nArray2[n12]);
                    int n24 = this.u2At(byArray2, 3, nArray2[n22]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n24] + 3, this.u2At(byArray2, 1, nArray2[n24]));
                    stackMapFrame.numberOfStackItems -= this.getParametersCount(cArray);
                    char[] cArray3 = this.getReturnType(cArray);
                    TypeBinding typeBinding = this.getTypeBinding(cArray3, scope, false);
                    if (typeBinding != null) {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(typeBinding));
                    }
                    n5 += 5;
                    break;
                }
                case -73: {
                    int n12 = this.u2At(byArray, 1, n5);
                    int n22 = this.u2At(byArray2, 3, nArray2[n12]);
                    int n24 = this.u2At(byArray2, 3, nArray2[n22]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n24] + 3, this.u2At(byArray2, 1, nArray2[n24]));
                    n24 = this.u2At(byArray2, 1, nArray2[n22]);
                    char[] cArray2 = this.utf8At(byArray2, nArray2[n24] + 3, this.u2At(byArray2, 1, nArray2[n24]));
                    stackMapFrame.numberOfStackItems -= this.getParametersCount(cArray);
                    if (CharOperation.equals(ConstantPool.Init, cArray2)) {
                        stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1].tag = 7;
                    }
                    --stackMapFrame.numberOfStackItems;
                    char[] cArray3 = this.getReturnType(cArray);
                    TypeBinding typeBinding = this.getTypeBinding(cArray3, scope, false);
                    if (typeBinding != null) {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(typeBinding));
                    }
                    n5 += 3;
                    break;
                }
                case -72: {
                    int n12 = this.u2At(byArray, 1, n5);
                    int n22 = this.u2At(byArray2, 3, nArray2[n12]);
                    int n24 = this.u2At(byArray2, 3, nArray2[n22]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n24] + 3, this.u2At(byArray2, 1, nArray2[n24]));
                    n24 = this.u2At(byArray2, 1, nArray2[n22]);
                    char[] cArray2 = this.utf8At(byArray2, nArray2[n24] + 3, this.u2At(byArray2, 1, nArray2[n24]));
                    stackMapFrame.numberOfStackItems -= this.getParametersCount(cArray);
                    char[] cArray3 = this.getReturnType(cArray);
                    TypeBinding typeBinding = this.getTypeBinding(cArray3, scope, false);
                    if (typeBinding != null) {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(typeBinding));
                    }
                    n5 += 3;
                    break;
                }
                case -71: {
                    int n12 = this.u2At(byArray, 1, n5);
                    int n22 = this.u2At(byArray2, 3, nArray2[n12]);
                    int n24 = this.u2At(byArray2, 3, nArray2[n22]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n24] + 3, this.u2At(byArray2, 1, nArray2[n24]));
                    n24 = this.u2At(byArray2, 1, nArray2[n22]);
                    char[] cArray2 = this.utf8At(byArray2, nArray2[n24] + 3, this.u2At(byArray2, 1, nArray2[n24]));
                    stackMapFrame.numberOfStackItems -= this.getParametersCount(cArray) + 1;
                    char[] cArray3 = this.getReturnType(cArray);
                    TypeBinding typeBinding = this.getTypeBinding(cArray3, scope, false);
                    if (typeBinding != null) {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(typeBinding));
                    }
                    n5 += 5;
                    break;
                }
                case -69: {
                    int n12 = this.u2At(byArray, 1, n5);
                    int n24 = this.u2At(byArray2, 1, nArray2[n12]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n24] + 3, this.u2At(byArray2, 1, nArray2[n24]));
                    TypeBinding typeBinding = this.getNewTypeBinding(cArray, scope);
                    VerificationTypeInfo verificationTypeInfo = new VerificationTypeInfo(8, typeBinding);
                    verificationTypeInfo.offset = n4;
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    n5 += 3;
                    break;
                }
                case -68: {
                    ArrayBinding arrayBinding = null;
                    switch (this.u1At(byArray, 1, n5)) {
                        case 10: {
                            arrayBinding = scope.createArrayType(TypeBinding.INT, 1);
                            break;
                        }
                        case 8: {
                            arrayBinding = scope.createArrayType(TypeBinding.BYTE, 1);
                            break;
                        }
                        case 4: {
                            arrayBinding = scope.createArrayType(TypeBinding.BOOLEAN, 1);
                            break;
                        }
                        case 9: {
                            arrayBinding = scope.createArrayType(TypeBinding.SHORT, 1);
                            break;
                        }
                        case 5: {
                            arrayBinding = scope.createArrayType(TypeBinding.CHAR, 1);
                            break;
                        }
                        case 11: {
                            arrayBinding = scope.createArrayType(TypeBinding.LONG, 1);
                            break;
                        }
                        case 6: {
                            arrayBinding = scope.createArrayType(TypeBinding.FLOAT, 1);
                            break;
                        }
                        case 7: {
                            arrayBinding = scope.createArrayType(TypeBinding.DOUBLE, 1);
                        }
                    }
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(arrayBinding);
                    n5 += 2;
                    break;
                }
                case -67: {
                    int n12 = this.u2At(byArray, 1, n5);
                    int n24 = this.u2At(byArray2, 1, nArray2[n12]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n24] + 3, this.u2At(byArray2, 1, nArray2[n24]));
                    --stackMapFrame.numberOfStackItems;
                    TypeBinding typeBinding = this.getANewArrayTypeBinding(cArray, scope);
                    if (typeBinding != null) {
                        if (typeBinding.isArrayType()) {
                            ArrayBinding arrayBinding = (ArrayBinding)typeBinding;
                            stackMapFrame.addStackItem(new VerificationTypeInfo(scope.createArrayType(arrayBinding.leafComponentType(), arrayBinding.dimensions + 1)));
                        } else {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(scope.createArrayType(typeBinding, 1)));
                        }
                    }
                    n5 += 3;
                    break;
                }
                case -66: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.INT);
                    ++n5;
                    break;
                }
                case -65: {
                    --stackMapFrame.numberOfStackItems;
                    this.addRealJumpTarget(hashSet, ++n5 - n2);
                    break;
                }
                case -64: {
                    int n12 = this.u2At(byArray, 1, n5);
                    int n24 = this.u2At(byArray2, 1, nArray2[n12]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n24] + 3, this.u2At(byArray2, 1, nArray2[n24]));
                    TypeBinding typeBinding = this.getTypeBinding(cArray, scope, true);
                    if (typeBinding != null) {
                        stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(typeBinding);
                    }
                    n5 += 3;
                    break;
                }
                case -63: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.INT);
                    n5 += 3;
                    break;
                }
                case -62: 
                case -61: {
                    --stackMapFrame.numberOfStackItems;
                    ++n5;
                    break;
                }
                case -60: {
                    n11 = (byte)this.u1At(byArray, 1, n5);
                    if (n11 == -124) {
                        n5 += 6;
                        break;
                    }
                    int n12 = this.u2At(byArray, 2, n5);
                    switch (n11) {
                        case 21: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.INT));
                            break;
                        }
                        case 23: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.FLOAT));
                            break;
                        }
                        case 25: {
                            object = stackMapFrame.locals[n12];
                            if (object == null) {
                                object = this.retrieveLocal(n4, n12);
                            }
                            stackMapFrame.addStackItem((VerificationTypeInfo)object);
                            break;
                        }
                        case 22: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.LONG));
                            break;
                        }
                        case 24: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(TypeBinding.DOUBLE));
                            break;
                        }
                        case 54: {
                            --stackMapFrame.numberOfStackItems;
                            break;
                        }
                        case 56: {
                            --stackMapFrame.numberOfStackItems;
                            break;
                        }
                        case 58: {
                            stackMapFrame.locals[n12] = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                            --stackMapFrame.numberOfStackItems;
                            break;
                        }
                        case 55: {
                            --stackMapFrame.numberOfStackItems;
                            break;
                        }
                        case 57: {
                            --stackMapFrame.numberOfStackItems;
                        }
                    }
                    n5 += 4;
                    break;
                }
                case -59: {
                    int n12 = this.u2At(byArray, 1, n5);
                    int n24 = this.u2At(byArray2, 1, nArray2[n12]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n24] + 3, this.u2At(byArray2, 1, nArray2[n24]));
                    int n25 = this.u1At(byArray, 3, n5);
                    stackMapFrame.numberOfStackItems -= n25;
                    TypeBinding typeBinding = this.getTypeBinding(cArray, scope, false);
                    if (typeBinding != null) {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(typeBinding));
                    }
                    n5 += 4;
                    break;
                }
                case -58: 
                case -57: {
                    --stackMapFrame.numberOfStackItems;
                    int n26 = n4 + this.i2At(byArray, 1, n5);
                    this.addRealJumpTarget(hashSet, n26, map, this.createNewFrame(n26, stackMapFrame, bl, methodBinding), scope);
                    n5 += 3;
                    break;
                }
                case -56: {
                    int n27 = n4 + this.i4At(byArray, 1, n5);
                    this.addRealJumpTarget(hashSet, n27, map, this.createNewFrame(n27, stackMapFrame, bl, methodBinding), scope);
                    this.addRealJumpTarget(hashSet, (n5 += 5) - n2);
                    break;
                }
                default: {
                    if (this.codeStream.methodDeclaration != null) {
                        this.codeStream.methodDeclaration.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidOpcode, new Object[]{(byte)n11, n5, new String(methodBinding.shortReadableName())}), this.codeStream.methodDeclaration);
                        break;
                    }
                    this.codeStream.lambdaExpression.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidOpcode, new Object[]{(byte)n11, n5, new String(methodBinding.shortReadableName())}), this.codeStream.lambdaExpression);
                }
            }
        } while (n5 < n3 + n2);
        return this.filterFakeFrames(hashSet, map, n3);
    }

    private StackMapFrame createNewFrame(int n, StackMapFrame stackMapFrame, boolean bl, MethodBinding methodBinding) {
        StackMapFrame stackMapFrame2 = stackMapFrame.duplicate();
        stackMapFrame2.pc = n;
        this.initializeLocals(bl ? true : methodBinding.isStatic(), n, stackMapFrame2);
        return stackMapFrame2;
    }

    private int getDimensions(char[] cArray) {
        int n = 0;
        while (cArray[n] == '[') {
            ++n;
        }
        return n;
    }

    private void addRealJumpTarget(Set<Integer> set, int n) {
        set.add(n);
    }

    private void addRealJumpTarget(Set<Integer> set, int n, Map<Integer, StackMapFrame> map, StackMapFrame stackMapFrame, Scope scope) {
        set.add(n);
        this.add(map, stackMapFrame, scope);
    }

    private void add(Map<Integer, StackMapFrame> map, StackMapFrame stackMapFrame, Scope scope) {
        Integer n = stackMapFrame.pc;
        StackMapFrame stackMapFrame2 = map.get(n);
        if (stackMapFrame2 == null) {
            map.put(n, stackMapFrame);
        } else {
            map.put(n, stackMapFrame2.merge(stackMapFrame, scope));
        }
    }

    private final int u1At(byte[] byArray, int n, int n2) {
        return byArray[n + n2] & 0xFF;
    }

    private final int u2At(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        return ((byArray[n3++] & 0xFF) << 8) + (byArray[n3] & 0xFF);
    }

    private final long u4At(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        return (((long)byArray[n3++] & 0xFFL) << 24) + (long)((byArray[n3++] & 0xFF) << 16) + (long)((byArray[n3++] & 0xFF) << 8) + (long)(byArray[n3] & 0xFF);
    }

    private final int i2At(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        return (byArray[n3++] << 8) + (byArray[n3] & 0xFF);
    }

    public char[] utf8At(byte[] byArray, int n, int n2) {
        int n3 = n2;
        char[] cArray = new char[n2];
        int n4 = 0;
        int n5 = n;
        while (n3 != 0) {
            int n6 = byArray[n5++] & 0xFF;
            --n3;
            if ((0x80 & n6) != 0) {
                if ((n6 & 0x20) != 0) {
                    n3 -= 2;
                    n6 = (n6 & 0xF) << 12 | (byArray[n5++] & 0x3F) << 6 | byArray[n5++] & 0x3F;
                } else {
                    --n3;
                    n6 = (n6 & 0x1F) << 6 | byArray[n5++] & 0x3F;
                }
            }
            cArray[n4++] = (char)n6;
        }
        if (n4 != n2) {
            char[] cArray2 = cArray;
            cArray = new char[n4];
            System.arraycopy(cArray2, 0, cArray, 0, n4);
        }
        return cArray;
    }
}

