/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SwitchExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.AnnotationContext;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBindingVisitor;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.parser.RecoveryScanner;

public class LocalDeclaration
extends AbstractVariableDeclaration {
    public LocalVariableBinding binding;

    public LocalDeclaration(char[] cArray, int n, int n2) {
        this.name = cArray;
        this.sourceStart = n;
        this.sourceEnd = n2;
        this.declarationEnd = n2;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        boolean bl;
        if ((flowInfo.tagBits & 1) == 0) {
            this.bits |= 0x40000000;
        }
        if (this.initialization == null) {
            return flowInfo;
        }
        this.initialization.checkNPEbyUnboxing(blockScope, flowContext, flowInfo);
        UnconditionalFlowInfo unconditionalFlowInfo = null;
        boolean bl2 = bl = this.binding != null && flowInfo.reachMode() == 0 && blockScope.compilerOptions().analyseResourceLeaks && FakedTrackingVariable.isAnyCloseable(this.initialization.resolvedType);
        if (bl) {
            unconditionalFlowInfo = flowInfo.unconditionalCopy();
            FakedTrackingVariable.preConnectTrackerAcrossAssignment(this, this.binding, this.initialization, flowInfo);
        }
        flowInfo = this.initialization.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
        if (bl) {
            FakedTrackingVariable.handleResourceAssignment(blockScope, unconditionalFlowInfo, flowInfo, flowContext, this, this.initialization, this.binding);
        } else {
            FakedTrackingVariable.cleanUpAfterAssignment(blockScope, 2, this.initialization);
        }
        int n = this.initialization.nullStatus(flowInfo, flowContext);
        this.bits = !flowInfo.isDefinitelyAssigned(this.binding) ? (this.bits |= 8) : (this.bits &= 0xFFFFFFF7);
        flowInfo.markAsDefinitelyAssigned(this.binding);
        if (blockScope.compilerOptions().isAnnotationBasedNullAnalysisEnabled) {
            n = NullAnnotationMatching.checkAssignment(blockScope, flowContext, this.binding, flowInfo, n, this.initialization, this.initialization.resolvedType);
        }
        if ((this.binding.type.tagBits & 2L) == 0L) {
            flowInfo.markNullStatus(this.binding, n);
        }
        return flowInfo;
    }

    public void checkModifiers() {
        if ((this.modifiers & 0xFFFF & 0xFFFFFFEF) != 0) {
            this.modifiers = this.modifiers & 0xFFBFFFFF | 0x800000;
        }
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if (this.binding.resolvedPosition != -1) {
            codeStream.addVisibleLocalVariable(this.binding);
        }
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        if (this.initialization != null) {
            if (this.binding.resolvedPosition < 0) {
                if (this.initialization.constant == Constant.NotAConstant) {
                    this.initialization.generateCode(blockScope, codeStream, false);
                }
            } else {
                this.initialization.generateCode(blockScope, codeStream, true);
                if (this.binding.type.isArrayType() && this.initialization instanceof CastExpression && ((CastExpression)this.initialization).innermostCastedExpression().resolvedType == TypeBinding.NULL) {
                    codeStream.checkcast(this.binding.type);
                }
                codeStream.store(this.binding, false);
                if ((this.bits & 8) != 0) {
                    this.binding.recordInitializationStartPC(codeStream.position);
                }
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public int getKind() {
        return 4;
    }

    public void getAllAnnotationContexts(int n, LocalVariableBinding localVariableBinding, List<AnnotationContext> list) {
        TypeReference.AnnotationCollector annotationCollector = new TypeReference.AnnotationCollector(this, n, localVariableBinding, list);
        this.traverseWithoutInitializer(annotationCollector, null);
    }

    public void getAllAnnotationContexts(int n, int n2, List<AnnotationContext> list) {
        TypeReference.AnnotationCollector annotationCollector = new TypeReference.AnnotationCollector(this, n, n2, list);
        this.traverse(annotationCollector, null);
    }

    public boolean isArgument() {
        return false;
    }

    public boolean isReceiver() {
        return false;
    }

    public TypeBinding patchType(TypeBinding typeBinding) {
        TypeBinding[] typeBindingArray = this.findCapturedTypeVariables(typeBinding);
        if (typeBindingArray != null && typeBindingArray.length > 0) {
            typeBinding = typeBinding.upwardsProjection(this.binding.declaringScope, typeBindingArray);
        }
        this.type.resolvedType = typeBinding;
        if (this.binding != null) {
            this.binding.type = typeBinding;
            this.binding.markInitialized();
        }
        return this.type.resolvedType;
    }

    private TypeVariableBinding[] findCapturedTypeVariables(TypeBinding typeBinding) {
        final HashSet hashSet = new HashSet();
        TypeBindingVisitor.visit(new TypeBindingVisitor(){

            @Override
            public boolean visit(TypeVariableBinding typeVariableBinding) {
                if (typeVariableBinding.isCapture()) {
                    hashSet.add(typeVariableBinding);
                }
                return super.visit(typeVariableBinding);
            }
        }, typeBinding);
        if (hashSet.isEmpty()) {
            return null;
        }
        return hashSet.toArray(new TypeVariableBinding[hashSet.size()]);
    }

    private static Expression findPolyExpression(Expression expression) {
        Expression expression2;
        if (expression instanceof FunctionalExpression) {
            return expression;
        }
        if (expression instanceof ConditionalExpression) {
            expression2 = (ConditionalExpression)expression;
            Object object = LocalDeclaration.findPolyExpression(expression2.valueIfTrue);
            if (object == null) {
                object = LocalDeclaration.findPolyExpression(expression2.valueIfFalse);
            }
            if (object != null) {
                return object;
            }
        }
        if (expression instanceof SwitchExpression) {
            expression2 = (SwitchExpression)expression;
            for (Expression expression3 : ((SwitchExpression)expression2).resultExpressions) {
                Expression expression4 = LocalDeclaration.findPolyExpression(expression3);
                if (expression4 == null) continue;
                return expression4;
            }
        }
        return null;
    }

    @Override
    public void resolve(BlockScope blockScope) {
        this.resolve(blockScope, false);
    }

    public void resolve(final BlockScope blockScope, boolean bl) {
        boolean bl2;
        Binding binding;
        LocalDeclaration.handleNonNullByDefault(blockScope, this.annotations, this);
        TypeBinding typeBinding = null;
        boolean bl3 = false;
        boolean bl4 = this.isTypeNameVar(blockScope);
        if (bl4) {
            if ((this.bits & 0x10) == 0) {
                if (this.initialization != null) {
                    typeBinding = this.checkInferredLocalVariableInitializer(blockScope);
                    bl3 = typeBinding != null;
                } else {
                    blockScope.problemReporter().varLocalWithoutInitizalier(this);
                    typeBinding = blockScope.getJavaLangObject();
                    bl3 = true;
                }
            }
        } else {
            typeBinding = this.type.resolveType(blockScope, true);
        }
        this.bits |= this.type.bits & 0x100000;
        this.checkModifiers();
        if (typeBinding != null) {
            if (typeBinding == TypeBinding.VOID) {
                blockScope.problemReporter().variableTypeCannotBeVoid(this);
                return;
            }
            if (typeBinding.isArrayType() && ((ArrayBinding)typeBinding).leafComponentType == TypeBinding.VOID) {
                blockScope.problemReporter().variableTypeCannotBeVoidArray(this);
                return;
            }
        }
        if ((binding = blockScope.getBinding(this.name, 3, (InvocationSite)this, false)) != null && binding.isValidBinding()) {
            bl2 = binding instanceof LocalVariableBinding;
            if (bl2 && (this.bits & 0x200000) != 0 && blockScope.isLambdaSubscope() && this.hiddenVariableDepth == 0) {
                blockScope.problemReporter().lambdaRedeclaresLocal(this);
            } else if (bl2 && this.hiddenVariableDepth == 0) {
                blockScope.problemReporter().redefineLocal(this);
            } else {
                blockScope.problemReporter().localVariableHiding(this, binding, false);
            }
        }
        if ((this.modifiers & 0x10) != 0 && this.initialization == null) {
            this.modifiers |= 0x4000000;
        }
        this.binding = bl4 ? new LocalVariableBinding(this, typeBinding != null ? typeBinding : blockScope.getJavaLangObject(), this.modifiers, false){
            private boolean isInitialized;
            {
                super(localDeclaration2, typeBinding, n, bl);
                this.isInitialized = false;
            }

            @Override
            public void markReferenced() {
                if (!this.isInitialized) {
                    blockScope.problemReporter().varLocalReferencesItself(LocalDeclaration.this);
                    this.type = null;
                    this.isInitialized = true;
                }
            }

            @Override
            public void markInitialized() {
                this.isInitialized = true;
            }
        } : new LocalVariableBinding(this, typeBinding, this.modifiers, false);
        blockScope.addLocalVariable(this.binding);
        this.binding.setConstant(Constant.NotAConstant);
        if (typeBinding == null && this.initialization != null) {
            if (this.initialization instanceof CastExpression) {
                ((CastExpression)this.initialization).setVarTypeDeclaration(true);
            }
            this.initialization.resolveType(blockScope);
            if (bl4 && this.initialization.resolvedType != null) {
                if (TypeBinding.equalsEquals(TypeBinding.NULL, this.initialization.resolvedType)) {
                    blockScope.problemReporter().varLocalInitializedToNull(this);
                    bl3 = true;
                } else if (TypeBinding.equalsEquals(TypeBinding.VOID, this.initialization.resolvedType)) {
                    blockScope.problemReporter().varLocalInitializedToVoid(this);
                    bl3 = true;
                }
                typeBinding = this.patchType(this.initialization.resolvedType);
            } else {
                bl3 = true;
            }
        }
        this.binding.markInitialized();
        if (bl3) {
            return;
        }
        bl2 = false;
        if (blockScope.environment().usesNullTypeAnnotations() && !bl4 && typeBinding != null && typeBinding.isValidBinding()) {
            boolean bl5 = bl2 = this.initialization instanceof Invocation || this.initialization instanceof ConditionalExpression || this.initialization instanceof SwitchExpression || this.initialization instanceof ArrayInitializer;
        }
        if (bl2) {
            LocalDeclaration.resolveAnnotations(blockScope, this.annotations, this.binding, true);
            typeBinding = this.type.resolvedType;
        }
        if (this.initialization != null) {
            if (this.initialization instanceof ArrayInitializer) {
                TypeBinding typeBinding2 = this.initialization.resolveTypeExpecting(blockScope, typeBinding);
                if (typeBinding2 != null) {
                    ((ArrayInitializer)this.initialization).binding = (ArrayBinding)typeBinding2;
                    this.initialization.computeConversion(blockScope, typeBinding, typeBinding2);
                }
            } else {
                TypeBinding typeBinding3;
                this.initialization.setExpressionContext(bl4 ? ExpressionContext.VANILLA_CONTEXT : ExpressionContext.ASSIGNMENT_CONTEXT);
                this.initialization.setExpectedType(typeBinding);
                TypeBinding typeBinding4 = typeBinding3 = this.initialization.resolvedType != null ? this.initialization.resolvedType : this.initialization.resolveType(blockScope);
                if (typeBinding3 != null) {
                    if (TypeBinding.notEquals(typeBinding, typeBinding3)) {
                        blockScope.compilationUnitScope().recordTypeConversion(typeBinding, typeBinding3);
                    }
                    if (this.initialization.isConstantValueOfTypeAssignableToType(typeBinding3, typeBinding) || typeBinding3.isCompatibleWith(typeBinding, blockScope)) {
                        this.initialization.computeConversion(blockScope, typeBinding, typeBinding3);
                        if (typeBinding3.needsUncheckedConversion(typeBinding)) {
                            blockScope.problemReporter().unsafeTypeConversion(this.initialization, typeBinding3, typeBinding);
                        }
                        if (this.initialization instanceof CastExpression && (this.initialization.bits & 0x4000) == 0) {
                            CastExpression.checkNeedForAssignedCast(blockScope, typeBinding, (CastExpression)this.initialization);
                        }
                    } else if (this.isBoxingCompatible(typeBinding3, typeBinding, this.initialization, blockScope)) {
                        this.initialization.computeConversion(blockScope, typeBinding, typeBinding3);
                        if (this.initialization instanceof CastExpression && (this.initialization.bits & 0x4000) == 0) {
                            CastExpression.checkNeedForAssignedCast(blockScope, typeBinding, (CastExpression)this.initialization);
                        }
                    } else if ((typeBinding.tagBits & 0x80L) == 0L) {
                        blockScope.problemReporter().typeMismatchError(typeBinding3, typeBinding, this.initialization, null);
                    }
                }
            }
            if (this.binding == Expression.getDirectBinding(this.initialization)) {
                blockScope.problemReporter().assignmentHasNoEffect(this, this.name);
            }
            this.binding.setConstant(this.binding.isFinal() ? this.initialization.constant.castTo((typeBinding.id << 4) + this.initialization.constant.typeID()) : Constant.NotAConstant);
        }
        if (!bl2) {
            LocalDeclaration.resolveAnnotations(blockScope, this.annotations, this.binding, true);
        }
        Annotation.isTypeUseCompatible(this.type, blockScope, this.annotations);
        this.validateNullAnnotations(blockScope);
    }

    void validateNullAnnotations(BlockScope blockScope) {
        if (!blockScope.validateNullAnnotation(this.binding.tagBits, this.type, this.annotations)) {
            this.binding.tagBits &= 0xFE7FFFFFFFFFFFFFL;
        }
    }

    private TypeBinding checkInferredLocalVariableInitializer(BlockScope blockScope) {
        TypeBinding typeBinding = null;
        if (this.initialization instanceof ArrayInitializer) {
            blockScope.problemReporter().varLocalCannotBeArrayInitalizers(this);
            typeBinding = blockScope.createArrayType(blockScope.getJavaLangObject(), 1);
        } else {
            Expression expression = LocalDeclaration.findPolyExpression(this.initialization);
            if (expression instanceof ReferenceExpression) {
                blockScope.problemReporter().varLocalCannotBeMethodReference(this);
                typeBinding = TypeBinding.NULL;
            } else if (expression != null) {
                blockScope.problemReporter().varLocalCannotBeLambda(this);
                typeBinding = TypeBinding.NULL;
            }
        }
        if (this.type.dimensions() > 0 || this.type.extraDimensions() > 0) {
            blockScope.problemReporter().varLocalCannotBeArray(this);
            typeBinding = blockScope.createArrayType(blockScope.getJavaLangObject(), 1);
        }
        if ((this.bits & 0x400000) != 0) {
            blockScope.problemReporter().varLocalMultipleDeclarators(this);
            typeBinding = this.initialization.resolveType(blockScope);
        }
        return typeBinding;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.annotations != null) {
                int n = this.annotations.length;
                for (int i = 0; i < n; ++i) {
                    this.annotations[i].traverse(aSTVisitor, blockScope);
                }
            }
            this.type.traverse(aSTVisitor, blockScope);
            if (this.initialization != null) {
                this.initialization.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    private void traverseWithoutInitializer(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.annotations != null) {
                int n = this.annotations.length;
                for (int i = 0; i < n; ++i) {
                    this.annotations[i].traverse(aSTVisitor, blockScope);
                }
            }
            this.type.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public boolean isRecoveredFromLoneIdentifier() {
        return this.name == RecoveryScanner.FAKE_IDENTIFIER && (this.type instanceof SingleTypeReference || this.type instanceof QualifiedTypeReference && !(this.type instanceof ArrayQualifiedTypeReference)) && this.initialization == null && !this.type.isBaseTypeReference();
    }

    public boolean isTypeNameVar(Scope scope) {
        return this.type != null && this.type.isTypeNameVar(scope);
    }
}

