/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import weka.classifiers.functions.supportVector.CachedKernel;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionMetadata;
import weka.core.RevisionUtils;

public class RBFKernel
extends CachedKernel {
    static final long serialVersionUID = 5247117544316387852L;
    protected double m_gamma = 0.01;
    protected double[] m_kernelPrecalc;

    public RBFKernel() {
    }

    public RBFKernel(Instances data, int cacheSize, double gamma) throws Exception {
        this.setCacheSize(cacheSize);
        this.setGamma(gamma);
        this.buildKernel(data);
    }

    @Override
    public void buildKernel(Instances data) throws Exception {
        super.buildKernel(data);
        this.m_kernelPrecalc = new double[data.numInstances()];
        for (int i = 0; i < data.numInstances(); ++i) {
            double sum = 0.0;
            Instance inst = data.instance(i);
            for (int j = 0; j < inst.numValues(); ++j) {
                if (inst.index(j) == data.classIndex()) continue;
                sum += inst.valueSparse(j) * inst.valueSparse(j);
            }
            this.m_kernelPrecalc[i] = sum;
        }
    }

    @Override
    public String globalInfo() {
        return "The RBF kernel : K(x, y) = exp(-gamma*(x-y)^2)";
    }

    @Override
    protected double evaluate(int id1, int id2, Instance inst1) throws Exception {
        if (id1 == id2) {
            return 1.0;
        }
        if (id1 == -1) {
            return Math.exp(-this.m_gamma * (this.dotProd(inst1, inst1) - 2.0 * this.dotProd(inst1, this.m_data.instance(id2)) + this.m_kernelPrecalc[id2]));
        }
        return Math.exp(-this.m_gamma * (this.m_kernelPrecalc[id1] - 2.0 * this.dotProd(inst1, this.m_data.instance(id2)) + this.m_kernelPrecalc[id2]));
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @OptionMetadata(description="The value to use for the gamma parameter (default: 0.01).", displayName="gamma", commandLineParamName="G", commandLineParamSynopsis="-G <double>", displayOrder=1)
    public void setGamma(double value) {
        this.m_gamma = value;
    }

    public double getGamma() {
        return this.m_gamma;
    }

    public String gammaTipText() {
        return "The gamma value.";
    }

    public String toString() {
        return "RBF Kernel: K(x,y) = exp(-" + this.m_gamma + "*(x-y)^2)";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }
}

