/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.SingleClassifierEnhancer;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Drawable;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializationHelper;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class InputMappedClassifier
extends SingleClassifierEnhancer
implements Serializable,
OptionHandler,
Drawable,
WeightedInstancesHandler,
AdditionalMeasureProducer,
EnvironmentHandler {
    private static final long serialVersionUID = 4901630631723287761L;
    protected String m_modelPath = "";
    protected transient Instances m_inputHeader;
    protected Instances m_modelHeader;
    protected transient Environment m_env;
    protected transient int[] m_attributeMap;
    protected transient int[] m_attributeStatus;
    protected transient int[][] m_nominalValueMap;
    protected boolean m_trim = true;
    protected boolean m_ignoreCase = true;
    protected boolean m_suppressMappingReport = false;
    protected boolean m_initialTestStructureKnown = false;
    protected double[] m_vals;
    protected static final int NO_MATCH = -1;
    protected static final int TYPE_MISMATCH = -2;
    protected static final int OK = -3;

    public String globalInfo() {
        return "Wrapper classifier that addresses incompatible training and test data by building a mapping between the training data that a classifier has been built with and the incoming test instances' structure. Model attributes that are not found in the incoming instances receive missing values, so do incoming nominal attribute values that the classifier has not seen before. A new classifier can be trained or an existing one loaded from a file.";
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    public String ignoreCaseForNamesTipText() {
        return "Ignore case when matching attribute names and nomina values.";
    }

    public void setIgnoreCaseForNames(boolean ignore) {
        this.m_ignoreCase = ignore;
    }

    public boolean getIgnoreCaseForNames() {
        return this.m_ignoreCase;
    }

    public String trimTipText() {
        return "Trim white space from each end of attribute names and nominal values before matching.";
    }

    public void setTrim(boolean trim) {
        this.m_trim = trim;
    }

    public boolean getTrim() {
        return this.m_trim;
    }

    public String suppressMappingReportTipText() {
        return "Don't output a report of model-to-input mappings.";
    }

    public void setSuppressMappingReport(boolean suppress) {
        this.m_suppressMappingReport = suppress;
    }

    public boolean getSuppressMappingReport() {
        return this.m_suppressMappingReport;
    }

    public String modelPathTipText() {
        return "Set the path from which to load a model. Loading occurs when the first test instance is received. Environment variables can be used in the supplied path.";
    }

    public void setModelPath(String modelPath) throws Exception {
        if (this.m_env == null) {
            this.m_env = Environment.getSystemWide();
        }
        this.m_modelPath = modelPath;
    }

    public String getModelPath() {
        return this.m_modelPath;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        return result;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tIgnore case when matching attribute names and nominal values.", "I", 0, "-I"));
        newVector.addElement(new Option("\tSuppress the output of the mapping report.", "M", 0, "-M"));
        newVector.addElement(new Option("\tTrim white space from either end of names before matching.", "trim", 0, "-trim"));
        newVector.addElement(new Option("\tPath to a model to load. If set, this model\n\twill be used for prediction and any base classifier\n\tspecification will be ignored. Environment variables\n\tmay be used in the path (e.g. ${HOME}/myModel.model)", "L", 1, "-L <path to model to load>"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setIgnoreCaseForNames(Utils.getFlag('I', options));
        this.setSuppressMappingReport(Utils.getFlag('M', options));
        this.setTrim(Utils.getFlag("trim", options));
        String modelPath = Utils.getOption('L', options);
        if (modelPath.length() > 0) {
            this.setModelPath(modelPath);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 5];
        int current = 0;
        if (this.getIgnoreCaseForNames()) {
            options[current++] = "-I";
        }
        if (this.getSuppressMappingReport()) {
            options[current++] = "-M";
        }
        if (this.getTrim()) {
            options[current++] = "-trim";
        }
        if (this.getModelPath() != null && this.getModelPath().length() > 0) {
            options[current++] = "-L";
            options[current++] = this.getModelPath();
        }
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        current += superOptions.length;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public void setTestStructure(Instances testStructure) {
        this.m_inputHeader = testStructure;
        this.m_initialTestStructureKnown = true;
    }

    public void setModelHeader(Instances modelHeader) {
        this.m_modelHeader = modelHeader;
    }

    private void loadModel(String modelPath) throws Exception {
        if (modelPath != null && modelPath.length() > 0) {
            try {
                if (this.m_env == null) {
                    this.m_env = Environment.getSystemWide();
                }
                modelPath = this.m_env.substitute(modelPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Object[] modelAndHeader = SerializationHelper.readAll(modelPath);
                if (modelAndHeader.length != 2) {
                    throw new Exception("[InputMappedClassifier] serialized model file does not seem to contain both a model and the instances header used in training it!");
                }
                this.setClassifier((Classifier)modelAndHeader[0]);
                this.m_modelHeader = (Instances)modelAndHeader[1];
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        if (!this.m_initialTestStructureKnown) {
            this.m_inputHeader = data.stringFreeStructure();
        }
        this.m_attributeMap = null;
        if (this.m_modelPath != null && this.m_modelPath.length() > 0) {
            return;
        }
        this.getCapabilities().testWithFail(data);
        this.m_Classifier.buildClassifier(data);
        this.m_modelHeader = data.stringFreeStructure();
    }

    private boolean stringMatch(String one, String two) {
        if (this.m_trim) {
            one = one.trim();
            two = two.trim();
        }
        if (this.m_ignoreCase) {
            return one.equalsIgnoreCase(two);
        }
        return one.equals(two);
    }

    private String getFixedLengthString(String s, char pad, int len) {
        String padded = null;
        if (len <= 0) {
            return s;
        }
        if (s.length() >= len) {
            return s.substring(0, len);
        }
        char[] buf = new char[len - s.length()];
        for (int j = 0; j < len - s.length(); ++j) {
            buf[j] = pad;
        }
        padded = s + new String(buf);
        return padded;
    }

    private StringBuffer createMappingReport() {
        StringBuffer result = new StringBuffer();
        result.append("Attribute mappings:\n\n");
        int maxLength = 0;
        for (int i = 0; i < this.m_modelHeader.numAttributes(); ++i) {
            if (this.m_modelHeader.attribute(i).name().length() <= maxLength) continue;
            maxLength = this.m_modelHeader.attribute(i).name().length();
        }
        int minLength = 16;
        String headerS = "Model attributes";
        String sep = "----------------";
        if ((maxLength += 12) < minLength) {
            maxLength = minLength;
        }
        headerS = this.getFixedLengthString(headerS, ' ', maxLength);
        sep = this.getFixedLengthString(sep, '-', maxLength);
        sep = sep + "\t    ----------------\n";
        headerS = headerS + "\t    Incoming attributes\n";
        result.append(headerS);
        result.append(sep);
        for (int i = 0; i < this.m_modelHeader.numAttributes(); ++i) {
            Attribute temp = this.m_modelHeader.attribute(i);
            String attName = "(";
            if (temp.isNumeric()) {
                attName = attName + "numeric";
            } else if (temp.isNominal()) {
                attName = attName + "nominal";
            } else if (temp.isRelationValued()) {
                attName = attName + "relational";
            } else if (temp.isString()) {
                attName = attName + "string";
            }
            attName = attName + ") " + temp.name();
            attName = this.getFixedLengthString(attName, ' ', maxLength);
            attName = attName + "\t--> ";
            result.append(attName);
            String inAttNum = "";
            if (this.m_attributeStatus[i] == -1) {
                inAttNum = inAttNum + "- ";
                result.append(inAttNum + "missing (no match)\n");
                continue;
            }
            if (this.m_attributeStatus[i] == -2) {
                inAttNum = inAttNum + (this.m_attributeMap[i] + 1) + " ";
                result.append(inAttNum + "missing (type mis-match)\n");
                continue;
            }
            Attribute inAtt = this.m_inputHeader.attribute(this.m_attributeMap[i]);
            String inName = "" + (this.m_attributeMap[i] + 1) + " (";
            if (inAtt.isNumeric()) {
                inName = inName + "numeric";
            } else if (inAtt.isNominal()) {
                inName = inName + "nominal";
            } else if (inAtt.isRelationValued()) {
                inName = inName + "relational";
            } else if (inAtt.isString()) {
                inName = inName + "string";
            }
            inName = inName + ") " + inAtt.name();
            result.append(inName + "\n");
        }
        return result;
    }

    private boolean regenerateMapping() throws Exception {
        this.loadModel(this.m_modelPath);
        if (this.m_modelHeader == null) {
            return false;
        }
        this.m_attributeMap = new int[this.m_modelHeader.numAttributes()];
        this.m_attributeStatus = new int[this.m_modelHeader.numAttributes()];
        this.m_nominalValueMap = new int[this.m_modelHeader.numAttributes()][];
        block0: for (int i = 0; i < this.m_modelHeader.numAttributes(); ++i) {
            String modelAttName = this.m_modelHeader.attribute(i).name();
            this.m_attributeStatus[i] = -1;
            for (int j = 0; j < this.m_inputHeader.numAttributes(); ++j) {
                String incomingAttName = this.m_inputHeader.attribute(j).name();
                if (!this.stringMatch(modelAttName, incomingAttName)) continue;
                this.m_attributeMap[i] = j;
                this.m_attributeStatus[i] = -3;
                Attribute modelAtt = this.m_modelHeader.attribute(i);
                Attribute incomingAtt = this.m_inputHeader.attribute(j);
                if (modelAtt.type() != incomingAtt.type()) {
                    this.m_attributeStatus[i] = -2;
                    continue block0;
                }
                if (modelAtt.numValues() != incomingAtt.numValues()) {
                    System.out.println("[InputMappedClassifier] Warning: incoming nominal attribute " + incomingAttName + " does not have the same number of values as model attribute " + modelAttName);
                }
                if (!modelAtt.isNominal() || !incomingAtt.isNominal()) continue;
                int[] valuesMap = new int[incomingAtt.numValues()];
                for (int k = 0; k < incomingAtt.numValues(); ++k) {
                    String incomingNomValue = incomingAtt.value(k);
                    int indexInModel = modelAtt.indexOfValue(incomingNomValue);
                    valuesMap[k] = indexInModel < 0 ? -1 : indexInModel;
                }
                this.m_nominalValueMap[i] = valuesMap;
            }
        }
        return true;
    }

    public Instances getModelHeader(Instances defaultH) throws Exception {
        this.loadModel(this.m_modelPath);
        Instances toReturn = this.m_modelHeader == null ? defaultH : this.m_modelHeader;
        return toReturn.stringFreeStructure();
    }

    public int getMappedClassIndex() throws Exception {
        if (this.m_modelHeader == null) {
            throw new Exception("[InputMappedClassifier] No model available!");
        }
        if (this.m_attributeMap[this.m_modelHeader.classIndex()] == -1) {
            return -1;
        }
        return this.m_attributeMap[this.m_modelHeader.classIndex()];
    }

    public synchronized Instance constructMappedInstance(Instance incoming) throws Exception {
        boolean regenerateMapping = false;
        if (this.m_inputHeader == null) {
            this.m_inputHeader = incoming.dataset().stringFreeStructure();
            regenerateMapping = true;
            this.m_initialTestStructureKnown = false;
        } else if (!this.m_inputHeader.equalHeaders(incoming.dataset())) {
            this.m_inputHeader = incoming.dataset().stringFreeStructure();
            regenerateMapping = true;
            this.m_initialTestStructureKnown = false;
        } else if (this.m_attributeMap == null) {
            regenerateMapping = true;
            this.m_initialTestStructureKnown = false;
        }
        if (regenerateMapping) {
            this.regenerateMapping();
            this.m_vals = null;
            if (!this.m_suppressMappingReport) {
                StringBuffer result = this.createMappingReport();
                System.out.println(result.toString());
            }
        }
        this.m_vals = new double[this.m_modelHeader.numAttributes()];
        Instances freshData = this.m_modelHeader.stringFreeStructure();
        for (int i = 0; i < this.m_modelHeader.numAttributes(); ++i) {
            if (this.m_attributeStatus[i] == -3) {
                Attribute modelAtt = this.m_modelHeader.attribute(i);
                if (Utils.isMissingValue(incoming.value(this.m_attributeMap[i]))) {
                    this.m_vals[i] = Utils.missingValue();
                    continue;
                }
                if (modelAtt.isNumeric()) {
                    this.m_vals[i] = incoming.value(this.m_attributeMap[i]);
                    continue;
                }
                if (modelAtt.isNominal()) {
                    int mapVal = this.m_nominalValueMap[i][(int)incoming.value(this.m_attributeMap[i])];
                    if (mapVal == -1) {
                        this.m_vals[i] = Utils.missingValue();
                        continue;
                    }
                    this.m_vals[i] = mapVal;
                    continue;
                }
                if (modelAtt.isString()) {
                    this.m_vals[i] = freshData.attribute(i).addStringValue(incoming.attribute(this.m_attributeMap[i]), (int)incoming.value(this.m_attributeMap[i]));
                    continue;
                }
                if (!modelAtt.isRelationValued()) continue;
                this.m_vals[i] = freshData.attribute(i).addRelation(incoming.relationalValue(this.m_attributeMap[i]));
                continue;
            }
            this.m_vals[i] = Utils.missingValue();
        }
        DenseInstance newInst = new DenseInstance(incoming.weight(), this.m_vals);
        newInst.setDataset(freshData);
        return newInst;
    }

    @Override
    public double classifyInstance(Instance inst) throws Exception {
        Instance converted = this.constructMappedInstance(inst);
        return this.m_Classifier.classifyInstance(converted);
    }

    @Override
    public double[] distributionForInstance(Instance inst) throws Exception {
        Instance converted = this.constructMappedInstance(inst);
        return this.m_Classifier.distributionForInstance(converted);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("InputMappedClassifier:\n\n");
        try {
            this.loadModel(this.m_modelPath);
        }
        catch (Exception ex) {
            return "[InputMappedClassifier] Problem loading model.";
        }
        if (this.m_modelPath != null && this.m_modelPath.length() > 0) {
            buff.append("Model sourced from: " + this.m_modelPath + "\n\n");
        }
        buff.append(this.m_Classifier);
        if (!this.m_suppressMappingReport && this.m_inputHeader != null) {
            try {
                this.regenerateMapping();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return "[InputMappedClassifier] Problem loading model.";
            }
            if (this.m_attributeMap != null) {
                buff.append("\n" + this.createMappingReport().toString());
            }
        }
        return buff.toString();
    }

    @Override
    public int graphType() {
        if (this.m_Classifier instanceof Drawable) {
            return ((Drawable)((Object)this.m_Classifier)).graphType();
        }
        return 0;
    }

    @Override
    public Enumeration<String> enumerateMeasures() {
        Vector<String> newVector = new Vector<String>();
        if (this.m_Classifier instanceof AdditionalMeasureProducer) {
            Enumeration<String> en = ((AdditionalMeasureProducer)((Object)this.m_Classifier)).enumerateMeasures();
            while (en.hasMoreElements()) {
                String mname = en.nextElement();
                newVector.addElement(mname);
            }
        }
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (this.m_Classifier instanceof AdditionalMeasureProducer) {
            return ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(additionalMeasureName);
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (InputMappedClassifier)");
    }

    @Override
    public String graph() throws Exception {
        if (this.m_Classifier != null && this.m_Classifier instanceof Drawable) {
            return ((Drawable)((Object)this.m_Classifier)).graph();
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot be graphed");
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }

    public static void main(String[] argv) {
        InputMappedClassifier.runClassifier(new InputMappedClassifier(), argv);
    }
}

