/*
 * Decompiled with CFR 0.152.
 */
package weka.core.stopwords;

import java.util.HashSet;
import java.util.List;
import weka.core.stopwords.AbstractFileBasedStopwords;

public class WordsFromFile
extends AbstractFileBasedStopwords {
    private static final long serialVersionUID = -722795295494945193L;
    protected HashSet<String> m_Words;

    @Override
    public String globalInfo() {
        return "Uses the stopwords located in the specified file (ignored _if pointing to a directory). One stopword per line. Lines starting with '#' are considered comments and ignored.";
    }

    @Override
    public String stopwordsTipText() {
        return "The file containing the stopwords.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Words = new HashSet();
        List<String> words = this.read();
        for (String word : words) {
            if (word.startsWith("#")) continue;
            this.m_Words.add(word);
        }
    }

    @Override
    protected synchronized boolean is(String word) {
        return this.m_Words.contains(word.trim().toLowerCase());
    }
}

