/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import weka.core.RevisionUtils;
import weka.estimators.ConditionalEstimator;
import weka.estimators.Estimator;
import weka.estimators.NormalEstimator;

public class NDConditionalEstimator
implements ConditionalEstimator {
    private NormalEstimator[] m_Estimators;

    public NDConditionalEstimator() {
        this(1, 0.01);
    }

    public NDConditionalEstimator(int numCondSymbols, double precision) {
        this.m_Estimators = new NormalEstimator[numCondSymbols];
        for (int i = 0; i < numCondSymbols; ++i) {
            this.m_Estimators[i] = new NormalEstimator(precision);
        }
    }

    @Override
    public void addValue(double data, double given, double weight) {
        this.m_Estimators[(int)given].addValue(data, weight);
    }

    @Override
    public Estimator getEstimator(double given) {
        return this.m_Estimators[(int)given];
    }

    @Override
    public double getProbability(double data, double given) {
        return this.getEstimator(given).getProbability(data);
    }

    public String toString() {
        String result = "ND Conditional Estimator. " + this.m_Estimators.length + " sub-estimators:\n";
        for (int i = 0; i < this.m_Estimators.length; ++i) {
            result = result + "Sub-estimator " + i + ": " + this.m_Estimators[i];
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }

    public static void main(String[] argv) {
        try {
            int currentB;
            int currentA;
            if (argv.length == 0) {
                System.out.println("Please specify a set of instances.");
                return;
            }
            int maxA = currentA = Integer.parseInt(argv[0]);
            int maxB = currentB = Integer.parseInt(argv[1]);
            for (int i = 2; i < argv.length - 1; i += 2) {
                currentA = Integer.parseInt(argv[i]);
                currentB = Integer.parseInt(argv[i + 1]);
                if (currentA > maxA) {
                    maxA = currentA;
                }
                if (currentB <= maxB) continue;
                maxB = currentB;
            }
            NDConditionalEstimator newEst = new NDConditionalEstimator(maxB + 1, 1.0);
            for (int i = 0; i < argv.length - 1; i += 2) {
                currentA = Integer.parseInt(argv[i]);
                currentB = Integer.parseInt(argv[i + 1]);
                System.out.println(newEst);
                System.out.println("Prediction for " + currentA + '|' + currentB + " = " + newEst.getProbability(currentA, currentB));
                newEst.addValue(currentA, currentB, 1.0);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

