/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.experiment.PairedStats;

public class PairedStatsCorrected
extends PairedStats {
    protected double m_testTrainRatio;

    public PairedStatsCorrected(double sig, double testTrainRatio) {
        super(sig);
        this.m_testTrainRatio = testTrainRatio;
    }

    @Override
    public void calculateDerived() {
        this.xStats.calculateDerived();
        this.yStats.calculateDerived();
        this.differencesStats.calculateDerived();
        this.correlation = Double.NaN;
        if (!Double.isNaN(this.xStats.stdDev) && !Double.isNaN(this.yStats.stdDev) && this.xStats.stdDev > 0.0 && this.yStats.stdDev > 0.0 && this.count > 1.0) {
            this.correlation = (this.xySum - this.xStats.sum * this.yStats.sum / this.count) / ((this.count - 1.0) * this.xStats.stdDev * this.yStats.stdDev);
        }
        if (this.differencesStats.stdDev > 0.0) {
            double tval = this.differencesStats.mean / Math.sqrt((1.0 / this.count + this.m_testTrainRatio) * this.differencesStats.stdDev * this.differencesStats.stdDev);
            this.differencesProbability = this.count > 1.0 ? Statistics.FProbability(tval * tval, 1, (int)this.count - 1) : 1.0;
        } else {
            this.differencesProbability = this.differencesStats.sumSq == 0.0 ? 1.0 : 0.0;
        }
        this.differencesSignificance = 0;
        if (this.differencesProbability <= this.sigLevel) {
            this.differencesSignificance = this.xStats.mean > this.yStats.mean ? 1 : -1;
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }

    public static void main(String[] args) {
        try {
            String line;
            PairedStatsCorrected ps = new PairedStatsCorrected(0.05, 0.1111111111111111);
            LineNumberReader r = new LineNumberReader(new InputStreamReader(System.in));
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("@") || line.startsWith("%")) continue;
                StringTokenizer s = new StringTokenizer(line, " ,\t\n\r\f");
                int count = 0;
                double v1 = 0.0;
                double v2 = 0.0;
                while (s.hasMoreTokens()) {
                    double val = new Double(s.nextToken());
                    if (count == 0) {
                        v1 = val;
                    } else if (count == 1) {
                        v2 = val;
                    } else {
                        System.err.println("MSG: Too many values in line \"" + line + "\", skipped.");
                        break;
                    }
                    ++count;
                }
                if (count != 2) continue;
                ps.add(v1, v2);
            }
            ps.calculateDerived();
            System.err.println(ps);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

