/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.trees.J48;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.PartitionGenerator;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class PartitionMembership
extends Filter
implements SupervisedFilter,
OptionHandler,
RevisionHandler,
TechnicalInformationHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = 333532554667754026L;
    protected PartitionGenerator m_partitionGenerator = new J48();

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = this.m_partitionGenerator.getCapabilities();
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    protected void testInputFormat(Instances instanceInfo) throws Exception {
        this.getCapabilities().testWithFail(instanceInfo);
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        return false;
    }

    @Override
    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.outputFormatPeek() == null) {
            Instances toFilter = this.getInputFormat();
            this.m_partitionGenerator.generatePartition(toFilter);
            ArrayList<Attribute> attInfo = new ArrayList<Attribute>();
            for (int i = 0; i < this.m_partitionGenerator.numElements(); ++i) {
                attInfo.add(new Attribute("partition_" + i));
            }
            if (toFilter.classIndex() >= 0) {
                attInfo.add((Attribute)toFilter.classAttribute().copy());
            }
            attInfo.trimToSize();
            Instances filtered = new Instances(toFilter.relationName() + "_partitionMembership", attInfo, 0);
            if (toFilter.classIndex() >= 0) {
                filtered.setClassIndex(filtered.numAttributes() - 1);
            }
            this.setOutputFormat(filtered);
            for (int i = 0; i < toFilter.numInstances(); ++i) {
                this.convertInstance(toFilter.instance(i));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    @Override
    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.outputFormatPeek() != null) {
            this.convertInstance(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    protected void convertInstance(Instance instance) throws Exception {
        Instance cp = (Instance)instance.copy();
        cp.setWeight(1.0);
        double[] instanceVals = new double[this.outputFormatPeek().numAttributes()];
        double[] vals = this.m_partitionGenerator.getMembershipValues(cp);
        System.arraycopy(vals, 0, instanceVals, 0, vals.length);
        if (instance.classIndex() >= 0) {
            instanceVals[instanceVals.length - 1] = instance.classValue();
        }
        this.push(new SparseInstance(instance.weight(), instanceVals));
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tFull name of partition generator to use, e.g.:\n\t\tweka.classifiers.trees.J48\n\tAdditional options after the '--'.\n\t(default: weka.classifiers.trees.J48)", "W", 1, "-W <name of partition generator>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String generatorString = Utils.getOption('W', options);
        if (generatorString.length() == 0) {
            generatorString = J48.class.getName();
        }
        this.setPartitionGenerator((PartitionGenerator)Utils.forName(PartitionGenerator.class, generatorString, Utils.partitionOptions(options)));
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] generatorOptions;
        Vector<String> options = new Vector<String>();
        if (this.m_partitionGenerator != null) {
            options.add("-W");
            options.add(this.getPartitionGenerator().getClass().getName());
        }
        if (this.m_partitionGenerator != null && this.m_partitionGenerator instanceof OptionHandler && (generatorOptions = ((OptionHandler)((Object)this.m_partitionGenerator)).getOptions()).length > 0) {
            options.add("--");
            Collections.addAll(options, generatorOptions);
        }
        return options.toArray(new String[0]);
    }

    public String globalInfo() {
        return "A filter that uses a PartitionGenerator to generate partition membership values; filtered instances are composed of these values plus the class attribute (if set in the input data) and rendered as sparse instances. See Section 3 of\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Eibe Frank and Bernhard Pfahringer");
        result.setValue(TechnicalInformation.Field.TITLE, "Propositionalisation of Multi-instance Data Using Random Forests");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "AI 2013: Advances in Artificial Intelligence");
        result.setValue(TechnicalInformation.Field.YEAR, "2013");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        result.setValue(TechnicalInformation.Field.PAGES, "362-373");
        return result;
    }

    public String partitionGeneratorTipText() {
        return "The partition generator that will generate membership values for the instances.";
    }

    public void setPartitionGenerator(PartitionGenerator newPartitionGenerator) {
        this.m_partitionGenerator = newPartitionGenerator;
    }

    public PartitionGenerator getPartitionGenerator() {
        return this.m_partitionGenerator;
    }

    public static void main(String[] argv) {
        PartitionMembership.runFilter(new PartitionMembership(), argv);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }
}

